/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.data;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.api.GeoMesaIndexManager;
import org.locationtech.geomesa.index.conf.partition.TablePartition;
import org.locationtech.geomesa.index.conf.partition.TimePartition;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.data.ManagePartitionsCommand;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public abstract class ManagePartitionsCommand$AdoptPartitionCommand$class {
    public static void execute(ManagePartitionsCommand.AdoptPartitionCommand $this, GeoMesaDataStore ds, SimpleFeatureType sft, TablePartition partition) {
        TimePartition time = (TimePartition)Option$.MODULE$.apply((Object)partition).collect((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends TablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TimePartition) {
                    TimePartition timePartition = (TimePartition)A1;
                    object = timePartition;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(TablePartition x1) {
                TablePartition tablePartition = x1;
                boolean bl = tablePartition instanceof TimePartition;
                return bl;
            }
        }).getOrElse((Function0)new Serializable($this, partition){
            public static final long serialVersionUID = 0L;
            private final TablePartition partition$3;

            public final Nothing$ apply() {
                throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported partition implementation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$3.getClass().getName()})));
            }
            {
                this.partition$3 = partition$3;
            }
        });
        Tuple2<Date, Date> tuple2 = new ParameterConverters.IntervalConverter("value").convert($this.params().value());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Date s = (Date)tuple2._1();
            Date e = (Date)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)s, (Object)e);
            Date s2 = (Date)tuple23._1();
            Date e2 = (Date)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)ZonedDateTime.ofInstant(s2.toInstant(), ZoneOffset.UTC), (Object)ZonedDateTime.ofInstant(e2.toInstant(), ZoneOffset.UTC));
            if (tuple24 != null) {
                Tuple2 tuple25;
                ZonedDateTime start2 = (ZonedDateTime)tuple24._1();
                ZonedDateTime end = (ZonedDateTime)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)start2, (Object)end);
                ZonedDateTime start3 = (ZonedDateTime)tuple26._1();
                ZonedDateTime end2 = (ZonedDateTime)tuple26._2();
                Buffer tables = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().tables()).asScala();
                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adopting tables ", " as partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tables.mkString(", "), $this.params().partition()})));
                GeoMesaIndexManager qual$3 = ds.manager();
                SimpleFeatureType x$15 = sft;
                Option x$16 = qual$3.indices$default$2();
                IndexMode.IndexMode x$17 = qual$3.indices$default$3();
                Seq indices = qual$3.indices(x$15, x$16, x$17);
                if (indices.lengthCompare(tables.length()) != 0) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected an index table for each index: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)indices.map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(GeoMesaFeatureIndex<DS, F, W> x$5) {
                            return x$5.name();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
                }
                Seq indicesAndTables = (Seq)indices.map((Function1)new Serializable($this, tables){
                    public static final long serialVersionUID = 0L;
                    private final Buffer tables$1;

                    public final Tuple2<GeoMesaFeatureIndex<DS, F, W>, String> apply(GeoMesaFeatureIndex<DS, F, W> index) {
                        String table = (String)this.tables$1.find((Function1)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final GeoMesaFeatureIndex index$1;

                            public final boolean apply(String x$6) {
                                return x$6.contains(GeoMesaFeatureIndex$.MODULE$.tableSuffix(this.index$1, (Option)None$.MODULE$));
                            }
                            {
                                this.index$1 = index$1;
                            }
                        }).getOrElse((Function0)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final GeoMesaFeatureIndex index$1;

                            public final Nothing$ apply() {
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"None of the index tables correspond to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.index$1.identifier()})));
                            }
                            {
                                this.index$1 = index$1;
                            }
                        });
                        return new Tuple2(index, (Object)table);
                    }
                    {
                        this.tables$1 = tables$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                indicesAndTables.foreach((Function1)new Serializable($this, ds, sft){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ManagePartitionsCommand.AdoptPartitionCommand $outer;
                    private final GeoMesaDataStore ds$3;
                    private final SimpleFeatureType sft$4;

                    public final void apply(Tuple2<GeoMesaFeatureIndex<DS, F, W>, String> x0$1) {
                        Tuple2<GeoMesaFeatureIndex<DS, F, W>, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)tuple2._1();
                            String table = (String)tuple2._2();
                            this.ds$3.metadata().insert(this.sft$4.getTypeName(), index.tableNameKey((Option)new Some((Object)this.$outer.params().partition())), (Object)table);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        void var3_3;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ds$3 = ds$3;
                        this.sft$4 = var3_3;
                    }
                });
                time.register($this.params().partition(), start3, end2);
                Command$.MODULE$.user().info("Done");
                return;
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError(tuple2);
    }

    public static void $init$(ManagePartitionsCommand.AdoptPartitionCommand $this) {
        $this.org$locationtech$geomesa$tools$data$ManagePartitionsCommand$AdoptPartitionCommand$_setter_$name_$eq("adopt");
    }
}

