/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.Point2PointProcess$;
import org.locationtech.geomesa.process.analytic.Point2PointProcess$$anonfun$3$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.SchemaBuilder;
import org.locationtech.geomesa.utils.geotools.SchemaBuilder$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Point2PointProcess", description="Aggregates a collection of points into a collection of line segments")
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u00015\u0011!\u0003U8j]R\u0014\u0004k\\5oiB\u0013xnY3tg*\u00111\u0001B\u0001\tC:\fG.\u001f;jG*\u0011QAB\u0001\baJ|7-Z:t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qa\u0003\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9\u0002$D\u0001\u0005\u0013\tIBA\u0001\bHK>lUm]1Qe>\u001cWm]:\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\tE\u0006\u001cX\rV=qKV\t!\u0005\u0005\u0002$U5\tAE\u0003\u0002&M\u000511/[7qY\u0016T!a\n\u0015\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0011FC\u0001\b_B,gnZ5t\u0013\tYCEA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016Da!\f\u0001!\u0002\u0013\u0011\u0013!\u00032bg\u0016$\u0016\u0010]3!\u0011\u001dy\u0003A1A\u0005\nA\n!a\u001a4\u0016\u0003E\u0002\"AM\u001e\u000e\u0003MR!\u0001N\u001b\u0002\t\u001d,w.\u001c\u0006\u0003m]\n1A\u001b;t\u0015\tA\u0014(\u0001\bwSZLGm]8mkRLwN\\:\u000b\u0003i\n1aY8n\u0013\ta4GA\bHK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z\u0011\u0019q\u0004\u0001)A\u0005c\u0005\u0019qM\u001a\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\u000f\u0015DXmY;uKRA!iS-j_f\f)\u0001\u0005\u0002D\u00136\tAI\u0003\u0002&\u000b*\u0011aiR\u0001\u0005I\u0006$\u0018M\u0003\u0002I\u0015\u0005Aq-Z8u_>d7/\u0003\u0002K\t\n92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0006\r~\u0002\rA\u0011\u0015\u0007\u00176#VKV,\u0011\u00059\u0013V\"A(\u000b\u0005A\u000b\u0016a\u00024bGR|'/\u001f\u0006\u0003\u000b\u001dK!aU(\u0003#\u0011+7o\u0019:jE\u0016\u0004\u0016M]1nKR,'/\u0001\u0003oC6,\u0017%\u0001$\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u00021\u0006A\u0012J\u001c9vi\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8\t\u000bi{\u0004\u0019A.\u0002\u001b\u001d\u0014x.\u001e9j]\u001e4\u0015.\u001a7e!\ta&M\u0004\u0002^A6\taLC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tg,\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1_Q\u0019IV\n\u00164WO\u0006\n!,I\u0001i\u0003]1\u0015.\u001a7eA=t\u0007e\u001e5jG\"\u0004Co\u001c\u0011he>,\b\u000fC\u0003k\u007f\u0001\u00071,A\u0005t_J$h)[3mI\"2\u0011.\u0014+m-6\f\u0013A[\u0011\u0002]\u0006Qc)[3mI\u0002zg\u000eI<iS\u000eD\u0007\u0005^8!g>\u0014H\u000f\t\u0015nkN$\bEY3!\t\u0006$X\r\t;za\u0016L\u0003\"\u00029@\u0001\u0004\t\u0018!C7j]B{\u0017N\u001c;t!\ti&/\u0003\u0002t=\n\u0019\u0011J\u001c;)\r=lE+\u001e,xC\u00051\u0018!F7j]&lW/\u001c(v[\n,'o\u00144Q_&tGo]\u0011\u0002q\u0006AR*\u001b8j[Vl\u0007E\\;nE\u0016\u0014\be\u001c4!a>Lg\u000e^:\t\u000bi|\u0004\u0019A>\u0002\u0015\t\u0014X-Y6P]\u0012\u000b\u0017\u0010\u0005\u0002^y&\u0011QP\u0018\u0002\b\u0005>|G.Z1oQ\u001dIX\nV@W\u0003\u0003\t\u0013A_\u0011\u0003\u0003\u0007\taD\u0011:fC.\u00043m\u001c8oK\u000e$\u0018n\u001c8tA=t\u0007\u0005Z1zA5\f'o[:\t\r\u0005\u001dq\b1\u0001|\u0003Q1\u0017\u000e\u001c;feNKgnZ;mCJ\u0004v.\u001b8ug\"j\u0011QA'U\u0003\u00171\u0016QBA\t\u0003'\t#!a\u0002\"\u0005\u0005=\u0011a\f$jYR,'\u000fI8vi\u0002\u001aXmZ7f]R\u001c\b\u0005\u001e5bi\u00022\u0017\r\u001c7!_:\u0004C\u000f[3!g\u0006lW\r\t9pS:$\u0018\u0001\u00043fM\u0006,H\u000e\u001e,bYV,\u0017EAA\u000b\u0003\u0011!(/^3)\u0013}\nI\u0002VA\u0010-\u0006\r\u0002c\u0001(\u0002\u001c%\u0019\u0011QD(\u0003\u001d\u0011+7o\u0019:jE\u0016\u0014Vm];mi\u0006\u0012\u0011\u0011E\u0001\u0007e\u0016\u001cX\u000f\u001c;\"\u0005\u0005\u0015\u0012!H!hOJ,w-\u0019;fI\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u0005aq-\u001a;ECf|e-W3beR)\u0011/!\f\u00022!9\u0011qFA\u0014\u0001\u0004\t\u0018AD:peR4\u0015.\u001a7e\u0013:$W\r\u001f\u0005\t\u0003g\t9\u00031\u0001\u00026\u0005\ta\rE\u0002$\u0003oI1!!\u000f%\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"R\u0001!!\u0010\u0002D\u0005\u0015c+!\u0013\u0011\u00079\u000by$C\u0002\u0002B=\u0013q\u0002R3tGJL'-\u001a)s_\u000e,7o]\u0001\u0006i&$H.Z\u0011\u0003\u0003\u000f\n!\u0003U8j]R\u0014\u0004k\\5oiB\u0013xnY3tg\u0006\u0012\u00111J\u0001E\u0003\u001e<'/Z4bi\u0016\u001c\b%\u0019\u0011d_2dWm\u0019;j_:\u0004sN\u001a\u0011q_&tGo\u001d\u0011j]R|\u0007%\u0019\u0011d_2dWm\u0019;j_:\u0004sN\u001a\u0011mS:,\u0007e]3h[\u0016tGo\u001d")
public class Point2PointProcess
implements GeoMesaProcess {
    private final SimpleFeatureType baseType = SchemaBuilder$.MODULE$.toSchemaBuilder((SchemaBuilder.AttributeBuilder)SchemaBuilder$.MODULE$.builder().addLineString("geom", true)).build("point2point");
    private final GeometryFactory org$locationtech$geomesa$process$analytic$Point2PointProcess$$gf = JTSFactoryFinder.getGeometryFactory();

    private SimpleFeatureType baseType() {
        return this.baseType;
    }

    public GeometryFactory org$locationtech$geomesa$process$analytic$Point2PointProcess$$gf() {
        return this.org$locationtech$geomesa$process$analytic$Point2PointProcess$$gf;
    }

    @DescribeResult(name="result", description="Aggregated feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input feature collection") SimpleFeatureCollection data, @DescribeParameter(name="groupingField", description="Field on which to group") String groupingField, @DescribeParameter(name="sortField", description="Field on which to sort (must be Date type)") String sortField, @DescribeParameter(name="minimumNumberOfPoints", description="Minimum number of points") int minPoints, @DescribeParameter(name="breakOnDay", description="Break connections on day marks") boolean breakOnDay, @DescribeParameter(name="filterSingularPoints", description="Filter out segments that fall on the same point", defaultValue="true") boolean filterSingularPoints) {
        SimpleFeatureType queryType = (SimpleFeatureType)data.getSchema();
        SimpleFeatureTypeBuilder sftBuilder = new SimpleFeatureTypeBuilder();
        sftBuilder.init(this.baseType());
        int groupingFieldIndex = ((SimpleFeatureType)data.getSchema()).indexOf(groupingField);
        sftBuilder.add((AttributeDescriptor)queryType.getAttributeDescriptors().get(groupingFieldIndex));
        int sortFieldIndex = ((SimpleFeatureType)data.getSchema()).indexOf(sortField);
        AttributeDescriptor sortDesc = (AttributeDescriptor)queryType.getAttributeDescriptors().get(sortFieldIndex);
        String sortAttrName = sortDesc.getLocalName();
        Class sortType = sortDesc.getType().getBinding();
        sftBuilder.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_start"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sortAttrName})), sortType);
        sftBuilder.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_end"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sortAttrName})), sortType);
        SimpleFeatureType sft = sftBuilder.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(sft);
        Iterable lineFeatures = (Iterable)((TraversableLike)SelfClosingIterator$.MODULE$.apply(data.features()).toList().groupBy((Function1)new Serializable(this, groupingFieldIndex){
            public static final long serialVersionUID = 0L;
            private final int groupingFieldIndex$1;

            public final String apply(SimpleFeature f) {
                return String.valueOf(f.getAttribute(this.groupingFieldIndex$1));
            }
            {
                this.groupingFieldIndex$1 = groupingFieldIndex$1;
            }
        }).filter((Function1)new Serializable(this, minPoints){
            public static final long serialVersionUID = 0L;
            private final int minPoints$1;

            public final boolean apply(Tuple2<String, List<SimpleFeature>> x0$1) {
                Tuple2<String, List<SimpleFeature>> tuple2 = x0$1;
                if (tuple2 != null) {
                    List coll = (List)tuple2._2();
                    boolean bl = coll.lengthCompare(this.minPoints$1) > 0;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.minPoints$1 = minPoints$1;
            }
        })).flatMap((Function1)new Serializable(this, breakOnDay, filterSingularPoints, groupingFieldIndex, sortFieldIndex, sortAttrName, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Point2PointProcess $outer;
            private final boolean breakOnDay$1;
            private final boolean filterSingularPoints$1;
            public final int groupingFieldIndex$1;
            public final int sortFieldIndex$1;
            public final String sortAttrName$1;
            public final SimpleFeatureBuilder builder$1;

            public final ArrayOps<SimpleFeature> apply(Tuple2<String, List<SimpleFeature>> x0$2) {
                Tuple2<String, List<SimpleFeature>> tuple2 = x0$2;
                if (tuple2 != null) {
                    List coll = (List)tuple2._2();
                    List globalSorted = (List)coll.sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;

                        public final Date apply(SimpleFeature x$1) {
                            return (Date)Conversions.RichSimpleFeature$.MODULE$.get$extension0(Conversions$.MODULE$.RichSimpleFeature(x$1), this.$outer.sortFieldIndex$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                    List[] groups = this.breakOnDay$1 ? (List[])((TraversableOnce)((TraversableLike)globalSorted.groupBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;

                        public final int apply(SimpleFeature f) {
                            return this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$$outer().getDayOfYear(this.$outer.sortFieldIndex$1, f);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, List<SimpleFeature>> x0$3) {
                            Tuple2<Object, List<SimpleFeature>> tuple2 = x0$3;
                            if (tuple2 != null) {
                                List g = (List)tuple2._2();
                                boolean bl = g.lengthCompare(2) >= 0;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final List<SimpleFeature> apply(Tuple2<Object, List<SimpleFeature>> x0$4) {
                            Tuple2<Object, List<SimpleFeature>> tuple2 = x0$4;
                            if (tuple2 != null) {
                                List g;
                                List list = g = (List)tuple2._2();
                                return list;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(List.class)) : (List[])((Object[])new List[]{globalSorted});
                    Tuple2[] results = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])groups).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;

                        public final Iterator<Tuple2<Object, SimpleFeature>> apply(List<SimpleFeature> sorted) {
                            return sorted.sliding(2).zipWithIndex().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$3$$anonfun$8 $outer;

                                public final Tuple2<Object, SimpleFeature> apply(Tuple2<List<SimpleFeature>, Object> x0$5) {
                                    Tuple2<List<SimpleFeature>, Object> tuple2 = x0$5;
                                    if (tuple2 != null) {
                                        List ptLst = (List)tuple2._1();
                                        int idx = tuple2._2$mcI$sp();
                                        List pts = (List)ptLst.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Coordinate apply(SimpleFeature x$2) {
                                                return Conversions.RichSimpleFeature$.MODULE$.point$extension(Conversions$.MODULE$.RichSimpleFeature(x$2)).getCoordinate();
                                            }
                                        }, List$.MODULE$.canBuildFrom());
                                        double length = JTS.orthodromicDistance((Coordinate)((Coordinate)pts.head()), (Coordinate)((Coordinate)pts.last()), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                                        Object group = ((SimpleFeature)ptLst.head()).getAttribute(this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().groupingFieldIndex$1);
                                        Object startDtg = ((SimpleFeature)ptLst.head()).getAttribute(this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().sortAttrName$1);
                                        Object endDtg = ((SimpleFeature)ptLst.last()).getAttribute(this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().sortAttrName$1);
                                        Object[] attrs = new Object[]{this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$$outer().org$locationtech$geomesa$process$analytic$Point2PointProcess$$gf().createLineString((Coordinate[])pts.toArray(ClassTag$.MODULE$.apply(Coordinate.class))), group, startDtg, endDtg};
                                        SimpleFeature sf = this.$outer.org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer().builder$1.buildFeature(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, BoxesRunTime.boxToInteger((int)idx)})), attrs);
                                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)length), (Object)sf);
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$3 org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                    ArrayOps arrayOps = this.filterSingularPoints$1 ? Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])results).collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, SimpleFeature>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                double length = A1._1$mcD$sp();
                                SimpleFeature sf = (SimpleFeature)A1._2();
                                if (length > 0.0) {
                                    object = sf;
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Tuple2<Object, SimpleFeature> x1) {
                            double length;
                            Tuple2<Object, SimpleFeature> tuple2 = x1;
                            boolean bl = tuple2 != null && (length = tuple2._1$mcD$sp()) > 0.0;
                            return bl;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeature.class)))) : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])results).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final SimpleFeature apply(Tuple2<Object, SimpleFeature> x0$6) {
                            Tuple2<Object, SimpleFeature> tuple2 = x0$6;
                            if (tuple2 != null) {
                                SimpleFeature sf;
                                SimpleFeature simpleFeature = sf = (SimpleFeature)tuple2._2();
                                return simpleFeature;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeature.class))));
                    return arrayOps;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ Point2PointProcess org$locationtech$geomesa$process$analytic$Point2PointProcess$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.breakOnDay$1 = breakOnDay$1;
                this.filterSingularPoints$1 = filterSingularPoints$1;
                this.groupingFieldIndex$1 = groupingFieldIndex$1;
                this.sortFieldIndex$1 = sortFieldIndex$1;
                this.sortAttrName$1 = sortAttrName$1;
                this.builder$1 = builder$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return new ListFeatureCollection(sft, JavaConversions$.MODULE$.seqAsJavaList((Seq)lineFeatures.toList()));
    }

    public int getDayOfYear(int sortFieldIndex, SimpleFeature f) {
        return ZonedDateTime.ofInstant(((Date)f.getAttribute(sortFieldIndex)).toInstant(), ZoneOffset.UTC).getDayOfYear();
    }
}

