/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.util.Converters;
import org.locationtech.geomesa.process.query.RouteVisitor$;
import org.locationtech.geomesa.process.query.RouteVisitor$$anon$2$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.Map;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class RouteVisitor$ {
    public static final RouteVisitor$ MODULE$;

    static {
        new RouteVisitor$();
    }

    public SimpleFeatureCollection matchRoutes(SimpleFeatureCollection input, Seq<LineString> routes, int geomIndex, boolean isPoints, Option<Object> headingIndex, double threshold, boolean bidirectional) {
        Option<Object> option;
        block4: {
            Object object;
            Map headingCache;
            ThreadLocal<GeodeticCalculator> calculator;
            block3: {
                block2: {
                    calculator = new ThreadLocal<GeodeticCalculator>(){

                        public GeodeticCalculator initialValue() {
                            return new GeodeticCalculator();
                        }
                    };
                    headingCache = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
                    option = headingIndex;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    int index = BoxesRunTime.unboxToInt((Object)some.x());
                    object = new Serializable(index){
                        public static final long serialVersionUID = 0L;
                        private final int index$2;

                        public final double apply(SimpleFeature sf) {
                            return BoxesRunTime.unboxToDouble((Object)Converters.convert((Object)sf.getAttribute(this.index$2), Double.TYPE));
                        }
                        {
                            this.index$2 = index$2;
                        }
                    };
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                object = new Serializable(geomIndex, calculator){
                    public static final long serialVersionUID = 0L;
                    private final int geomIndex$1;
                    private final ThreadLocal calculator$1;

                    public final double apply(SimpleFeature sf) {
                        LineString geom = (LineString)sf.getAttribute(this.geomIndex$1);
                        return RouteVisitor$.MODULE$.org$locationtech$geomesa$process$query$RouteVisitor$$getRouteHeading(geom, geom.getNumPoints() - 2, (GeodeticCalculator)this.calculator$1.get());
                    }
                    {
                        this.geomIndex$1 = geomIndex$1;
                        this.calculator$1 = calculator$1;
                    }
                };
            }
            Serializable getFeatureHeading = object;
            Object getComparisonPoint = isPoints ? new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Point apply(Geometry g) {
                    return (Point)g;
                }
            } : new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Point apply(Geometry g) {
                    return ((LineString)g).getEndPoint();
                }
            };
            return new DecoratingSimpleFeatureCollection(input, routes, geomIndex, threshold, bidirectional, calculator, headingCache, (Function1)getFeatureHeading, (Function1)getComparisonPoint){
                public final SimpleFeatureCollection input$1;
                public final Seq routes$1;
                public final int geomIndex$1;
                public final double threshold$1;
                public final boolean bidirectional$1;
                public final ThreadLocal calculator$1;
                public final Map headingCache$1;
                public final Function1 getFeatureHeading$1;
                public final Function1 getComparisonPoint$1;

                public SimpleFeatureIterator features() {
                    return new SimpleFeatureIterator(this){
                        private final CloseableIterator<SimpleFeature> delegate;
                        private final /* synthetic */ anon.2 $outer;

                        private CloseableIterator<SimpleFeature> delegate() {
                            return this.delegate;
                        }

                        public SimpleFeature next() {
                            return (SimpleFeature)this.delegate().next();
                        }

                        public boolean hasNext() {
                            return this.delegate().hasNext();
                        }

                        public void close() {
                            this.delegate().close();
                        }

                        public /* synthetic */ anon.2 org$locationtech$geomesa$process$query$RouteVisitor$$anon$$anon$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.delegate = CloseableIterator$.MODULE$.apply((FeatureIterator)$outer.input$1.features()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon$2$$anon$1 $outer;

                                public final boolean apply(SimpleFeature sf) {
                                    return RouteVisitor$.MODULE$.org$locationtech$geomesa$process$query$RouteVisitor$$matchRoute$1(sf, this.$outer.org$locationtech$geomesa$process$query$RouteVisitor$$anon$$anon$$$outer().routes$1, this.$outer.org$locationtech$geomesa$process$query$RouteVisitor$$anon$$anon$$$outer().geomIndex$1, this.$outer.org$locationtech$geomesa$process$query$RouteVisitor$$anon$$anon$$$outer().threshold$1, this.$outer.org$locationtech$geomesa$process$query$RouteVisitor$$anon$$anon$$$outer().bidirectional$1, this.$outer.org$locationtech$geomesa$process$query$RouteVisitor$$anon$$anon$$$outer().calculator$1, this.$outer.org$locationtech$geomesa$process$query$RouteVisitor$$anon$$anon$$$outer().headingCache$1, this.$outer.org$locationtech$geomesa$process$query$RouteVisitor$$anon$$anon$$$outer().getFeatureHeading$1, this.$outer.org$locationtech$geomesa$process$query$RouteVisitor$$anon$$anon$$$outer().getComparisonPoint$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                    };
                }
                {
                    this.input$1 = input$1;
                    this.routes$1 = routes$1;
                    this.geomIndex$1 = geomIndex$1;
                    this.threshold$1 = threshold$1;
                    this.bidirectional$1 = bidirectional$1;
                    this.calculator$1 = calculator$1;
                    this.headingCache$1 = headingCache$1;
                    this.getFeatureHeading$1 = getFeatureHeading$1;
                    this.getComparisonPoint$1 = getComparisonPoint$1;
                    super(input$1);
                }
            };
        }
        throw new MatchError(option);
    }

    private Tuple2<LineString, Object> getClosestRoute(Point geom, Seq<LineString> routes) {
        Tuple3 tuple3 = (Tuple3)((TraversableOnce)routes.map((Function1)new Serializable(geom){
            public static final long serialVersionUID = 0L;
            private final Point geom$1;

            public final Tuple3<Object, LineString, Object> apply(LineString ls) {
                return RouteVisitor$.MODULE$.org$locationtech$geomesa$process$query$RouteVisitor$$closestPoint$1(ls, this.geom$1);
            }
            {
                this.geom$1 = geom$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).minBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, LineString, Object> x$4) {
                return BoxesRunTime.unboxToDouble((Object)x$4._1());
            }
        }, (Ordering)Ordering.Double$.MODULE$);
        if (tuple3 != null) {
            Tuple2 tuple2;
            LineString route = (LineString)tuple3._2();
            int location = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)route, (Object)BoxesRunTime.boxToInteger((int)location));
            LineString route2 = (LineString)tuple22._1();
            int location2 = tuple22._2$mcI$sp();
            return new Tuple2((Object)route2, (Object)BoxesRunTime.boxToInteger((int)location2));
        }
        throw new MatchError((Object)tuple3);
    }

    public double org$locationtech$geomesa$process$query$RouteVisitor$$getRouteHeading(LineString route, int index, GeodeticCalculator calculator) {
        Coordinate[] coords = route.getCoordinates();
        Coordinate segment0 = coords[index];
        Coordinate segment1 = coords[index + 1];
        calculator.setStartingGeographicPoint(segment0.x, segment0.y);
        calculator.setDestinationGeographicPoint(segment1.x, segment1.y);
        double azimuth = calculator.getAzimuth();
        return azimuth < 0.0 ? 360.0 + azimuth : azimuth;
    }

    public final boolean org$locationtech$geomesa$process$query$RouteVisitor$$matchRoute$1(SimpleFeature sf, Seq routes$1, int geomIndex$1, double threshold$1, boolean bidirectional$1, ThreadLocal calculator$1, Map headingCache$1, Function1 getFeatureHeading$1, Function1 getComparisonPoint$1) {
        Geometry geom = (Geometry)sf.getAttribute(geomIndex$1);
        Tuple2<LineString, Object> tuple2 = this.getClosestRoute((Point)getComparisonPoint$1.apply((Object)geom), (Seq<LineString>)routes$1);
        if (tuple2 != null) {
            double featureHeading;
            int closestLocation;
            int closestLocation2;
            LineString route = (LineString)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)route, (Object)BoxesRunTime.boxToInteger((int)(closestLocation2 = tuple2._2$mcI$sp())));
            Tuple2 tuple23 = tuple22;
            LineString route2 = (LineString)tuple23._1();
            double routeHeading = BoxesRunTime.unboxToDouble((Object)headingCache$1.getOrElseUpdate((Object)new Tuple2((Object)route2, (Object)BoxesRunTime.boxToInteger((int)(closestLocation = tuple23._2$mcI$sp()))), (Function0)new Serializable(calculator$1, route2, closestLocation){
                public static final long serialVersionUID = 0L;
                private final ThreadLocal calculator$1;
                private final LineString route$1;
                private final int closestLocation$1;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return RouteVisitor$.MODULE$.org$locationtech$geomesa$process$query$RouteVisitor$$getRouteHeading(this.route$1, this.closestLocation$1, (GeodeticCalculator)this.calculator$1.get());
                }
                {
                    this.calculator$1 = calculator$1;
                    this.route$1 = route$1;
                    this.closestLocation$1 = closestLocation$1;
                }
            }));
            double diff = package$.MODULE$.abs(routeHeading - (featureHeading = BoxesRunTime.unboxToDouble((Object)getFeatureHeading$1.apply((Object)sf))));
            if (diff > 180.0) {
                diff = package$.MODULE$.abs(diff - 360.0);
            }
            return diff <= threshold$1 || bidirectional$1 && package$.MODULE$.abs(diff - 180.0) <= threshold$1;
        }
        throw new MatchError(tuple2);
    }

    public final Tuple3 org$locationtech$geomesa$process$query$RouteVisitor$$closestPoint$1(LineString ls, Point geom$1) {
        DistanceOp op = new DistanceOp((Geometry)ls, (Geometry)geom$1);
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)op.distance()), (Object)ls, (Object)BoxesRunTime.boxToInteger((int)op.nearestLocations()[0].getSegmentIndex()));
    }

    private RouteVisitor$() {
        MODULE$ = this;
    }
}

