/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.index.BucketIndex$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import org.locationtech.geomesa.utils.index.SpatialIndex$class;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u0001\u0003\u00015\u00111BQ;dW\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0006S:$W\r\u001f\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0011abG\n\u0005\u0001=)B\u0005\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0004-]IR\"\u0001\u0002\n\u0005a\u0011!\u0001D*qCRL\u0017\r\\%oI\u0016D\bC\u0001\u000e\u001c\u0019\u0001!Q\u0001\b\u0001C\u0002u\u0011\u0011\u0001V\t\u0003=\u0005\u0002\"\u0001E\u0010\n\u0005\u0001\n\"a\u0002(pi\"Lgn\u001a\t\u0003!\tJ!aI\t\u0003\u0007\u0005s\u0017\u0010\u0005\u0002&Y5\taE\u0003\u0002(Q\u0005a1oY1mC2|wmZ5oO*\u0011\u0011FK\u0001\tif\u0004Xm]1gK*\t1&A\u0002d_6L!!\f\u0014\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005A\u0001PQ;dW\u0016$8\u000f\u0005\u0002\u0011c%\u0011!'\u0005\u0002\u0004\u0013:$\b\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u0011e\u0014UoY6fiND\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\bKb$XM\u001c;t!\tAt(D\u0001:\u0015\tQ4(\u0001\u0003hK>l'B\u0001\u001f>\u0003\rQGo\u001d\u0006\u0003})\naB^5wS\u0012\u001cx\u000e\\;uS>t7/\u0003\u0002As\tAQI\u001c<fY>\u0004X\rC\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\u0005\t\u00163u\tE\u0002\u0017\u0001eAqaL!\u0011\u0002\u0003\u0007\u0001\u0007C\u00045\u0003B\u0005\t\u0019\u0001\u0019\t\u000fY\n\u0005\u0013!a\u0001o!9\u0011\n\u0001b\u0001\n\u0013Q\u0015a\u00022vG.,Go]\u000b\u0002\u0017B\u0019\u0001\u0003\u0014(\n\u00055\u000b\"!B!se\u0006L\bc\u0001\tM\u001fB!\u0001kV-\u001a\u001b\u0005\t&B\u0001*T\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003)V\u000bA!\u001e;jY*\ta+\u0001\u0003kCZ\f\u0017B\u0001-R\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u00035vs!\u0001E.\n\u0005q\u000b\u0012A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001X\t\t\r\u0005\u0004\u0001\u0015!\u0003L\u0003!\u0011WoY6fiN\u0004\u0003bB2\u0001\u0005\u0004%I\u0001Z\u0001\tOJLGm\u00158baV\tQ\r\u0005\u0002gS6\tqM\u0003\u0002i\t\u0005Aq-Z8u_>d7/\u0003\u0002kO\nAqI]5e':\f\u0007\u000f\u0003\u0004m\u0001\u0001\u0006I!Z\u0001\nOJLGm\u00158ba\u0002BQA\u001c\u0001\u0005B=\fa!\u001b8tKJ$H\u0003\u00029tof\u0004\"\u0001E9\n\u0005I\f\"\u0001B+oSRDQAO7A\u0002Q\u0004\"\u0001O;\n\u0005YL$\u0001C$f_6,GO]=\t\u000bal\u0007\u0019A-\u0002\u0007-,\u0017\u0010C\u0003{[\u0002\u0007\u0011$A\u0003wC2,X\rC\u0003o\u0001\u0011\u0005C\u0010F\u0003q{~\f\t\u0001C\u0003\u007fw\u0002\u0007q'\u0001\u0005f]Z,Gn\u001c9f\u0011\u0015A8\u00101\u0001Z\u0011\u0019\t\u0019a\u001fa\u00013\u0005!\u0011\u000e^3n\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\taA]3n_Z,G#B\r\u0002\f\u00055\u0001B\u0002\u001e\u0002\u0006\u0001\u0007A\u000f\u0003\u0004y\u0003\u000b\u0001\r!\u0017\u0005\b\u0003\u000f\u0001A\u0011IA\t)\u0015I\u00121CA\u000b\u0011\u0019q\u0018q\u0002a\u0001o!1\u00010a\u0004A\u0002eCq!!\u0007\u0001\t\u0003\nY\"A\u0002hKR$R!GA\u000f\u0003?AaAOA\f\u0001\u0004!\bB\u0002=\u0002\u0018\u0001\u0007\u0011\fC\u0004\u0002\u001a\u0001!\t%a\t\u0015\u000be\t)#a\n\t\ry\f\t\u00031\u00018\u0011\u0019A\u0018\u0011\u0005a\u00013\"9\u00111\u0006\u0001\u0005B\u00055\u0012!B9vKJLHCCA\u0018\u0003\u000f\n\t&!\u0016\u0002ZA)\u0011\u0011GA!39!\u00111GA\u001f\u001d\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d\u0019\u00051AH]8pizJ\u0011AE\u0005\u0004\u0003\u007f\t\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\n)E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\ty$\u0005\u0005\t\u0003\u0013\nI\u00031\u0001\u0002L\u0005!\u00010\\5o!\r\u0001\u0012QJ\u0005\u0004\u0003\u001f\n\"A\u0002#pk\ndW\r\u0003\u0005\u0002T\u0005%\u0002\u0019AA&\u0003\u0011IX.\u001b8\t\u0011\u0005]\u0013\u0011\u0006a\u0001\u0003\u0017\nA\u0001_7bq\"A\u00111LA\u0015\u0001\u0004\tY%\u0001\u0003z[\u0006D\bbBA\u0016\u0001\u0011\u0005\u0013q\f\u000b\u0003\u0003_Aq!a\u0019\u0001\t\u0003\n)'\u0001\u0003tSj,G#\u0001\u0019\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l\u0005)1\r\\3beR\t\u0001\u000fC\u0004\u0002p\u0001!I!!\u001d\u0002\u000bMt\u0017\r\u001d-\u0015\u0007A\n\u0019\b\u0003\u0005\u0002v\u00055\u0004\u0019AA&\u0003\u0005A\bbBA=\u0001\u0011%\u00111P\u0001\u0006g:\f\u0007/\u0017\u000b\u0004a\u0005u\u0004\u0002CA@\u0003o\u0002\r!a\u0013\u0002\u0003e4a!a!\u0001\u0001\u0005\u0015%A\u0004\"vG.,G/\u0013;fe\u0006$xN]\n\u0006\u0003\u0003{\u0011q\u0006\u0005\u000b\u0003\u0013\u000b\tI!A!\u0002\u0013\u0001\u0014\u0001B7j]&D!\"!$\u0002\u0002\n\u0005\t\u0015!\u00031\u0003\u0011i\u0017\r_5\t\u0015\u0005E\u0015\u0011\u0011B\u0001B\u0003%\u0001'\u0001\u0003nS:T\u0007BCAK\u0003\u0003\u0013\t\u0011)A\u0005a\u0005!Q.\u0019=k\u0011!\u0011\u0015\u0011\u0011C\u0001\u0001\u0005eECCAN\u0003?\u000b\t+a)\u0002&B!\u0011QTAA\u001b\u0005\u0001\u0001bBAE\u0003/\u0003\r\u0001\r\u0005\b\u0003\u001b\u000b9\n1\u00011\u0011\u001d\t\t*a&A\u0002ABq!!&\u0002\u0018\u0002\u0007\u0001\u0007\u0003\u0006\u0002*\u0006\u0005\u0005\u0019!C\u0005\u0003W\u000b\u0011![\u000b\u0002a!Q\u0011qVAA\u0001\u0004%I!!-\u0002\u000b%|F%Z9\u0015\u0007A\f\u0019\fC\u0005\u00026\u00065\u0016\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005e\u0016\u0011\u0011Q!\nA\n!!\u001b\u0011\t\u0015\u0005u\u0016\u0011\u0011a\u0001\n\u0013\tY+A\u0001k\u0011)\t\t-!!A\u0002\u0013%\u00111Y\u0001\u0006U~#S-\u001d\u000b\u0004a\u0006\u0015\u0007\"CA[\u0003\u007f\u000b\t\u00111\u00011\u0011!\tI-!!!B\u0013\u0001\u0014A\u00016!\u0011)\ti-!!A\u0002\u0013%\u0011qZ\u0001\u0005SR,'/\u0006\u0002\u0002RB)\u00111[Ak35\t1+C\u0002\u0002DMC!\"!7\u0002\u0002\u0002\u0007I\u0011BAn\u0003!IG/\u001a:`I\u0015\fHc\u00019\u0002^\"Q\u0011QWAl\u0003\u0003\u0005\r!!5\t\u0013\u0005\u0005\u0018\u0011\u0011Q!\n\u0005E\u0017!B5uKJ\u0004\u0003\u0002CAs\u0003\u0003#)%a:\u0002\u000f!\f7OT3yiV\u0011\u0011\u0011\u001e\t\u0004!\u0005-\u0018bAAw#\t9!i\\8mK\u0006t\u0007\u0006BAr\u0003c\u0004B!a=\u0002z6\u0011\u0011Q\u001f\u0006\u0004\u0003o\f\u0012AC1o]>$\u0018\r^5p]&!\u00111`A{\u0005\u001d!\u0018-\u001b7sK\u000eD\u0001\"a@\u0002\u0002\u0012\u0005#\u0011A\u0001\u0005]\u0016DH\u000fF\u0001\u001a\u000f%\u0011)AAA\u0001\u0012\u0003\u00119!A\u0006Ck\u000e\\W\r^%oI\u0016D\bc\u0001\f\u0003\n\u0019A\u0011AAA\u0001\u0012\u0003\u0011YaE\u0002\u0003\n=AqA\u0011B\u0005\t\u0003\u0011y\u0001\u0006\u0002\u0003\b!Q!1\u0003B\u0005#\u0003%\tA!\u0006\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0011\u00119B!\u000b\u0016\u0005\te!f\u0001\u0019\u0003\u001c-\u0012!Q\u0004\t\u0005\u0005?\u0011)#\u0004\u0002\u0003\")!!1EA{\u0003%)hn\u00195fG.,G-\u0003\u0003\u0003(\t\u0005\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121AD!\u0005C\u0002uA!B!\f\u0003\nE\u0005I\u0011\u0001B\u0018\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU!!q\u0003B\u0019\t\u0019a\"1\u0006b\u0001;!Q!Q\u0007B\u0005#\u0003%\tAa\u000e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011ID!\u0010\u0016\u0005\tm\"fA\u001c\u0003\u001c\u00111ADa\rC\u0002u\u0001")
public class BucketIndex<T>
implements SpatialIndex<T>,
LazyLogging {
    private final int xBuckets;
    private final int yBuckets;
    private final Envelope extents;
    private final ConcurrentHashMap<String, T>[][] org$locationtech$geomesa$utils$index$BucketIndex$$buckets;
    private final GridSnap gridSnap;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static <T> Envelope $lessinit$greater$default$3() {
        return BucketIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> int $lessinit$greater$default$2() {
        return BucketIndex$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> int $lessinit$greater$default$1() {
        return BucketIndex$.MODULE$.$lessinit$greater$default$1();
    }

    private Logger logger$lzycompute() {
        BucketIndex bucketIndex = this;
        synchronized (bucketIndex) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Iterator<T> query(Envelope bbox) {
        return SpatialIndex$class.query(this, bbox);
    }

    @Override
    public void insert(double x, double y, String key2, T item) {
        SpatialIndex$class.insert(this, x, y, key2, item);
    }

    @Override
    public void insert(Envelope envelope, T item) {
        SpatialIndex$class.insert(this, envelope, item);
    }

    @Override
    public T remove(double x, double y, String key2) {
        return (T)SpatialIndex$class.remove(this, x, y, key2);
    }

    @Override
    public boolean remove(Envelope envelope, T item) {
        return SpatialIndex$class.remove((SpatialIndex)this, envelope, item);
    }

    @Override
    public T get(double x, double y, String key2) {
        return (T)SpatialIndex$class.get(this, x, y, key2);
    }

    @Override
    public Iterator<T> query(Envelope envelope, Function1<T, Object> filter2) {
        return SpatialIndex$class.query(this, envelope, filter2);
    }

    public ConcurrentHashMap<String, T>[][] org$locationtech$geomesa$utils$index$BucketIndex$$buckets() {
        return this.org$locationtech$geomesa$utils$index$BucketIndex$$buckets;
    }

    private GridSnap gridSnap() {
        return this.gridSnap;
    }

    @Override
    public void insert(Geometry geom, String key2, T value2) {
        Point pt = (Point)geom;
        int i = this.snapX(pt.getX());
        int j = this.snapY(pt.getY());
        this.org$locationtech$geomesa$utils$index$BucketIndex$$buckets()[i][j].put(key2, value2);
    }

    @Override
    public void insert(Envelope envelope, String key2, T item) {
        BoxedUnit boxedUnit;
        if (envelope.getArea() > 0.0) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("This index only supports point inserts, but received {} - will insert using the centroid", new Object[]{envelope});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.insert((envelope.getMinX() + envelope.getMaxX()) / 2.0, (envelope.getMinY() + envelope.getMaxY()) / 2.0, key2, item);
    }

    @Override
    public T remove(Geometry geom, String key2) {
        Point pt = (Point)geom;
        int i = this.snapX(pt.getX());
        int j = this.snapY(pt.getY());
        return this.org$locationtech$geomesa$utils$index$BucketIndex$$buckets()[i][j].remove(key2);
    }

    @Override
    public T remove(Envelope envelope, String key2) {
        return this.remove((envelope.getMinX() + envelope.getMaxX()) / 2.0, (envelope.getMinY() + envelope.getMaxY()) / 2.0, key2);
    }

    @Override
    public T get(Geometry geom, String key2) {
        Point pt = (Point)geom;
        int i = this.snapX(pt.getX());
        int j = this.snapY(pt.getY());
        return this.org$locationtech$geomesa$utils$index$BucketIndex$$buckets()[i][j].get(key2);
    }

    @Override
    public T get(Envelope envelope, String key2) {
        return this.get((envelope.getMinX() + envelope.getMaxX()) / 2.0, (envelope.getMinY() + envelope.getMaxY()) / 2.0, key2);
    }

    @Override
    public Iterator<T> query(double xmin, double ymin, double xmax, double ymax) {
        return new BucketIterator(this, this.snapX(xmin), this.snapX(xmax), this.snapY(ymin), this.snapY(ymax));
    }

    @Override
    public Iterator<T> query() {
        return new BucketIterator(this, 0, this.xBuckets - 1, 0, this.yBuckets - 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        void var1_1;
        int size2 = 0;
        for (int i = 0; i < this.xBuckets; ++i) {
            for (int j = 0; j < this.yBuckets; ++j) {
                size2 += this.org$locationtech$geomesa$utils$index$BucketIndex$$buckets()[i][j].size();
            }
        }
        return (int)var1_1;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.xBuckets; ++i) {
            for (int j = 0; j < this.yBuckets; ++j) {
                this.org$locationtech$geomesa$utils$index$BucketIndex$$buckets()[i][j].clear();
            }
        }
    }

    private int snapX(double x) {
        int i = this.gridSnap().i(x);
        return i != -1 ? i : (x < this.extents.getMinX() ? 0 : this.xBuckets - 1);
    }

    private int snapY(double y) {
        int j = this.gridSnap().j(y);
        return j != -1 ? j : (y < this.extents.getMinY() ? 0 : this.yBuckets - 1);
    }

    public BucketIndex(int xBuckets, int yBuckets, Envelope extents) {
        this.xBuckets = xBuckets;
        this.yBuckets = yBuckets;
        this.extents = extents;
        SpatialIndex$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$utils$index$BucketIndex$$buckets = (ConcurrentHashMap[][])Array$.MODULE$.fill(xBuckets, yBuckets, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ConcurrentHashMap<String, T> apply() {
                return new ConcurrentHashMap<K, V>();
            }
        }, ClassTag$.MODULE$.apply(ConcurrentHashMap.class));
        this.gridSnap = new GridSnap(extents, xBuckets, yBuckets);
    }

    public class BucketIterator
    implements Iterator<T> {
        private final int maxi;
        private final int minj;
        private final int maxj;
        private int i;
        private int j;
        private java.util.Iterator<T> iter;
        public final /* synthetic */ BucketIndex $outer;

        public Iterator<T> seq() {
            return Iterator.class.seq((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.class.isEmpty((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.class.isTraversableAgain((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.class.hasDefiniteSize((Iterator)this);
        }

        public Iterator<T> take(int n) {
            return Iterator.class.take((Iterator)this, (int)n);
        }

        public Iterator<T> drop(int n) {
            return Iterator.class.drop((Iterator)this, (int)n);
        }

        public Iterator<T> slice(int from, int until) {
            return Iterator.class.slice((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<T, B> f) {
            return Iterator.class.map((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.class.$plus$plus((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
            return Iterator.class.flatMap((Iterator)this, f);
        }

        public Iterator<T> filter(Function1<T, Object> p) {
            return Iterator.class.filter((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
            return Iterator.class.corresponds((Iterator)this, that, p);
        }

        public Iterator<T> withFilter(Function1<T, Object> p) {
            return Iterator.class.withFilter((Iterator)this, p);
        }

        public Iterator<T> filterNot(Function1<T, Object> p) {
            return Iterator.class.filterNot((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
            return Iterator.class.collect((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
            return Iterator.class.scanLeft((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
            return Iterator.class.scanRight((Iterator)this, z, op);
        }

        public Iterator<T> takeWhile(Function1<T, Object> p) {
            return Iterator.class.takeWhile((Iterator)this, p);
        }

        public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
            return Iterator.class.partition((Iterator)this, p);
        }

        public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
            return Iterator.class.span((Iterator)this, p);
        }

        public Iterator<T> dropWhile(Function1<T, Object> p) {
            return Iterator.class.dropWhile((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
            return Iterator.class.zip((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.class.padTo((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<T, Object>> zipWithIndex() {
            return Iterator.class.zipWithIndex((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<T, U> f) {
            Iterator.class.foreach((Iterator)this, f);
        }

        public boolean forall(Function1<T, Object> p) {
            return Iterator.class.forall((Iterator)this, p);
        }

        public boolean exists(Function1<T, Object> p) {
            return Iterator.class.exists((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.class.contains((Iterator)this, (Object)elem);
        }

        public Option<T> find(Function1<T, Object> p) {
            return Iterator.class.find((Iterator)this, p);
        }

        public int indexWhere(Function1<T, Object> p) {
            return Iterator.class.indexWhere((Iterator)this, p);
        }

        public <B> int indexOf(B elem) {
            return Iterator.class.indexOf((Iterator)this, elem);
        }

        public BufferedIterator<T> buffered() {
            return Iterator.class.buffered((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size2) {
            return Iterator.class.grouped((Iterator)this, (int)size2);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
            return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
        }

        public int length() {
            return Iterator.class.length((Iterator)this);
        }

        public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
            return Iterator.class.duplicate((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.class.sameElements((Iterator)this, that);
        }

        public Traversable<T> toTraversable() {
            return Iterator.class.toTraversable((Iterator)this);
        }

        public Iterator<T> toIterator() {
            return Iterator.class.toIterator((Iterator)this);
        }

        public Stream<T> toStream() {
            return Iterator.class.toStream((Iterator)this);
        }

        public String toString() {
            return Iterator.class.toString((Iterator)this);
        }

        public <B> int sliding$default$2() {
            return Iterator.class.sliding$default$2((Iterator)this);
        }

        public List<T> reversed() {
            return TraversableOnce.class.reversed((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.class.size((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.class.nonEmpty((TraversableOnce)this);
        }

        public int count(Function1<T, Object> p) {
            return TraversableOnce.class.count((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
            return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, T, B> op) {
            return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
            return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, T, B> op) {
            return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<T, B, B> op) {
            return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, T, B> op) {
            return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<T, B, B> op) {
            return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
            return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
            return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.class.product((TraversableOnce)this, num);
        }

        public <B> T min(Ordering<B> cmp) {
            return TraversableOnce.class.min((TraversableOnce)this, cmp);
        }

        public <B> T max(Ordering<B> cmp) {
            return TraversableOnce.class.max((TraversableOnce)this, cmp);
        }

        public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
            return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
        }

        public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
            return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
        }

        public List<T> toList() {
            return TraversableOnce.class.toList((TraversableOnce)this);
        }

        public Iterable<T> toIterable() {
            return TraversableOnce.class.toIterable((TraversableOnce)this);
        }

        public Seq<T> toSeq() {
            return TraversableOnce.class.toSeq((TraversableOnce)this);
        }

        public IndexedSeq<T> toIndexedSeq() {
            return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.class.toBuffer((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.class.toSet((TraversableOnce)this);
        }

        public Vector<T> toVector() {
            return TraversableOnce.class.toVector((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
            return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
            return TraversableOnce.class.toMap((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.class.mkString((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
        }

        private int i() {
            return this.i;
        }

        private void i_$eq(int x$1) {
            this.i = x$1;
        }

        private int j() {
            return this.j;
        }

        private void j_$eq(int x$1) {
            this.j = x$1;
        }

        private java.util.Iterator<T> iter() {
            return this.iter;
        }

        private void iter_$eq(java.util.Iterator<T> x$1) {
            this.iter = x$1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasNext() {
            while (!this.iter().hasNext()) {
                if (this.i() == this.maxi && this.j() == this.maxj) {
                    if (!false) return false;
                    return true;
                }
                if (this.j() < this.maxj) {
                    this.j_$eq(this.j() + 1);
                } else {
                    this.j_$eq(this.minj);
                    this.i_$eq(this.i() + 1);
                }
                this.iter_$eq(this.org$locationtech$geomesa$utils$index$BucketIndex$BucketIterator$$$outer().org$locationtech$geomesa$utils$index$BucketIndex$$buckets()[this.i()][this.j()].values().iterator());
            }
            return true;
        }

        public T next() {
            return this.iter().next();
        }

        public /* synthetic */ BucketIndex org$locationtech$geomesa$utils$index$BucketIndex$BucketIterator$$$outer() {
            return this.$outer;
        }

        public BucketIterator(BucketIndex<T> $outer, int mini, int maxi, int minj, int maxj) {
            this.maxi = maxi;
            this.minj = minj;
            this.maxj = maxj;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            TraversableOnce.class.$init$((TraversableOnce)this);
            Iterator.class.$init$((Iterator)this);
            this.i = mini;
            this.j = minj;
            this.iter = $outer.org$locationtech$geomesa$utils$index$BucketIndex$$buckets()[this.i()][this.j()].values().iterator();
        }
    }
}

