/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class ReservedWordCheck$
implements LazyLogging {
    public static final ReservedWordCheck$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ReservedWordCheck$();
    }

    private Logger logger$lzycompute() {
        ReservedWordCheck$ reservedWordCheck$ = this;
        synchronized (reservedWordCheck$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void validateAttributeNames(SimpleFeatureType sft) {
        Seq<String> reservedWords = FeatureUtils$.MODULE$.sftReservedWords(sft);
        if (reservedWords.nonEmpty()) {
            String msg = new StringBuilder().append((Object)"The simple feature type contains attribute name(s) that are reserved words: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". You may override this check by putting Boolean.TRUE into the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reservedWords.mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SimpleFeatureType user data under the key '", "' before calling createSchema, or by "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$Configs$.MODULE$.RESERVED_WORDS()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"setting the system property '", "' to 'true', however it may cause errors with some functionality."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$Configs$.MODULE$.RESERVED_WORDS()}))).toString();
            if (GeoMesaSchemaValidator$.MODULE$.declared(sft, SimpleFeatureTypes$Configs$.MODULE$.RESERVED_WORDS())) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new IllegalArgumentException(msg);
            }
        }
    }

    private ReservedWordCheck$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

