/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z3;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.z3.Z3IndexKey;
import org.locationtech.geomesa.index.index.z3.Z3IndexKeySpace;
import org.locationtech.geomesa.index.index.z3.Z3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.Z3IndexValues;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public abstract class Z3IndexKeySpace$class {
    public static boolean supports(Z3IndexKeySpace $this, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).isDefined() && RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    public static Function1 toIndexKey(Z3IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        Z3SFC z3 = $this.sfc(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        int dtgIndex = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Z3 index requires a valid date");
            }
        }));
        Function1 timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        return new Serializable($this, z3, geomIndex, dtgIndex, timeToIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3IndexKeySpace $outer;
            private final Z3SFC z3$1;
            private final int geomIndex$1;
            private final int dtgIndex$1;
            private final Function1 timeToIndex$1;
            private final boolean lenient$1;

            public final Seq<Z3IndexKey> apply(SimpleFeature feature) {
                return Z3IndexKeySpace$class.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$getZValue(this.$outer, this.z3$1, this.geomIndex$1, this.dtgIndex$1, this.timeToIndex$1, this.lenient$1, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.z3$1 = z3$1;
                this.geomIndex$1 = geomIndex$1;
                this.dtgIndex$1 = dtgIndex$1;
                this.timeToIndex$1 = timeToIndex$1;
                this.lenient$1 = lenient$1;
            }
        };
    }

    public static Function3 toIndexKeyBytes(Z3IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        Z3SFC z3 = $this.sfc(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        int dtgIndex = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Z3 index requires a valid date");
            }
        }));
        Function1 timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        return new Serializable($this, z3, geomIndex, dtgIndex, timeToIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3IndexKeySpace $outer;
            private final Z3SFC z3$2;
            private final int geomIndex$2;
            private final int dtgIndex$2;
            private final Function1 timeToIndex$2;
            private final boolean lenient$2;

            public final Seq<byte[]> apply(Seq<byte[]> prefix, SimpleFeature feature, byte[] suffix) {
                return Z3IndexKeySpace$class.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$getZValueBytes(this.$outer, this.z3$2, this.geomIndex$2, this.dtgIndex$2, this.timeToIndex$2, this.lenient$2, prefix, feature, suffix);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.z3$2 = z3$2;
                this.geomIndex$2 = geomIndex$2;
                this.dtgIndex$2 = dtgIndex$2;
                this.timeToIndex$2 = timeToIndex$2;
                this.lenient$2 = lenient$2;
            }
        };
    }

    public static Z3IndexValues getIndexValues(Z3IndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        String dtgField = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new RuntimeException("Trying to execute a z3 query but the schema does not have a date");
            }
        });
        Z3SFC z3 = $this.sfc(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$11 = filter2;
        String x$12 = dtgField;
        boolean x$13 = true;
        boolean x$14 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$11, x$12, x$14, x$13);
        explain.apply((Function0<String>)new Serializable($this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        explain.apply((Function0<String>)new Serializable($this, intervals){
            public static final long serialVersionUID = 0L;
            private final FilterValues intervals$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intervals$1}));
            }
            {
                this.intervals$1 = intervals$1;
            }
        });
        if (geometries.disjoint() || intervals.disjoint()) {
            explain.apply((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disjoint geometries or dates extracted, short-circuiting to empty query";
                }
            });
            return new Z3IndexValues(z3, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()), (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)Predef$.MODULE$.Map().empty());
        }
        long minTime = (long)z3.time().min();
        long maxTime = (long)z3.time().max();
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1)new Serializable($this, multiplier, bits){
            public static final long serialVersionUID = 0L;
            private final int multiplier$1;
            private final int bits$1;

            public final Seq<Tuple4<Object, Object, Object, Object>> apply(Geometry x$1) {
                return GeometryUtils$.MODULE$.bounds(x$1, this.multiplier$1, this.bits$1);
            }
            {
                this.multiplier$1 = multiplier$1;
                this.bits$1 = bits$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty().withDefaultValue((Object)Seq$.MODULE$.empty());
        Function1 dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Function1 boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        intervals.foreach((Function1)new Serializable($this, z3, minTime, maxTime, timesByBin, dateToIndex, boundsToDates){
            public static final long serialVersionUID = 0L;
            public final Z3SFC z3$3;
            private final long minTime$1;
            private final long maxTime$1;
            public final scala.collection.mutable.Map timesByBin$1;
            private final Function1 dateToIndex$1;
            private final Function1 boundsToDates$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Bounds<ZonedDateTime> interval) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Tuple2 tuple23;
                if (!interval.isBoundedBothSides()) return;
                Tuple2 tuple24 = (Tuple2)this.boundsToDates$1.apply((Object)interval.bounds());
                if (tuple24 == null) throw new MatchError((Object)tuple24);
                ZonedDateTime lower = (ZonedDateTime)tuple24._1();
                ZonedDateTime upper = (ZonedDateTime)tuple24._2();
                Tuple2 tuple25 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                ZonedDateTime lower2 = (ZonedDateTime)tuple25._1();
                ZonedDateTime upper2 = (ZonedDateTime)tuple25._2();
                BinnedTime binnedTime = (BinnedTime)this.dateToIndex$1.apply((Object)lower2);
                if (binnedTime == null) throw new MatchError((Object)binnedTime);
                short lb = binnedTime.bin();
                long lt = binnedTime.offset();
                Tuple2 tuple26 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
                short lb2 = BoxesRunTime.unboxToShort((Object)tuple26._1());
                long lt2 = tuple26._2$mcJ$sp();
                BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex$1.apply((Object)upper2);
                if (binnedTime2 == null) throw new MatchError((Object)binnedTime2);
                short ub = binnedTime2.bin();
                long ut = binnedTime2.offset();
                Tuple2 tuple27 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
                short ub2 = BoxesRunTime.unboxToShort((Object)tuple27._1());
                long ut2 = tuple27._2$mcJ$sp();
                if (lb2 == ub2) {
                    this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(lt2, ut2)})), Seq$.MODULE$.canBuildFrom()));
                    return;
                } else {
                    this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(lt2, this.maxTime$1)})), Seq$.MODULE$.canBuildFrom()));
                    this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)ub2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(this.minTime$1, ut2)})), Seq$.MODULE$.canBuildFrom()));
                    package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Z3IndexKeySpace$.anonfun.getIndexValues.4 $outer;

                        public final void apply(int b) {
                            this.apply$mcVI$sp(b);
                        }

                        public void apply$mcVI$sp(int b) {
                            this.$outer.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.$outer.z3$3.wholePeriod());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
            }
            {
                this.z3$3 = z3$3;
                this.minTime$1 = minTime$1;
                this.maxTime$1 = maxTime$1;
                this.timesByBin$1 = timesByBin$1;
                this.dateToIndex$1 = dateToIndex$1;
                this.boundsToDates$1 = boundsToDates$1;
            }
        });
        return new Z3IndexValues(z3, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)timesByBin.toMap(Predef$.MODULE$.$conforms()));
    }

    public static Iterator getRanges(Z3IndexKeySpace $this, Z3IndexValues values, int multiplier) {
        ObjectRef wholePeriodRanges$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Z3IndexValues z3IndexValues = values;
        if (z3IndexValues != null) {
            Tuple3 tuple3;
            Z3SFC z3 = z3IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = z3IndexValues.spatialBounds();
            Map<Object, Seq<Tuple2<Object, Object>>> timesByBin = z3IndexValues.temporalBounds();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)z3, xy, timesByBin);
            Z3SFC z32 = (Z3SFC)tuple32._1();
            Seq xy2 = (Seq)tuple32._2();
            Map timesByBin2 = (Map)tuple32._3();
            Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1)new Serializable($this, timesByBin2, multiplier){
                public static final long serialVersionUID = 0L;
                private final Map timesByBin$2;
                private final int multiplier$2;

                public final int apply(String t) {
                    return scala.math.package$.MODULE$.max(1, this.timesByBin$2.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(t)).toInt() : new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / this.timesByBin$2.size() / this.multiplier$2);
                }
                {
                    this.timesByBin$2 = timesByBin$2;
                    this.multiplier$2 = multiplier$2;
                }
            });
            return timesByBin2.iterator().flatMap((Function1)new Serializable($this, z32, xy2, target, wholePeriodRanges$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Z3IndexKeySpace $outer;
                private final Z3SFC z3$4;
                private final Seq xy$1;
                private final Option target$1;
                private final ObjectRef wholePeriodRanges$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final GenTraversableOnce<IndexKeySpace.ScanRange<Z3IndexKey>> apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x0$1) {
                    Tuple2<Object, Seq<Tuple2<Object, Object>>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Seq times = (Seq)tuple2._2();
                        Seq zs = times == this.z3$4.wholePeriod() ? Z3IndexKeySpace$class.wholePeriodRanges$1(this.$outer, this.z3$4, this.xy$1, this.target$1, this.wholePeriodRanges$lzy$1, this.bitmap$0$1) : Z3IndexKeySpace$class.toZRanges$1(this.$outer, times, this.z3$4, this.xy$1, this.target$1);
                        GenTraversableOnce genTraversableOnce = (GenTraversableOnce)zs.map((Function1)new Serializable(this, bin){
                            public static final long serialVersionUID = 0L;
                            private final short bin$1;

                            public final IndexKeySpace.BoundedRange<Z3IndexKey> apply(IndexRange range2) {
                                return new IndexKeySpace.BoundedRange<Z3IndexKey>(new Z3IndexKey(this.bin$1, range2.lower()), new Z3IndexKey(this.bin$1, range2.upper()));
                            }
                            {
                                this.bin$1 = bin$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return genTraversableOnce;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.z3$4 = z3$4;
                    this.xy$1 = xy$1;
                    this.target$1 = target$1;
                    this.wholePeriodRanges$lzy$1 = wholePeriodRanges$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
        }
        throw new MatchError((Object)z3IndexValues);
    }

    public static Iterator getRangeBytes(Z3IndexKeySpace $this, Iterator ranges, Seq prefixes, boolean tier) {
        return prefixes.isEmpty() ? ranges.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IndexKeySpace.ByteRange apply(IndexKeySpace.ScanRange<Z3IndexKey> x0$2) {
                IndexKeySpace.ScanRange<Z3IndexKey> scanRange = x0$2;
                if (scanRange instanceof IndexKeySpace.BoundedRange) {
                    IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                    Z3IndexKey lo = (Z3IndexKey)boundedRange.lower();
                    Z3IndexKey hi = (Z3IndexKey)boundedRange.upper();
                    IndexKeySpace.BoundedByteRange boundedByteRange = new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                    return boundedByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable($this, prefixes){
            public static final long serialVersionUID = 0L;
            private final Seq prefixes$1;

            public final GenTraversableOnce<IndexKeySpace.ByteRange> apply(IndexKeySpace.ScanRange<Z3IndexKey> x0$3) {
                IndexKeySpace.ScanRange<Z3IndexKey> scanRange = x0$3;
                if (scanRange instanceof IndexKeySpace.BoundedRange) {
                    IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                    Z3IndexKey lo = (Z3IndexKey)boundedRange.lower();
                    Z3IndexKey hi = (Z3IndexKey)boundedRange.upper();
                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                    GenTraversableOnce genTraversableOnce = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, lower, upper){
                        public static final long serialVersionUID = 0L;
                        private final byte[] lower$1;
                        private final byte[] upper$1;

                        public final IndexKeySpace.BoundedByteRange apply(byte[] p) {
                            return new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$1), ByteArrays$.MODULE$.concat(p, this.upper$1));
                        }
                        {
                            this.lower$1 = lower$1;
                            this.upper$1 = upper$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return genTraversableOnce;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                this.prefixes$1 = prefixes$1;
            }
        });
    }

    public static boolean useFullFilter(Z3IndexKeySpace $this, Option values, Option config, Hints hints) {
        boolean looseBBox = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(hints.get((Object)QueryHints$.MODULE$.LOOSE_BBOX())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x) {
                return BoxesRunTime.unboxToBoolean((Object)x);
            }
        }).getOrElse((Function0)new Serializable($this, config){
            public static final long serialVersionUID = 0L;
            private final Option config$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.config$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(GeoMesaDataStoreFactory.GeoMesaDataStoreConfig x$6) {
                        return x$6.looseBBox();
                    }
                });
            }
            {
                this.config$1 = config$1;
            }
        }));
        return !looseBBox || !Z3IndexKeySpace$class.simpleGeoms$1($this, values);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Seq org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$getZValue(Z3IndexKeySpace $this, Z3SFC z3, int geomIndex, int dtgIndex, Function1 timeToIndex, boolean lenient, SimpleFeature feature) {
        long z;
        Tuple2 tuple2;
        Point geom = (Point)feature.getAttribute(geomIndex);
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
        }
        Date dtg = (Date)feature.getAttribute(dtgIndex);
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)timeToIndex.apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) throw new MatchError((Object)binnedTime);
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long t2 = tuple22._2$mcJ$sp();
        try {
            z = z3.index(geom.getX(), geom.getY(), t2, lenient);
        }
        catch (Throwable throwable) {
            void var8_8;
            void var7_7;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_7, var8_8})), e);
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Z3IndexKey[]{new Z3IndexKey(b2, z)}));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Seq org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$getZValueBytes(Z3IndexKeySpace $this, Z3SFC z3, int geomIndex, int dtgIndex, Function1 timeToIndex, boolean lenient, Seq prefix, SimpleFeature feature, byte[] suffix) {
        long z;
        Tuple2 tuple2;
        Point geom = (Point)feature.getAttribute(geomIndex);
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
        }
        Date dtg = (Date)feature.getAttribute(dtgIndex);
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)timeToIndex.apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) throw new MatchError((Object)binnedTime);
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long t2 = tuple22._2$mcJ$sp();
        try {
            z = z3.index(geom.getX(), geom.getY(), t2, lenient);
        }
        catch (Throwable throwable) {
            void var10_10;
            void var9_9;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var9_9, var10_10})), e);
        }
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(BoxesRunTime.unboxToInt((Object)((TraversableOnce)prefix.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(byte[] x$10) {
                return x$10.length;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 10 + suffix.length, ClassTag$.MODULE$.Byte());
        IntRef i = IntRef.create((int)0);
        prefix.foreach((Function1)new Serializable($this, bytes, i){
            public static final long serialVersionUID = 0L;
            private final byte[] bytes$1;
            private final IntRef i$1;

            public final void apply(byte[] p) {
                System.arraycopy(p, 0, this.bytes$1, this.i$1.elem, p.length);
                this.i$1.elem += p.length;
            }
            {
                this.bytes$1 = bytes$1;
                this.i$1 = i$1;
            }
        });
        ByteArrays$.MODULE$.writeShort(b2, bytes, i.elem);
        ByteArrays$.MODULE$.writeLong(z, bytes, i.elem + 2);
        System.arraycopy(suffix, 0, bytes, i.elem + 10, suffix.length);
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{bytes}));
    }

    public static final Seq toZRanges$1(Z3IndexKeySpace $this, Seq t, Z3SFC z3$4, Seq xy$1, Option target$1) {
        return z3$4.ranges(xy$1, t, 64, target$1);
    }

    private static final Seq wholePeriodRanges$lzycompute$1(Z3IndexKeySpace $this, Z3SFC z3$4, Seq xy$1, Option target$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        Z3IndexKeySpace z3IndexKeySpace = $this;
        synchronized (z3IndexKeySpace) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                wholePeriodRanges$lzy$1.elem = Z3IndexKeySpace$class.toZRanges$1($this, z3$4.wholePeriod(), z3$4, xy$1, target$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Seq)wholePeriodRanges$lzy$1.elem;
        }
    }

    public static final Seq wholePeriodRanges$1(Z3IndexKeySpace $this, Z3SFC z3$4, Seq xy$1, Option target$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? Z3IndexKeySpace$class.wholePeriodRanges$lzycompute$1($this, z3$4, xy$1, target$1, wholePeriodRanges$lzy$1, bitmap$0$1) : (Seq)wholePeriodRanges$lzy$1.elem;
    }

    private static final boolean simpleGeoms$1(Z3IndexKeySpace $this, Option values$1) {
        return ((IterableLike)Option$.MODULE$.option2Iterable(values$1).toSeq().flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<Geometry> apply(Z3IndexValues x$7) {
                return x$7.geometries().values();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Geometry geometry) {
                return GeometryUtils$.MODULE$.isRectangular(geometry);
            }
        });
    }

    public static void $init$(Z3IndexKeySpace $this) {
        $this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$_setter_$indexKeyByteLength_$eq(10);
    }
}

