/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.geotools.factory.Hints;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.Converters;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureDeserialization$;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureSerialization$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.AggregatingScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$Configuration$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.interop.SimpleFeatureTypes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class DensityScan$
implements LazyLogging {
    public static final DensityScan$ MODULE$;
    private final SimpleFeatureType DensitySft;
    private final Hints.ClassKey DensityValueKey;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DensityScan$();
    }

    private Logger logger$lzycompute() {
        DensityScan$ densityScan$ = this;
        synchronized (densityScan$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeatureType DensitySft() {
        return this.DensitySft;
    }

    public Hints.ClassKey DensityValueKey() {
        return this.DensityValueKey;
    }

    public scala.collection.immutable.Map<String, String> configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?, ?> index, Option<Filter> filter2, Hints hints) {
        Envelope envelope = (Envelope)QueryHints$.MODULE$.RichHints(hints).getDensityEnvelope().get();
        Tuple2 tuple2 = (Tuple2)QueryHints$.MODULE$.RichHints(hints).getDensityBounds().get();
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int width = tuple2._1$mcI$sp();
            int height = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(width, height);
            int width2 = sp3._1$mcI$sp();
            int height2 = sp3._2$mcI$sp();
            scala.collection.immutable.Map<String, String> base = AggregatingScan$.MODULE$.configure(sft, index, filter2, (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$, QueryHints$.MODULE$.RichHints(hints).getSampling());
            return base.$plus$plus(AggregatingScan$.MODULE$.optionalMap((Seq<Tuple2<String, Either<String, Option<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.EnvelopeOpt()), AggregatingScan$.MODULE$.StringToConfig(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ",", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)envelope.getMinX()), BoxesRunTime.boxToDouble((double)envelope.getMaxX()), BoxesRunTime.boxToDouble((double)envelope.getMinY()), BoxesRunTime.boxToDouble((double)envelope.getMaxY())})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.GridOpt()), AggregatingScan$.MODULE$.StringToConfig(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)width2), BoxesRunTime.boxToInteger((int)height2)})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DensityScan$Configuration$.MODULE$.WeightOpt()), AggregatingScan$.MODULE$.OptionToConfig(QueryHints$.MODULE$.RichHints(hints).getDensityWeight()))})));
        }
        throw new MatchError((Object)tuple2);
    }

    public byte[] encodeResult(Map<Tuple2<Object, Object>, Object> result) {
        Output output = KryoFeatureSerialization$.MODULE$.getOutput(null);
        result.toList().groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Tuple2<Object, Object>, Object> x$5) {
                return ((Tuple2)x$5._1())._1$mcI$sp();
            }
        }).foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            public final Output output$1;

            public final void apply(Tuple2<Object, List<Tuple2<Tuple2<Object, Object>, Object>>> x0$1) {
                Tuple2<Object, List<Tuple2<Tuple2<Object, Object>, Object>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int row = tuple2._1$mcI$sp();
                    List cols = (List)tuple2._2();
                    this.output$1.writeInt(row, true);
                    this.output$1.writeInt(cols.size(), true);
                    cols.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.encodeResult.2 $outer;

                        public final void apply(Tuple2<Tuple2<Object, Object>, Object> x0$2) {
                            Tuple2<Tuple2<Object, Object>, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                Tuple2 xy = (Tuple2)tuple2._1();
                                double weight = tuple2._2$mcD$sp();
                                this.$outer.output$1.writeInt(xy._2$mcI$sp(), true);
                                this.$outer.output$1.writeDouble(weight);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$1 = output$1;
            }
        });
        return output.toBytes();
    }

    public Function1<SimpleFeature, Iterator<Tuple3<Object, Object, Object>>> decodeResult(Envelope envelope, int gridWidth, int gridHeight) {
        GridSnap gridSnap = new GridSnap(envelope, gridWidth, gridHeight);
        return new Serializable(gridSnap){
            public static final long serialVersionUID = 0L;
            private final GridSnap eta$0$1$1;

            public final Iterator<Tuple3<Object, Object, Object>> apply(SimpleFeature sf) {
                return DensityScan$.MODULE$.decodeResult(this.eta$0$1$1, sf);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
    }

    public Iterator<Tuple3<Object, Object, Object>> decodeResult(GridSnap gridSnap, SimpleFeature sf) {
        byte[] result = (byte[])sf.getUserData().get(this.DensityValueKey());
        Input input = KryoFeatureDeserialization$.MODULE$.getInput(result, 0, result.length);
        return new Iterator<Tuple3<Object, Object, Object>>(gridSnap, input){
            private double x;
            private int colCount;
            private final GridSnap gridSnap$1;
            private final Input input$1;

            public Iterator<Tuple3<Object, Object, Object>> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<Tuple3<Object, Object, Object>> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<Tuple3<Object, Object, Object>> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<Tuple3<Object, Object, Object>> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple3<Object, Object, Object>, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple3<Object, Object, Object>, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<Tuple3<Object, Object, Object>> filter(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple3<Object, Object, Object>, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> withFilter(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> filterNot(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple3<Object, Object, Object>, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<Tuple3<Object, Object, Object>> takeWhile(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> partition(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> span(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<Tuple3<Object, Object, Object>> dropWhile(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple3<Object, Object, Object>, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple3<Object, Object, Object>, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple3<Object, Object, Object>, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<Tuple3<Object, Object, Object>> find(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<Tuple3<Object, Object, Object>> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<Tuple3<Object, Object, Object>>, Iterator<Tuple3<Object, Object, Object>>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<Tuple3<Object, Object, Object>> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<Tuple3<Object, Object, Object>> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<Tuple3<Object, Object, Object>> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<Tuple3<Object, Object, Object>> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<Tuple3<Object, Object, Object>, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple3<Object, Object, Object>, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple3<Object, Object, Object>, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple3<Object, Object, Object>, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple3<Object, Object, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<Tuple3<Object, Object, Object>> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<Tuple3<Object, Object, Object>> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<Tuple3<Object, Object, Object>> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<Tuple3<Object, Object, Object>> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<Tuple3<Object, Object, Object>> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple3<Object, Object, Object>, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Tuple3<Object, Object, Object>, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private double x() {
                return this.x;
            }

            private void x_$eq(double x$1) {
                this.x = x$1;
            }

            private int colCount() {
                return this.colCount;
            }

            private void colCount_$eq(int x$1) {
                this.colCount = x$1;
            }

            public boolean hasNext() {
                return this.input$1.position() < this.input$1.limit();
            }

            public Tuple3<Object, Object, Object> next() {
                if (this.colCount() == 0) {
                    this.x_$eq(this.gridSnap$1.x(this.input$1.readInt(true)));
                    this.colCount_$eq(this.input$1.readInt(true));
                }
                double y = this.gridSnap$1.y(this.input$1.readInt(true));
                double weight = this.input$1.readDouble();
                this.colCount_$eq(this.colCount() - 1);
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)this.x()), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToDouble((double)weight));
            }
            {
                this.gridSnap$1 = gridSnap$1;
                this.input$1 = input$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.x = 0.0;
                this.colCount = 0;
            }
        };
    }

    public Function1<SimpleFeature, Object> getWeight(SimpleFeatureType sft, Option<String> weight) {
        Object object;
        int weightIndex = BoxesRunTime.unboxToInt((Object)weight.map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final int apply(String x$1) {
                return this.sft$1.indexOf(x$1);
            }
            {
                this.sft$1 = sft$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -2;
            }
        }));
        if (weightIndex == -2) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(SimpleFeature x$6) {
                    return 1.0;
                }
            };
        } else if (weightIndex == -1) {
            Expression expression = ECQL.toExpression((String)((String)weight.get()));
            object = new Serializable(expression){
                public static final long serialVersionUID = 0L;
                private final Expression eta$0$2$1;

                public final double apply(SimpleFeature sf) {
                    return DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$getWeightFromExpression(this.eta$0$2$1, sf);
                }
                {
                    this.eta$0$2$1 = eta$0$2$1;
                }
            };
        } else {
            object = Number.class.isAssignableFrom(sft.getDescriptor(weightIndex).getType().getBinding()) ? new Serializable(weightIndex){
                public static final long serialVersionUID = 0L;
                private final int weightIndex$1;

                public final double apply(SimpleFeature sf) {
                    return DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$getWeightFromNumber(this.weightIndex$1, sf);
                }
                {
                    this.weightIndex$1 = weightIndex$1;
                }
            } : new Serializable(weightIndex){
                public static final long serialVersionUID = 0L;
                private final int weightIndex$1;

                public final double apply(SimpleFeature sf) {
                    return DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$getWeightFromNonNumber(this.weightIndex$1, sf);
                }
                {
                    this.weightIndex$1 = weightIndex$1;
                }
            };
        }
        return object;
    }

    public Seq<String> propertyNames(Hints hints, SimpleFeatureType sft) {
        Option weight = QueryHints$.MODULE$.RichHints(hints).getDensityWeight().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Expression apply(String x$1) {
                return ECQL.toExpression((String)x$1);
            }
        });
        return (Seq)((SeqLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(weight).toSeq().flatMap((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final Seq<String> apply(Expression x$7) {
                return FilterHelper$.MODULE$.propertyNames(x$7, this.sft$2);
            }
            {
                this.sft$2 = sft$2;
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public Function3<SimpleFeature, Object, Map<Tuple2<Object, Object>, Object>, BoxedUnit> writeGeometry(SimpleFeatureType sft, GridSnap grid) {
        Object object;
        Class clazz;
        int geomIndex = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Class clazz2 = clazz = sft.getGeometryDescriptor().getType().getBinding();
        Class<Point> clazz3 = Point.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            object = new Serializable(grid, geomIndex){
                public static final long serialVersionUID = 0L;
                private final GridSnap grid$1;
                private final int geomIndex$1;

                public final void apply(SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
                    DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$writePoint(this.geomIndex$1, this.grid$1, sf, weight, result);
                }
                {
                    this.grid$1 = grid$1;
                    this.geomIndex$1 = geomIndex$1;
                }
            };
        } else {
            Class clazz4 = clazz;
            Class<MultiPoint> clazz5 = MultiPoint.class;
            if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                object = new Serializable(grid, geomIndex){
                    public static final long serialVersionUID = 0L;
                    private final GridSnap grid$1;
                    private final int geomIndex$1;

                    public final void apply(SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
                        DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$writeMultiPoint(this.geomIndex$1, this.grid$1, sf, weight, result);
                    }
                    {
                        this.grid$1 = grid$1;
                        this.geomIndex$1 = geomIndex$1;
                    }
                };
            } else {
                Class clazz6 = clazz;
                Class<LineString> clazz7 = LineString.class;
                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                    object = new Serializable(grid, geomIndex){
                        public static final long serialVersionUID = 0L;
                        private final GridSnap grid$1;
                        private final int geomIndex$1;

                        public final void apply(SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
                            DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$writeLineString(this.geomIndex$1, this.grid$1, sf, weight, result);
                        }
                        {
                            this.grid$1 = grid$1;
                            this.geomIndex$1 = geomIndex$1;
                        }
                    };
                } else {
                    Class clazz8 = clazz;
                    Class<MultiLineString> clazz9 = MultiLineString.class;
                    object = !(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null) ? new Serializable(grid, geomIndex){
                        public static final long serialVersionUID = 0L;
                        private final GridSnap grid$1;
                        private final int geomIndex$1;

                        public final void apply(SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
                            DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$writeMultiLineString(this.geomIndex$1, this.grid$1, sf, weight, result);
                        }
                        {
                            this.grid$1 = grid$1;
                            this.geomIndex$1 = geomIndex$1;
                        }
                    } : new Serializable(grid, geomIndex){
                        public static final long serialVersionUID = 0L;
                        private final GridSnap grid$1;
                        private final int geomIndex$1;

                        public final void apply(SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
                            DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$writeGeometry(this.geomIndex$1, this.grid$1, sf, weight, result);
                        }
                        {
                            this.grid$1 = grid$1;
                            this.geomIndex$1 = geomIndex$1;
                        }
                    };
                }
            }
        }
        return object;
    }

    public double org$locationtech$geomesa$index$iterators$DensityScan$$getWeightFromNumber(int i, SimpleFeature sf) {
        Number d = (Number)sf.getAttribute(i);
        return d == null ? 0.0 : d.doubleValue();
    }

    public double org$locationtech$geomesa$index$iterators$DensityScan$$getWeightFromNonNumber(int i, SimpleFeature sf) {
        Double converted;
        Object d = sf.getAttribute(i);
        return d == null ? 0.0 : ((converted = (Double)Converters.convert((Object)d, Double.class)) == null ? 1.0 : Predef$.MODULE$.Double2double(converted));
    }

    public double org$locationtech$geomesa$index$iterators$DensityScan$$getWeightFromExpression(Expression e, SimpleFeature sf) {
        Double d = (Double)e.evaluate((Object)sf, Double.class);
        return d == null ? 0.0 : Predef$.MODULE$.Double2double(d);
    }

    public void org$locationtech$geomesa$index$iterators$DensityScan$$writePoint(int geomIndex, GridSnap grid, SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
        this.writePointToResult((Point)sf.getAttribute(geomIndex), weight, grid, result);
    }

    public void org$locationtech$geomesa$index$iterators$DensityScan$$writeMultiPoint(int geomIndex, GridSnap grid, SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
        this.writeMultiPointToResult((MultiPoint)sf.getAttribute(geomIndex), weight, grid, result);
    }

    public void org$locationtech$geomesa$index$iterators$DensityScan$$writeLineString(int geomIndex, GridSnap grid, SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
        this.writeLineToResult((LineString)sf.getAttribute(geomIndex), weight, grid, result);
    }

    public void org$locationtech$geomesa$index$iterators$DensityScan$$writeMultiLineString(int geomIndex, GridSnap grid, SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
        this.writeMultiLineToResult((MultiLineString)sf.getAttribute(geomIndex), weight, grid, result);
    }

    private void writePolygon(int geomIndex, GridSnap grid, SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
        this.writePolygonToResult((Polygon)sf.getAttribute(geomIndex), weight, grid, result);
    }

    private void writeMultiPolygon(int geomIndex, GridSnap grid, SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
        this.writeMultiPolygonToResult((MultiPolygon)sf.getAttribute(geomIndex), weight, grid, result);
    }

    public void org$locationtech$geomesa$index$iterators$DensityScan$$writeGeometry(int geomIndex, GridSnap grid, SimpleFeature sf, double weight, Map<Tuple2<Object, Object>, Object> result) {
        this.org$locationtech$geomesa$index$iterators$DensityScan$$writeGeometryToResult((Geometry)sf.getAttribute(geomIndex), weight, grid, result);
    }

    private void writePointToResult(Point pt, double weight, GridSnap grid, Map<Tuple2<Object, Object>, Object> result) {
        this.org$locationtech$geomesa$index$iterators$DensityScan$$writeSnappedPoint(grid.i(pt.getX()), grid.j(pt.getY()), weight, result);
    }

    private void writeMultiPointToResult(MultiPoint pts, double weight, GridSnap grid, Map<Tuple2<Object, Object>, Object> result) {
        for (int i = 0; i < pts.getNumGeometries(); ++i) {
            this.writePointToResult((Point)pts.getGeometryN(i), weight, grid, result);
        }
    }

    private void writeLineToResult(LineString ls, double weight, GridSnap grid, Map<Tuple2<Object, Object>, Object> result) {
        if (ls.getNumPoints() < 1) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Encountered line string with fewer than two points: {}", new Object[]{ls});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            IntRef iN = IntRef.create((int)-1);
            IntRef jN = IntRef.create((int)-1);
            Seq points = (Seq)Seq$.MODULE$.tabulate(ls.getNumPoints(), (Function1)new Serializable(ls, grid){
                public static final long serialVersionUID = 0L;
                private final LineString ls$1;
                private final GridSnap grid$2;

                public final Tuple3<Coordinate, Object, Object> apply(int i) {
                    Coordinate p = this.ls$1.getCoordinateN(i);
                    return new Tuple3((Object)p, (Object)BoxesRunTime.boxToInteger((int)this.grid$2.i(p.x)), (Object)BoxesRunTime.boxToInteger((int)this.grid$2.j(p.y)));
                }
                {
                    this.ls$1 = ls$1;
                    this.grid$2 = grid$2;
                }
            });
            points.sliding(2).foreach((Function1)new Serializable(weight, grid, result, iN, jN){
                public static final long serialVersionUID = 0L;
                private final double weight$1;
                private final GridSnap grid$2;
                private final Map result$1;
                private final IntRef iN$1;
                private final IntRef jN$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void apply(Seq<Tuple3<Coordinate, Object, Object>> x0$3) {
                    BoxedUnit boxedUnit;
                    block12: {
                        Seq<Tuple3<Coordinate, Object, Object>> seq;
                        block13: {
                            seq = x0$3;
                            Some some = Seq$.MODULE$.unapplySeq(seq);
                            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block13;
                            Tuple3 tuple3 = (Tuple3)((SeqLike)some.get()).apply(0);
                            Tuple3 tuple32 = (Tuple3)((SeqLike)some.get()).apply(1);
                            if (tuple3 == null) break block13;
                            Coordinate p0 = (Coordinate)tuple3._1();
                            int i0 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                            int j0 = BoxesRunTime.unboxToInt((Object)tuple3._3());
                            if (tuple32 == null) break block13;
                            Coordinate p1 = (Coordinate)tuple32._1();
                            int i1 = BoxesRunTime.unboxToInt((Object)tuple32._2());
                            int j1 = BoxesRunTime.unboxToInt((Object)tuple32._3());
                            if (i0 == -1 || j0 == -1 || i1 == -1 || j1 == -1) {
                                try {
                                    Geometry intersection = GeometryUtils$.MODULE$.geoFactory().createLineString((Coordinate[])((Object[])new Coordinate[]{p0, p1})).intersection(this.grid$2.envelope());
                                    if (intersection.isEmpty()) {
                                        boxedUnit = BoxedUnit.UNIT;
                                        break block12;
                                    }
                                    DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$writeGeometryToResult(intersection, this.weight$1, this.grid$2, (Map<Tuple2<Object, Object>, Object>)this.result$1);
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                catch (Throwable throwable) {
                                    BoxedUnit boxedUnit2;
                                    Throwable throwable2 = throwable;
                                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                                    if (option.isEmpty()) {
                                        throw throwable;
                                    }
                                    Throwable e = (Throwable)option.get();
                                    if (DensityScan$.MODULE$.logger().underlying().isErrorEnabled()) {
                                        DensityScan$.MODULE$.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error intersecting line string [", " ", "] with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p0, p1, this.grid$2.envelope()})), e);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit3 = boxedUnit2;
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                break block12;
                            } else {
                                boolean next2;
                                Tuple2.mcII.sp sp2;
                                Iterator bresenham = this.grid$2.bresenhamLine(i0, j0, i1, j1);
                                Tuple2 tuple2 = (Tuple2)bresenham.next();
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                int iF = tuple2._1$mcI$sp();
                                int jF = tuple2._2$mcI$sp();
                                Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(iF, jF);
                                int iF2 = sp3._1$mcI$sp();
                                int jF2 = sp3._2$mcI$sp();
                                if (iF2 != this.iN$1.elem || jF2 != this.jN$1.elem) {
                                    DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$writeSnappedPoint(iF2, jF2, this.weight$1, (Map<Tuple2<Object, Object>, Object>)this.result$1);
                                }
                                if (next2 = bresenham.hasNext()) {
                                    this.writeNext$1(bresenham);
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block12;
                                } else {
                                    this.iN$1.elem = iF2;
                                    this.jN$1.elem = jF2;
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                            break block12;
                        }
                        throw new MatchError(seq);
                    }
                    BoxedUnit boxedUnit4 = boxedUnit;
                }

                private final void writeNext$1(Iterator bresenham$1) {
                    Tuple2 tuple2;
                    while ((tuple2 = (Tuple2)bresenham$1.next()) != null) {
                        Tuple2.mcII.sp sp2;
                        int i = tuple2._1$mcI$sp();
                        int j = tuple2._2$mcI$sp();
                        Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(i, j);
                        int i2 = sp3._1$mcI$sp();
                        int j2 = sp3._2$mcI$sp();
                        DensityScan$.MODULE$.org$locationtech$geomesa$index$iterators$DensityScan$$writeSnappedPoint(i2, j2, this.weight$1, (Map<Tuple2<Object, Object>, Object>)this.result$1);
                        if (bresenham$1.hasNext()) continue;
                        this.iN$1.elem = i2;
                        this.jN$1.elem = j2;
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.weight$1 = weight$1;
                    this.grid$2 = grid$2;
                    this.result$1 = result$1;
                    this.iN$1 = iN$1;
                    this.jN$1 = jN$1;
                }
            });
        }
    }

    private void writeMultiLineToResult(MultiLineString lines, double weight, GridSnap grid, Map<Tuple2<Object, Object>, Object> result) {
        for (int i = 0; i < lines.getNumGeometries(); ++i) {
            this.writeLineToResult((LineString)lines.getGeometryN(i), weight, grid, result);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writePolygonToResult(Polygon poly, double weight, GridSnap grid, Map<Tuple2<Object, Object>, Object> result) {
        Envelope envelope = poly.getEnvelopeInternal();
        int imin = grid.i(envelope.getMinX());
        int imax = grid.i(envelope.getMaxX());
        int jmin = grid.j(envelope.getMinY());
        int jmax = grid.j(envelope.getMaxY());
        if (imin == -1 || imax == -1 || jmin == -1 || jmax == -1) {
            try {
                Geometry intersection = poly.intersection(grid.envelope());
                if (intersection.isEmpty()) return;
                this.org$locationtech$geomesa$index$iterators$DensityScan$$writeGeometryToResult(intersection, weight, grid, result);
                return;
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error intersecting polygon [", "] with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{poly, grid.envelope()})), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        } else {
            int iLength = imax - imin + 1;
            int jLength = jmax - jmin + 1;
            BufferedImage image = new BufferedImage(iLength, jLength, 12);
            Graphics2D graphics = image.createGraphics();
            LineString border = poly.getExteriorRing();
            int[] xPoints = (int[])Array$.MODULE$.ofDim(border.getNumPoints(), ClassTag$.MODULE$.Int());
            int[] yPoints = (int[])Array$.MODULE$.ofDim(border.getNumPoints(), ClassTag$.MODULE$.Int());
            for (int i = 0; i < xPoints.length; ++i) {
                Coordinate coord = border.getCoordinateN(i);
                xPoints[i] = grid.i(coord.x) - imin;
                yPoints[i] = grid.j(coord.y) - jmin;
            }
            graphics.fillPolygon(xPoints, yPoints, xPoints.length);
            WritableRaster raster = image.getRaster();
            int i = 0;
            int j = 0;
            while (i < iLength) {
                while (j < jLength) {
                    if (raster.getSample(i, j, 0) != 0) {
                        this.org$locationtech$geomesa$index$iterators$DensityScan$$writeSnappedPoint(i + imin, j + jmin, weight, result);
                    }
                    ++j;
                }
                j = 0;
                ++i;
            }
            return;
        }
    }

    private void writeMultiPolygonToResult(MultiPolygon polys, double weight, GridSnap grid, Map<Tuple2<Object, Object>, Object> result) {
        for (int i = 0; i < polys.getNumGeometries(); ++i) {
            this.writePolygonToResult((Polygon)polys.getGeometryN(i), weight, grid, result);
        }
    }

    public void org$locationtech$geomesa$index$iterators$DensityScan$$writeGeometryToResult(Geometry geometry, double weight, GridSnap grid, Map<Tuple2<Object, Object>, Object> result) {
        Geometry geometry2;
        block10: {
            block4: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block3: {
                                        geometry2 = geometry;
                                        if (!(geometry2 instanceof Point)) break block3;
                                        Point point = (Point)geometry2;
                                        this.writePointToResult(point, weight, grid, result);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    if (!(geometry2 instanceof LineString)) break block5;
                                    LineString lineString = (LineString)geometry2;
                                    this.writeLineToResult(lineString, weight, grid, result);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                if (!(geometry2 instanceof Polygon)) break block6;
                                Polygon polygon = (Polygon)geometry2;
                                this.writePolygonToResult(polygon, weight, grid, result);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (!(geometry2 instanceof MultiPoint)) break block7;
                            MultiPoint multiPoint = (MultiPoint)geometry2;
                            this.writeMultiPointToResult(multiPoint, weight, grid, result);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (!(geometry2 instanceof MultiLineString)) break block8;
                        MultiLineString multiLineString = (MultiLineString)geometry2;
                        this.writeMultiLineToResult(multiLineString, weight, grid, result);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!(geometry2 instanceof MultiPolygon)) break block9;
                    MultiPolygon multiPolygon = (MultiPolygon)geometry2;
                    this.writeMultiPolygonToResult(multiPolygon, weight, grid, result);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (!(geometry2 instanceof GeometryCollection)) break block10;
                GeometryCollection geometryCollection = (GeometryCollection)geometry2;
                for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                    this.org$locationtech$geomesa$index$iterators$DensityScan$$writeGeometryToResult(geometryCollection.getGeometryN(i), weight, grid, result);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)geometry2);
    }

    public void org$locationtech$geomesa$index$iterators$DensityScan$$writeSnappedPoint(int i, int j, double weight, Map<Tuple2<Object, Object>, Object> result) {
        if (i != -1 && j != -1) {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(i, j);
            result.update((Object)sp2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)result.apply((Object)sp2)) + weight)));
        }
    }

    private DensityScan$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.DensitySft = SimpleFeatureTypes.createType((String)"density", (String)"*geom:Point:srid=4326");
        this.DensityValueKey = new Hints.ClassKey(byte[].class);
    }
}

