/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.canonicalizer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.calrissian.mango.types.SimpleTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;
import org.calrissian.mango.types.canonicalizer.domain.CanonicalDef;
import org.calrissian.mango.types.canonicalizer.validator.Validator;

public class CanonicalizerContext {
    private final TypeRegistry<String> typeContext;
    private Map<String, Class<? extends Validator>> validatorClasses;
    private Map<String, String> matchers;
    private Map<String, String> types;
    private Map<String, Validator> validators;

    public CanonicalizerContext() throws IOException {
        this(SimpleTypeEncoders.SIMPLE_TYPES);
    }

    public CanonicalizerContext(TypeRegistry<String> typeContext) throws IOException {
        this.typeContext = typeContext;
        this.loadCanonicalDefs();
    }

    private void loadCanonicalDefs() throws IOException {
        String[] info;
        String theKey;
        this.validatorClasses = new HashMap<String, Class<? extends Validator>>();
        this.types = new HashMap<String, String>();
        this.matchers = new HashMap<String, String>();
        this.validators = new HashMap<String, Validator>();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("validators.properties");
        Properties props = new Properties();
        props.load(is);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            theKey = (String)entry.getKey();
            info = theKey.split("\\.");
            if (info.length != 2 || !"validator".equals(info[0])) continue;
            try {
                this.validatorClasses.put(info[1], this.getClass().getClassLoader().loadClass((String)entry.getValue()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        is = this.getClass().getClassLoader().getResourceAsStream("canonicalDefs.properties");
        props = new Properties();
        props.load(is);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            theKey = (String)entry.getKey();
            info = theKey.split("\\.");
            if (info.length == 2) {
                if (info[1].equals("type")) {
                    this.types.put(info[0], (String)entry.getValue());
                    continue;
                }
                if (!info[1].equals("matcher")) continue;
                this.matchers.put(info[0], (String)entry.getValue());
                continue;
            }
            if (info.length != 3 || !"validator".equals(info[2])) continue;
            Class<? extends Validator> vclass = this.validatorClasses.get(info[1]);
            if (vclass == null) {
                throw new IllegalArgumentException("Validator not found for type: " + info[1]);
            }
            try {
                Validator validator = vclass.newInstance();
                validator.configure((String)entry.getValue());
                this.validators.put(info[0], validator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Object canonicalizeValueFromString(String typeName, String value) {
        Validator validator;
        String datatype = this.types.get(typeName);
        if (datatype == null) {
            throw new IllegalArgumentException(typeName + " is not a recognized type.");
        }
        String matcher = this.matchers.get(typeName);
        Validator validator2 = validator = matcher != null ? this.validators.get(matcher) : null;
        if (validator != null && !validator.validate(value)) {
            throw new IllegalArgumentException(value + " did not validate with validator: " + validator.getClass());
        }
        return this.typeContext.decode(datatype, value.trim());
    }

    public List<CanonicalDef> getCanonicalDefs() {
        ArrayList<CanonicalDef> canonicalDefs = new ArrayList<CanonicalDef>();
        for (Map.Entry<String, String> entry : this.types.entrySet()) {
            String type = entry.getKey();
            String dataType = entry.getValue();
            canonicalDefs.add(new CanonicalDef(type, dataType));
        }
        Collections.sort(canonicalDefs);
        return Collections.unmodifiableList(canonicalDefs);
    }
}

