/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public class MapRemove
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("", "http://www.w3.org/2005/xpath-functions/map", "remove");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{HashTrieMap.SINGLE_MAP_TYPE, SequenceType.ATOMIC_SEQUENCE};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return HashTrieMap.SINGLE_MAP_TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                AtomicValue key;
                MapItem map = (MapItem)arguments[0].head();
                SequenceIterator iter = arguments[1].iterate();
                while ((key = (AtomicValue)iter.next()) != null) {
                    map = map.remove(key);
                }
                return map;
            }
        };
    }
}

