/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.utils;

import org.geotools.data.Query;
import org.geotools.feature.FeatureTypes;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;

public final class Reprojection$ {
    public static final Reprojection$ MODULE$;

    static {
        new Reprojection$();
    }

    public Option<Reprojection> apply(Query query) {
        None$ none$;
        SimpleFeatureType sft = QueryHints$.MODULE$.RichHints(query.getHints()).getReturnSft();
        if (sft.getGeometryDescriptor() == null) {
            none$ = None$.MODULE$;
        } else {
            CoordinateReferenceSystem target;
            CoordinateReferenceSystem coordinateReferenceSystem = sft.getGeometryDescriptor().getCoordinateReferenceSystem();
            CoordinateReferenceSystem source = (CoordinateReferenceSystem)Option$.MODULE$.apply((Object)query.getCoordinateSystem()).getOrElse((Function0)new Serializable(coordinateReferenceSystem){
                public static final long serialVersionUID = 0L;
                private final CoordinateReferenceSystem native$1;

                public final CoordinateReferenceSystem apply() {
                    return this.native$1;
                }
                {
                    this.native$1 = native$1;
                }
            });
            CoordinateReferenceSystem coordinateReferenceSystem2 = target = (CoordinateReferenceSystem)Option$.MODULE$.apply((Object)query.getCoordinateSystemReproject()).getOrElse((Function0)new Serializable(coordinateReferenceSystem){
                public static final long serialVersionUID = 0L;
                private final CoordinateReferenceSystem native$1;

                public final CoordinateReferenceSystem apply() {
                    return this.native$1;
                }
                {
                    this.native$1 = native$1;
                }
            });
            CoordinateReferenceSystem coordinateReferenceSystem3 = source;
            if (!(coordinateReferenceSystem2 != null ? !coordinateReferenceSystem2.equals(coordinateReferenceSystem3) : coordinateReferenceSystem3 != null)) {
                CoordinateReferenceSystem coordinateReferenceSystem4 = source;
                CoordinateReferenceSystem coordinateReferenceSystem5 = coordinateReferenceSystem;
                if (!(coordinateReferenceSystem4 != null ? !coordinateReferenceSystem4.equals(coordinateReferenceSystem5) : coordinateReferenceSystem5 != null)) {
                    none$ = None$.MODULE$;
                } else {
                    SimpleFeatureType reprojected = FeatureTypes.transform((SimpleFeatureType)sft, (CoordinateReferenceSystem)source);
                    reprojected.getUserData().putAll(sft.getUserData());
                    none$ = new Some((Object)new Reprojection(reprojected, (Option<GeometryCoordinateSequenceTransformer>)None$.MODULE$));
                }
            } else {
                GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
                transformer.setMathTransform(CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (boolean)true));
                SimpleFeatureType reprojected = FeatureTypes.transform((SimpleFeatureType)sft, (CoordinateReferenceSystem)target);
                reprojected.getUserData().putAll(sft.getUserData());
                none$ = new Some((Object)new Reprojection(reprojected, (Option<GeometryCoordinateSequenceTransformer>)new Some((Object)transformer)));
            }
        }
        return none$;
    }

    private Reprojection$() {
        MODULE$ = this;
    }
}

