/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.algorithm.RectangleLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.ShortCircuitedGeometryVisitor;
import java.util.List;

class RectangleIntersectsSegmentVisitor
extends ShortCircuitedGeometryVisitor {
    private Envelope rectEnv;
    private RectangleLineIntersector rectIntersector;
    private boolean hasIntersection = false;
    private Coordinate p0 = new Coordinate();
    private Coordinate p1 = new Coordinate();

    public RectangleIntersectsSegmentVisitor(Polygon rectangle) {
        this.rectEnv = rectangle.getEnvelopeInternal();
        this.rectIntersector = new RectangleLineIntersector(this.rectEnv);
    }

    public boolean intersects() {
        return this.hasIntersection;
    }

    protected void visit(Geometry geom) {
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        List lines = LinearComponentExtracter.getLines(geom);
        this.checkIntersectionWithLineStrings(lines);
    }

    private void checkIntersectionWithLineStrings(List lines) {
        for (LineString testLine : lines) {
            this.checkIntersectionWithSegments(testLine);
            if (!this.hasIntersection) continue;
            return;
        }
    }

    private void checkIntersectionWithSegments(LineString testLine) {
        CoordinateSequence seq1 = testLine.getCoordinateSequence();
        int j = 1;
        while (j < seq1.size()) {
            seq1.getCoordinate(j - 1, this.p0);
            seq1.getCoordinate(j, this.p1);
            if (this.rectIntersector.intersects(this.p0, this.p1)) {
                this.hasIntersection = true;
                return;
            }
            ++j;
        }
    }

    protected boolean isDone() {
        return this.hasIntersection;
    }
}

