/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import org.locationtech.geomesa.utils.geohash.BoundingBox;
import org.locationtech.geomesa.utils.geohash.BoundingBox$;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.geohash.GeohashUtils;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3$;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$4$;
import org.locationtech.geomesa.utils.geohash.GeomDistance;
import org.locationtech.geomesa.utils.geohash.GeomDistance$Distance$;
import org.locationtech.geomesa.utils.geohash.GeomDistance$class;
import org.locationtech.geomesa.utils.geohash.VincentyModel$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.iterators.CartesianProductIterable;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.BitSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileByteRef;
import scala.runtime.VolatileObjectRef;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class GeohashUtils$
implements GeomDistance,
LazyLogging {
    public static final GeohashUtils$ MODULE$;
    private final Seq<Object> base32seq;
    private Polygon wholeEarthBBox;
    private final IndexedSeq<List<Seq<Object>>> Base32Padding;
    private final IndexedSeq<List<Seq<Object>>> BinaryPadding;
    private final int maxRealisticGeoHashPrecision;
    private final long numDistinctGridPoints;
    private final PrecisionModel defaultPrecisionModel;
    private final GeometryFactory defaultGeometryFactory;
    private Geometry emptyGeometry;
    private final Logger logger;
    private volatile byte bitmap$0;
    private volatile GeomDistance$Distance$ Distance$module;

    static {
        new GeohashUtils$();
    }

    private Polygon wholeEarthBBox$lzycompute() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.wholeEarthBBox = this.defaultGeometryFactory().createPolygon((Coordinate[])((Object[])new Coordinate[]{new Coordinate(-180.0, 90.0), new Coordinate(-180.0, -90.0), new Coordinate(180.0, -90.0), new Coordinate(180.0, 90.0), new Coordinate(-180.0, 90.0)}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.wholeEarthBBox;
        }
    }

    private Geometry emptyGeometry$lzycompute() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.emptyGeometry = WKTUtils$.MODULE$.read("POLYGON((0 0,0 0,0 0,0 0,0 0))");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.emptyGeometry;
        }
    }

    private Logger logger$lzycompute() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.logger$lzycompute() : this.logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GeomDistance$Distance$ Distance$lzycompute() {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if (this.Distance$module != null) return this.Distance$module;
            this.Distance$module = new GeomDistance$Distance$(this);
            return this.Distance$module;
        }
    }

    @Override
    public GeomDistance$Distance$ Distance() {
        return this.Distance$module == null ? this.Distance$lzycompute() : this.Distance$module;
    }

    public Seq<Object> base32seq() {
        return this.base32seq;
    }

    public Polygon wholeEarthBBox() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.wholeEarthBBox$lzycompute() : this.wholeEarthBBox;
    }

    public IndexedSeq<List<Seq<Object>>> Base32Padding() {
        return this.Base32Padding;
    }

    public IndexedSeq<List<Seq<Object>>> BinaryPadding() {
        return this.BinaryPadding;
    }

    public Geometry wkt2geom(String wkt) {
        return WKTUtils$.MODULE$.read(wkt);
    }

    public String getGeohashWKT(GeoHash gh) {
        return WKTUtils$.MODULE$.write(GeoHash$.MODULE$.toGeometry(gh));
    }

    public int maxRealisticGeoHashPrecision() {
        return this.maxRealisticGeoHashPrecision;
    }

    public long numDistinctGridPoints() {
        return this.numDistinctGridPoints;
    }

    public PrecisionModel defaultPrecisionModel() {
        return this.defaultPrecisionModel;
    }

    public GeometryFactory defaultGeometryFactory() {
        return this.defaultGeometryFactory;
    }

    public Tuple6<Point, Point, Point, Point, Point, Point> getGeohashPoints(GeoHash gh) {
        BoundingBox bbox = gh.bbox();
        Point lr = bbox.lr();
        Point ul = bbox.ul();
        Point ll = bbox.ll();
        Point ur = bbox.ur();
        double midLatitude = 0.5 * (lr.getY() + ul.getY());
        Point cl = lr.getFactory().createPoint(new Coordinate(ul.getX(), midLatitude));
        Point cr = lr.getFactory().createPoint(new Coordinate(lr.getX(), midLatitude));
        return new Tuple6((Object)ll, (Object)cl, (Object)ul, (Object)ur, (Object)cr, (Object)lr);
    }

    public double getGeohashAreaSquareMeters(GeoHash gh) {
        Tuple6<Point, Point, Point, Point, Point, Point> tuple6 = this.getGeohashPoints(gh);
        if (tuple6 != null) {
            Tuple4 tuple4;
            Point ll = (Point)tuple6._1();
            Point cl = (Point)tuple6._2();
            Point ul = (Point)tuple6._3();
            Point cr = (Point)tuple6._5();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)ll, (Object)cl, (Object)ul, (Object)cr);
            Point ll2 = (Point)tuple42._1();
            Point cl2 = (Point)tuple42._2();
            Point ul2 = (Point)tuple42._3();
            Point cr2 = (Point)tuple42._4();
            double dx = VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(cl2, cr2));
            double dy = VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(ll2, ul2));
            return dx * dy;
        }
        throw new MatchError(tuple6);
    }

    public double getGeohashExtremeDimensionMeters(GeoHash gh, Function2<Object, Object, Object> fExtreme) {
        Tuple6<Point, Point, Point, Point, Point, Point> tuple6 = this.getGeohashPoints(gh);
        if (tuple6 != null) {
            Tuple6 tuple62;
            Point ll = (Point)tuple6._1();
            Point cl = (Point)tuple6._2();
            Point ul = (Point)tuple6._3();
            Point ur = (Point)tuple6._4();
            Point cr = (Point)tuple6._5();
            Point lr = (Point)tuple6._6();
            Tuple6 tuple63 = tuple62 = new Tuple6((Object)ll, (Object)cl, (Object)ul, (Object)ur, (Object)cr, (Object)lr);
            Point ll2 = (Point)tuple63._1();
            Point cl2 = (Point)tuple63._2();
            Point ul2 = (Point)tuple63._3();
            Point ur2 = (Point)tuple63._4();
            Point cr2 = (Point)tuple63._5();
            Point lr2 = (Point)tuple63._6();
            return fExtreme.apply$mcDDD$sp(fExtreme.apply$mcDDD$sp(VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(ll2, lr2)), VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(ul2, ur2))), fExtreme.apply$mcDDD$sp(VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(ll2, ul2)), VincentyModel$.MODULE$.Distance().distance2double(VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(lr2, ur2))));
        }
        throw new MatchError(tuple6);
    }

    public double getGeohashMaxDimensionMeters(GeoHash gh) {
        return this.getGeohashExtremeDimensionMeters(gh, (Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x, double y) {
                return this.apply$mcDDD$sp(x, y);
            }

            public double apply$mcDDD$sp(double x, double y) {
                return package$.MODULE$.max(x, y);
            }
        });
    }

    public double getGeohashMinDimensionMeters(GeoHash gh) {
        return this.getGeohashExtremeDimensionMeters(gh, (Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x, double y) {
                return this.apply$mcDDD$sp(x, y);
            }

            public double apply$mcDDD$sp(double x, double y) {
                return package$.MODULE$.min(x, y);
            }
        });
    }

    public GeoHash getMinimumBoundingGeohash(Geometry geom, GeohashUtils.ResolutionRange resolutions) {
        Point centroid = this.getCentroid(geom);
        Geometry env = this.defaultGeometryFactory().toGeometry(geom.getEnvelopeInternal());
        Tuple2 tuple2 = (Tuple2)resolutions.foldRight(new Tuple2((Object)BoxesRunTime.boxToInteger((int)resolutions.minBitsResolution()), (Object)Option$.MODULE$.empty()), (Function2)new Serializable(centroid, env){
            public static final long serialVersionUID = 0L;
            private final Point centroid$1;
            private final Geometry env$1;

            public final Tuple2<Object, Option<GeoHash>> apply(int x0$2, Tuple2<Object, Option<GeoHash>> x1$2) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$2), x1$2);
                if (tuple2 != null) {
                    int bits = tuple2._1$mcI$sp();
                    Tuple2 orig = (Tuple2)tuple2._2();
                    if (orig != null) {
                        int res = orig._1$mcI$sp();
                        GeoHash gh = GeoHash$.MODULE$.apply(this.centroid$1.getX(), this.centroid$1.getY(), bits);
                        Tuple2 tuple22 = GeoHash$.MODULE$.toGeometry(gh).contains(this.env$1) && bits >= res ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)bits), (Object)new Some((Object)gh)) : orig;
                        return tuple22;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.centroid$1 = centroid$1;
                this.env$1 = env$1;
            }
        });
        if (tuple2 != null) {
            Option ghOpt = (Option)tuple2._2();
            Option option2 = ghOpt;
            Option ghOpt2 = option2;
            GeoHash gh = (GeoHash)ghOpt2.getOrElse((Function0)new Serializable(resolutions, centroid){
                public static final long serialVersionUID = 0L;
                private final GeohashUtils.ResolutionRange resolutions$1;
                private final Point centroid$1;

                public final GeoHash apply() {
                    return GeoHash$.MODULE$.apply(this.centroid$1.getX(), this.centroid$1.getY(), this.resolutions$1.minBitsResolution());
                }
                {
                    this.resolutions$1 = resolutions$1;
                    this.centroid$1 = centroid$1;
                }
            });
            if (GeoHash$.MODULE$.toGeometry(gh).contains(env) || gh.geom().equals(env)) {
                return gh;
            }
            throw new Exception(new StringBuilder().append((Object)"ERROR:  Could not find a suitable ").append((Object)BoxesRunTime.boxToInteger((int)resolutions.minBitsResolution())).append((Object)"-bit MBR for the target geometry:  ").append((Object)geom).toString());
        }
        throw new MatchError((Object)tuple2);
    }

    public GeomDistance.Distance getMinimumGeodeticDistance(BoundingBox bbox, Point point, boolean exhaustive) {
        GeohashUtils.GHClosePoint closestPoint = this.getClosestPoint(bbox, point, exhaustive);
        return closestPoint.chordLength() == 0.0 ? new GeomDistance.Distance(VincentyModel$.MODULE$, 0.0) : VincentyModel$.MODULE$.getDistanceBetweenTwoPoints(point, this.defaultGeometryFactory().createPoint(new Coordinate(Math.toDegrees(closestPoint.point().getX()), Math.toDegrees(closestPoint.point().getY()))));
    }

    public boolean getMinimumGeodeticDistance$default$3() {
        return false;
    }

    public double getMinimumChordLength(BoundingBox bbox, Point point, boolean exhaustive) {
        return this.getClosestPoint(bbox, point, exhaustive).chordLength();
    }

    public boolean getMinimumChordLength$default$3() {
        return false;
    }

    public GeohashUtils.GHClosePoint min(GeohashUtils.GHClosePoint p1, GeohashUtils.GHClosePoint p2) {
        return p1.chordLength() < p2.chordLength() ? p1 : p2;
    }

    private GeohashUtils.GHClosePoint getClosestPoint(BoundingBox bbox, Point point, boolean exhaustive) {
        GeohashUtils.GHClosePoint gHClosePoint;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        if (point.within(BoundingBox$.MODULE$.toGeometry(bbox))) {
            gHClosePoint = new GeohashUtils.GHClosePoint(point, 0.0);
        } else {
            Seq seq;
            ObjectRef topEdgeSolutions$lzy = ObjectRef.zero();
            ObjectRef bottomEdgeSolutions$lzy = ObjectRef.zero();
            ObjectRef leftEdgeSolutions$lzy = ObjectRef.zero();
            ObjectRef rightEdgeSolutions$lzy = ObjectRef.zero();
            double x = Math.toRadians(point.getX());
            double y = Math.toRadians(point.getY());
            double sinY = Math.sin(y);
            double sinX = Math.sin(x);
            double cosY = Math.cos(y);
            double cosX = Math.cos(x);
            double minLon = Math.toRadians(bbox.minLon());
            double maxLon = Math.toRadians(bbox.maxLon());
            double minLat = Math.toRadians(bbox.minLat());
            double maxLat = Math.toRadians(bbox.maxLat());
            if (exhaustive) {
                seq = (Seq)((TraversableLike)((TraversableLike)this.topEdgeSolutions$1(x, minLon, maxLon, maxLat, topEdgeSolutions$lzy, bitmap$0).$plus$plus((GenTraversableOnce)this.bottomEdgeSolutions$1(x, minLon, maxLon, minLat, bottomEdgeSolutions$lzy, bitmap$0), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.leftEdgeSolutions$1(y, sinX, cosX, minLon, minLat, maxLat, leftEdgeSolutions$lzy, bitmap$0), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.rightEdgeSolutions$1(y, sinX, cosX, maxLon, minLat, maxLat, rightEdgeSolutions$lzy, bitmap$0), Seq$.MODULE$.canBuildFrom());
            } else {
                double d;
                double d2 = y;
                double d3 = d2;
                Seq seq2 = d3 >= maxLat && x <= maxLon && x >= minLon ? this.topEdgeSolutions$1(x, minLon, maxLon, maxLat, topEdgeSolutions$lzy, bitmap$0) : ((d = d2) <= minLat && x <= maxLon && x >= minLon ? this.bottomEdgeSolutions$1(x, minLon, maxLon, minLat, bottomEdgeSolutions$lzy, bitmap$0) : (Seq)this.leftEdgeSolutions$1(y, sinX, cosX, minLon, minLat, maxLat, leftEdgeSolutions$lzy, bitmap$0).$plus$plus((GenTraversableOnce)this.rightEdgeSolutions$1(y, sinX, cosX, maxLon, minLat, maxLat, rightEdgeSolutions$lzy, bitmap$0), Seq$.MODULE$.canBuildFrom()));
                seq = seq2;
            }
            Seq pointsToTry = seq;
            gHClosePoint = (GeohashUtils.GHClosePoint)((TraversableOnce)pointsToTry.map((Function1)new Serializable(sinY, sinX, cosY, cosX){
                public static final long serialVersionUID = 0L;
                private final double sinY$1;
                private final double sinX$1;
                private final double cosY$1;
                private final double cosX$1;

                public final GeohashUtils.GHClosePoint apply(Point p) {
                    return new GeohashUtils.GHClosePoint(p, GeohashUtils$.MODULE$.org$locationtech$geomesa$utils$geohash$GeohashUtils$$getChordLength$1(p.getY(), p.getX(), this.sinY$1, this.sinX$1, this.cosY$1, this.cosX$1));
                }
                {
                    this.sinY$1 = sinY$1;
                    this.sinX$1 = sinX$1;
                    this.cosY$1 = cosY$1;
                    this.cosX$1 = cosX$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final GeohashUtils.GHClosePoint apply(GeohashUtils.GHClosePoint p1, GeohashUtils.GHClosePoint p2) {
                    return GeohashUtils$.MODULE$.min(p1, p2);
                }
            });
        }
        return gHClosePoint;
    }

    private boolean getClosestPoint$default$3() {
        return false;
    }

    public Point getCentroid(Geometry geom) {
        Point pt = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
        return geom.getFactory().createPoint(new Coordinate(pt.getX(), pt.getY()));
    }

    public Option<GeoHash> getMBGH(Point ll, Point ur) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option2;
            Object object = new Object();
            try {
                double width = ur.getX() - ll.getX();
                double height = ur.getY() - ll.getY();
                Predef$.MODULE$.require(width >= 0.0 && height >= 0.0, (Function0)new Serializable(width, height){
                    public static final long serialVersionUID = 0L;
                    private final double width$1;
                    private final double height$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong width ", " and height ", " of input bounding box, cannot process"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.width$1), BoxesRunTime.boxToDouble((double)this.height$1)}));
                    }
                    {
                        this.width$1 = width$1;
                        this.height$1 = height$1;
                    }
                });
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(60), 0).by(-5).foreach$mVc$sp((Function1)new Serializable(ll, ur, width, height, object){
                    public static final long serialVersionUID = 0L;
                    private final Point ll$1;
                    private final Point ur$1;
                    private final double width$1;
                    private final double height$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int prec) {
                        this.apply$mcVI$sp(prec);
                    }

                    public void apply$mcVI$sp(int prec) {
                        GeoHash geo;
                        double lonDelta = GeoHash$.MODULE$.longitudeDeltaForPrecision(prec);
                        double latDelta = GeoHash$.MODULE$.latitudeDeltaForPrecision(prec);
                        if (lonDelta >= this.width$1 && latDelta >= this.height$1 && (geo = GeoHash$.MODULE$.apply(this.ll$1.getX(), this.ll$1.getY(), prec)).bbox().covers(this.ur$1)) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)geo));
                        }
                    }
                    {
                        this.ll$1 = ll$1;
                        this.ur$1 = ur$1;
                        this.width$1 = width$1;
                        this.height$1 = height$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                option2 = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option2 = (Option)nonLocalReturnControl2.value();
            }
            return option2;
        }
        throw nonLocalReturnControl2;
    }

    public Option<GeoHash> getMBGH(Envelope env) {
        return this.getMBGH(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY());
    }

    public Option<GeoHash> getMBGH(BoundingBox bbox) {
        return this.getMBGH(BoundingBox$.MODULE$.toEnvelope(bbox).getMinX(), BoundingBox$.MODULE$.toEnvelope(bbox).getMaxX(), BoundingBox$.MODULE$.toEnvelope(bbox).getMinY(), BoundingBox$.MODULE$.toEnvelope(bbox).getMaxY());
    }

    public Option<GeoHash> getMBGH(double minX, double maxX, double minY, double maxY) {
        return this.getMBGH(GeoHash$.MODULE$.factory().createPoint(new Coordinate(minX, minY)), GeoHash$.MODULE$.factory().createPoint(new Coordinate(maxX, maxY)));
    }

    public Option<GeoHash> getClosestAcceptableGeoHash(Envelope env) {
        return this.getClosestAcceptableGeoHash(BoundingBox$.MODULE$.apply(env));
    }

    public Option<GeoHash> getClosestAcceptableGeoHash(BoundingBox bbox) {
        None$ none$;
        int prec = this.calculatePrecision(bbox);
        if (prec >= 0) {
            GeoHash gh = this.getClosestAcceptableGeoHash(bbox, prec);
            int n = prec % 5;
            switch (n) {
                default: {
                    if (prec > 5) {
                        none$ = new Some((Object)GeoHash$.MODULE$.apply((String)new StringOps(Predef$.MODULE$.augmentString(gh.hash())).dropRight(1)));
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
                case 0: {
                    none$ = new Some((Object)gh);
                    break;
                }
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public GeoHash getClosestAcceptableGeoHash(BoundingBox bbox, int r) {
        return GeoHash$.MODULE$.apply(BoundingBox$.MODULE$.toGeometry(bbox).getCentroid(), r);
    }

    public int calculatePrecision(BoundingBox bbox) {
        double dx = bbox.maxLon() - bbox.minLon();
        double dy = bbox.maxLat() - bbox.minLat();
        return (int)package$.MODULE$.round(package$.MODULE$.log((double)360 / dx) / package$.MODULE$.log(2.0) + package$.MODULE$.log((double)180 / dy) / package$.MODULE$.log(2.0));
    }

    public Geometry emptyGeometry() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.emptyGeometry$lzycompute() : this.emptyGeometry;
    }

    public boolean decompositionCandidateSorter(GeohashUtils.DecompositionCandidate a, GeohashUtils.DecompositionCandidate b) {
        return a.isLT(b);
    }

    private List<GeoHash> decomposeGeometry_(Geometry targetGeom, int maxSize, GeohashUtils.ResolutionRange resolutions) {
        ObjectRef geomCatcher$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        double targetArea = BoxesRunTime.unboxToDouble((Object)this.geomCatcher$2(geomCatcher$lzy, bitmap$0).opt((Function0)new Serializable(targetGeom){
            public static final long serialVersionUID = 0L;
            private final Geometry targetGeom$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.targetGeom$1.getArea();
            }
            {
                this.targetGeom$1 = targetGeom$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }));
        double targetLength = BoxesRunTime.unboxToDouble((Object)this.geomCatcher$2(geomCatcher$lzy, bitmap$0).opt((Function0)new Serializable(targetGeom){
            public static final long serialVersionUID = 0L;
            private final Geometry targetGeom$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.targetGeom$1.getLength();
            }
            {
                this.targetGeom$1 = targetGeom$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }));
        GeoHash ghMBR = this.getMinimumBoundingGeohash(targetGeom, resolutions);
        GeohashUtils.DecompositionCandidate candidateMBR = this.org$locationtech$geomesa$utils$geohash$GeohashUtils$$createDecompositionCandidate$1(ghMBR, targetGeom, resolutions, targetArea, targetLength);
        List keepers = this.decomposeStep$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeohashUtils.DecompositionCandidate[]{candidateMBR})), targetGeom, maxSize, resolutions, targetArea, targetLength);
        return ((List)keepers.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(GeohashUtils.DecompositionCandidate check$ifrefutable$1) {
                GeohashUtils.DecompositionCandidate decompositionCandidate = check$ifrefutable$1;
                boolean bl = decompositionCandidate != null;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GeoHash apply(GeohashUtils.DecompositionCandidate keeper) {
                return keeper.gh();
            }
        }, List$.MODULE$.canBuildFrom())).toList();
    }

    public Geometry getDecomposableGeometry(Geometry targetGeom) {
        Geometry geometry = targetGeom;
        Geometry geometry2 = geometry instanceof Point ? targetGeom : (geometry instanceof Polygon ? targetGeom : (geometry instanceof LineString && targetGeom.getNumPoints() < 100 ? targetGeom : (geometry instanceof MultiLineString && targetGeom.getNumPoints() < 100 ? targetGeom : targetGeom.convexHull())));
        return geometry2;
    }

    public Try<Geometry> getInternationalDateLineSafeGeometry(Geometry targetGeom) {
        return Try$.MODULE$.apply((Function0)new Serializable(targetGeom){
            public static final long serialVersionUID = 0L;
            private final Geometry targetGeom$2;

            public final Geometry apply() {
                Geometry copy = GeometryUtils$.MODULE$.geoFactory().createGeometry(this.targetGeom$2);
                Geometry withinBoundsGeom = this.targetGeom$2.getEnvelopeInternal().getMinX() < (double)-180 || this.targetGeom$2.getEnvelopeInternal().getMaxX() > (double)180 ? GeohashUtils$.MODULE$.org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateGeometry$1(copy) : copy;
                return JtsSpatialContext.GEO.makeShape(withinBoundsGeom, true, true).getGeom();
            }
            {
                this.targetGeom$2 = targetGeom$2;
            }
        });
    }

    public List<GeoHash> decomposeGeometry(Geometry targetGeom, int maxSize, GeohashUtils.ResolutionRange resolutions, boolean relaxFit) {
        List list;
        Geometry geometry = targetGeom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeoHash[]{GeoHash$.MODULE$.apply(point.getX(), point.getY(), resolutions.maxBitsResolution())}));
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            list = (List)((SeqLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geometryCollection.getNumGeometries()).toList().flatMap((Function1)new Serializable(maxSize, resolutions, relaxFit, geometryCollection){
                public static final long serialVersionUID = 0L;
                private final int maxSize$2;
                private final GeohashUtils.ResolutionRange resolutions$3;
                private final boolean relaxFit$1;
                private final GeometryCollection x3$1;

                public final List<GeoHash> apply(int i) {
                    return GeohashUtils$.MODULE$.decomposeGeometry(this.x3$1.getGeometryN(i), this.maxSize$2, this.resolutions$3, this.relaxFit$1);
                }
                {
                    this.maxSize$2 = maxSize$2;
                    this.resolutions$3 = resolutions$3;
                    this.relaxFit$1 = relaxFit$1;
                    this.x3$1 = x3$1;
                }
            }, List$.MODULE$.canBuildFrom())).distinct();
        } else {
            Geometry safeGeom = (Geometry)this.getInternationalDateLineSafeGeometry(targetGeom).getOrElse((Function0)new Serializable(targetGeom){
                public static final long serialVersionUID = 0L;
                private final Geometry targetGeom$3;

                public final Geometry apply() {
                    return this.targetGeom$3;
                }
                {
                    this.targetGeom$3 = targetGeom$3;
                }
            });
            list = this.decomposeGeometry_(relaxFit ? this.getDecomposableGeometry(safeGeom) : safeGeom, maxSize, resolutions);
        }
        return list;
    }

    private int decomposeGeometry_$default$2() {
        return 100;
    }

    private GeohashUtils.ResolutionRange decomposeGeometry_$default$3() {
        return new GeohashUtils.ResolutionRange(5, 40, 5);
    }

    public int decomposeGeometry$default$2() {
        return 100;
    }

    public GeohashUtils.ResolutionRange decomposeGeometry$default$3() {
        return new GeohashUtils.ResolutionRange(0, 40, 5);
    }

    public boolean decomposeGeometry$default$4() {
        return true;
    }

    public int estimateGeometryGeohashPrecision(Geometry geometry) {
        int n;
        if (geometry == null) {
            n = 0;
        } else {
            Envelope envelope = geometry.getEnvelopeInternal();
            double spanLongitude = envelope.getWidth();
            double spanLatitude = envelope.getHeight();
            double numLatitudeDivisions = package$.MODULE$.log(180.0 / spanLatitude) / package$.MODULE$.log(2.0);
            double numLongitudeDivisions = package$.MODULE$.log(360.0 / spanLongitude) / package$.MODULE$.log(2.0);
            n = (int)package$.MODULE$.round(numLatitudeDivisions + numLongitudeDivisions);
        }
        return n;
    }

    public GeoHash reconstructGeohashFromGeometry(Geometry geometry) {
        block8: {
            block9: {
                GeoHash geoHash;
                block6: {
                    Geometry geometry2;
                    block7: {
                        block5: {
                            geometry2 = geometry;
                            if (geometry2 == null) {
                                throw new Exception("Invalid geometry:  null");
                            }
                            if (!"Point".equals(geometry.getGeometryType())) break block5;
                            geoHash = GeoHash$.MODULE$.apply((Point)geometry, this.maxRealisticGeoHashPrecision());
                            break block6;
                        }
                        if (!geometry.isRectangle()) break block7;
                        geoHash = GeoHash$.MODULE$.apply(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geometry)), this.estimateGeometryGeohashPrecision(geometry));
                        break block6;
                    }
                    if (!(geometry2 instanceof MultiPolygon)) break block8;
                    MultiPolygon multiPolygon = (MultiPolygon)geometry2;
                    if (multiPolygon.getNumGeometries() != 1) {
                        throw new Exception("Expected simple geometry");
                    }
                    if (!multiPolygon.getGeometryN(0).isRectangle()) break block9;
                    geoHash = GeoHash$.MODULE$.apply(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(multiPolygon.getGeometryN(0))), this.estimateGeometryGeohashPrecision(multiPolygon.getGeometryN(0)));
                }
                return geoHash;
            }
            throw new Exception("Expected rectangular geometry");
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid geometry:  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geometry})));
    }

    public Iterator<String> getGeohashStringDottingIterator(Seq<String> set, int maxSize) {
        int len = BoxesRunTime.unboxToInt((Object)set.headOption().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$6) {
                return x$6.length();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), len).iterator().flatMap((Function1)new Serializable(set, len){
            public static final long serialVersionUID = 0L;
            private final Seq set$1;
            public final int len$1;

            public final Seq<String> apply(int i) {
                return (Seq)((TraversableLike)((TraversableLike)((SeqLike)this.set$1.map((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final String apply(String x$7) {
                        return (String)new StringOps(Predef$.MODULE$.augmentString(x$7)).take(this.i$1);
                    }
                    {
                        this.i$1 = i$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getGeohashStringDottingIterator.1 $outer;
                    private final int i$1;

                    public final Tuple2<String, String> apply(String hash2) {
                        String newStr = new StringBuilder().append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(hash2)).take(this.i$1))).append((Object)((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString("")).padTo(this.$outer.len$1 - this.i$1, (Object)".", Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString()).toString();
                        return new Tuple2((Object)hash2, (Object)newStr);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> x$8) {
                        Tuple2<String, String> tuple2 = x$8;
                        if (tuple2 != null) {
                            String newStr;
                            String string2 = newStr = (String)tuple2._2();
                            return string2;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.set$1 = set$1;
                this.len$1 = len$1;
            }
        }).take(maxSize + 1);
    }

    public Geometry promoteToRegion(Geometry geom) {
        Object object;
        Geometry geometry = geom;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            object = point.buffer(1.0E-6);
        } else {
            Geometry env;
            Polygon polygon;
            object = geometry instanceof Polygon ? ((polygon = (Polygon)geometry).getArea() > 0.0 ? polygon : Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)polygon)).buffer(1.0E-6)) : ((env = geometry.getEnvelope()).getArea() > 0.0 ? env : env.getCentroid().buffer(1.0E-6));
        }
        return object;
    }

    public Try<Seq<String>> getUniqueGeohashSubstringsInPolygon(Geometry geom, int offset, int length2, int MAX_KEYS_IN_LIST, boolean includeDots) {
        return Try$.MODULE$.apply((Function0)new Serializable(geom, offset, length2, MAX_KEYS_IN_LIST, includeDots){
            public static final long serialVersionUID = 0L;
            private final Geometry geom$2;
            private final int offset$1;
            public final int length$1;
            private final int MAX_KEYS_IN_LIST$1;
            private final boolean includeDots$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$4$ org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$$BitPrefixes$2$lzycompute(int x$1, int x$2, int x$3, int x$4, VolatileObjectRef x$5) {
                anonfun.getUniqueGeohashSubstringsInPolygon.1 var6_6 = this;
                synchronized (var6_6) {
                    if (x$5.elem != null) return (GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$4$)((Object)x$5.elem);
                    x$5.elem = new GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$4$(this, x$1, x$2, x$3, x$4, x$5);
                    return (GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$4$)((Object)x$5.elem);
                }
            }

            public final Seq<String> apply() {
                List keepers;
                VolatileObjectRef BitPrefixes$module = VolatileObjectRef.zero();
                Geometry cover = GeohashUtils$.MODULE$.promoteToRegion(this.geom$2);
                int maxBits = (this.offset$1 + this.length$1) * 5;
                int minBits = this.offset$1 * 5;
                int usedBits = this.length$1 * 5;
                GeohashUtils.ResolutionRange allResolutions = new GeohashUtils.ResolutionRange(0, Math.min(35, maxBits), 1);
                int maxKeys = Math.min(2 << Math.min(usedBits, 29), this.MAX_KEYS_IN_LIST$1);
                Point polyCentroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(cover));
                GeoHash ghMBR = GeohashUtils$.MODULE$.getMinimumBoundingGeohash(this.geom$2, allResolutions);
                public class Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3
                implements Product,
                Serializable {
                    private final Seq<String> prefixes;
                    private final boolean hasEverythingPrefix;
                    private final int entailedSize;
                    private final boolean usesAll;
                    public final /* synthetic */ anonfun.getUniqueGeohashSubstringsInPolygon.1 $outer;
                    public final int maxBits$1;
                    public final int minBits$1;
                    public final int usedBits$1;
                    private final int maxKeys$1;

                    public Seq<String> prefixes() {
                        return this.prefixes;
                    }

                    public boolean hasEverythingPrefix() {
                        return this.hasEverythingPrefix;
                    }

                    public int entailedSize() {
                        return this.entailedSize;
                    }

                    public boolean usesAll() {
                        return this.usesAll;
                    }

                    public boolean hasRoom() {
                        return this.entailedSize() <= this.maxKeys$1;
                    }

                    public boolean notDone() {
                        return !this.usesAll() && this.hasRoom();
                    }

                    public boolean overflowed() {
                        return this.usesAll() ? 1 << this.usedBits$1 > this.maxKeys$1 : this.entailedSize() > this.maxKeys$1;
                    }

                    public Seq<String> generateAll(String prefix) {
                        Seq seq;
                        String prefixHash = GeoHash$.MODULE$.fromBinaryString(prefix).hash();
                        if (prefixHash.length() < this.org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$BitPrefixes$$$outer().length$1) {
                            List charSeqs = (List)GeohashUtils$.MODULE$.Base32Padding().apply(this.org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$BitPrefixes$$$outer().length$1 - prefixHash.length());
                            seq = (Seq)new CartesianProductIterable((Seq<Seq<?>>)charSeqs).toList().map((Function1)new Serializable(this, prefixHash){
                                public static final long serialVersionUID = 0L;
                                private final String prefixHash$1;

                                public final String apply(Seq<?> x$9) {
                                    return new StringBuilder().append((Object)this.prefixHash$1).append((Object)x$9.mkString()).toString();
                                }
                                {
                                    this.prefixHash$1 = prefixHash$1;
                                }
                            }, List$.MODULE$.canBuildFrom());
                        } else {
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{prefixHash}));
                        }
                        return seq;
                    }

                    public Seq<String> generateSome() {
                        return ((SetLike)this.prefixes().foldLeft((Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3 $outer;

                            public final HashSet<String> apply(HashSet<String> ghsSoFar, String prefix) {
                                Seq seq;
                                int bitsToBoundary = (65 - prefix.length()) % 5;
                                if (bitsToBoundary == 0) {
                                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{prefix}));
                                } else {
                                    List fillers = (List)GeohashUtils$.MODULE$.BinaryPadding().apply(bitsToBoundary);
                                    List result = (List)new CartesianProductIterable((Seq<Seq<?>>)fillers).toList().map((Function1)new Serializable(this, prefix){
                                        public static final long serialVersionUID = 0L;
                                        private final String prefix$1;

                                        public final String apply(Seq<?> x$10) {
                                            return new StringBuilder().append((Object)this.prefix$1).append((Object)x$10.mkString()).toString();
                                        }
                                        {
                                            this.prefix$1 = prefix$1;
                                        }
                                    }, List$.MODULE$.canBuildFrom());
                                    seq = result;
                                }
                                Seq bases = seq;
                                return (HashSet)bases.foldLeft(ghsSoFar, (Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3$$anonfun$generateSome$1 $outer;

                                    public final HashSet<String> apply(HashSet<String> ghs, String base) {
                                        String baseTrimmed = (String)new StringOps(Predef$.MODULE$.augmentString(base)).drop(this.$outer.org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$BitPrefixes$$anonfun$$$outer().minBits$1);
                                        Seq<String> newSubs = this.$outer.org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$BitPrefixes$$anonfun$$$outer().generateAll(baseTrimmed);
                                        return (HashSet)ghs.$plus$plus(newSubs);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }

                            public /* synthetic */ Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3 org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$BitPrefixes$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })).toSeq();
                    }

                    public Seq<String> toSeq() {
                        return this.usesAll() ? this.generateAll("") : this.generateSome();
                    }

                    public Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3 copy(Seq<String> prefixes) {
                        return new Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3(this.org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$BitPrefixes$$$outer(), prefixes, this.maxBits$1, this.minBits$1, this.usedBits$1, this.maxKeys$1);
                    }

                    public Seq<String> copy$default$1() {
                        return this.prefixes();
                    }

                    public String productPrefix() {
                        return "BitPrefixes";
                    }

                    public int productArity() {
                        return 1;
                    }

                    public Object productElement(int x$1) {
                        int n = x$1;
                        switch (n) {
                            default: {
                                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                            }
                            case 0: 
                        }
                        return this.prefixes();
                    }

                    public Iterator<Object> productIterator() {
                        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                    }

                    public boolean canEqual(Object x$1) {
                        return x$1 instanceof Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3;
                    }

                    public int hashCode() {
                        return ScalaRunTime$.MODULE$._hashCode((Product)this);
                    }

                    public String toString() {
                        return ScalaRunTime$.MODULE$._toString((Product)this);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object x$1) {
                        if (this == x$1) return true;
                        Object object = x$1;
                        if (!(object instanceof Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3)) return false;
                        boolean bl = true;
                        if (!bl) return false;
                        Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3 var4_4 = (Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3)x$1;
                        Seq<String> seq = this.prefixes();
                        Seq<String> seq2 = var4_4.prefixes();
                        if (seq == null) {
                            if (seq2 != null) {
                                return false;
                            }
                        } else if (!seq.equals(seq2)) return false;
                        if (!var4_4.canEqual(this)) return false;
                        return true;
                    }

                    public /* synthetic */ anonfun.getUniqueGeohashSubstringsInPolygon.1 org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$BitPrefixes$$$outer() {
                        return this.$outer;
                    }

                    public Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3(anonfun.getUniqueGeohashSubstringsInPolygon.1 $outer, Seq<String> prefixes) {
                        this.prefixes = prefixes;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.maxBits$1 = maxBits$1;
                        this.minBits$1 = minBits$1;
                        this.usedBits$1 = usedBits$1;
                        this.maxKeys$1 = maxKeys$1;
                        Product.class.$init$((Product)this);
                        this.hasEverythingPrefix = prefixes.exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3 $outer;

                            public final boolean apply(String prefix) {
                                return prefix.length() <= this.$outer.minBits$1;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.entailedSize = this.hasEverythingPrefix() ? maxKeys$1 : Math.min(1 << usedBits$1, BoxesRunTime.unboxToInt((Object)prefixes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3 $outer;

                            public final int apply(int sumSoFar, String prefix) {
                                return sumSoFar + (1 << Math.min(this.$outer.usedBits$1, this.$outer.maxBits$1 - prefix.length()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })));
                        this.usesAll = prefixes.exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3 $outer;

                            public final boolean apply(String prefix) {
                                return prefix.length() <= this.$outer.minBits$1;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }) || this.entailedSize() == maxKeys$1;
                    }
                }
                Org_locationtech_geomesa_utils_geohash_GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$3 bitPrefixes = this.org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$$BitPrefixes$2(maxBits, minBits, usedBits, maxKeys, BitPrefixes$module).apply((Seq<String>)(ghMBR.prec() <= maxBits ? this.considerCandidate$1(ghMBR, cover, maxBits, minBits, polyCentroid) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(ghMBR.toBinaryString())).drop(minBits))).take(usedBits)}))));
                if (bitPrefixes.overflowed()) {
                    throw new IllegalStateException(new StringBuilder().append((Object)"Bit prefixes overflowed while calculating unique Geohash substrings in polygon using the following parameters: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nGeometry: ", " \\nOffset: ", " \\nLength: ", " \\nMax Keys in List: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geom$2, BoxesRunTime.boxToInteger((int)this.offset$1), BoxesRunTime.boxToInteger((int)this.length$1), BoxesRunTime.boxToInteger((int)this.MAX_KEYS_IN_LIST$1)}))).toString());
                }
                Seq unDotted = bitPrefixes.toSeq();
                Object object = this.includeDots$1 ? (unDotted.size() < maxKeys ? ((keepers = GeohashUtils$.MODULE$.getGeohashStringDottingIterator((Seq<String>)unDotted, this.MAX_KEYS_IN_LIST$1).take(this.MAX_KEYS_IN_LIST$1 + 1).toList()).size() <= this.MAX_KEYS_IN_LIST$1 ? keepers.toSeq() : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)) : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)) : unDotted;
                return object;
            }

            public final GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$4$ org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$$BitPrefixes$2(int maxBits$1, int minBits$1, int usedBits$1, int maxKeys$1, VolatileObjectRef BitPrefixes$module$1) {
                return BitPrefixes$module$1.elem == null ? this.org$locationtech$geomesa$utils$geohash$GeohashUtils$$anonfun$$BitPrefixes$2$lzycompute(maxBits$1, minBits$1, usedBits$1, maxKeys$1, BitPrefixes$module$1) : (GeohashUtils$$anonfun$getUniqueGeohashSubstringsInPolygon$1$BitPrefixes$4$)((Object)BitPrefixes$module$1.elem);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final Seq considerCandidate$1(GeoHash candidate, Geometry cover$1, int maxBits$1, int minBits$1, Point polyCentroid$1) {
                Seq seq;
                String bitString = candidate.toBinaryString();
                if (!this.geom$2.intersects(candidate.geom())) return Nil$.MODULE$;
                if (cover$1.covers(candidate.geom()) || new StringOps(Predef$.MODULE$.augmentString(bitString)).size() == maxBits$1) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bitString}));
                    return seq;
                } else if (new StringOps(Predef$.MODULE$.augmentString(bitString)).size() < maxBits$1) {
                    void var24_24;
                    Some some;
                    String bitStr;
                    Tuple2 tuple2;
                    double d1;
                    Tuple2 tuple22;
                    GeoHash gh0 = GeoHash$.MODULE$.fromBinaryString(new StringBuilder().append((Object)bitString).append((Object)"0").toString());
                    GeoHash gh1 = GeoHash$.MODULE$.fromBinaryString(new StringBuilder().append((Object)bitString).append((Object)"1").toString());
                    double d0 = Math.hypot(gh0.getPoint().getX() - polyCentroid$1.getX(), gh0.getPoint().getY() - polyCentroid$1.getY());
                    Tuple2 tuple23 = tuple22 = d0 <= (d1 = Math.hypot(gh1.getPoint().getX() - polyCentroid$1.getX(), gh1.getPoint().getY() - polyCentroid$1.getY())) ? new Tuple2((Object)gh0, (Object)gh1) : new Tuple2((Object)gh1, (Object)gh0);
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    GeoHash firstChild = (GeoHash)tuple22._1();
                    GeoHash secondChild = (GeoHash)tuple22._2();
                    Tuple2 tuple24 = tuple2 = new Tuple2((Object)firstChild, (Object)secondChild);
                    GeoHash firstChild2 = (GeoHash)tuple24._1();
                    GeoHash secondChild2 = (GeoHash)tuple24._2();
                    Seq firstChildList = this.considerCandidate$1(firstChild2, cover$1, maxBits$1, minBits$1, polyCentroid$1);
                    Option option2 = firstChildList.headOption();
                    if (option2 instanceof Some && (bitStr = (String)(some = (Some)option2).x()).length() <= minBits$1) {
                        Nil$ nil$ = Nil$.MODULE$;
                    } else {
                        Seq seq2 = this.considerCandidate$1(secondChild2, cover$1, maxBits$1, minBits$1, polyCentroid$1);
                    }
                    seq = (Seq)firstChildList.$plus$plus((GenTraversableOnce)var24_24, Seq$.MODULE$.canBuildFrom());
                    return seq;
                } else {
                    seq = Nil$.MODULE$;
                }
                return seq;
            }
            {
                this.geom$2 = geom$2;
                this.offset$1 = offset$1;
                this.length$1 = length$1;
                this.MAX_KEYS_IN_LIST$1 = MAX_KEYS_IN_LIST$1;
                this.includeDots$1 = includeDots$1;
            }
        });
    }

    public int getUniqueGeohashSubstringsInPolygon$default$4() {
        return 0x7FFFFFFE;
    }

    public boolean getUniqueGeohashSubstringsInPolygon$default$5() {
        return true;
    }

    private final Seq getLocalMinimumAlongLongitude$1(double lon2, double y$1, double sinX$1, double cosX$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Math.atan(Math.tan(y$1) / (Math.cos(lon2) * cosX$1 + Math.sin(lon2) * sinX$1))}));
    }

    private final Seq getLocalMinimaAlongLatitude$1(double x$12) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x$12, x$12 > 0.0 ? x$12 - Math.PI : x$12 + Math.PI}));
    }

    public final double org$locationtech$geomesa$utils$geohash$GeohashUtils$$getChordLength$1(double lat2, double lon2, double sinY$1, double sinX$1, double cosY$1, double cosX$1) {
        double cosLat2 = Math.cos(lat2);
        double dX = cosLat2 * Math.cos(lon2) - cosY$1 * cosX$1;
        double dY = cosLat2 * Math.sin(lon2) - cosY$1 * sinX$1;
        double dZ = Math.sin(lat2) - sinY$1;
        return Math.sqrt(dX * dX + dY * dY + dZ * dZ);
    }

    private final Seq getPointsToTryIfAboveOrBelowLat$1(double lat, double x$12, double minLon$1, double maxLon$1) {
        Seq minima = (Seq)this.getLocalMinimaAlongLatitude$1(x$12).withFilter((Function1)new Serializable(minLon$1, maxLon$1){
            public static final long serialVersionUID = 0L;
            private final double minLon$1;
            private final double maxLon$1;

            public final boolean apply(double m) {
                return this.apply$mcZD$sp(m);
            }

            public boolean apply$mcZD$sp(double m) {
                return m > this.minLon$1 && m < this.maxLon$1;
            }
            {
                this.minLon$1 = minLon$1;
                this.maxLon$1 = maxLon$1;
            }
        }).map((Function1)new Serializable(lat){
            public static final long serialVersionUID = 0L;
            private final double lat$1;

            public final Point apply(double m) {
                return GeohashUtils$.MODULE$.defaultGeometryFactory().createPoint(new Coordinate(m, this.lat$1));
            }
            {
                this.lat$1 = lat$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq startAndEndpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Point[]{this.defaultGeometryFactory().createPoint(new Coordinate(minLon$1, lat)), this.defaultGeometryFactory().createPoint(new Coordinate(maxLon$1, lat))}));
        return (Seq)minima.$plus$plus((GenTraversableOnce)startAndEndpoints, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq getPointsToTryAlongLongitude$1(double lon, double y$1, double sinX$1, double cosX$1, double minLat$1, double maxLat$1) {
        Seq minima = (Seq)this.getLocalMinimumAlongLongitude$1(lon, y$1, sinX$1, cosX$1).withFilter((Function1)new Serializable(minLat$1, maxLat$1){
            public static final long serialVersionUID = 0L;
            private final double minLat$1;
            private final double maxLat$1;

            public final boolean apply(double m) {
                return this.apply$mcZD$sp(m);
            }

            public boolean apply$mcZD$sp(double m) {
                return m > this.minLat$1 && m < this.maxLat$1;
            }
            {
                this.minLat$1 = minLat$1;
                this.maxLat$1 = maxLat$1;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$3) {
                return this.apply$mcZD$sp(x$3);
            }

            public boolean apply$mcZD$sp(double x$3) {
                return !Predef$.MODULE$.double2Double(x$3).isNaN();
            }
        }).map((Function1)new Serializable(lon){
            public static final long serialVersionUID = 0L;
            private final double lon$1;

            public final Point apply(double m) {
                return GeohashUtils$.MODULE$.defaultGeometryFactory().createPoint(new Coordinate(this.lon$1, m));
            }
            {
                this.lon$1 = lon$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq startAndEndpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Point[]{this.defaultGeometryFactory().createPoint(new Coordinate(lon, minLat$1)), this.defaultGeometryFactory().createPoint(new Coordinate(lon, maxLat$1))}));
        return (Seq)minima.$plus$plus((GenTraversableOnce)startAndEndpoints, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq topEdgeSolutions$lzycompute$1(double x$12, double minLon$1, double maxLon$1, double maxLat$1, ObjectRef topEdgeSolutions$lzy$1, VolatileByteRef bitmap$0$1) {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                topEdgeSolutions$lzy$1.elem = this.getPointsToTryIfAboveOrBelowLat$1(maxLat$1, x$12, minLon$1, maxLon$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Seq)topEdgeSolutions$lzy$1.elem;
        }
    }

    private final Seq topEdgeSolutions$1(double x$12, double minLon$1, double maxLon$1, double maxLat$1, ObjectRef topEdgeSolutions$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.topEdgeSolutions$lzycompute$1(x$12, minLon$1, maxLon$1, maxLat$1, topEdgeSolutions$lzy$1, bitmap$0$1) : (Seq)topEdgeSolutions$lzy$1.elem;
    }

    private final Seq bottomEdgeSolutions$lzycompute$1(double x$12, double minLon$1, double maxLon$1, double minLat$1, ObjectRef bottomEdgeSolutions$lzy$1, VolatileByteRef bitmap$0$1) {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                bottomEdgeSolutions$lzy$1.elem = this.getPointsToTryIfAboveOrBelowLat$1(minLat$1, x$12, minLon$1, maxLon$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (Seq)bottomEdgeSolutions$lzy$1.elem;
        }
    }

    private final Seq bottomEdgeSolutions$1(double x$12, double minLon$1, double maxLon$1, double minLat$1, ObjectRef bottomEdgeSolutions$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.bottomEdgeSolutions$lzycompute$1(x$12, minLon$1, maxLon$1, minLat$1, bottomEdgeSolutions$lzy$1, bitmap$0$1) : (Seq)bottomEdgeSolutions$lzy$1.elem;
    }

    private final Seq leftEdgeSolutions$lzycompute$1(double y$1, double sinX$1, double cosX$1, double minLon$1, double minLat$1, double maxLat$1, ObjectRef leftEdgeSolutions$lzy$1, VolatileByteRef bitmap$0$1) {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(bitmap$0$1.elem & 4) == 0) {
                leftEdgeSolutions$lzy$1.elem = this.getPointsToTryAlongLongitude$1(minLon$1, y$1, sinX$1, cosX$1, minLat$1, maxLat$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 4);
            }
            return (Seq)leftEdgeSolutions$lzy$1.elem;
        }
    }

    private final Seq leftEdgeSolutions$1(double y$1, double sinX$1, double cosX$1, double minLon$1, double minLat$1, double maxLat$1, ObjectRef leftEdgeSolutions$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 4) == 0 ? this.leftEdgeSolutions$lzycompute$1(y$1, sinX$1, cosX$1, minLon$1, minLat$1, maxLat$1, leftEdgeSolutions$lzy$1, bitmap$0$1) : (Seq)leftEdgeSolutions$lzy$1.elem;
    }

    private final Seq rightEdgeSolutions$lzycompute$1(double y$1, double sinX$1, double cosX$1, double maxLon$1, double minLat$1, double maxLat$1, ObjectRef rightEdgeSolutions$lzy$1, VolatileByteRef bitmap$0$1) {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(bitmap$0$1.elem & 8) == 0) {
                rightEdgeSolutions$lzy$1.elem = this.getPointsToTryAlongLongitude$1(maxLon$1, y$1, sinX$1, cosX$1, minLat$1, maxLat$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 8);
            }
            return (Seq)rightEdgeSolutions$lzy$1.elem;
        }
    }

    private final Seq rightEdgeSolutions$1(double y$1, double sinX$1, double cosX$1, double maxLon$1, double minLat$1, double maxLat$1, ObjectRef rightEdgeSolutions$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 8) == 0 ? this.rightEdgeSolutions$lzycompute$1(y$1, sinX$1, cosX$1, maxLon$1, minLat$1, maxLat$1, rightEdgeSolutions$lzy$1, bitmap$0$1) : (Seq)rightEdgeSolutions$lzy$1.elem;
    }

    private final Exception.Catch geomCatcher$lzycompute$2(ObjectRef geomCatcher$lzy$2, VolatileByteRef bitmap$0$3) {
        GeohashUtils$ geohashUtils$ = this;
        synchronized (geohashUtils$) {
            if ((byte)(bitmap$0$3.elem & 1) == 0) {
                geomCatcher$lzy$2.elem = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Exception.class}));
                bitmap$0$3.elem = (byte)(bitmap$0$3.elem | 1);
            }
            return (Exception.Catch)geomCatcher$lzy$2.elem;
        }
    }

    private final Exception.Catch geomCatcher$2(ObjectRef geomCatcher$lzy$2, VolatileByteRef bitmap$0$3) {
        return (byte)(bitmap$0$3.elem & 1) == 0 ? this.geomCatcher$lzycompute$2(geomCatcher$lzy$2, bitmap$0$3) : (Exception.Catch)geomCatcher$lzy$2.elem;
    }

    public final GeohashUtils.DecompositionCandidate org$locationtech$geomesa$utils$geohash$GeohashUtils$$createDecompositionCandidate$1(GeoHash gh, Geometry targetGeom$1, GeohashUtils.ResolutionRange resolutions$2, double targetArea$1, double targetLength$1) {
        block7: {
            GeohashUtils.DecompositionCandidate decompositionCandidate;
            block3: {
                Geometry geometry;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                geometry = targetGeom$1;
                                if (!(geometry instanceof MultiPolygon)) break block2;
                                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                                decompositionCandidate = new GeohashUtils.PolygonDecompositionCandidate(gh, multiPolygon, targetArea$1, resolutions$2);
                                break block3;
                            }
                            if (!(geometry instanceof Polygon)) break block4;
                            Polygon polygon = (Polygon)geometry;
                            decompositionCandidate = new GeohashUtils.PolygonDecompositionCandidate(gh, new MultiPolygon((Polygon[])((Object[])new Polygon[]{polygon}), polygon.getFactory()), targetArea$1, resolutions$2);
                            break block3;
                        }
                        if (!(geometry instanceof LineString)) break block5;
                        LineString lineString = (LineString)geometry;
                        decompositionCandidate = new GeohashUtils.LineDecompositionCandidate(gh, new MultiLineString((LineString[])((Object[])new LineString[]{lineString}), lineString.getFactory()), targetLength$1, resolutions$2);
                        break block3;
                    }
                    if (!(geometry instanceof MultiLineString)) break block6;
                    MultiLineString multiLineString = (MultiLineString)geometry;
                    decompositionCandidate = new GeohashUtils.LineDecompositionCandidate(gh, multiLineString, targetLength$1, resolutions$2);
                    break block3;
                }
                if (!(geometry instanceof Point)) break block7;
                Point point = (Point)geometry;
                decompositionCandidate = new GeohashUtils.PointDecompositionCandidate(gh, point, targetArea$1, resolutions$2);
            }
            return decompositionCandidate;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Geometry type for decomposition:  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetGeom$1.getClass().getName()})));
    }

    private final List decomposeStep$1(List candidates, Geometry targetGeom$1, int maxSize$1, GeohashUtils.ResolutionRange resolutions$2, double targetArea$1, double targetLength$1) {
        while (true) {
            if (candidates.size() > maxSize$1) {
                throw new Exception("Too many candidates upon entry.");
            }
            GeohashUtils.DecompositionCandidate candidate = (GeohashUtils.DecompositionCandidate)candidates.apply(0);
            int childResolution = candidate.gh().prec() + resolutions$2.numBitsIncrement();
            BitSet candidateBitSet = candidate.gh().bitset();
            List children = (List)((TraversableLike)resolutions$2.getNextChildren(candidateBitSet, candidate.gh().prec()).map((Function1)new Serializable(targetGeom$1, resolutions$2, targetArea$1, targetLength$1, childResolution){
                public static final long serialVersionUID = 0L;
                private final Geometry targetGeom$1;
                private final GeohashUtils.ResolutionRange resolutions$2;
                private final double targetArea$1;
                private final double targetLength$1;
                private final int childResolution$1;

                public final GeohashUtils.DecompositionCandidate apply(BitSet childBitSet) {
                    return GeohashUtils$.MODULE$.org$locationtech$geomesa$utils$geohash$GeohashUtils$$createDecompositionCandidate$1(GeoHash$.MODULE$.apply(childBitSet, this.childResolution$1), this.targetGeom$1, this.resolutions$2, this.targetArea$1, this.targetLength$1);
                }
                {
                    this.targetGeom$1 = targetGeom$1;
                    this.resolutions$2 = resolutions$2;
                    this.targetArea$1 = targetArea$1;
                    this.targetLength$1 = targetLength$1;
                    this.childResolution$1 = childResolution$1;
                }
            }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(GeohashUtils.DecompositionCandidate child) {
                    return child.intersectsTarget();
                }
            });
            List newCandidates = (List)((SeqLike)((List)candidates.tail()).$plus$plus((GenTraversableOnce)children, List$.MODULE$.canBuildFrom())).sortWith((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(GeohashUtils.DecompositionCandidate a, GeohashUtils.DecompositionCandidate b) {
                    return GeohashUtils$.MODULE$.decompositionCandidateSorter(a, b);
                }
            });
            if (newCandidates.size() > maxSize$1 || childResolution > resolutions$2.maxBitsResolution()) break;
            candidates = newCandidates;
        }
        return candidates;
    }

    private final double degreesLonTranslation$1(double lon) {
        return (int)(RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((lon + (double)180) / 360.0)) * (double)-360);
    }

    public final Coordinate org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateCoord$1(Coordinate coord) {
        return new Coordinate(coord.x + this.degreesLonTranslation$1(coord.x), coord.y);
    }

    public final Geometry org$locationtech$geomesa$utils$geohash$GeohashUtils$$translatePolygon$1(Geometry geometry) {
        return this.defaultGeometryFactory().createPolygon((Coordinate[])Predef$.MODULE$.refArrayOps((Object[])geometry.getCoordinates()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Coordinate apply(Coordinate c) {
                return GeohashUtils$.MODULE$.org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateCoord$1(c);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
    }

    public final Geometry org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateLineString$1(Geometry geometry) {
        return this.defaultGeometryFactory().createLineString((Coordinate[])Predef$.MODULE$.refArrayOps((Object[])geometry.getCoordinates()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Coordinate apply(Coordinate c) {
                return GeohashUtils$.MODULE$.org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateCoord$1(c);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
    }

    private final Geometry translateMultiLineString$1(Geometry geometry) {
        IndexedSeq coords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geometry.getNumGeometries()).map((Function1)new Serializable(geometry){
            public static final long serialVersionUID = 0L;
            private final Geometry geometry$1;

            public final Geometry apply(int i) {
                return this.geometry$1.getGeometryN(i);
            }
            {
                this.geometry$1 = geometry$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq translated = (IndexedSeq)coords.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LineString apply(Geometry c) {
                return (LineString)GeohashUtils$.MODULE$.org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateLineString$1(c);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return this.defaultGeometryFactory().createMultiLineString((LineString[])translated.toArray(ClassTag$.MODULE$.apply(LineString.class)));
    }

    private final Geometry translateMultiPolygon$1(Geometry geometry) {
        IndexedSeq coords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geometry.getNumGeometries()).map((Function1)new Serializable(geometry){
            public static final long serialVersionUID = 0L;
            private final Geometry geometry$2;

            public final Geometry apply(int i) {
                return this.geometry$2.getGeometryN(i);
            }
            {
                this.geometry$2 = geometry$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq translated = (IndexedSeq)coords.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Polygon apply(Geometry c) {
                return (Polygon)GeohashUtils$.MODULE$.org$locationtech$geomesa$utils$geohash$GeohashUtils$$translatePolygon$1(c);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return this.defaultGeometryFactory().createMultiPolygon((Polygon[])translated.toArray(ClassTag$.MODULE$.apply(Polygon.class)));
    }

    private final Geometry translateMultiPoint$1(Geometry geometry) {
        return this.defaultGeometryFactory().createMultiPoint((Coordinate[])Predef$.MODULE$.refArrayOps((Object[])geometry.getCoordinates()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Coordinate apply(Coordinate c) {
                return GeohashUtils$.MODULE$.org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateCoord$1(c);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
    }

    private final Geometry translatePoint$1(Geometry geometry) {
        return this.defaultGeometryFactory().createPoint(this.org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateCoord$1(geometry.getCoordinate()));
    }

    public final Geometry org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateGeometry$1(Geometry geometry) {
        Geometry geometry2;
        block8: {
            Geometry geometry3;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    geometry2 = geometry;
                                    if (!(geometry2 instanceof Polygon)) break block2;
                                    geometry3 = this.org$locationtech$geomesa$utils$geohash$GeohashUtils$$translatePolygon$1(geometry);
                                    break block3;
                                }
                                if (!(geometry2 instanceof LineString)) break block4;
                                geometry3 = this.org$locationtech$geomesa$utils$geohash$GeohashUtils$$translateLineString$1(geometry);
                                break block3;
                            }
                            if (!(geometry2 instanceof MultiLineString)) break block5;
                            geometry3 = this.translateMultiLineString$1(geometry);
                            break block3;
                        }
                        if (!(geometry2 instanceof MultiPolygon)) break block6;
                        geometry3 = this.translateMultiPolygon$1(geometry);
                        break block3;
                    }
                    if (!(geometry2 instanceof MultiPoint)) break block7;
                    geometry3 = this.translateMultiPoint$1(geometry);
                    break block3;
                }
                if (!(geometry2 instanceof Point)) break block8;
                geometry3 = this.translatePoint$1(geometry);
            }
            return geometry3;
        }
        throw new MatchError((Object)geometry2);
    }

    private GeohashUtils$() {
        MODULE$ = this;
        GeomDistance$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.base32seq = new StringOps(Predef$.MODULE$.augmentString(GeoHash$.MODULE$.base32())).toSeq();
        this.Base32Padding = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Seq<Object>> apply(int i) {
                return (List)List$.MODULE$.fill(i, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply() {
                        return GeohashUtils$.MODULE$.base32seq();
                    }
                });
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.BinaryPadding = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Seq<Object>> apply(int i) {
                return (List)List$.MODULE$.fill(i, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply() {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'0', '1'}));
                    }
                });
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.maxRealisticGeoHashPrecision = 45;
        this.numDistinctGridPoints = 1L << (int)((long)((this.maxRealisticGeoHashPrecision() + 1) / 2));
        this.defaultPrecisionModel = new PrecisionModel((double)this.numDistinctGridPoints());
        this.defaultGeometryFactory = new GeometryFactory(this.defaultPrecisionModel(), 4326);
    }
}

