/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid;

import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.DefaultGridFeatureBuilder;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.hexagon.HexagonOrientation;
import org.geotools.grid.hexagon.Hexagons;
import org.geotools.grid.oblong.Oblongs;

public class Grids {
    public static SimpleFeatureSource createSquareGrid(ReferencedEnvelope bounds, double sideLen) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Oblongs.createGrid(bounds, sideLen, sideLen, new DefaultGridFeatureBuilder(bounds.getCoordinateReferenceSystem()));
    }

    public static SimpleFeatureSource createSquareGrid(ReferencedEnvelope bounds, double sideLen, double vertexSpacing) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Oblongs.createGrid(bounds, sideLen, sideLen, vertexSpacing, new DefaultGridFeatureBuilder(bounds.getCoordinateReferenceSystem()));
    }

    public static SimpleFeatureSource createSquareGrid(ReferencedEnvelope bounds, double sideLen, double vertexSpacing, GridFeatureBuilder builder) {
        return Oblongs.createGrid(bounds, sideLen, sideLen, vertexSpacing, builder);
    }

    public static SimpleFeatureSource createHexagonalGrid(ReferencedEnvelope bounds, double sideLen) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Hexagons.createGrid(bounds, sideLen, HexagonOrientation.FLAT, new DefaultGridFeatureBuilder(bounds.getCoordinateReferenceSystem()));
    }

    public static SimpleFeatureSource createHexagonalGrid(ReferencedEnvelope bounds, double sideLen, double vertexSpacing) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Hexagons.createGrid(bounds, sideLen, vertexSpacing, HexagonOrientation.FLAT, new DefaultGridFeatureBuilder(bounds.getCoordinateReferenceSystem()));
    }

    public static SimpleFeatureSource createHexagonalGrid(ReferencedEnvelope bounds, double sideLen, double vertexSpacing, GridFeatureBuilder builder) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds should not be null");
        }
        return Hexagons.createGrid(bounds, sideLen, vertexSpacing, HexagonOrientation.FLAT, builder);
    }
}

