/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ZeroVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.vector.GeometryVector;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryVector;

public abstract class AbstractPointVector<T extends FieldVector>
extends AbstractGeometryVector<Point, FixedSizeListVector, T> {
    public static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)new ArrowType.FixedSizeList(2), null, metadata);
    }

    protected AbstractPointVector(String name, BufferAllocator allocator, Map<String, String> metadata) {
        this(new FixedSizeListVector(name, allocator, AbstractPointVector.createFieldType(metadata), null));
    }

    protected AbstractPointVector(String name, AbstractContainerVector container, Map<String, String> metadata) {
        this((FixedSizeListVector)container.addOrGet(name, AbstractPointVector.createFieldType(metadata), FixedSizeListVector.class));
    }

    protected AbstractPointVector(FixedSizeListVector vector) {
        super(vector);
        if (vector.getDataVector() == ZeroVector.INSTANCE) {
            vector.initializeChildrenFromFields(this.getFields());
            vector.allocateNew();
        }
        this.setOrdinalVector((FieldVector)vector.getChildrenFromFields().get(0));
    }

    @Override
    public void set(int index, Point geom) {
        if (geom == null) {
            ((FixedSizeListVector)this.vector).setNull(index);
        } else {
            ((FixedSizeListVector)this.vector).setNotNull(index);
            this.writeOrdinal(index * 2, geom.getY());
            this.writeOrdinal(index * 2 + 1, geom.getX());
        }
    }

    @Override
    public Point get(int index) {
        if (((FixedSizeListVector)this.vector).isNull(index)) {
            return null;
        }
        double y = this.readOrdinal(index * 2);
        double x = this.readOrdinal(index * 2 + 1);
        return factory.createPoint(new Coordinate(x, y));
    }

    @Override
    public void transfer(int fromIndex, int toIndex, GeometryVector<Point, FixedSizeListVector> to) {
        AbstractPointVector typed = (AbstractPointVector)to;
        if (((FixedSizeListVector)this.vector).isNull(fromIndex)) {
            ((FixedSizeListVector)typed.vector).setNull(toIndex);
        } else {
            ((FixedSizeListVector)typed.vector).setNotNull(toIndex);
            typed.writeOrdinal(toIndex * 2, this.readOrdinal(fromIndex * 2));
            typed.writeOrdinal(toIndex * 2 + 1, this.readOrdinal(fromIndex * 2 + 1));
        }
    }

    public double getCoordinateY(int index) {
        return this.readOrdinal(index * 2);
    }

    public double getCoordinateX(int index) {
        return this.readOrdinal(index * 2 + 1);
    }
}

