/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.capability;

import org.geotools.filter.capability.FunctionsImpl;
import org.opengis.filter.capability.ArithmeticOperators;
import org.opengis.filter.capability.Functions;

public class ArithmeticOperatorsImpl
implements ArithmeticOperators {
    boolean simpleArithmetic;
    FunctionsImpl functions;

    public ArithmeticOperatorsImpl() {
        this.simpleArithmetic = false;
        this.functions = new FunctionsImpl();
    }

    public ArithmeticOperatorsImpl(boolean simpleArtithmetic, Functions functions) {
        this.simpleArithmetic = simpleArtithmetic;
        this.functions = ArithmeticOperatorsImpl.toFunctionsImpl(functions);
    }

    public ArithmeticOperatorsImpl(ArithmeticOperators copy) {
        this.simpleArithmetic = copy.hasSimpleArithmetic();
        this.functions = copy.getFunctions() == null ? new FunctionsImpl() : new FunctionsImpl(copy.getFunctions());
    }

    public void setSimpleArithmetic(boolean simpleArithmetic) {
        this.simpleArithmetic = simpleArithmetic;
    }

    public boolean hasSimpleArithmetic() {
        return this.simpleArithmetic;
    }

    public FunctionsImpl getFunctions() {
        return this.functions;
    }

    private static FunctionsImpl toFunctionsImpl(Functions functions) {
        if (functions == null) {
            return new FunctionsImpl();
        }
        if (functions instanceof FunctionsImpl) {
            return (FunctionsImpl)functions;
        }
        return new FunctionsImpl(functions);
    }

    public void addAll(ArithmeticOperators copy) {
        if (copy == null) {
            return;
        }
        this.getFunctions().addAll(copy.getFunctions());
        if (copy.hasSimpleArithmetic()) {
            this.simpleArithmetic = true;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ArithmeticOperators[");
        if (this.simpleArithmetic) {
            buf.append("simpleArithmetic=true");
        }
        buf.append("]");
        if (this.functions != null) {
            buf.append(" with functions");
        }
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.functions == null ? 0 : this.functions.hashCode());
        result = 31 * result + (this.simpleArithmetic ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArithmeticOperatorsImpl other = (ArithmeticOperatorsImpl)obj;
        if (this.functions == null ? other.functions != null : !this.functions.equals(other.functions)) {
            return false;
        }
        return this.simpleArithmetic == other.simpleArithmetic;
    }
}

