/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.EquidistantConic;
import org.geotools.referencing.operation.projection.LambertConformal;
import org.geotools.referencing.operation.projection.LambertConformal1SP;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ConicHandlerFactory
implements ProjectionHandlerFactory {
    static final double EPS = 0.1;
    static final double MAX_DISTANCE = 44.0;

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        if (renderingEnvelope == null) {
            return null;
        }
        MapProjection mapProjection = CRS.getMapProjection(renderingEnvelope.getCoordinateReferenceSystem());
        if (mapProjection instanceof LambertConformal || mapProjection instanceof EquidistantConic) {
            double maxLat;
            double minLat;
            double latitudeOrigin;
            ParameterValueGroup params = mapProjection.getParameterValues();
            double centralMeridian = params.parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
            if (mapProjection instanceof LambertConformal1SP) {
                latitudeOrigin = params.parameter(MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN.getName().getCode()).doubleValue();
            } else {
                double stdParallel1 = params.parameter(MapProjection.AbstractProvider.STANDARD_PARALLEL_1.getName().getCode()).doubleValue();
                double stdParallel2 = params.parameter(MapProjection.AbstractProvider.STANDARD_PARALLEL_2.getName().getCode()).doubleValue();
                latitudeOrigin = (stdParallel1 + stdParallel2) / 2.0;
            }
            if (latitudeOrigin > 0.0) {
                minLat = Math.max(-89.0, latitudeOrigin - 44.0);
                maxLat = 90.0;
            } else {
                minLat = -90.0;
                maxLat = Math.min(89.0, latitudeOrigin + 44.0);
            }
            if (centralMeridian != 0.0) {
                double antiMeridian = centralMeridian > 0.0 ? centralMeridian - 180.0 : centralMeridian + 180.0;
                Polygon beforeAntiMeridian = JTS.toGeometry(new Envelope(-180.0, antiMeridian - 0.1, minLat, maxLat));
                Polygon afterAntiMeridian = JTS.toGeometry(new Envelope(antiMeridian + 0.1, 180.0, minLat, maxLat));
                MultiPolygon mask = beforeAntiMeridian.getFactory().createMultiPolygon(new Polygon[]{beforeAntiMeridian, afterAntiMeridian});
                return new ProjectionHandler(sourceCrs, (Geometry)mask, renderingEnvelope);
            }
            Envelope validArea = new Envelope(-179.9, 179.9, minLat, maxLat);
            return new ProjectionHandler(sourceCrs, validArea, renderingEnvelope);
        }
        return null;
    }
}

