/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.SamplingVisitor;
import org.opengis.feature.FeatureVisitor;
import org.opengis.util.ProgressListener;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DescribeProcess(title="Sampling Process", description="Uses statistical sampling to reduces the features returned by a query")
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011qbU1na2Lgn\u001a)s_\u000e,7o\u001d\u0006\u0003\u0007\u0011\t\u0001\"\u00198bYf$\u0018n\u0019\u0006\u0003\u000b\u0019\tq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f-i\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u0011abR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8\u000f\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u0005a1oY1mC2|wmZ5oO*\u0011q\u0004I\u0001\tif\u0004Xm]1gK*\t\u0011%A\u0002d_6L!a\t\u000f\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003\tAQA\u000b\u0001\u0005\u0002-\nq!\u001a=fGV$X\rF\u0003-m\u0011#6\r\u0005\u0002.i5\taF\u0003\u00020a\u000511/[7qY\u0016T!!\r\u001a\u0002\t\u0011\fG/\u0019\u0006\u0003g)\t\u0001bZ3pi>|Gn]\u0005\u0003k9\u0012qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\t\u000bEJ\u0003\u0019\u0001\u0017)\rYBt\bQ!C!\tIT(D\u0001;\u0015\tYD(A\u0004gC\u000e$xN]=\u000b\u0005\u0015\u0011\u0014B\u0001 ;\u0005E!Um]2sS\n,\u0007+\u0019:b[\u0016$XM]\u0001\u0005]\u0006lW-I\u00012\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003\r\u000ba\"\u00138qkR\u0004c-Z1ukJ,7\u000fC\u0003FS\u0001\u0007a)A\u0007tC6\u0004H.\u001a)fe\u000e,g\u000e\u001e\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\u0006\r2|\u0017\r\u001e\u0015\u000b\tbzT*\u0011(Q#J\u001b\u0016%A#\"\u0003=\u000ba\u0006U3sG\u0016tG\u000fI8gA\u0019,\u0017\r^;sKN\u0004Co\u001c\u0011sKR,(O\u001c\u0017!E\u0016$x/Z3oAA\u0002\u0013M\u001c3!c\u0005AQ.\u001b8WC2,X\rI\u0001\u0001\u0003!i\u0017\r\u001f,bYV,\u0007\u0005C q\u0002\u0001\u0001\u0001\u0001\u0001\u0001\t\u000bUK\u0003\u0019\u0001,\u0002\u0011QD'/Z1e\u0005f\u0004\"a\u0016.\u000f\u0005\u001dC\u0016BA-I\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eC\u0005\u0006\u0003+9\u007fy\u000bu,\u00192\"\u0003U\u000b\u0013\u0001Y\u00019\u0003R$(/\u001b2vi\u0016\u0004c-[3mI\u0002\"x\u000e\t7j].\u0004\u0013m]:pG&\fG/\u001a3!M\u0016\fG/\u001e:fg\u00022wN\u001d\u0011tC6\u0004H.\u001b8h\u0003\ri\u0017N\\\u000f\u0002\u0001!)A-\u000ba\u0001K\u00069Qn\u001c8ji>\u0014\bC\u00014l\u001b\u00059'B\u00015j\u0003\u0011)H/\u001b7\u000b\u0005)T\u0011aB8qK:<\u0017n]\u0005\u0003Y\u001e\u0014\u0001\u0003\u0015:pOJ,7o\u001d'jgR,g.\u001a:)\r%rw(]!t!\tIt.\u0003\u0002qu\tqA)Z:de&\u0014WMU3tk2$\u0018%\u0001:\u0002\rI,7/\u001e7uC\u0005!\u0018aD(viB,H\u000f\t4fCR,(/Z:)\u0007%2X\u0010E\u0002HofL!\u0001\u001f%\u0003\rQD'o\\<t!\tQ80D\u0001=\u0013\taHH\u0001\tQe>\u001cWm]:Fq\u000e,\u0007\u000f^5p]\u000e\n\u0011\u0010K\u0005\u0001\u007f\u0006\u0015\u0011qA!\u0002\fA\u0019\u0011(!\u0001\n\u0007\u0005\r!HA\bEKN\u001c'/\u001b2f!J|7-Z:t\u0003\u0015!\u0018\u000e\u001e7fC\t\tI!\u0001\tTC6\u0004H.\u001b8hAA\u0013xnY3tg\u0006\u0012\u0011QB\u0001F+N,7\u000fI:uCRL7\u000f^5dC2\u00043/Y7qY&tw\r\t;pAI,G-^2fg\u0002\"\b.\u001a\u0011gK\u0006$XO]3tAI,G/\u001e:oK\u0012\u0004#-\u001f\u0011bAE,XM]=")
public class SamplingProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        SamplingProcess samplingProcess = this;
        synchronized (samplingProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(name="result", description="Output features")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection data, @DescribeParameter(name="samplePercent", description="Percent of features to return, between 0 and 1", minValue=0.0, maxValue=1.0) float samplePercent, @DescribeParameter(name="threadBy", description="Attribute field to link associated features for sampling", min=0) String threadBy, ProgressListener monitor) throws ProcessException {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Attempting sampling on {}", new Object[]{data.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SamplingVisitor visitor = new SamplingVisitor(data, samplePercent, (Option<String>)Option$.MODULE$.apply((Object)threadBy));
        data.accepts((FeatureVisitor)visitor, monitor);
        return visitor.getResult().results();
    }

    public SamplingProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

