/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.google.common.hash.HashFunction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.transform.HashAttribute;
import org.locationtech.geomesa.process.transform.HashAttribute$class;
import scala.reflect.ScalaSignature;

@DescribeProcess(title="Hash Attribute Color Process", description="Adds an attribute to each SimpleFeature that hashes the configured attribute modulo the configured param and emits a color")
@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u001b\tI\u0002*Y:i\u0003R$(/\u001b2vi\u0016\u001cu\u000e\\8s!J|7-Z:t\u0015\t\u0019A!A\u0005ue\u0006t7OZ8s[*\u0011QAB\u0001\baJ|7-Z:t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qaC\u0007\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011q\u0003G\u0007\u0002\t%\u0011\u0011\u0004\u0002\u0002\u000f\u000f\u0016|W*Z:b!J|7-Z:t!\tYB$D\u0001\u0003\u0013\ti\"AA\u0007ICND\u0017\t\u001e;sS\n,H/\u001a\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"a\u0007\u0001\t\u000f\r\u0002!\u0019!C\u0001I\u000511m\u001c7peN,\u0012!\n\t\u0004M%ZS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u00051zcB\u0001\u0014.\u0013\tqs%\u0001\u0004Qe\u0016$WMZ\u0005\u0003aE\u0012aa\u0015;sS:<'B\u0001\u0018(\u0011\u0019\u0019\u0004\u0001)A\u0005K\u000591m\u001c7peN\u0004\u0003\"B\u001b\u0001\t\u00032\u0014!\u0004;sC:\u001chm\u001c:n\u0011\u0006\u001c\b\u000e\u0006\u00028uA\u0011a\u0005O\u0005\u0003s\u001d\u0012a!\u00118z%\u00164\u0007\"B\u001e5\u0001\u0004a\u0014\u0001\u00025bg\"\u0004\"AJ\u001f\n\u0005y:#aA%oi\")\u0001\t\u0001C!\u0003\u0006Q\u0011-^4nK:$8K\u001a;\u0015\u0005\t+\u0005C\u0001\u0014D\u0013\t!uE\u0001\u0003V]&$\b\"\u0002$@\u0001\u00049\u0015AC:gi\n+\u0018\u000e\u001c3feB\u0011\u0001jT\u0007\u0002\u0013*\u0011!jS\u0001\u0007g&l\u0007\u000f\\3\u000b\u00051k\u0015a\u00024fCR,(/\u001a\u0006\u0003\u001d*\t\u0001bZ3pi>|Gn]\u0005\u0003!&\u0013\u0001dU5na2,g)Z1ukJ,G+\u001f9f\u0005VLG\u000eZ3sQ\u0019\u0001!+\u0017.];B\u00111kV\u0007\u0002)*\u0011QKV\u0001\bM\u0006\u001cGo\u001c:z\u0015\t)Q*\u0003\u0002Y)\nyA)Z:de&\u0014W\r\u0015:pG\u0016\u001c8/A\u0003uSRdW-I\u0001\\\u0003qA\u0015m\u001d5!\u0003R$(/\u001b2vi\u0016\u00043i\u001c7pe\u0002\u0002&o\\2fgN\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\na,\u0001>BI\u0012\u001c\b%\u00198!CR$(/\u001b2vi\u0016\u0004Co\u001c\u0011fC\u000eD\u0007eU5na2,g)Z1ukJ,\u0007\u0005\u001e5bi\u0002B\u0017m\u001d5fg\u0002\"\b.\u001a\u0011d_:4\u0017nZ;sK\u0012\u0004\u0013\r\u001e;sS\n,H/\u001a\u0011n_\u0012,Hn\u001c\u0011uQ\u0016\u00043m\u001c8gS\u001e,(/\u001a3!a\u0006\u0014\u0018-\u001c\u0011b]\u0012\u0004S-\\5ug\u0002\n\u0007eY8m_J\u0004")
public class HashAttributeColorProcess
implements GeoMesaProcess,
HashAttribute {
    private final String[] colors;
    private final HashFunction org$locationtech$geomesa$process$transform$HashAttribute$$hashFn;

    @Override
    public HashFunction org$locationtech$geomesa$process$transform$HashAttribute$$hashFn() {
        return this.org$locationtech$geomesa$process$transform$HashAttribute$$hashFn;
    }

    @Override
    public void org$locationtech$geomesa$process$transform$HashAttribute$_setter_$org$locationtech$geomesa$process$transform$HashAttribute$$hashFn_$eq(HashFunction x$1) {
        this.org$locationtech$geomesa$process$transform$HashAttribute$$hashFn = x$1;
    }

    @Override
    @DescribeResult(name="result", description="Output collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="attribute", description="The attribute to hash on") String attribute, @DescribeParameter(name="modulo", description="The divisor") Integer modulo) throws ProcessException {
        return HashAttribute$class.execute(this, obsFeatures, attribute, modulo);
    }

    public String[] colors() {
        return this.colors;
    }

    @Override
    public Object transformHash(int hash) {
        return this.colors()[hash % this.colors().length];
    }

    @Override
    public void augmentSft(SimpleFeatureTypeBuilder sftBuilder) {
        sftBuilder.add("hash", String.class);
    }

    public HashAttributeColorProcess() {
        HashAttribute$class.$init$(this);
        this.colors = (String[])((Object[])new String[]{"#6495ED", "#B0C4DE", "#00FFFF", "#9ACD32", "#00FA9A", "#FFF8DC", "#F5DEB3"});
    }
}

