/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.XMLReader;

public abstract class AbstractResourceCollection
implements ResourceCollection {
    protected Configuration config;
    protected String collectionURI;
    protected URIQueryParameters params = null;

    public AbstractResourceCollection(Configuration config) {
        this.config = config;
    }

    public String getCollectionURI() {
        return this.collectionURI;
    }

    public boolean isStable(XPathContext context) {
        if (this.params == null) {
            return false;
        }
        Boolean stable = this.params.getStable();
        if (stable == null) {
            return context.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/stableCollectionUri");
        }
        return stable;
    }

    public void registerContentType(String contentType, ResourceFactory factory) {
        this.config.registerMediaType(contentType, factory);
    }

    protected ParseOptions optionsFromQueryParameters(URIQueryParameters params, XPathContext context) {
        ParseOptions options = new ParseOptions(context.getConfiguration().getParseOptions());
        if (params != null) {
            Controller controller;
            UnfailingErrorListener oldErrorListener;
            Maker<XMLReader> p;
            int strip;
            Boolean xInclude;
            Integer v = params.getValidationMode();
            if (v != null) {
                options.setSchemaValidationMode(v);
            }
            if ((xInclude = params.getXInclude()) != null) {
                options.setXIncludeAware(xInclude);
            }
            if ((strip = params.getStripSpace()) != 3) {
                options.setStripSpace(strip);
            }
            if ((p = params.getXMLReaderMaker()) != null) {
                options.setXMLReaderMaker(p);
            }
            int onError = 1;
            if (params.getOnError() != null) {
                onError = params.getOnError();
            }
            UnfailingErrorListener unfailingErrorListener = oldErrorListener = (controller = context.getController()) == null ? new StandardErrorListener() : controller.getErrorListener();
            if (onError == 3) {
                options.setErrorListener(new UnfailingErrorListener(){

                    public void warning(TransformerException exception) {
                    }

                    public void error(TransformerException exception) {
                    }

                    public void fatalError(TransformerException exception) {
                    }
                });
            } else if (onError == 2) {
                options.setErrorListener(new UnfailingErrorListener(){

                    public void warning(TransformerException exception) {
                        oldErrorListener.warning(exception);
                    }

                    public void error(TransformerException exception) {
                        oldErrorListener.warning(exception);
                        XPathException supp = new XPathException("The document will be excluded from the collection");
                        supp.setLocator(exception.getLocator());
                        oldErrorListener.warning(supp);
                    }

                    public void fatalError(TransformerException exception) {
                        this.error(exception);
                    }
                });
            }
        }
        return options;
    }

    protected InputDetails getInputDetails(String resourceURI) throws XPathException {
        InputDetails inputDetails = new InputDetails();
        try {
            URI uri = new URI(resourceURI);
            if ("file".equals(uri.getScheme())) {
                File file = new File(uri);
                inputDetails.inputStream = new BufferedInputStream(new FileInputStream(file));
            } else {
                URL url = uri.toURL();
                URLConnection connection = url.openConnection();
                inputDetails.inputStream = connection.getInputStream();
                inputDetails.contentType = connection.getContentType();
                inputDetails.encoding = connection.getContentEncoding();
                for (String param : inputDetails.contentType.replace(" ", "").split(";")) {
                    if (param.startsWith("charset=")) {
                        inputDetails.encoding = param.split("=", 2)[1];
                        continue;
                    }
                    inputDetails.contentType = param;
                }
            }
        }
        catch (URISyntaxException e) {
            throw new XPathException(e);
        }
        catch (MalformedURLException e) {
            throw new XPathException(e);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
        if (inputDetails.contentType == null || this.config.getResourceFactoryForMediaType(inputDetails.contentType) == null) {
            inputDetails.contentType = this.guessContentType(resourceURI, inputDetails.inputStream);
        }
        if (this.params != null && this.params.getOnError() != null) {
            inputDetails.onError = this.params.getOnError();
        }
        return inputDetails;
    }

    protected String guessContentType(String resourceURI, InputStream stream) {
        String contentTypeFromStream = null;
        try {
            contentTypeFromStream = URLConnection.guessContentTypeFromStream(stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String contentTypeFromName = URLConnection.guessContentTypeFromName(resourceURI);
        String extension = null;
        if (contentTypeFromName == null && (extension = this.getFileExtension(resourceURI)) != null) {
            contentTypeFromName = this.config.getMediaTypeForFileExtension(extension);
        }
        if (contentTypeFromName == null) {
            return contentTypeFromStream;
        }
        if (contentTypeFromStream == null) {
            return contentTypeFromName;
        }
        if (contentTypeFromStream.equals(contentTypeFromName)) {
            return contentTypeFromStream;
        }
        if ("xsl".equals(extension) || "xslt".equals(extension) || "xml".equals(extension)) {
            return contentTypeFromName;
        }
        return contentTypeFromStream;
    }

    private String getFileExtension(String name) {
        int p;
        int i = name.lastIndexOf(46);
        if (i > (p = Math.max(name.lastIndexOf(47), name.lastIndexOf(92))) && i + 1 < name.length()) {
            return name.substring(i + 1);
        }
        return null;
    }

    public Resource makeResource(Configuration config, InputDetails details, String resourceURI) throws XPathException {
        ResourceFactory factory = null;
        String contentType = details.contentType;
        if (contentType != null) {
            factory = config.getResourceFactoryForMediaType(contentType);
        }
        if (factory == null) {
            factory = BinaryResource.FACTORY;
        }
        return factory.makeResource(config, resourceURI, contentType, details);
    }

    public Resource makeResource(Configuration config, String resourceURI) throws XPathException {
        InputDetails details = this.getInputDetails(resourceURI);
        return this.makeResource(config, details, resourceURI);
    }

    public boolean stripWhitespace(SpaceStrippingRule rules) {
        return false;
    }

    public static class InputDetails {
        public InputStream inputStream;
        public String contentType;
        public String encoding;
        public ParseOptions parseOptions;
        public int onError = 1;
    }
}

