/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class MultiSurfaceTypeBinding
extends AbstractComplexBinding {
    protected GeometryFactory gf;

    public MultiSurfaceTypeBinding(GeometryFactory gf) {
        this.gf = gf;
    }

    public QName getTarget() {
        return GML.MultiSurfaceType;
    }

    public Class getType() {
        return MultiPolygon.class;
    }

    public int getExecutionMode() {
        return 1;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List surfaces = node.getChildValues(Polygon.class);
        if (node.hasChild(Polygon[].class)) {
            surfaces.addAll(Arrays.asList((Polygon[])node.getChildValue(Polygon[].class)));
        }
        return this.gf.createMultiPolygon(surfaces.toArray(new Polygon[surfaces.size()]));
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if ("surfaceMember".equals(name.getLocalPart())) {
            MultiPolygon multiSurface = (MultiPolygon)object;
            Polygon[] members = new Polygon[multiSurface.getNumGeometries()];
            for (int i = 0; i < members.length; ++i) {
                members[i] = (Polygon)multiSurface.getGeometryN(i);
            }
            GML3EncodingUtils.setChildIDs(multiSurface);
            return members;
        }
        return null;
    }
}

