/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u00015\u0011Ab\u0015;biN4\u0016n]5u_JT!a\u0001\u0003\u0002\u0011\u0005t\u0017\r\\=uS\u000eT!!\u0002\u0004\u0002\u000fA\u0014xnY3tg*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0006\u000e\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\r\u000e\u0003\u0011I!!\u0007\u0003\u0003+\u001d+w.T3tCB\u0013xnY3tgZK7/\u001b;peB\u00111DI\u0007\u00029)\u0011QDH\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003?\u0001\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002C\u0005\u00191m\\7\n\u0005\rb\"a\u0003'bufdunZ4j]\u001eD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\tM\u0016\fG/\u001e:fgB\u0011qEL\u0007\u0002Q)\u0011\u0011FK\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005-b\u0013\u0001\u00023bi\u0006T!!\f\u0006\u0002\u0011\u001d,w\u000e^8pYNL!a\f\u0015\u0003/MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0015M$\u0018\r^*ue&tw\r\u0005\u00024s9\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tAT\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0003\u0019)gnY8eKB\u0011AgP\u0005\u0003\u0001V\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0004i\u0011\u0013\u0014BA#6\u0005\u0015\t%O]1z\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}Q)\u0011j\u0013'N\u001dB\u0011!\nA\u0007\u0002\u0005!)QE\u0012a\u0001M!)\u0011G\u0012a\u0001e!)QH\u0012a\u0001}!)!I\u0012a\u0001\u0007\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0016aB8sS\u001e\u001cf\r^\u000b\u0002%B\u00111+W\u0007\u0002)*\u0011\u0011&\u0016\u0006\u0003-^\u000bqAZ3biV\u0014XM\u0003\u0002Y\u0015\u00059q\u000e]3oO&\u001c\u0018B\u0001.U\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\u00079\u0002\u0001\u000b\u0011\u0002*\u0002\u0011=\u0014\u0018nZ*gi\u0002B!B\u0018\u0001\u0011\u0002#\u001d\r\u0015\"\u0003`\u0003\rAH\u0005N\u000b\u0002AB!A'\u0019\u001aS\u0013\t\u0011WG\u0001\u0004UkBdWM\r\u0005\tI\u0002A\t\u0011)Q\u0005A\u0006!\u0001\u0010\n\u001b!\u0011!1\u0007\u0001#b\u0001\n\u00139\u0017A\u0003;sC:\u001chm\u001c:ngV\t!\u0007\u0003\u0005j\u0001!\u0005\t\u0015)\u00033\u0003-!(/\u00198tM>\u0014Xn\u001d\u0011\t\u0011-\u0004\u0001R1A\u0005\nE\u000bA\u0002\u001e:b]N4wN]7T\rRC\u0001\"\u001c\u0001\t\u0002\u0003\u0006KAU\u0001\u000eiJ\fgn\u001d4pe6\u001cf\t\u0016\u0011\t\u0011=\u0004\u0001R1A\u0005\nA\f1\u0002\u001e:b]N4wN]7T\rV\t\u0011\u000f\u0005\u0002si6\t1O\u0003\u0002&\r%\u0011Qo\u001d\u0002\u0017)J\fgn\u001d4pe6\u001c\u0016.\u001c9mK\u001a+\u0017\r^;sK\"Aq\u000f\u0001E\u0001B\u0003&\u0011/\u0001\u0007ue\u0006t7OZ8s[N3\u0005\u0005\u0003\u0005z\u0001!\u0015\r\u0011\"\u0003R\u0003\u001d\u0019H/\u0019;TMRD\u0001b\u001f\u0001\t\u0002\u0003\u0006KAU\u0001\tgR\fGo\u00154uA!AQ\u0010\u0001EC\u0002\u0013%a0\u0001\u0003ti\u0006$X#A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005)1\u000f^1ug*\u0019\u0011\u0011\u0002\u0004\u0002\u000bU$\u0018\u000e\\:\n\t\u00055\u00111\u0001\u0002\u0005'R\fG\u000fC\u0005\u0002\u0012\u0001A\t\u0011)Q\u0005\u007f\u0006)1\u000f^1uA!Y\u0011Q\u0003\u0001A\u0002\u0003\u0007I\u0011BA\f\u0003)\u0011Xm];mi\u000e\u000bGnY\u000b\u0003\u00033\u00012aFA\u000e\u0013\r\ti\u0002\u0002\u0002\u000e\r\u0016\fG/\u001e:f%\u0016\u001cX\u000f\u001c;\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013%\u00111E\u0001\u000fe\u0016\u001cX\u000f\u001c;DC2\u001cw\fJ3r)\u0011\t)#a\u000b\u0011\u0007Q\n9#C\u0002\u0002*U\u0012A!\u00168ji\"Q\u0011QFA\u0010\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013\u0007\u0003\u0005\u00022\u0001\u0001\u000b\u0015BA\r\u0003-\u0011Xm];mi\u000e\u000bGn\u0019\u0011\t\u000f\u0005U\u0002\u0001\"\u0011\u00028\u0005)a/[:jiR!\u0011QEA\u001d\u0011\u001d1\u00161\u0007a\u0001\u0003w\u0001B!!\u0010\u0002@5\tQ+C\u0002\u0002BU\u0013qAR3biV\u0014X\rC\u0004\u0002F\u0001!\t%a\u0012\u0002\u0013\u001d,GOU3tk2$HCAA\r\u0011\u001d\tY\u0005\u0001C!\u0003\u001b\nq!\u001a=fGV$X\r\u0006\u0004\u0002&\u0005=\u0013\u0011\f\u0005\t\u0003#\nI\u00051\u0001\u0002T\u000511o\\;sG\u0016\u00042aJA+\u0013\r\t9\u0006\u000b\u0002\u0014'&l\u0007\u000f\\3GK\u0006$XO]3T_V\u00148-\u001a\u0005\t\u00037\nI\u00051\u0001\u0002^\u0005)\u0011/^3ssB!\u0011qLA1\u001b\u0005Q\u0013bAA2U\t)\u0011+^3ss\u0002")
public class StatsVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final String statString;
    private final boolean encode;
    private final String[] properties;
    private final SimpleFeatureType origSft;
    private Tuple2<String, SimpleFeatureType> x$4;
    private String transforms;
    private SimpleFeatureType transformSFT;
    private TransformSimpleFeature transformSF;
    private SimpleFeatureType statSft;
    private Stat stat;
    private FeatureResult resultCalc;
    private final Logger logger;
    private volatile byte bitmap$0;

    private Tuple2 x$4$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2 tuple2 = QueryPlanner$.MODULE$.buildTransformSFT(this.origSft(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.properties));
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String transforms = (String)tuple2._1();
                    SimpleFeatureType transformSFT = (SimpleFeatureType)tuple2._2();
                    this.x$4 = tuple22 = new Tuple2((Object)transforms, (Object)transformSFT);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                } else {
                    throw new MatchError((Object)tuple2);
                }
            }
            return this.x$4;
        }
    }

    private String transforms$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.transforms = (String)this.x$4()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.transforms;
        }
    }

    private SimpleFeatureType transformSFT$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.transformSFT = (SimpleFeatureType)this.x$4()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.transformSFT;
        }
    }

    private TransformSimpleFeature transformSF$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.transformSF = TransformSimpleFeature$.MODULE$.apply(this.origSft(), this.transformSFT(), this.transforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.transformSF;
        }
    }

    private SimpleFeatureType statSft$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.statSft = this.properties == null ? this.origSft() : this.transformSFT();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.statSft;
        }
    }

    private Stat stat$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.stat = Stat$.MODULE$.apply(this.statSft(), this.statString);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.stat;
        }
    }

    private Logger logger$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.class.getExpressions((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
    }

    private SimpleFeatureType origSft() {
        return this.origSft;
    }

    private /* synthetic */ Tuple2 x$4() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$4$lzycompute() : this.x$4;
    }

    private String transforms() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.transforms$lzycompute() : this.transforms;
    }

    private SimpleFeatureType transformSFT() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.transformSFT$lzycompute() : this.transformSFT;
    }

    private TransformSimpleFeature transformSF() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.transformSF$lzycompute() : this.transformSF;
    }

    private SimpleFeatureType statSft() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.statSft$lzycompute() : this.statSft;
    }

    private Stat stat() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.stat$lzycompute() : this.stat;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (this.properties != null) {
            this.transformSF().setFeature(sf);
            this.stat().observe((SimpleFeature)this.transformSF());
        } else {
            this.stat().observe(sf);
        }
    }

    public FeatureResult getResult() {
        FeatureResult featureResult;
        if (this.resultCalc() == null) {
            String stats = this.encode ? (String)StatsScan$.MODULE$.encodeStat(this.statSft()).apply((Object)this.stat()) : this.stat().toJson();
            ScalaSimpleFeature sf = new ScalaSimpleFeature(StatsScan$.MODULE$.StatsSft(), "", new Object[]{stats, GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            ListFeatureCollection manualVisitResults = new ListFeatureCollection(StatsScan$.MODULE$.StatsSft());
            manualVisitResults.add((SimpleFeature)sf);
            featureResult = new FeatureResult((SimpleFeatureCollection)manualVisitResults);
        } else {
            featureResult = this.resultCalc();
        }
        return featureResult;
    }

    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa stats iterator process on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.properties != null) {
            BoxedUnit boxedUnit2;
            List list = query.getProperties();
            List list2 = Query.ALL_PROPERTIES;
            if (!(list != null ? !((Object)list).equals(list2) : list2 != null)) {
                boxedUnit2 = BoxedUnit.UNIT;
            } else if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Overriding inner query's properties (", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.getProperties()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with properties/transforms ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.properties).mkString(",")}))).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            query.setPropertyNames(this.properties);
        }
        query.getHints().put((Object)QueryHints$.MODULE$.STATS_STRING(), (Object)this.statString);
        query.getHints().put((Object)QueryHints$.MODULE$.ENCODE_STATS(), (Object)new Boolean(this.encode));
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(query)));
    }

    public StatsVisitor(SimpleFeatureCollection features, String statString, boolean encode, String[] properties) {
        this.statString = statString;
        this.encode = encode;
        this.properties = properties;
        GeoMesaProcessVisitor.class.$init$((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.origSft = (SimpleFeatureType)features.getSchema();
    }
}

