/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.geom.Point2D;
import java.util.Date;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.util.Converters;
import org.locationtech.geomesa.features.ScalaSimpleFeatureFactory$;
import org.locationtech.geomesa.process.tube.TubeBuilder$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-w!B\u0001\u0003\u0011\u0003i\u0011a\u0003+vE\u0016\u0014U/\u001b7eKJT!a\u0001\u0003\u0002\tQ,(-\u001a\u0006\u0003\u000b\u0019\tq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"a\u0003+vE\u0016\u0014U/\u001b7eKJ\u001c\"a\u0004\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015Ir\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\tQ\u0002C\u0004\u001d\u001f\t\u0007I\u0011A\u000f\u0002\u001f\u0011+g-Y;mi\u0012#xMR5fY\u0012,\u0012A\b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019\u0019FO]5oO\"1qe\u0004Q\u0001\ny\t\u0001\u0003R3gCVdG\u000f\u0012;h\r&,G\u000e\u001a\u0011\u0007\u000bA\u0011\u0011\u0011A\u0015\u0014\u0007!\u0012\"\u0006\u0005\u0002,e5\tAF\u0003\u0002.]\u0005a1oY1mC2|wmZ5oO*\u0011q\u0006M\u0001\tif\u0004Xm]1gK*\t\u0011'A\u0002d_6L!a\r\u0017\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tk!\u0012)\u0019!C\u0001m\u0005aA/\u001e2f\r\u0016\fG/\u001e:fgV\tq\u0007\u0005\u00029\u007f5\t\u0011H\u0003\u0002;w\u000511/[7qY\u0016T!\u0001P\u001f\u0002\t\u0011\fG/\u0019\u0006\u0003})\t\u0001bZ3pi>|Gn]\u0005\u0003\u0001f\u0012qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\t\u0011\tC#\u0011!Q\u0001\n]\nQ\u0002^;cK\u001a+\u0017\r^;sKN\u0004\u0003\u0002\u0003#)\u0005\u000b\u0007I\u0011A#\u0002\u001d\t,hMZ3s\t&\u001cH/\u00198dKV\ta\t\u0005\u0002\u0014\u000f&\u0011\u0001\n\u0006\u0002\u0007\t>,(\r\\3\t\u0011)C#\u0011!Q\u0001\n\u0019\u000bqBY;gM\u0016\u0014H)[:uC:\u001cW\r\t\u0005\t\u0019\"\u0012)\u0019!C\u0001\u001b\u00069Q.\u0019=CS:\u001cX#\u0001(\u0011\u0005My\u0015B\u0001)\u0015\u0005\rIe\u000e\u001e\u0005\t%\"\u0012\t\u0011)A\u0005\u001d\u0006AQ.\u0019=CS:\u001c\b\u0005C\u0003\u001aQ\u0011\u0005A\u000b\u0006\u0003V-^C\u0006C\u0001\b)\u0011\u0015)4\u000b1\u00018\u0011\u0015!5\u000b1\u0001G\u0011\u0015a5\u000b1\u0001O\u0011\u001dQ\u0006F1A\u0005\u0002m\u000bAaY1mGV\tA\f\u0005\u0002^A6\taL\u0003\u0002`{\u0005Y!/\u001a4fe\u0016t7-\u001b8h\u0013\t\tgL\u0001\nHK>$W\r^5d\u0007\u0006d7-\u001e7bi>\u0014\bBB2)A\u0003%A,A\u0003dC2\u001c\u0007\u0005C\u0004fQ\t\u0007I\u0011\u00014\u0002\u0011\u0011$xMR5fY\u0012,\u0012a\u001a\t\u0003Q.t!aE5\n\u0005)$\u0012A\u0002)sK\u0012,g-\u0003\u0002&Y*\u0011!\u000e\u0006\u0005\u0007]\"\u0002\u000b\u0011B4\u0002\u0013\u0011$xMR5fY\u0012\u0004\u0003b\u00029)\u0005\u0004%\t!]\u0001\u0007O\u0016|g)Y2\u0016\u0003I\u0004\"a\u001d=\u000e\u0003QT!!\u001e<\u0002\t\u001d,w.\u001c\u0006\u0003o\"\t1A\u001b;t\u0013\tIHOA\bHK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z\u0011\u0019Y\b\u0006)A\u0005e\u00069q-Z8GC\u000e\u0004\u0003bB?)\u0005\u0004%\t!H\u0001\n\u000f\u0016{Uj\u0018)S\u001fBCaa \u0015!\u0002\u0013q\u0012AC$F\u001f6{\u0006KU(QA!I\u00111\u0001\u0015C\u0002\u0013\u0005\u0011QA\u0001\tiV\u0014W\rV=qKV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t)\"\u0004\u0002\u0002\f)\u0019!(!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\bM\u0016\fG/\u001e:f\u0015\r\t\u0019BC\u0001\b_B,gnZ5t\u0013\u0011\t9\"a\u0003\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\r\u0003\u0005\u0002\u001c!\u0002\u000b\u0011BA\u0004\u0003%!XOY3UsB,\u0007\u0005C\u0005\u0002 !\u0012\r\u0011\"\u0001\u0002\"\u00059!-^5mI\u0016\u0014XCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"b\u0001\u001e\u0002*)\u0019\u0011qB\u001f\n\t\u00055\u0012q\u0005\u0002\u0015'&l\u0007\u000f\\3GK\u0006$XO]3Ck&dG-\u001a:\t\u0011\u0005E\u0002\u0006)A\u0005\u0003G\t\u0001BY;jY\u0012,'\u000f\t\u0005\b\u0003kAC\u0011AA\u001c\u0003\u001d9W\r^$f_6$B!!\u000f\u0002@A\u00191/a\u000f\n\u0007\u0005uBO\u0001\u0005HK>lW\r\u001e:z\u0011!\t\t%a\rA\u0002\u0005\r\u0013AA:g!\u0011\tI!!\u0012\n\t\u0005\u001d\u00131\u0002\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000f\u0005-\u0003\u0006\"\u0001\u0002N\u0005aq-\u001a;Ti\u0006\u0014H\u000fV5nKR!\u0011qJA.!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+E\u0005!Q\u000f^5m\u0013\u0011\tI&a\u0015\u0003\t\u0011\u000bG/\u001a\u0005\t\u0003\u0003\nI\u00051\u0001\u0002D!9\u0011q\f\u0015\u0005\u0002\u0005\u0005\u0014AC4fi\u0016sG\rV5nKR!\u0011qJA2\u0011!\t\t%!\u0018A\u0002\u0005\r\u0003bBA4Q\u0011\u0005\u0011\u0011N\u0001\u000bEV4g-\u001a:HK>lGCBA\u001d\u0003W\ni\u0007C\u0004v\u0003K\u0002\r!!\u000f\t\u000f\u0005=\u0014Q\ra\u0001\r\u00061Q.\u001a;feNDq!a\u001d)\t\u0003\t)(A\bnKR,'o\u001d+p\t\u0016<'/Z3t)\u00151\u0015qOA=\u0011\u001d\ty'!\u001dA\u0002\u0019C\u0001\"a\u001f\u0002r\u0001\u0007\u0011QP\u0001\u0006a>Lg\u000e\u001e\t\u0004g\u0006}\u0014bAAAi\n)\u0001k\\5oi\"9\u0011Q\u0011\u0015\u0005\u0002\u0005\u001d\u0015A\u00022vM\u001a,'\u000f\u0006\u0004\u0002\n\u0006\u0005\u0016Q\u0015\t\u0007\u0003\u0017\u000bY*a\u0011\u000f\t\u00055\u0015q\u0013\b\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*\u0019\u00111\u0013\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012bAAM)\u00059\u0001/Y2lC\u001e,\u0017\u0002BAO\u0003?\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u00033#\u0002\u0002CAR\u0003\u0007\u0003\r!!#\u0002\u001dMLW\u000e\u001d7f\r\u0016\fG/\u001e:fg\"9\u0011qNAB\u0001\u00041\u0005bBAUQ\u0011\u0005\u00111V\u0001\niJ\fgn\u001d4pe6$b!!#\u0002.\u0006=\u0006BB\u001b\u0002(\u0002\u0007q\u0007\u0003\u0004f\u0003O\u0003\ra\u001a\u0005\b\u0003gCC\u0011AA[\u0003Ui\u0017m[3J\t2\u001b\u0016MZ3MS:,7\u000b\u001e:j]\u001e$b!!\u000f\u00028\u0006\u0005\u0007\u0002CA]\u0003c\u0003\r!a/\u0002\r%t\u0007/\u001e;2!\r\u0019\u0018QX\u0005\u0004\u0003\u007f#(AC\"p_J$\u0017N\\1uK\"A\u00111YAY\u0001\u0004\tY,\u0001\u0004j]B,HO\r\u0005\b\u0003\u000fDc\u0011AAe\u0003)\u0019'/Z1uKR+(-Z\u000b\u0003\u0003\u0013\u0003")
public abstract class TubeBuilder
implements LazyLogging {
    private final SimpleFeatureCollection tubeFeatures;
    private final double bufferDistance;
    private final int maxBins;
    private final GeodeticCalculator calc;
    private final String dtgField;
    private final GeometryFactory geoFac;
    private final String GEOM_PROP;
    private final SimpleFeatureType tubeType;
    private final SimpleFeatureBuilder builder;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String DefaultDtgField() {
        return TubeBuilder$.MODULE$.DefaultDtgField();
    }

    private Logger logger$lzycompute() {
        TubeBuilder tubeBuilder = this;
        synchronized (tubeBuilder) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeatureCollection tubeFeatures() {
        return this.tubeFeatures;
    }

    public double bufferDistance() {
        return this.bufferDistance;
    }

    public int maxBins() {
        return this.maxBins;
    }

    public GeodeticCalculator calc() {
        return this.calc;
    }

    public String dtgField() {
        return this.dtgField;
    }

    public GeometryFactory geoFac() {
        return this.geoFac;
    }

    public String GEOM_PROP() {
        return this.GEOM_PROP;
    }

    public SimpleFeatureType tubeType() {
        return this.tubeType;
    }

    public SimpleFeatureBuilder builder() {
        return this.builder;
    }

    public Geometry getGeom(SimpleFeature sf) {
        return (Geometry)sf.getAttribute(0);
    }

    public Date getStartTime(SimpleFeature sf) {
        return (Date)sf.getAttribute(1);
    }

    public Date getEndTime(SimpleFeature sf) {
        return (Date)sf.getAttribute(2);
    }

    public Geometry bufferGeom(Geometry geom, double meters) {
        return geom.buffer(this.metersToDegrees(meters, Conversions.RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom))));
    }

    public double metersToDegrees(double meters, Point point) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Buffering: ").append((Object)((Object)BoxesRunTime.boxToDouble((double)meters)).toString()).append((Object)" ").append((Object)WKTUtils$.MODULE$.write((Geometry)point)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.calc().setStartingGeographicPoint(point.getX(), point.getY());
        this.calc().setDirection(0.0, meters);
        Point2D dest2D = this.calc().getDestinationGeographicPoint();
        Point destPoint = this.geoFac().createPoint(new Coordinate(dest2D.getX(), dest2D.getY()));
        return point.distance((Geometry)destPoint);
    }

    public Iterator<SimpleFeature> buffer(Iterator<SimpleFeature> simpleFeatures, double meters) {
        return simpleFeatures.map((Function1)new Serializable(this, meters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TubeBuilder $outer;
            private final double meters$1;

            public final SimpleFeature apply(SimpleFeature sf) {
                Geometry bufferedGeom = this.$outer.bufferGeom(this.$outer.getGeom(sf), this.meters$1);
                this.$outer.builder().reset();
                this.$outer.builder().init(sf);
                this.$outer.builder().set(this.$outer.GEOM_PROP(), (Object)bufferedGeom);
                return this.$outer.builder().buildFeature(sf.getID());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.meters$1 = meters$1;
            }
        });
    }

    public Iterator<SimpleFeature> transform(SimpleFeatureCollection tubeFeatures, String dtgField) {
        return SelfClosingIterator$.MODULE$.apply(tubeFeatures.features()).map((Function1)new Serializable(this, dtgField){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TubeBuilder $outer;
            private final String dtgField$1;

            public final SimpleFeature apply(SimpleFeature sf) {
                Date date = (Date)Converters.convert((Object)sf.getAttribute(this.dtgField$1), Date.class);
                if (date == null) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isErrorEnabled()) {
                        this.$outer.logger().underlying().error(new StringBuilder().append((Object)"Unable to retrieve date field from input tubeFeatures...ensure there a field named ").append((Object)this.dtgField$1).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Unable to retrieve date field from input tubeFeatures...ensure there a field named \"").append((Object)this.dtgField$1).append((Object)"\"").toString());
                }
                this.$outer.builder().reset();
                return this.$outer.builder().buildFeature(sf.getID(), new Object[]{sf.getDefaultGeometry(), date, null});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dtgField$1 = dtgField$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Geometry makeIDLSafeLineString(Coordinate input1, Coordinate input2) {
        LineString lineString;
        if (GeometryUtils$.MODULE$.crossesIDL(input1, input2)) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            double latIntercept = GeometryUtils$.MODULE$.calcIDLIntercept(input1, input2);
            Coordinate p1 = new Coordinate(-180.0, latIntercept);
            Coordinate p2 = new Coordinate(180.0, latIntercept);
            Tuple2 tuple23 = tuple22 = input1.x > 0.0 ? new Tuple2((Object)input1, (Object)input2) : new Tuple2((Object)input2, (Object)input1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Coordinate point1 = (Coordinate)tuple22._1();
            Coordinate point2 = (Coordinate)tuple22._2();
            Tuple2 tuple24 = tuple2 = new Tuple2((Object)point1, (Object)point2);
            Coordinate point12 = (Coordinate)tuple24._1();
            Coordinate point22 = (Coordinate)tuple24._2();
            LineString westLine = new LineString((CoordinateSequence)new CoordinateArraySequence((Coordinate[])((Object[])new Coordinate[]{p1, point22})), this.geoFac());
            LineString eastLine = new LineString((CoordinateSequence)new CoordinateArraySequence((Coordinate[])((Object[])new Coordinate[]{point12, p2})), this.geoFac());
            lineString = new MultiLineString((LineString[])((Object[])new LineString[]{westLine, eastLine}), this.geoFac());
            return lineString;
        } else {
            lineString = new LineString((CoordinateSequence)new CoordinateArraySequence((Coordinate[])((Object[])new Coordinate[]{input1, input2})), this.geoFac());
        }
        return lineString;
    }

    public abstract Iterator<SimpleFeature> createTube();

    public TubeBuilder(SimpleFeatureCollection tubeFeatures, double bufferDistance, int maxBins) {
        this.tubeFeatures = tubeFeatures;
        this.bufferDistance = bufferDistance;
        this.maxBins = maxBins;
        LazyLogging.class.$init$((LazyLogging)this);
        this.calc = new GeodeticCalculator();
        this.dtgField = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)tubeFeatures.getSchema())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return TubeBuilder$.MODULE$.DefaultDtgField();
            }
        });
        this.geoFac = new GeometryFactory();
        this.GEOM_PROP = "geom";
        this.tubeType = SimpleFeatureTypes$.MODULE$.createType("tubeType", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":Geometry:srid=4326,start:Date,end:Date"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.GEOM_PROP()})));
        this.builder = ScalaSimpleFeatureFactory$.MODULE$.featureBuilder(this.tubeType());
    }
}

