/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.geotools.geometry.DirectPosition3D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.i18n.Errors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.BoundingBox3D;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ReferencedEnvelope3D
extends ReferencedEnvelope
implements BoundingBox3D {
    private static final long serialVersionUID = -3188702602373537163L;
    private double minz;
    private double maxz;
    public static ReferencedEnvelope3D EVERYTHING = new ReferencedEnvelope3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null){
        private static final long serialVersionUID = -3188702602373537164L;

        @Override
        public boolean contains(BoundingBox bbox) {
            return true;
        }

        @Override
        public boolean contains(Coordinate p) {
            return true;
        }

        @Override
        public boolean contains(DirectPosition pos) {
            return true;
        }

        @Override
        public boolean contains(double x, double y, double z) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public double getArea() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public double getVolume() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public void setBounds(BoundingBox3D arg0) {
            throw new IllegalStateException("Cannot modify ReferencedEnvelope.EVERYTHING");
        }

        @Override
        public Coordinate centre() {
            return new Coordinate();
        }

        @Override
        public void setToNull() {
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == EVERYTHING) {
                return true;
            }
            if (obj instanceof ReferencedEnvelope3D) {
                ReferencedEnvelope3D other = (ReferencedEnvelope3D)obj;
                if (other.crs != 1.EVERYTHING.crs) {
                    return false;
                }
                if (other.getMinX() != EVERYTHING.getMinX()) {
                    return false;
                }
                if (other.getMinY() != EVERYTHING.getMinY()) {
                    return false;
                }
                if (other.getMinZ() != EVERYTHING.getMinZ()) {
                    return false;
                }
                if (other.getMaxX() != EVERYTHING.getMaxX()) {
                    return false;
                }
                if (other.getMaxY() != EVERYTHING.getMaxY()) {
                    return false;
                }
                return other.getMaxZ() == EVERYTHING.getMaxZ();
            }
            return super.equals(obj);
        }

        @Override
        public String toString() {
            return "ReferencedEnvelope.EVERYTHING";
        }
    };

    public static boolean intersects(Coordinate p1, Coordinate p2, Coordinate q) {
        double d = q.x;
        double d2 = p1.x < p2.x ? p1.x : p2.x;
        if (d >= d2) {
            double d3 = q.x;
            double d4 = p1.x > p2.x ? p1.x : p2.x;
            if (d3 <= d4) {
                double d5 = q.y;
                double d6 = p1.y < p2.y ? p1.y : p2.y;
                if (d5 >= d6) {
                    double d7 = q.y;
                    double d8 = p1.y > p2.y ? p1.y : p2.y;
                    if (d7 <= d8) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean intersects(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        double minq = Math.min(q1.x, q2.x);
        double maxq = Math.max(q1.x, q2.x);
        double minp = Math.min(p1.x, p2.x);
        double maxp = Math.max(p1.x, p2.x);
        if (minp > maxq) {
            return false;
        }
        if (maxp < minq) {
            return false;
        }
        minq = Math.min(q1.y, q2.y);
        maxq = Math.max(q1.y, q2.y);
        minp = Math.min(p1.y, p2.y);
        maxp = Math.max(p1.y, p2.y);
        if (minp > maxq) {
            return false;
        }
        return !(maxp < minq);
    }

    @Override
    public void init() {
        this.setToNull();
    }

    public void init(double x1, double x2, double y1, double y2, double z1, double z2) {
        this.init(x1, x2, y1, y2);
        if (z1 < z2) {
            this.minz = z1;
            this.maxz = z2;
        } else {
            this.minz = z2;
            this.maxz = z1;
        }
    }

    @Override
    public void init(Coordinate p1, Coordinate p2) {
        this.init(p1.x, p2.x, p1.y, p2.y, p1.z, p2.z);
    }

    @Override
    public void init(Coordinate p) {
        this.init(p.x, p.x, p.y, p.y, p.z, p.z);
    }

    @Override
    public void init(Envelope env) {
        super.init(env);
        if (env instanceof BoundingBox3D) {
            this.minz = ((BoundingBox3D)env).getMinZ();
            this.maxz = ((BoundingBox3D)env).getMaxZ();
        }
    }

    public void init(ReferencedEnvelope3D env) {
        super.init(env);
        this.minz = env.minz;
        this.maxz = env.maxz;
    }

    @Override
    public void setToNull() {
        super.setToNull();
        this.minz = 0.0;
        this.maxz = -1.0;
    }

    public double getDepth() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxz - this.minz;
    }

    public double getMinZ() {
        return this.minz;
    }

    public double getMaxZ() {
        return this.maxz;
    }

    public double getVolume() {
        return this.getWidth() * this.getHeight() * this.getDepth();
    }

    @Override
    public double minExtent() {
        if (this.isNull()) {
            return 0.0;
        }
        return Math.min(this.getWidth(), Math.min(this.getHeight(), this.getDepth()));
    }

    @Override
    public double maxExtent() {
        if (this.isNull()) {
            return 0.0;
        }
        return Math.max(this.getWidth(), Math.max(this.getHeight(), this.getDepth()));
    }

    @Override
    public void expandToInclude(Coordinate p) {
        this.expandToInclude(p.x, p.y, p.z);
    }

    @Override
    public void expandBy(double distance) {
        this.expandBy(distance, distance, distance);
    }

    public void expandBy(double deltaX, double deltaY, double deltaZ) {
        if (this.isNull()) {
            return;
        }
        this.minz -= deltaZ;
        this.maxz += deltaZ;
        this.expandBy(deltaX, deltaY);
        if (this.minz > this.maxz) {
            this.setToNull();
        }
    }

    public void expandToInclude(double x, double y, double z) {
        if (this.isNull()) {
            this.expandToInclude(x, y);
            this.minz = z;
            this.maxz = z;
        } else {
            this.expandToInclude(x, y);
            if (z < this.minz) {
                this.minz = z;
            }
            if (z > this.maxz) {
                this.maxz = z;
            }
        }
    }

    @Override
    public void expandToInclude(DirectPosition pt) {
        double x = pt.getOrdinate(0);
        double y = pt.getOrdinate(1);
        double z = pt.getDimension() >= 3 ? pt.getOrdinate(2) : Double.NaN;
        this.expandToInclude(x, y, z);
    }

    public void translate(double transX, double transY, double transZ) {
        if (this.isNull()) {
            return;
        }
        this.init(this.getMinX() + transX, this.getMaxX() + transX, this.getMinY() + transY, this.getMaxY() + transY, this.getMinZ() + transZ, this.getMaxZ() + transZ);
    }

    @Override
    public Coordinate centre() {
        if (this.isNull()) {
            return null;
        }
        return new Coordinate((this.getMinX() + this.getMaxX()) / 2.0, (this.getMinY() + this.getMaxY()) / 2.0, (this.getMinZ() + this.getMaxZ()) / 2.0);
    }

    public boolean intersects(ReferencedEnvelope3D other) {
        if (this.isNull() || other.isNull()) {
            return false;
        }
        return super.intersects(other) && !(other.minz > this.maxz) && !(other.maxz < this.minz);
    }

    public boolean overlaps(ReferencedEnvelope3D other) {
        return this.intersects(other);
    }

    @Override
    public boolean intersects(Coordinate p) {
        return this.intersects(p.x, p.y, p.z);
    }

    @Override
    public boolean overlaps(Coordinate p) {
        return this.intersects(p);
    }

    public boolean intersects(double x, double y, double z) {
        if (this.isNull()) {
            return false;
        }
        return this.intersects(x, y) && !(z > this.maxz) && !(z > this.maxz);
    }

    public boolean overlaps(double x, double y, double z) {
        return this.intersects(x, y, z);
    }

    @Override
    public boolean contains(Coordinate p) {
        return this.covers(p);
    }

    public boolean contains(double x, double y, double z) {
        return this.covers(x, y, z);
    }

    public boolean covers(double x, double y, double z) {
        if (this.isNull()) {
            return false;
        }
        return this.covers(x, y) && z >= this.minz && z <= this.maxz;
    }

    @Override
    public boolean covers(Coordinate p) {
        return this.covers(p.x, p.y, p.z);
    }

    public boolean covers(ReferencedEnvelope3D other) {
        if (this.isNull() || other.isNull()) {
            return false;
        }
        return super.covers(other) && other.getMinZ() >= this.minz && other.getMaxZ() <= this.maxz;
    }

    public double distance(ReferencedEnvelope3D env) {
        if (this.intersects(env)) {
            return 0.0;
        }
        double dx = 0.0;
        if (this.getMaxX() < env.getMinX()) {
            dx = env.getMinX() - this.getMaxX();
        } else if (this.getMinX() > env.getMaxX()) {
            dx = this.getMinX() - env.getMaxX();
        }
        double dy = 0.0;
        if (this.getMaxY() < env.getMinY()) {
            dy = env.getMinY() - this.getMaxY();
        } else if (this.getMinY() > env.getMaxY()) {
            dy = this.getMinY() - env.getMaxY();
        }
        double dz = 0.0;
        if (this.maxz < env.minz) {
            dz = env.minz - this.maxz;
        } else if (this.minz > env.maxz) {
            dz = this.minz - env.maxz;
        }
        if (dx == 0.0 && dz == 0.0) {
            return dy;
        }
        if (dy == 0.0 && dz == 0.0) {
            return dx;
        }
        if (dx == 0.0 && dy == 0.0) {
            return dz;
        }
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public ReferencedEnvelope3D() {
        this((CoordinateReferenceSystem)null);
    }

    public ReferencedEnvelope3D(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope3D(double x1, double x2, double y1, double y2, double z1, double z2, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this.init(x1, x2, y1, y2, z1, z2);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope3D(ReferencedEnvelope3D envelope) throws MismatchedDimensionException {
        this.init(envelope);
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope3D(BoundingBox3D bbox) throws MismatchedDimensionException {
        this(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), bbox.getMinZ(), bbox.getMaxZ(), bbox.getCoordinateReferenceSystem());
    }

    public ReferencedEnvelope3D(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(envelope, crs);
        if (envelope instanceof ReferencedEnvelope3D) {
            this.minz = ((ReferencedEnvelope3D)envelope).getMinZ();
            this.maxz = ((ReferencedEnvelope3D)envelope).getMaxZ();
        }
    }

    public ReferencedEnvelope3D(org.opengis.geometry.Envelope envelope) throws MismatchedDimensionException {
        this.init(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1), envelope.getMinimum(2), envelope.getMaximum(2));
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope3D(ReferencedEnvelope3D envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this.init(envelope);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    @Override
    public void init(BoundingBox bounds) {
        this.init(bounds.getMinimum(0), bounds.getMaximum(0), bounds.getMinimum(1), bounds.getMaximum(1), bounds.getMinimum(2), bounds.getMaximum(2));
        this.crs = bounds.getCoordinateReferenceSystem();
    }

    private static ReferencedEnvelope3D getJTSEnvelope(BoundingBox3D bbox) {
        if (bbox == null) {
            throw new NullPointerException("Provided bbox envelope was null");
        }
        if (bbox instanceof ReferencedEnvelope3D) {
            return (ReferencedEnvelope3D)bbox;
        }
        return new ReferencedEnvelope3D(bbox);
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public double getMinimum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
            case 2: {
                return this.getMinZ();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public double getMaximum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
            case 2: {
                return this.getMaxZ();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public double getMedian(int dimension) {
        switch (dimension) {
            case 0: {
                return 0.5 * (this.getMinX() + this.getMaxX());
            }
            case 1: {
                return 0.5 * (this.getMinY() + this.getMaxY());
            }
            case 2: {
                return 0.5 * (this.getMinZ() + this.getMaxZ());
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public double getSpan(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
            case 2: {
                return this.getDepth();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public DirectPosition getLowerCorner() {
        return new DirectPosition3D(this.crs, this.getMinX(), this.getMinY(), this.getMinZ());
    }

    @Override
    public DirectPosition getUpperCorner() {
        return new DirectPosition3D(this.crs, this.getMaxX(), this.getMaxY(), this.getMinZ());
    }

    @Override
    public boolean isEmpty() {
        return super.isNull();
    }

    @Override
    public boolean contains(DirectPosition pos) {
        this.ensureCompatibleReferenceSystem(pos);
        return this.contains(pos.getOrdinate(0), pos.getOrdinate(1), pos.getOrdinate(2));
    }

    public boolean contains(BoundingBox3D bbox) {
        this.ensureCompatibleReferenceSystem((BoundingBox)bbox);
        return this.covers(ReferencedEnvelope3D.getJTSEnvelope(bbox));
    }

    public boolean intersects(BoundingBox3D bbox) {
        this.ensureCompatibleReferenceSystem((BoundingBox)bbox);
        return this.intersects(ReferencedEnvelope3D.getJTSEnvelope(bbox));
    }

    public ReferencedEnvelope3D intersection(ReferencedEnvelope3D env) {
        this.ensureCompatibleReferenceSystem(env);
        if (this.isNull() || env.isNull() || !this.intersects(env)) {
            return new ReferencedEnvelope3D();
        }
        double intMinX = this.getMinX() > env.getMinX() ? this.getMinX() : env.getMinX();
        double intMinY = this.getMinY() > env.getMinY() ? this.getMinY() : env.getMinY();
        double intMinZ = this.minz > env.minz ? this.minz : env.minz;
        double intMaxX = this.getMaxX() < env.getMaxX() ? this.getMaxX() : env.getMaxX();
        double intMaxY = this.getMaxY() < env.getMaxY() ? this.getMaxY() : env.getMaxY();
        double intMaxZ = this.maxz < env.maxz ? this.maxz : env.maxz;
        return new ReferencedEnvelope3D(intMinX, intMaxX, intMinY, intMaxY, intMinZ, intMaxZ, env.getCoordinateReferenceSystem());
    }

    public void include(BoundingBox3D bbox) {
        if (this.crs == null) {
            this.crs = bbox.getCoordinateReferenceSystem();
        }
        this.expandToInclude(ReferencedEnvelope3D.getJTSEnvelope(bbox));
    }

    public void expandToInclude(ReferencedEnvelope3D other) {
        this.ensureCompatibleReferenceSystem(other);
        if (other.isNull()) {
            return;
        }
        if (this.isNull()) {
            super.expandToInclude(other);
            this.minz = other.getMinZ();
            this.maxz = other.getMaxZ();
        } else {
            super.expandToInclude(other);
            if (other.minz < this.minz) {
                this.minz = other.minz;
            }
            if (other.maxz > this.maxz) {
                this.maxz = other.maxz;
            }
        }
    }

    public void include(double x, double y, double z) {
        this.expandToInclude(x, y, z);
    }

    public void setBounds(BoundingBox3D bbox) {
        this.ensureCompatibleReferenceSystem((BoundingBox)bbox);
        this.init(ReferencedEnvelope3D.getJTSEnvelope(bbox));
    }

    @Override
    public BoundingBox toBounds(CoordinateReferenceSystem targetCRS) throws TransformException {
        try {
            return this.transform(targetCRS, true);
        }
        catch (FactoryException e) {
            throw new TransformException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient) throws TransformException, FactoryException {
        return this.transform(targetCRS, lenient, 5);
    }

    @Override
    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient, int numPointsForTransformation) throws TransformException, FactoryException {
        if (this.crs == null) {
            if (this.isEmpty()) {
                return new ReferencedEnvelope3D(targetCRS);
            }
            throw new NullPointerException("Unable to transform referenced envelope, crs has not yet been provided.");
        }
        if (this.getDimension() != targetCRS.getCoordinateSystem().getDimension()) {
            if (lenient) {
                return JTS.transformTo2D(this, targetCRS, lenient, numPointsForTransformation);
            }
            throw new MismatchedDimensionException(Errors.format((int)94, (Object)this.crs.getName().getCode(), (Object)new Integer(this.getDimension()), (Object)new Integer(targetCRS.getCoordinateSystem().getDimension())));
        }
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(lenient);
        CoordinateOperation operation = coordinateOperationFactory.createOperation(this.crs, targetCRS);
        GeneralEnvelope transformed = CRS.transform(operation, (org.opengis.geometry.Envelope)this);
        transformed.setCoordinateReferenceSystem(targetCRS);
        ReferencedEnvelope3D target = new ReferencedEnvelope3D(transformed);
        MathTransform transform = operation.getMathTransform();
        JTS.transform(this, target, transform, numPointsForTransformation);
        target.expandToInclude(0.0, 0.0, this.minz);
        target.expandToInclude(0.0, 0.0, this.maxz);
        return target;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + Coordinate.hashCode(this.minz);
        result = 37 * result + Coordinate.hashCode(this.maxz);
        int code = result ^ 0xAB296275;
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ReferencedEnvelope3D)) {
            return false;
        }
        ReferencedEnvelope3D otherEnvelope = (ReferencedEnvelope3D)other;
        if (this.isNull()) {
            return otherEnvelope.isNull();
        }
        if (super.equals(other) && this.minz == otherEnvelope.getMinZ() && this.minz == otherEnvelope.getMinZ()) {
            CoordinateReferenceSystem otherCRS = other instanceof ReferencedEnvelope3D ? ((ReferencedEnvelope3D)other).crs : null;
            return CRS.equalsIgnoreMetadata(this.crs, otherCRS);
        }
        return false;
    }

    public boolean boundsEquals3D(org.opengis.geometry.Envelope other, double eps) {
        eps *= 0.5 * (this.getWidth() + this.getHeight());
        double[] delta = new double[]{this.getMinimum(0) - other.getMinimum(0), this.getMaximum(0) - other.getMaximum(0), this.getMinimum(1) - other.getMinimum(1), this.getMaximum(1) - other.getMaximum(1)};
        delta[4] = this.getMinimum(2) - other.getMinimum(2);
        delta[5] = this.getMaximum(2) - other.getMaximum(2);
        for (int i = 0; i < delta.length; ++i) {
            if (Math.abs(delta[i]) <= eps) continue;
            return false;
        }
        return true;
    }

    @Override
    public void include(double x, double y) {
        super.expandToInclude(x, y);
    }
}

