/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultEngineeringDatum;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.util.InternationalString;

public class CartesianAuthorityFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory {
    public static final String GENERIC_2D_CODE = "404000";
    public static final DefaultEngineeringCRS GENERIC_2D = new DefaultEngineeringCRS(CartesianAuthorityFactory.buildProperties("Wildcard 2D cartesian plane in metric unit", Citations.EPSG, "404000"), DefaultEngineeringDatum.UNKNOWN, DefaultCartesianCS.GENERIC_2D, true);

    static Map<String, ?> buildProperties(String name, Citation authority, String code) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", name);
        props.put("identifiers", new NamedIdentifier(authority, code));
        return props;
    }

    public CartesianAuthorityFactory() {
        this(null);
    }

    public CartesianAuthorityFactory(Hints hints) {
        super(hints, 80);
    }

    @Override
    public Citation getAuthority() {
        return Citations.EPSG;
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        if (type.isAssignableFrom(EngineeringCRS.class)) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.add(GENERIC_2D_CODE);
            return set;
        }
        return Collections.EMPTY_SET;
    }

    public InternationalString getDescriptionText(String code) throws NoSuchAuthorityCodeException, FactoryException {
        if (code.equals("EPSG:404000")) {
            return new SimpleInternationalString("A two-dimensional wildcard coordinate system with X,Y axis in meters");
        }
        throw this.noSuchAuthorityException(code);
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.createEngineeringCRS(code);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        if (GENERIC_2D_CODE.equals(code) || "EPSG:404000".equals(code)) {
            return GENERIC_2D;
        }
        throw this.noSuchAuthorityException(code);
    }

    private NoSuchAuthorityCodeException noSuchAuthorityException(String code) throws NoSuchAuthorityCodeException {
        String authority = "EPSG";
        return new NoSuchAuthorityCodeException(Errors.format((int)138, (Object)code, (Object)authority, EngineeringCRS.class), authority, code);
    }
}

