/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import org.geotools.data.DataUtilities;
import org.geotools.filter.spatial.BBOXImpl;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.Bounds$;
import org.locationtech.geomesa.filter.Bounds$Bound$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterHelper$FilterHelperLogger$;
import org.locationtech.geomesa.filter.FilterHelper$SpatialOpOrder$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.filter.expression.AttributeExpression;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.filter.visitor.IdDetectingFilterVisitor;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.TEquals;
import org.opengis.temporal.Period;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class FilterHelper$ {
    public static final FilterHelper$ MODULE$;
    private final String org$locationtech$geomesa$filter$FilterHelper$$SafeGeomString;

    static {
        new FilterHelper$();
    }

    public String org$locationtech$geomesa$filter$FilterHelper$$SafeGeomString() {
        return this.org$locationtech$geomesa$filter$FilterHelper$$SafeGeomString;
    }

    public Filter visitBinarySpatialOp(BinarySpatialOperator op, SimpleFeatureType sft, FilterFactory2 factory) {
        BinarySpatialOperator binarySpatialOperator;
        AttributeExpression prop = package$.MODULE$.checkOrderUnsafe(op.getExpression1(), op.getExpression2());
        Geometry geom = (Geometry)prop.literal().evaluate(null, Geometry.class);
        Object object = geom.getUserData();
        String string = this.org$locationtech$geomesa$filter$FilterHelper$$SafeGeomString();
        if (!(object != null ? !object.equals(string) : string != null)) {
            binarySpatialOperator = op;
        } else {
            String attribute2 = (String)Option$.MODULE$.apply((Object)prop.name()).filterNot((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return x$1.isEmpty();
                }
            }).orElse((Function0)new Serializable(sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final Option<String> apply() {
                    return Option$.MODULE$.apply((Object)this.sft$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(SimpleFeatureType x$2) {
                            return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(x$2));
                        }
                    });
                }
                {
                    this.sft$1 = sft$1;
                }
            }).orNull(Predef$.MODULE$.$conforms());
            Geometry geomCopy = geom.getFactory().createGeometry(geom);
            Geometry trimmedGeom = geomCopy.intersection((Geometry)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon());
            if (trimmedGeom.isEmpty()) {
                binarySpatialOperator = Filter.EXCLUDE;
            } else {
                Object[] objectArray;
                Geometry geomWithWayPoints = op instanceof BBOX ? this.addWayPointsToBBOX(trimmedGeom) : trimmedGeom;
                Seq<Geometry> safeGeometries = this.org$locationtech$geomesa$filter$FilterHelper$$flattenGeometry(this.org$locationtech$geomesa$filter$FilterHelper$$tryGetIdlSafeGeom(geomWithWayPoints));
                safeGeometries.foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Geometry x$3) {
                        x$3.setUserData((Object)FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$SafeGeomString());
                    }
                });
                BinarySpatialOperator binarySpatialOperator2 = op;
                if (binarySpatialOperator2 instanceof DWithin) {
                    DWithin dWithin = (DWithin)binarySpatialOperator2;
                    objectArray = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)dWithin.getDistance()), dWithin.getDistanceUnits()}), ClassTag$.MODULE$.Any());
                } else {
                    objectArray = null;
                }
                Object[] args = objectArray;
                binarySpatialOperator = package$.MODULE$.orFilters((Seq<Filter>)((Seq)safeGeometries.map((Function1)new Serializable(op, factory, prop, attribute2, args){
                    public static final long serialVersionUID = 0L;
                    private final BinarySpatialOperator op$1;
                    private final FilterFactory2 factory$1;
                    private final AttributeExpression prop$1;
                    private final String attribute$1;
                    private final Object[] args$1;

                    public final Filter apply(Geometry x$4) {
                        return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$recreateFilter(this.op$1, this.attribute$1, x$4, this.prop$1.flipped(), this.factory$1, this.args$1);
                    }
                    {
                        this.op$1 = op$1;
                        this.factory$1 = factory$1;
                        this.prop$1 = prop$1;
                        this.attribute$1 = attribute$1;
                        this.args$1 = args$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())), (FilterFactory)factory);
            }
        }
        return binarySpatialOperator;
    }

    public Geometry org$locationtech$geomesa$filter$FilterHelper$$tryGetIdlSafeGeom(Geometry geom) {
        Try try_;
        block7: {
            Geometry geometry;
            block6: {
                BoxedUnit boxedUnit;
                block5: {
                    Geometry g;
                    try_ = GeohashUtils$.MODULE$.getInternationalDateLineSafeGeometry(geom);
                    if (!(try_ instanceof Success)) break block5;
                    Success success = (Success)try_;
                    geometry = g = (Geometry)success.value();
                    break block6;
                }
                if (!(try_ instanceof Failure)) break block7;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().isWarnEnabled()) {
                    FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error splitting geometry on IDL for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geom})), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                geometry = geom;
            }
            return geometry;
        }
        throw new MatchError((Object)try_);
    }

    public Filter org$locationtech$geomesa$filter$FilterHelper$$recreateFilter(BinarySpatialOperator op, String property, Geometry geom, boolean flipped, FilterFactory2 factory, Object[] args) {
        Tuple2 tuple2;
        block2: {
            BinarySpatialOperator binarySpatialOperator;
            block9: {
                Within within;
                block4: {
                    Expression e2;
                    Expression e1;
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block3: {
                                        Tuple2 tuple22;
                                        Tuple2 tuple23 = tuple2 = flipped ? new Tuple2((Object)factory.literal((Object)geom), (Object)factory.property(property)) : new Tuple2((Object)factory.property(property), (Object)factory.literal((Object)geom));
                                        if (tuple2 == null) break block2;
                                        Expression e12 = (Expression)tuple2._1();
                                        Expression e22 = (Expression)tuple2._2();
                                        Tuple2 tuple24 = tuple22 = new Tuple2((Object)e12, (Object)e22);
                                        e1 = (Expression)tuple24._1();
                                        e2 = (Expression)tuple24._2();
                                        binarySpatialOperator = op;
                                        if (!(binarySpatialOperator instanceof Within)) break block3;
                                        within = factory.within(e1, e2);
                                        break block4;
                                    }
                                    if (!(binarySpatialOperator instanceof Intersects)) break block5;
                                    within = factory.intersects(e1, e2);
                                    break block4;
                                }
                                if (!(binarySpatialOperator instanceof Overlaps)) break block6;
                                within = factory.overlaps(e1, e2);
                                break block4;
                            }
                            if (!(binarySpatialOperator instanceof DWithin)) break block7;
                            within = factory.dwithin(e1, e2, BoxesRunTime.unboxToDouble((Object)args[0]), (String)args[1]);
                            break block4;
                        }
                        if (!(binarySpatialOperator instanceof BBOX)) break block8;
                        within = new BBOXImpl(e1, e2);
                        break block4;
                    }
                    if (!(binarySpatialOperator instanceof Contains)) break block9;
                    within = factory.contains(e1, e2);
                }
                return within;
            }
            throw new MatchError((Object)binarySpatialOperator);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean isFilterWholeWorld(Filter f) {
        boolean bl;
        Filter filter = f;
        if (filter instanceof BBOX) {
            BBOX bBOX = (BBOX)filter;
            bl = this.isOperationGeomWholeWorld(bBOX, this.isOperationGeomWholeWorld$default$2());
        } else if (filter instanceof Intersects) {
            Intersects intersects = (Intersects)filter;
            bl = this.isOperationGeomWholeWorld(intersects, this.isOperationGeomWholeWorld$default$2());
        } else if (filter instanceof Overlaps) {
            Overlaps overlaps = (Overlaps)filter;
            bl = this.isOperationGeomWholeWorld(overlaps, this.isOperationGeomWholeWorld$default$2());
        } else if (filter instanceof Within) {
            Within within = (Within)filter;
            bl = this.isOperationGeomWholeWorld(within, FilterHelper$SpatialOpOrder$.MODULE$.PropertyFirst());
        } else if (filter instanceof Contains) {
            Contains contains = (Contains)filter;
            bl = this.isOperationGeomWholeWorld(contains, FilterHelper$SpatialOpOrder$.MODULE$.LiteralFirst());
        } else {
            bl = false;
        }
        return bl;
    }

    private <Op extends BinarySpatialOperator> boolean isOperationGeomWholeWorld(Op op, Enumeration.Value order) {
        Option<AttributeExpression> prop = package$.MODULE$.checkOrder(op.getExpression1(), op.getExpression2());
        return prop.exists((Function1)new Serializable(order){
            public static final long serialVersionUID = 0L;
            private final Enumeration.Value order$1;

            public final boolean apply(AttributeExpression p) {
                Enumeration.Value value;
                block5: {
                    boolean bl;
                    block3: {
                        block4: {
                            block2: {
                                value = this.order$1;
                                Enumeration.Value value2 = FilterHelper$SpatialOpOrder$.MODULE$.AnyOrder();
                                Enumeration.Value value3 = value;
                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                bl = true;
                                break block3;
                            }
                            Enumeration.Value value4 = FilterHelper$SpatialOpOrder$.MODULE$.PropertyFirst();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                            bl = !p.flipped();
                            break block3;
                        }
                        Enumeration.Value value6 = FilterHelper$SpatialOpOrder$.MODULE$.LiteralFirst();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                        bl = p.flipped();
                    }
                    boolean ordered = bl;
                    return ordered && Option$.MODULE$.apply(p.literal().evaluate(null, Geometry.class)).exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Geometry g) {
                            return FilterHelper$.MODULE$.isWholeWorld(g);
                        }
                    });
                }
                throw new MatchError((Object)value);
            }
            {
                this.order$1 = order$1;
            }
        });
    }

    private <Op extends BinarySpatialOperator> Enumeration.Value isOperationGeomWholeWorld$default$2() {
        return FilterHelper$SpatialOpOrder$.MODULE$.AnyOrder();
    }

    public <G extends Geometry> boolean isWholeWorld(G g) {
        return g != null && g.union().covers((Geometry)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon());
    }

    public Geometry addWayPointsToBBOX(Geometry g) {
        Coordinate[] correctedGeom;
        Coordinate[] geomArray = g.getCoordinates();
        return geomArray.length == (correctedGeom = (Coordinate[])GeometryUtils$.MODULE$.addWayPoints((Seq)Predef$.MODULE$.wrapRefArray((Object[])geomArray)).toArray(ClassTag$.MODULE$.apply(Coordinate.class))).length ? g : g.getFactory().createPolygon(correctedGeom);
    }

    public FilterValues<Geometry> extractGeometries(Filter filter, String attribute2, boolean intersect) {
        return this.org$locationtech$geomesa$filter$FilterHelper$$extractUnclippedGeometries(filter, attribute2, intersect).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Geometry apply(Geometry x$6) {
                return x$6.intersection((Geometry)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon());
            }
        });
    }

    public boolean extractGeometries$default$3() {
        return true;
    }

    public FilterValues<Geometry> org$locationtech$geomesa$filter$FilterHelper$$extractUnclippedGeometries(Filter filter, String attribute2, boolean intersect) {
        BinarySpatialOperator binarySpatialOperator;
        FilterValues filterValues;
        Filter filter2 = filter;
        if (filter2 instanceof Or) {
            Or or2 = (Or)filter2;
            Buffer all = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(or2.getChildren()).map((Function1)new Serializable(attribute2, intersect){
                public static final long serialVersionUID = 0L;
                private final String attribute$2;
                private final boolean intersect$1;

                public final FilterValues<Geometry> apply(Filter x$7) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractUnclippedGeometries(x$7, this.attribute$2, this.intersect$1);
                }
                {
                    this.attribute$2 = attribute$2;
                    this.intersect$1 = intersect$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Serializable serializable = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Geometry> apply(Seq<Geometry> l, Seq<Geometry> r) {
                    return (Seq)l.$plus$plus(r, Seq$.MODULE$.canBuildFrom());
                }
            };
            Serializable join = new Serializable((Function2)serializable){
                public static final long serialVersionUID = 0L;
                private final Function2 eta$0$1$1;

                public final FilterValues<Geometry> apply(FilterValues<Geometry> left, FilterValues<Geometry> right) {
                    return FilterValues$.MODULE$.or(this.eta$0$1$1, left, right);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            };
            filterValues = (FilterValues)all.reduceLeftOption((Function2)join).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final FilterValues<Nothing$> apply() {
                    return FilterValues$.MODULE$.empty();
                }
            });
        } else if (filter2 instanceof And) {
            FilterValues filterValues2;
            And and = (And)filter2;
            Buffer all = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(and.getChildren()).map((Function1)new Serializable(attribute2, intersect){
                public static final long serialVersionUID = 0L;
                private final String attribute$2;
                private final boolean intersect$1;

                public final FilterValues<Geometry> apply(Filter x$8) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractUnclippedGeometries(x$8, this.attribute$2, this.intersect$1);
                }
                {
                    this.attribute$2 = attribute$2;
                    this.intersect$1 = intersect$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FilterValues<Geometry> x$9) {
                    return x$9.nonEmpty();
                }
            });
            if (intersect) {
                Serializable serializable = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<Geometry> apply(Geometry l, Geometry r) {
                        return Option$.MODULE$.apply((Object)l.intersection(r)).filterNot((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Geometry x$10) {
                                return x$10.isEmpty();
                            }
                        });
                    }
                };
                Serializable intersect2 = new Serializable((Function2)serializable){
                    public static final long serialVersionUID = 0L;
                    private final Function2 eta$0$2$1;

                    public final FilterValues<Geometry> apply(FilterValues<Geometry> left, FilterValues<Geometry> right) {
                        return FilterValues$.MODULE$.and(this.eta$0$2$1, left, right);
                    }
                    {
                        this.eta$0$2$1 = eta$0$2$1;
                    }
                };
                filterValues2 = (FilterValues)all.reduceLeftOption((Function2)intersect2).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final FilterValues<Nothing$> apply() {
                        return FilterValues$.MODULE$.empty();
                    }
                });
            } else {
                filterValues2 = new FilterValues((Seq)all.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Geometry> apply(FilterValues<Geometry> x$11) {
                        return x$11.values();
                    }
                }, Buffer$.MODULE$.canBuildFrom()), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
            }
            filterValues = filterValues2;
        } else if (filter2 instanceof BinarySpatialOperator && package$.MODULE$.isSpatialFilter((Filter)(binarySpatialOperator = (BinarySpatialOperator)filter2))) {
            Option geometry = package$.MODULE$.checkOrder(binarySpatialOperator.getExpression1(), binarySpatialOperator.getExpression2()).withFilter((Function1)new Serializable(attribute2){
                public static final long serialVersionUID = 0L;
                private final String attribute$2;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(AttributeExpression prop) {
                    if (prop.name() == null) return true;
                    String string = prop.name();
                    String string2 = this.attribute$2;
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
                {
                    this.attribute$2 = attribute$2;
                }
            }).flatMap((Function1)new Serializable(filter){
                public static final long serialVersionUID = 0L;
                public final Filter filter$1;

                public final Option<Geometry> apply(AttributeExpression prop) {
                    return Option$.MODULE$.apply(prop.literal().evaluate(null, Geometry.class)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.11 $outer;

                        public final Geometry apply(Geometry geom) {
                            Geometry geometry;
                            Filter filter = this.$outer.filter$1;
                            if (filter instanceof DWithin) {
                                DWithin dWithin = (DWithin)filter;
                                geometry = geom.buffer(GeometryUtils$.MODULE$.distanceDegrees(geom, dWithin.getDistance() * FilterHelper$.MODULE$.metersMultiplier(dWithin.getDistanceUnits()))._2$mcD$sp());
                            } else {
                                geometry = filter instanceof BBOX ? FilterHelper$.MODULE$.addWayPointsToBBOX(geom.getFactory().createGeometry(geom).intersection((Geometry)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon())) : geom;
                            }
                            Geometry buffered = geometry;
                            return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$tryGetIdlSafeGeom(buffered);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.filter$1 = filter$1;
                }
            });
            filterValues = new FilterValues((Seq)geometry.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Geometry> apply(Geometry geometry) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$flattenGeometry(geometry);
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.empty();
                }
            }), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        } else {
            filterValues = FilterValues$.MODULE$.empty();
        }
        return filterValues;
    }

    public double metersMultiplier(String units) {
        double d;
        if (units == null) {
            d = 1.0;
        } else {
            String string = units.trim().toLowerCase(Locale.US);
            double d2 = "meters".equals(string) ? 1.0 : ("kilometers".equals(string) ? 1000.0 : ("feet".equals(string) ? 0.3048 : ("statute miles".equals(string) ? 1609.347 : ("nautical miles".equals(string) ? 1852.0 : 1.0))));
            d = d2;
        }
        return d;
    }

    public Seq<Geometry> org$locationtech$geomesa$filter$FilterHelper$$flattenGeometry(Geometry geometry) {
        Seq seq;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry2;
            seq = (Seq)((TraversableLike)Seq$.MODULE$.tabulate(geometryCollection.getNumGeometries(), (Function1)new Serializable(geometryCollection){
                public static final long serialVersionUID = 0L;
                private final GeometryCollection x2$1;

                public final Geometry apply(int x$1) {
                    return this.x2$1.getGeometryN(x$1);
                }
                {
                    this.x2$1 = x2$1;
                }
            })).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Geometry> apply(Geometry geometry) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$flattenGeometry(geometry);
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geometry}));
        }
        return seq;
    }

    public FilterValues<Bounds<ZonedDateTime>> extractIntervals(Filter filter, String attribute2, boolean intersect, boolean handleExclusiveBounds) {
        return this.extractAttributeBounds(filter, attribute2, Date.class).map(new Serializable(handleExclusiveBounds){
            public static final long serialVersionUID = 0L;
            private final boolean handleExclusiveBounds$1;

            public final Bounds<ZonedDateTime> apply(Bounds<Date> bounds) {
                Bounds.Bound<ZonedDateTime> lower = null;
                Bounds.Bound<ZonedDateTime> upper = null;
                if (!(!this.handleExclusiveBounds$1 || bounds.lower().value().isEmpty() || bounds.upper().value().isEmpty() || bounds.lower().inclusive() && bounds.upper().inclusive())) {
                    int margin = bounds.lower().inclusive() || bounds.upper().inclusive() ? 1000 : 2000;
                    boolean round = ((Date)bounds.upper().value().get()).getTime() - ((Date)bounds.lower().value().get()).getTime() > (long)margin;
                    lower = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$createDateTime(bounds.lower(), (Function1<ZonedDateTime, ZonedDateTime>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ZonedDateTime apply(ZonedDateTime dt) {
                            return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$roundSecondsUp(dt);
                        }
                    }, round);
                    upper = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$createDateTime(bounds.upper(), (Function1<ZonedDateTime, ZonedDateTime>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ZonedDateTime apply(ZonedDateTime dt) {
                            return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$roundSecondsDown(dt);
                        }
                    }, round);
                } else {
                    lower = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$createDateTime(bounds.lower(), (Function1<ZonedDateTime, ZonedDateTime>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ZonedDateTime apply(ZonedDateTime dt) {
                            return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$roundSecondsUp(dt);
                        }
                    }, this.handleExclusiveBounds$1);
                    upper = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$createDateTime(bounds.upper(), (Function1<ZonedDateTime, ZonedDateTime>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ZonedDateTime apply(ZonedDateTime dt) {
                            return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$roundSecondsDown(dt);
                        }
                    }, this.handleExclusiveBounds$1);
                }
                return new Bounds<ZonedDateTime>(lower, upper);
            }
            {
                this.handleExclusiveBounds$1 = handleExclusiveBounds$1;
            }
        });
    }

    public boolean extractIntervals$default$3() {
        return true;
    }

    public boolean extractIntervals$default$4() {
        return false;
    }

    public Bounds.Bound<ZonedDateTime> org$locationtech$geomesa$filter$FilterHelper$$createDateTime(Bounds.Bound<Date> bound, Function1<ZonedDateTime, ZonedDateTime> round, boolean roundExclusive) {
        Bounds.Bound bound2;
        if (bound.value().isEmpty()) {
            bound2 = Bounds$Bound$.MODULE$.unbounded();
        } else {
            Option dt = bound.value().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ZonedDateTime apply(Date d) {
                    return ZonedDateTime.ofInstant(d.toInstant(), ZoneOffset.UTC);
                }
            });
            bound2 = roundExclusive && !bound.inclusive() ? new Bounds.Bound(dt.map(round), true) : new Bounds.Bound(dt, bound.inclusive());
        }
        return bound2;
    }

    public ZonedDateTime org$locationtech$geomesa$filter$FilterHelper$$roundSecondsUp(ZonedDateTime dt) {
        return dt.plusSeconds(1L).withNano(0);
    }

    public ZonedDateTime org$locationtech$geomesa$filter$FilterHelper$$roundSecondsDown(ZonedDateTime dt) {
        int nanos = dt.getNano();
        return nanos == 0 ? dt.minusSeconds(1L) : dt.withNano(0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> FilterValues<Bounds<T>> extractAttributeBounds(Filter filter, String attribute2, Class<T> binding) {
        Filter filter2;
        Not not;
        boolean bl;
        block37: {
            String prop;
            FilterValues filterValues;
            block38: {
                FilterValues filterValues2;
                PropertyIsLike propertyIsLike;
                FilterValues filterValues3;
                PropertyIsBetween propertyIsBetween;
                bl = false;
                not = null;
                filter2 = filter;
                if (filter2 instanceof Or) {
                    Or or2 = (Or)filter2;
                    Buffer all = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(or2.getChildren()).flatMap((Function1)new Serializable(attribute2, binding){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$3;
                        private final Class binding$1;

                        public final Seq<FilterValues<Bounds<T>>> apply(Filter f) {
                            FilterValues<Bounds<T>> child = FilterHelper$.MODULE$.extractAttributeBounds(f, this.attribute$3, this.binding$1);
                            return child.isEmpty() ? (Seq)Seq$.MODULE$.empty() : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FilterValues[]{child}));
                        }
                        {
                            this.attribute$3 = attribute$3;
                            this.binding$1 = binding$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    Serializable serializable = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Bounds<T>> apply(Seq<Bounds<T>> left, Seq<Bounds<T>> right) {
                            return Bounds$.MODULE$.union(left, right);
                        }
                    };
                    Serializable union = new Serializable((Function2)serializable){
                        public static final long serialVersionUID = 0L;
                        private final Function2 eta$0$3$1;

                        public final FilterValues<Bounds<T>> apply(FilterValues<Bounds<T>> left, FilterValues<Bounds<T>> right) {
                            return FilterValues$.MODULE$.or(this.eta$0$3$1, left, right);
                        }
                        {
                            this.eta$0$3$1 = eta$0$3$1;
                        }
                    };
                    return (FilterValues)all.reduceLeftOption((Function2)union).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Nothing$> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof And) {
                    And and = (And)filter2;
                    Buffer all = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(and.getChildren()).flatMap((Function1)new Serializable(attribute2, binding){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$3;
                        private final Class binding$1;

                        public final Seq<FilterValues<Bounds<T>>> apply(Filter f) {
                            FilterValues<Bounds<T>> child = FilterHelper$.MODULE$.extractAttributeBounds(f, this.attribute$3, this.binding$1);
                            return child.isEmpty() ? (Seq)Seq$.MODULE$.empty() : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FilterValues[]{child}));
                        }
                        {
                            this.attribute$3 = attribute$3;
                            this.binding$1 = binding$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    Serializable serializable = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Option<Bounds<T>> apply(Bounds<T> left, Bounds<T> right) {
                            return Bounds$.MODULE$.intersection(left, right);
                        }
                    };
                    Serializable intersection = new Serializable((Function2)serializable){
                        public static final long serialVersionUID = 0L;
                        private final Function2 eta$0$4$1;

                        public final FilterValues<Bounds<T>> apply(FilterValues<Bounds<T>> left, FilterValues<Bounds<T>> right) {
                            return FilterValues$.MODULE$.and(this.eta$0$4$1, left, right);
                        }
                        {
                            this.eta$0$4$1 = eta$0$4$1;
                        }
                    };
                    return (FilterValues)all.reduceLeftOption((Function2)intersection).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Nothing$> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsEqualTo) {
                    PropertyIsEqualTo propertyIsEqualTo = (PropertyIsEqualTo)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsEqualTo.getExpression1(), propertyIsEqualTo.getExpression2()).filter((Function1)new Serializable(attribute2){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$3;

                        public final boolean apply(AttributeExpression x$12) {
                            String string = x$12.name();
                            String string2 = this.attribute$3;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$3 = attribute$3;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(AttributeExpression x0$1) {
                            AttributeExpression attributeExpression;
                            block4: {
                                Option option;
                                block3: {
                                    block2: {
                                        attributeExpression = x0$1;
                                        if (!(attributeExpression instanceof AttributeExpression.PropertyLiteral)) break block2;
                                        AttributeExpression.PropertyLiteral propertyLiteral = (AttributeExpression.PropertyLiteral)attributeExpression;
                                        option = Option$.MODULE$.apply(propertyLiteral.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final FilterValues<Bounds<T>> apply(T lit) {
                                                Bounds.Bound<T> bound = new Bounds.Bound<T>(new Some(lit), true);
                                                return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(bound, bound)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                                            }
                                        });
                                        break block3;
                                    }
                                    if (!(attributeExpression instanceof AttributeExpression.FunctionLiteral)) break block4;
                                    AttributeExpression.FunctionLiteral functionLiteral = (AttributeExpression.FunctionLiteral)attributeExpression;
                                    option = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractFunctionBounds(functionLiteral, true, this.binding$1);
                                }
                                return option;
                            }
                            throw new MatchError((Object)attributeExpression);
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Nothing$> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsBetween) {
                    String prop2;
                    propertyIsBetween = (PropertyIsBetween)filter2;
                    String string = prop2 = ((PropertyName)propertyIsBetween.getExpression()).getPropertyName();
                    String string2 = attribute2;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        Bounds.Bound lower = new Bounds.Bound(Option$.MODULE$.apply(propertyIsBetween.getLowerBoundary().evaluate(null, binding)), true);
                        Bounds.Bound upper = new Bounds.Bound(Option$.MODULE$.apply(propertyIsBetween.getUpperBoundary().evaluate(null, binding)), true);
                        filterValues3 = new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds(lower, upper)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                        return filterValues3;
                    }
                    filterValues3 = FilterValues$.MODULE$.empty();
                    return filterValues3;
                }
                if (filter2 instanceof During) {
                    During during = (During)filter2;
                    if (Date.class.isAssignableFrom(binding)) {
                        return (FilterValues)package$.MODULE$.checkOrder(during.getExpression1(), during.getExpression2()).filter((Function1)new Serializable(attribute2){
                            public static final long serialVersionUID = 0L;
                            private final String attribute$3;

                            public final boolean apply(AttributeExpression x$13) {
                                String string = x$13.name();
                                String string2 = this.attribute$3;
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                this.attribute$3 = attribute$3;
                            }
                        }).flatMap((Function1)new Serializable(binding){
                            public static final long serialVersionUID = 0L;
                            private final Class binding$1;

                            public final Option<FilterValues<Bounds<T>>> apply(AttributeExpression x0$2) {
                                AttributeExpression attributeExpression;
                                block4: {
                                    Option option;
                                    block3: {
                                        block2: {
                                            attributeExpression = x0$2;
                                            if (!(attributeExpression instanceof AttributeExpression.PropertyLiteral)) break block2;
                                            AttributeExpression.PropertyLiteral propertyLiteral = (AttributeExpression.PropertyLiteral)attributeExpression;
                                            option = Option$.MODULE$.apply(propertyLiteral.literal().evaluate(null, Period.class)).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final FilterValues<Bounds<T>> apply(Period p) {
                                                    Bounds.Bound<T> lower = new Bounds.Bound<T>(Option$.MODULE$.apply((Object)p.getBeginning().getPosition().getDate()), false);
                                                    Bounds.Bound<T> upper = new Bounds.Bound<T>(Option$.MODULE$.apply((Object)p.getEnding().getPosition().getDate()), false);
                                                    return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(lower, upper)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                                                }
                                            });
                                            break block3;
                                        }
                                        if (!(attributeExpression instanceof AttributeExpression.FunctionLiteral)) break block4;
                                        AttributeExpression.FunctionLiteral functionLiteral = (AttributeExpression.FunctionLiteral)attributeExpression;
                                        option = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractFunctionBounds(functionLiteral, false, this.binding$1);
                                    }
                                    return option;
                                }
                                throw new MatchError((Object)attributeExpression);
                            }
                            {
                                this.binding$1 = binding$1;
                            }
                        }).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final FilterValues<Nothing$> apply() {
                                return FilterValues$.MODULE$.empty();
                            }
                        });
                    }
                }
                if (filter2 instanceof PropertyIsGreaterThan) {
                    PropertyIsGreaterThan propertyIsGreaterThan = (PropertyIsGreaterThan)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsGreaterThan.getExpression1(), propertyIsGreaterThan.getExpression2()).filter((Function1)new Serializable(attribute2){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$3;

                        public final boolean apply(AttributeExpression x$14) {
                            String string = x$14.name();
                            String string2 = this.attribute$3;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$3 = attribute$3;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(AttributeExpression x0$3) {
                            AttributeExpression attributeExpression;
                            block4: {
                                Option option;
                                block3: {
                                    block2: {
                                        attributeExpression = x0$3;
                                        if (!(attributeExpression instanceof AttributeExpression.PropertyLiteral)) break block2;
                                        AttributeExpression.PropertyLiteral propertyLiteral = (AttributeExpression.PropertyLiteral)attributeExpression;
                                        option = Option$.MODULE$.apply(propertyLiteral.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, propertyLiteral){
                                            public static final long serialVersionUID = 0L;
                                            private final AttributeExpression.PropertyLiteral x2$2;

                                            public final FilterValues<Bounds<T>> apply(T lit) {
                                                Tuple2 tuple2;
                                                Bounds.Bound<T> bound = new Bounds.Bound<T>(new Some(lit), false);
                                                Tuple2 tuple22 = tuple2 = this.x2$2.flipped() ? new Tuple2(Bounds$Bound$.MODULE$.unbounded(), bound) : new Tuple2(bound, Bounds$Bound$.MODULE$.unbounded());
                                                if (tuple2 != null) {
                                                    Tuple2 tuple23;
                                                    Bounds.Bound lower = (Bounds.Bound)tuple2._1();
                                                    Bounds.Bound upper = (Bounds.Bound)tuple2._2();
                                                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                                    Bounds.Bound lower2 = (Bounds.Bound)tuple24._1();
                                                    Bounds.Bound upper2 = (Bounds.Bound)tuple24._2();
                                                    return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(lower2, upper2)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                                                }
                                                throw new MatchError((Object)tuple2);
                                            }
                                            {
                                                this.x2$2 = x2$2;
                                            }
                                        });
                                        break block3;
                                    }
                                    if (!(attributeExpression instanceof AttributeExpression.FunctionLiteral)) break block4;
                                    AttributeExpression.FunctionLiteral functionLiteral = (AttributeExpression.FunctionLiteral)attributeExpression;
                                    option = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractFunctionBounds(functionLiteral, false, this.binding$1);
                                }
                                return option;
                            }
                            throw new MatchError((Object)attributeExpression);
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Nothing$> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsGreaterThanOrEqualTo) {
                    PropertyIsGreaterThanOrEqualTo propertyIsGreaterThanOrEqualTo = (PropertyIsGreaterThanOrEqualTo)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsGreaterThanOrEqualTo.getExpression1(), propertyIsGreaterThanOrEqualTo.getExpression2()).filter((Function1)new Serializable(attribute2){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$3;

                        public final boolean apply(AttributeExpression x$16) {
                            String string = x$16.name();
                            String string2 = this.attribute$3;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$3 = attribute$3;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(AttributeExpression x0$4) {
                            AttributeExpression attributeExpression;
                            block4: {
                                Option option;
                                block3: {
                                    block2: {
                                        attributeExpression = x0$4;
                                        if (!(attributeExpression instanceof AttributeExpression.PropertyLiteral)) break block2;
                                        AttributeExpression.PropertyLiteral propertyLiteral = (AttributeExpression.PropertyLiteral)attributeExpression;
                                        option = Option$.MODULE$.apply(propertyLiteral.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, propertyLiteral){
                                            public static final long serialVersionUID = 0L;
                                            private final AttributeExpression.PropertyLiteral x2$3;

                                            public final FilterValues<Bounds<T>> apply(T lit) {
                                                Tuple2 tuple2;
                                                Bounds.Bound<T> bound = new Bounds.Bound<T>(new Some(lit), true);
                                                Tuple2 tuple22 = tuple2 = this.x2$3.flipped() ? new Tuple2(Bounds$Bound$.MODULE$.unbounded(), bound) : new Tuple2(bound, Bounds$Bound$.MODULE$.unbounded());
                                                if (tuple2 != null) {
                                                    Tuple2 tuple23;
                                                    Bounds.Bound lower = (Bounds.Bound)tuple2._1();
                                                    Bounds.Bound upper = (Bounds.Bound)tuple2._2();
                                                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                                    Bounds.Bound lower2 = (Bounds.Bound)tuple24._1();
                                                    Bounds.Bound upper2 = (Bounds.Bound)tuple24._2();
                                                    return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(lower2, upper2)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                                                }
                                                throw new MatchError((Object)tuple2);
                                            }
                                            {
                                                this.x2$3 = x2$3;
                                            }
                                        });
                                        break block3;
                                    }
                                    if (!(attributeExpression instanceof AttributeExpression.FunctionLiteral)) break block4;
                                    AttributeExpression.FunctionLiteral functionLiteral = (AttributeExpression.FunctionLiteral)attributeExpression;
                                    option = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractFunctionBounds(functionLiteral, true, this.binding$1);
                                }
                                return option;
                            }
                            throw new MatchError((Object)attributeExpression);
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Nothing$> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsLessThan) {
                    PropertyIsLessThan propertyIsLessThan = (PropertyIsLessThan)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsLessThan.getExpression1(), propertyIsLessThan.getExpression2()).filter((Function1)new Serializable(attribute2){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$3;

                        public final boolean apply(AttributeExpression x$18) {
                            String string = x$18.name();
                            String string2 = this.attribute$3;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$3 = attribute$3;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(AttributeExpression x0$5) {
                            AttributeExpression attributeExpression;
                            block4: {
                                Option option;
                                block3: {
                                    block2: {
                                        attributeExpression = x0$5;
                                        if (!(attributeExpression instanceof AttributeExpression.PropertyLiteral)) break block2;
                                        AttributeExpression.PropertyLiteral propertyLiteral = (AttributeExpression.PropertyLiteral)attributeExpression;
                                        option = Option$.MODULE$.apply(propertyLiteral.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, propertyLiteral){
                                            public static final long serialVersionUID = 0L;
                                            private final AttributeExpression.PropertyLiteral x2$4;

                                            public final FilterValues<Bounds<T>> apply(T lit) {
                                                Tuple2 tuple2;
                                                Bounds.Bound<T> bound = new Bounds.Bound<T>(new Some(lit), false);
                                                Tuple2 tuple22 = tuple2 = this.x2$4.flipped() ? new Tuple2(bound, Bounds$Bound$.MODULE$.unbounded()) : new Tuple2(Bounds$Bound$.MODULE$.unbounded(), bound);
                                                if (tuple2 != null) {
                                                    Tuple2 tuple23;
                                                    Bounds.Bound lower = (Bounds.Bound)tuple2._1();
                                                    Bounds.Bound upper = (Bounds.Bound)tuple2._2();
                                                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                                    Bounds.Bound lower2 = (Bounds.Bound)tuple24._1();
                                                    Bounds.Bound upper2 = (Bounds.Bound)tuple24._2();
                                                    return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(lower2, upper2)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                                                }
                                                throw new MatchError((Object)tuple2);
                                            }
                                            {
                                                this.x2$4 = x2$4;
                                            }
                                        });
                                        break block3;
                                    }
                                    if (!(attributeExpression instanceof AttributeExpression.FunctionLiteral)) break block4;
                                    AttributeExpression.FunctionLiteral functionLiteral = (AttributeExpression.FunctionLiteral)attributeExpression;
                                    option = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractFunctionBounds(functionLiteral, false, this.binding$1);
                                }
                                return option;
                            }
                            throw new MatchError((Object)attributeExpression);
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Nothing$> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsLessThanOrEqualTo) {
                    PropertyIsLessThanOrEqualTo propertyIsLessThanOrEqualTo = (PropertyIsLessThanOrEqualTo)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsLessThanOrEqualTo.getExpression1(), propertyIsLessThanOrEqualTo.getExpression2()).filter((Function1)new Serializable(attribute2){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$3;

                        public final boolean apply(AttributeExpression x$20) {
                            String string = x$20.name();
                            String string2 = this.attribute$3;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$3 = attribute$3;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(AttributeExpression x0$6) {
                            AttributeExpression attributeExpression;
                            block4: {
                                Option option;
                                block3: {
                                    block2: {
                                        attributeExpression = x0$6;
                                        if (!(attributeExpression instanceof AttributeExpression.PropertyLiteral)) break block2;
                                        AttributeExpression.PropertyLiteral propertyLiteral = (AttributeExpression.PropertyLiteral)attributeExpression;
                                        option = Option$.MODULE$.apply(propertyLiteral.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, propertyLiteral){
                                            public static final long serialVersionUID = 0L;
                                            private final AttributeExpression.PropertyLiteral x2$5;

                                            public final FilterValues<Bounds<T>> apply(T lit) {
                                                Tuple2 tuple2;
                                                Bounds.Bound<T> bound = new Bounds.Bound<T>(new Some(lit), true);
                                                Tuple2 tuple22 = tuple2 = this.x2$5.flipped() ? new Tuple2(bound, Bounds$Bound$.MODULE$.unbounded()) : new Tuple2(Bounds$Bound$.MODULE$.unbounded(), bound);
                                                if (tuple2 != null) {
                                                    Tuple2 tuple23;
                                                    Bounds.Bound lower = (Bounds.Bound)tuple2._1();
                                                    Bounds.Bound upper = (Bounds.Bound)tuple2._2();
                                                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                                    Bounds.Bound lower2 = (Bounds.Bound)tuple24._1();
                                                    Bounds.Bound upper2 = (Bounds.Bound)tuple24._2();
                                                    return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(lower2, upper2)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                                                }
                                                throw new MatchError((Object)tuple2);
                                            }
                                            {
                                                this.x2$5 = x2$5;
                                            }
                                        });
                                        break block3;
                                    }
                                    if (!(attributeExpression instanceof AttributeExpression.FunctionLiteral)) break block4;
                                    AttributeExpression.FunctionLiteral functionLiteral = (AttributeExpression.FunctionLiteral)attributeExpression;
                                    option = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractFunctionBounds(functionLiteral, true, this.binding$1);
                                }
                                return option;
                            }
                            throw new MatchError((Object)attributeExpression);
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Nothing$> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof Before) {
                    Before before = (Before)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(before.getExpression1(), before.getExpression2()).filter((Function1)new Serializable(attribute2){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$3;

                        public final boolean apply(AttributeExpression x$22) {
                            String string = x$22.name();
                            String string2 = this.attribute$3;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$3 = attribute$3;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(AttributeExpression x0$7) {
                            AttributeExpression attributeExpression;
                            block4: {
                                Option option;
                                block3: {
                                    block2: {
                                        attributeExpression = x0$7;
                                        if (!(attributeExpression instanceof AttributeExpression.PropertyLiteral)) break block2;
                                        AttributeExpression.PropertyLiteral propertyLiteral = (AttributeExpression.PropertyLiteral)attributeExpression;
                                        option = Option$.MODULE$.apply(propertyLiteral.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, propertyLiteral){
                                            public static final long serialVersionUID = 0L;
                                            private final AttributeExpression.PropertyLiteral x2$6;

                                            public final FilterValues<Bounds<T>> apply(T lit) {
                                                Tuple2 tuple2;
                                                Bounds.Bound<T> bound = new Bounds.Bound<T>(new Some(lit), false);
                                                Tuple2 tuple22 = tuple2 = this.x2$6.flipped() ? new Tuple2(bound, Bounds$Bound$.MODULE$.unbounded()) : new Tuple2(Bounds$Bound$.MODULE$.unbounded(), bound);
                                                if (tuple2 != null) {
                                                    Tuple2 tuple23;
                                                    Bounds.Bound lower = (Bounds.Bound)tuple2._1();
                                                    Bounds.Bound upper = (Bounds.Bound)tuple2._2();
                                                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                                    Bounds.Bound lower2 = (Bounds.Bound)tuple24._1();
                                                    Bounds.Bound upper2 = (Bounds.Bound)tuple24._2();
                                                    return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(lower2, upper2)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                                                }
                                                throw new MatchError((Object)tuple2);
                                            }
                                            {
                                                this.x2$6 = x2$6;
                                            }
                                        });
                                        break block3;
                                    }
                                    if (!(attributeExpression instanceof AttributeExpression.FunctionLiteral)) break block4;
                                    AttributeExpression.FunctionLiteral functionLiteral = (AttributeExpression.FunctionLiteral)attributeExpression;
                                    option = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractFunctionBounds(functionLiteral, false, this.binding$1);
                                }
                                return option;
                            }
                            throw new MatchError((Object)attributeExpression);
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Nothing$> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof After) {
                    After after = (After)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(after.getExpression1(), after.getExpression2()).filter((Function1)new Serializable(attribute2){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$3;

                        public final boolean apply(AttributeExpression x$24) {
                            String string = x$24.name();
                            String string2 = this.attribute$3;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$3 = attribute$3;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(AttributeExpression x0$8) {
                            AttributeExpression attributeExpression;
                            block4: {
                                Option option;
                                block3: {
                                    block2: {
                                        attributeExpression = x0$8;
                                        if (!(attributeExpression instanceof AttributeExpression.PropertyLiteral)) break block2;
                                        AttributeExpression.PropertyLiteral propertyLiteral = (AttributeExpression.PropertyLiteral)attributeExpression;
                                        option = Option$.MODULE$.apply(propertyLiteral.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, propertyLiteral){
                                            public static final long serialVersionUID = 0L;
                                            private final AttributeExpression.PropertyLiteral x2$7;

                                            public final FilterValues<Bounds<T>> apply(T lit) {
                                                Tuple2 tuple2;
                                                Bounds.Bound<T> bound = new Bounds.Bound<T>(new Some(lit), false);
                                                Tuple2 tuple22 = tuple2 = this.x2$7.flipped() ? new Tuple2(Bounds$Bound$.MODULE$.unbounded(), bound) : new Tuple2(bound, Bounds$Bound$.MODULE$.unbounded());
                                                if (tuple2 != null) {
                                                    Tuple2 tuple23;
                                                    Bounds.Bound lower = (Bounds.Bound)tuple2._1();
                                                    Bounds.Bound upper = (Bounds.Bound)tuple2._2();
                                                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                                    Bounds.Bound lower2 = (Bounds.Bound)tuple24._1();
                                                    Bounds.Bound upper2 = (Bounds.Bound)tuple24._2();
                                                    return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(lower2, upper2)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                                                }
                                                throw new MatchError((Object)tuple2);
                                            }
                                            {
                                                this.x2$7 = x2$7;
                                            }
                                        });
                                        break block3;
                                    }
                                    if (!(attributeExpression instanceof AttributeExpression.FunctionLiteral)) break block4;
                                    AttributeExpression.FunctionLiteral functionLiteral = (AttributeExpression.FunctionLiteral)attributeExpression;
                                    option = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractFunctionBounds(functionLiteral, false, this.binding$1);
                                }
                                return option;
                            }
                            throw new MatchError((Object)attributeExpression);
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Nothing$> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsLike) {
                    propertyIsLike = (PropertyIsLike)filter2;
                    Class<T> clazz = binding;
                    Class<String> clazz2 = String.class;
                    if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                        String prop3;
                        String string = prop3 = ((PropertyName)propertyIsLike.getExpression()).getPropertyName();
                        String string3 = attribute2;
                        if (!(string != null ? !string.equals(string3) : string3 != null)) {
                            String literal = propertyIsLike.getLiteral();
                            String lower = literal.endsWith(package$.MODULE$.MULTICHAR_WILDCARD()) ? literal.substring(0, literal.length() - package$.MODULE$.MULTICHAR_WILDCARD().length()) : literal;
                            Bounds.Bound upper = new Bounds.Bound(new Some((Object)new StringBuilder().append((Object)lower).append((Object)package$.MODULE$.WILDCARD_SUFFIX()).toString()), true);
                            filterValues2 = new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds(new Bounds.Bound(new Some((Object)lower), true), upper)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                            return filterValues2;
                        }
                        filterValues2 = FilterValues$.MODULE$.empty();
                        return filterValues2;
                    }
                }
                if (!(filter2 instanceof Not)) break block37;
                bl = true;
                not = (Not)filter2;
                if (!(not.getFilter() instanceof PropertyIsNull)) break block37;
                try {}
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().isWarnEnabled()) {
                        FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract bounds from filter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.filterToString((Filter)not)})), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    filterValues = FilterValues$.MODULE$.empty();
                    return filterValues;
                }
                break block38;
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().isWarnEnabled()) {
                        FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract bounds from filter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.filterToString((Filter)propertyIsLike)})), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    filterValues2 = FilterValues$.MODULE$.empty();
                }
                return filterValues2;
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().isWarnEnabled()) {
                        FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract bounds from filter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.filterToString((Filter)propertyIsBetween)})), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    filterValues3 = FilterValues$.MODULE$.empty();
                }
                return filterValues3;
            }
            PropertyIsNull isNull = (PropertyIsNull)not.getFilter();
            String string = prop = ((PropertyName)isNull.getExpression()).getPropertyName();
            String string4 = attribute2;
            filterValues = !(string != null ? !string.equals(string4) : string4 != null) ? new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{Bounds$.MODULE$.everything()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3()) : FilterValues$.MODULE$.empty();
            return filterValues;
        }
        if (bl) {
            FilterValues filterValues;
            FilterValues inverted = this.extractAttributeBounds(not.getFilter(), attribute2, binding);
            if (inverted.isEmpty()) {
                filterValues = inverted;
                return filterValues;
            } else if (inverted.disjoint()) {
                filterValues = new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{Bounds$.MODULE$.everything()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                return filterValues;
            } else if (inverted.precise()) {
                Seq uninverted = (Seq)inverted.values().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final FilterValues<Bounds<T>> apply(Bounds<T> bounds) {
                        Tuple2<Option<T>, Option<T>> tuple2;
                        block6: {
                            Seq seq;
                            block3: {
                                block5: {
                                    block4: {
                                        block2: {
                                            tuple2 = bounds.bounds();
                                            if (tuple2 == null) break block2;
                                            Option option = (Option)tuple2._1();
                                            Option option2 = (Option)tuple2._2();
                                            if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option2)) break block2;
                                            seq = (Seq)Seq$.MODULE$.empty();
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        Option option = (Option)tuple2._1();
                                        Option option3 = (Option)tuple2._2();
                                        if (!(option instanceof Some)) break block4;
                                        Some some = (Some)option;
                                        Object lo = some.x();
                                        if (!None$.MODULE$.equals(option3)) break block4;
                                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(Bounds$Bound$.MODULE$.unbounded(), new Bounds.Bound<T>(new Some(lo), !bounds.lower().inclusive()))}));
                                        break block3;
                                    }
                                    if (tuple2 == null) break block5;
                                    Option option = (Option)tuple2._1();
                                    Option option4 = (Option)tuple2._2();
                                    if (!None$.MODULE$.equals(option) || !(option4 instanceof Some)) break block5;
                                    Some some = (Some)option4;
                                    Object hi = some.x();
                                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(new Bounds.Bound<T>(new Some(hi), !bounds.upper().inclusive()), Bounds$Bound$.MODULE$.unbounded())}));
                                    break block3;
                                }
                                if (tuple2 == null) break block6;
                                Option option = (Option)tuple2._1();
                                Option option5 = (Option)tuple2._2();
                                if (!(option instanceof Some)) break block6;
                                Some some = (Some)option;
                                Object lo = some.x();
                                if (!(option5 instanceof Some)) break block6;
                                Some some2 = (Some)option5;
                                Object hi = some2.x();
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(Bounds$Bound$.MODULE$.unbounded(), new Bounds.Bound<T>(new Some(lo), !bounds.lower().inclusive())), new Bounds<T>(new Bounds.Bound<T>(new Some(hi), !bounds.upper().inclusive()), Bounds$Bound$.MODULE$.unbounded())}));
                            }
                            Seq not = seq;
                            return new FilterValues<Bounds<T>>(not, FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Serializable serializable = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<Bounds<T>> apply(Bounds<T> left, Bounds<T> right) {
                        return Bounds$.MODULE$.intersection(left, right);
                    }
                };
                Serializable intersect = new Serializable((Function2)serializable){
                    public static final long serialVersionUID = 0L;
                    private final Function2 eta$0$5$1;

                    public final FilterValues<Bounds<T>> apply(FilterValues<Bounds<T>> left, FilterValues<Bounds<T>> right) {
                        return FilterValues$.MODULE$.and(this.eta$0$5$1, left, right);
                    }
                    {
                        this.eta$0$5$1 = eta$0$5$1;
                    }
                };
                filterValues = (FilterValues)uninverted.reduceLeft((Function2)intersect);
                return filterValues;
            } else {
                BoxedUnit boxedUnit;
                if (FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().isWarnEnabled()) {
                    FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().warn("Falling back to full table scan for inverted query: '{}'", new Object[]{package$.MODULE$.filterToString((Filter)not)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                filterValues = new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{Bounds$.MODULE$.everything()})), false, FilterValues$.MODULE$.apply$default$3());
            }
            return filterValues;
        }
        if (!(filter2 instanceof TEquals)) return FilterValues$.MODULE$.empty();
        TEquals tEquals = (TEquals)filter2;
        return (FilterValues)package$.MODULE$.checkOrder(tEquals.getExpression1(), tEquals.getExpression2()).filter((Function1)new Serializable(attribute2){
            public static final long serialVersionUID = 0L;
            private final String attribute$3;

            public final boolean apply(AttributeExpression x$26) {
                String string = x$26.name();
                String string2 = this.attribute$3;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.attribute$3 = attribute$3;
            }
        }).flatMap((Function1)new Serializable(binding){
            public static final long serialVersionUID = 0L;
            private final Class binding$1;

            public final Option<FilterValues<Bounds<T>>> apply(AttributeExpression prop) {
                return Option$.MODULE$.apply(prop.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FilterValues<Bounds<T>> apply(T lit) {
                        Bounds.Bound<T> bound = new Bounds.Bound<T>(new Some(lit), true);
                        return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(bound, bound)})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
                    }
                });
            }
            {
                this.binding$1 = binding$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FilterValues<Nothing$> apply() {
                return FilterValues$.MODULE$.empty();
            }
        });
    }

    public <T> Option<FilterValues<Bounds<T>>> org$locationtech$geomesa$filter$FilterHelper$$extractFunctionBounds(AttributeExpression.FunctionLiteral function, boolean inclusive, Class<T> binding) {
        return new Some(new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{Bounds$.MODULE$.everything()})), false, FilterValues$.MODULE$.apply$default$3()));
    }

    public Seq<String> propertyNames(Filter filter, SimpleFeatureType sft) {
        return (Seq)((SeqLike)Predef$.MODULE$.refArrayOps((Object[])DataUtilities.attributeNames((Filter)filter, (SimpleFeatureType)sft)).toSeq().distinct()).sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Seq<String> propertyNames(Expression expression, SimpleFeatureType sft) {
        return (Seq)((SeqLike)Predef$.MODULE$.refArrayOps((Object[])DataUtilities.attributeNames((Expression)expression, (SimpleFeatureType)sft)).toSeq().distinct()).sorted((Ordering)Ordering.String$.MODULE$);
    }

    public boolean hasIdFilter(Filter filter) {
        return BoxesRunTime.unboxToBoolean((Object)filter.accept((FilterVisitor)new IdDetectingFilterVisitor(), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public Option<Filter> filterListAsAnd(Seq<Filter> filters) {
        return package$.MODULE$.andOption(filters, (FilterFactory)package$.MODULE$.ff());
    }

    public Filter simplify(Filter filter) {
        return this.flatten(this.org$locationtech$geomesa$filter$FilterHelper$$deduplicateOrs$1(this.flatten(filter)));
    }

    public Filter flatten(Filter filter) {
        Filter filter2;
        block5: {
            Filter filter3;
            block3: {
                Filter filter4;
                block4: {
                    block2: {
                        filter2 = filter;
                        if (!(filter2 instanceof And)) break block2;
                        And and = (And)filter2;
                        filter3 = package$.MODULE$.ff().and(JavaConversions$.MODULE$.bufferAsJavaList(this.flattenAnd((Seq<Filter>)JavaConversions$.MODULE$.asScalaBuffer(and.getChildren()))));
                        break block3;
                    }
                    if (!(filter2 instanceof Or)) break block4;
                    Or or2 = (Or)filter2;
                    filter3 = package$.MODULE$.ff().or(JavaConversions$.MODULE$.bufferAsJavaList(this.flattenOr((Seq<Filter>)JavaConversions$.MODULE$.asScalaBuffer(or2.getChildren()))));
                    break block3;
                }
                if (filter2 == null) break block5;
                filter3 = filter4 = filter2;
            }
            return filter3;
        }
        throw new MatchError((Object)filter2);
    }

    /*
     * WARNING - void declaration
     */
    public ListBuffer<Filter> flattenAnd(Seq<Filter> filters) {
        void var3_3;
        ListBuffer remaining = (ListBuffer)((BufferLike)ListBuffer$.MODULE$.empty()).$plus$plus(filters);
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        do {
            BoxedUnit boxedUnit;
            Filter filter;
            if ((filter = (Filter)remaining.remove(0)) instanceof And) {
                And and = (And)filter;
                remaining.appendAll((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(and.getChildren()));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{this.flatten(filter)}));
            boxedUnit = BoxedUnit.UNIT;
        } while (remaining.nonEmpty());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ListBuffer<Filter> flattenOr(Seq<Filter> filters) {
        void var3_3;
        ListBuffer remaining = (ListBuffer)((BufferLike)ListBuffer$.MODULE$.empty()).$plus$plus(filters);
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        do {
            BoxedUnit boxedUnit;
            Filter filter;
            if ((filter = (Filter)remaining.remove(0)) instanceof Or) {
                Or or2 = (Or)filter;
                remaining.appendAll((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(or2.getChildren()));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{this.flatten(filter)}));
            boxedUnit = BoxedUnit.UNIT;
        } while (remaining.nonEmpty());
        return var3_3;
    }

    public final Filter org$locationtech$geomesa$filter$FilterHelper$$deduplicateOrs$1(Filter f) {
        Filter filter;
        Filter filter2 = f;
        if (filter2 instanceof And) {
            And and = (And)filter2;
            filter = package$.MODULE$.ff().and(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(and.getChildren()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Filter apply(Filter f) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$deduplicateOrs$1(f);
                }
            }, Buffer$.MODULE$.canBuildFrom())));
        } else if (filter2 instanceof Or) {
            Or or2;
            Or or3 = (Or)filter2;
            Buffer decomposed = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(or3.getChildren()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Filter> apply(Filter f) {
                    return package$.MODULE$.decomposeAnd(f);
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Seq clauses = (Seq)decomposed.head();
            Seq duplicates = (Seq)clauses.filter((Function1)new Serializable(decomposed){
                public static final long serialVersionUID = 0L;
                private final Buffer decomposed$1;

                public final boolean apply(Filter c) {
                    return ((IterableLike)this.decomposed$1.tail()).forall((Function1)new Serializable(this, c){
                        public static final long serialVersionUID = 0L;
                        private final Filter c$1;

                        public final boolean apply(Seq<Filter> x$27) {
                            return x$27.contains((Object)this.c$1);
                        }
                        {
                            this.c$1 = c$1;
                        }
                    });
                }
                {
                    this.decomposed$1 = decomposed$1;
                }
            });
            if (duplicates.isEmpty()) {
                or2 = or3;
            } else {
                Option<Filter> deduplicated = package$.MODULE$.orOption((Seq<Filter>)((Seq)decomposed.flatMap((Function1)new Serializable(duplicates){
                    public static final long serialVersionUID = 0L;
                    public final Seq duplicates$1;

                    public final Iterable<Filter> apply(Seq<Filter> d) {
                        return Option$.MODULE$.option2Iterable(package$.MODULE$.andOption((Seq<Filter>)((Seq)d.filterNot((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.24 $outer;

                            public final boolean apply(Object elem) {
                                return this.$outer.duplicates$1.contains(elem);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })), (FilterFactory)package$.MODULE$.ff()));
                    }
                    {
                        this.duplicates$1 = duplicates$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())), (FilterFactory)package$.MODULE$.ff());
                or2 = package$.MODULE$.andFilters((Seq<Filter>)((Seq)Option$.MODULE$.option2Iterable(deduplicated).toSeq().$plus$plus((GenTraversableOnce)duplicates, Seq$.MODULE$.canBuildFrom())), (FilterFactory)package$.MODULE$.ff());
            }
            filter = or2;
        } else {
            filter = f;
        }
        return filter;
    }

    private FilterHelper$() {
        MODULE$ = this;
        this.org$locationtech$geomesa$filter$FilterHelper$$SafeGeomString = "gm-safe";
    }
}

