/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u001b\ta\u0011J\\4fgRl\u0015\r\u001d9fe*\u00111\u0001B\u0001\u0007S:<Wm\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b,!\u0019ya\u0003\u0007\u0010)=5\t\u0001C\u0003\u0002\u0012%\u0005IQ.\u00199sK\u0012,8-\u001a\u0006\u0003'Q\ta\u0001[1e_>\u0004(BA\u000b\u000b\u0003\u0019\t\u0007/Y2iK&\u0011q\u0003\u0005\u0002\u0007\u001b\u0006\u0004\b/\u001a:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m\u0011\u0012AA5p\u0013\ti\"D\u0001\u0007M_:<wK]5uC\ndW\r\u0005\u0002 M5\t\u0001E\u0003\u0002\"E\u000511/[7qY\u0016T!a\t\u0013\u0002\u000f\u0019,\u0017\r^;sK*\u0011QEC\u0001\b_B,gnZ5t\u0013\t9\u0003EA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\t\u00033%J!A\u000b\u000e\u0003\tQ+\u0007\u0010\u001e\t\u0003YMj\u0011!\f\u0006\u0003]=\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001M\u0019\u0002\u0011QL\b/Z:bM\u0016T\u0011AM\u0001\u0004G>l\u0017B\u0001\u001b.\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000bY\u0002A\u0011A\u001c\u0002\rqJg.\u001b;?)\u0005A\u0004CA\u001d\u0001\u001b\u0005\u0011Q\u0001B\u001e\u0001\u0001q\u0012qaQ8oi\u0016DH\u000f\u0005\u0002\u000f{%\u00111H\u0006\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0003\u0011!X\r\u001f;\u0016\u0003!BaA\u0011\u0001!\u0002\u0013A\u0013!\u0002;fqR\u0004\u0003\"\u0002#\u0001\t\u0003*\u0015aA7baR!a\t\u0014(Q!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u0011)f.\u001b;\t\u000b5\u001b\u0005\u0019\u0001\r\u0002\u0007-,\u0017\u0010C\u0003P\u0007\u0002\u0007a$\u0001\u0002tM\")\u0011k\u0011a\u0001%\u000691m\u001c8uKb$\bCA*;\u001b\u0005\u0001\u0001")
public class IngestMapper
extends Mapper<LongWritable, SimpleFeature, Text, SimpleFeature>
implements LazyLogging {
    private final Text text;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        IngestMapper ingestMapper = this;
        synchronized (ingestMapper) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Text text() {
        return this.text;
    }

    public void map(LongWritable key, SimpleFeature sf, Mapper.Context context) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("map key {}, map value {}", (Object[])new String[]{key.toString(), DataUtilities.encodeFeature((SimpleFeature)sf)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        sf.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
        context.write((Object)this.text(), (Object)sf);
    }

    public IngestMapper() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.text = new Text();
    }
}

