/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.stats;

import org.geotools.data.DataStore;
import org.geotools.util.Converters;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.GeoMesaStats$;
import org.locationtech.geomesa.index.stats.HasGeoMesaStats;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.stats.StatsCommand$;
import org.locationtech.geomesa.tools.stats.StatsHistogramCommand;
import org.locationtech.geomesa.tools.stats.StatsHistogramCommand$;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.stats.Histogram;
import org.locationtech.geomesa.utils.stats.Histogram$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.Try$;

public abstract class StatsHistogramCommand$class {
    public static void execute(StatsHistogramCommand $this) {
        $this.withDataStore(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsHistogramCommand $outer;

            public final void apply(DS ds) {
                this.$outer.histogram(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void histogram(StatsHistogramCommand $this, DataStore ds) {
        Seq seq;
        SimpleFeatureType sft = ds.getSchema($this.params().featureName());
        Seq<String> attributes = StatsCommand$.MODULE$.getAttributesFromParams(sft, $this.params());
        Filter filter = (Filter)Option$.MODULE$.apply((Object)$this.params().cqlFilter()).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IncludeFilter apply() {
                return Filter.INCLUDE;
            }
        });
        Option bins = Option$.MODULE$.apply((Object)$this.params().bins()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        });
        if ($this.params().exact()) {
            Map bounds = Map$.MODULE$.empty();
            attributes.foreach((Function1)new Serializable($this, sft, bounds, ds){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;
                public final Map bounds$1;
                private final DataStore ds$1;

                public final void apply(String attribute) {
                    GeoMesaStats qual$1 = ((HasGeoMesaStats)this.ds$1).stats();
                    SimpleFeatureType x$11 = this.sft$1;
                    Seq x$12 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{attribute}));
                    Seq x$13 = qual$1.getStats$default$3();
                    qual$1.getStats(x$11, x$12, x$13, ClassTag$.MODULE$.apply(MinMax.class)).headOption().foreach((Function1)new Serializable(this, attribute){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ StatsHistogramCommand$.anonfun.4 $outer;
                        private final String attribute$1;

                        public final Option<Tuple2<Object, Object>> apply(MinMax<Object> b) {
                            return this.$outer.bounds$1.put((Object)this.attribute$1, (Object)(BoxesRunTime.equals((Object)b.min(), (Object)b.max()) ? Histogram$.MODULE$.buffer(b.min()) : b.bounds()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.attribute$1 = attribute$1;
                        }
                    });
                }
                {
                    void var4_4;
                    void var3_3;
                    this.sft$1 = sft$1;
                    this.bounds$1 = var3_3;
                    this.ds$1 = var4_4;
                }
            });
            if (bounds.size() != attributes.size()) {
                Seq noBounds = (Seq)attributes.filterNot((Function1)new Serializable($this, bounds){
                    public static final long serialVersionUID = 0L;
                    private final Map bounds$1;

                    public final boolean apply(String key) {
                        return this.bounds$1.contains((Object)key);
                    }
                    {
                        this.bounds$1 = bounds$1;
                    }
                });
                Command$.MODULE$.user().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial bounds are not available for attributes ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{noBounds.mkString(", ")})));
                Integer response = null;
                Command$.MODULE$.user().info("Would you like to:\n  1. Calculate bounds (may be slow)\n  2. Use default bounds (may be less accurate)\n  3. Manually enter bounds\n  4. Cancel operation\n");
                while (response == null) {
                    String x$14 = "Please enter the number of your choice: ";
                    Object x$15 = Prompt$.MODULE$.read$default$2(x$14);
                    String in = Prompt$.MODULE$.read(x$14, x$15);
                    response = (Integer)Try$.MODULE$.apply((Function0)new Serializable($this, in){
                        public static final long serialVersionUID = 0L;
                        private final String in$1;

                        public final Integer apply() {
                            return BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(this.in$1)).toInt());
                        }
                        {
                            this.in$1 = in$1;
                        }
                    }).filter((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Integer r) {
                            return Predef$.MODULE$.Integer2int(r) > 0 && Predef$.MODULE$.Integer2int(r) < 5;
                        }
                    }).getOrElse((Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    });
                    if (response != null) continue;
                    Command$.MODULE$.user().error("Invalid input. Please enter 1-4.");
                }
                if (BoxesRunTime.equalsNumObject(response, (Object)BoxesRunTime.boxToInteger((int)1))) {
                    Command$.MODULE$.user().info("Running bounds query...");
                    ((HasGeoMesaStats)ds).stats().runStats(sft, Stat$.MODULE$.SeqStat((Seq)noBounds.map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String attribute) {
                            return Stat$.MODULE$.MinMax(attribute);
                        }
                    }, Seq$.MODULE$.canBuildFrom())), filter).foreach((Function1)new Serializable($this, bounds){
                        public static final long serialVersionUID = 0L;
                        private final Map bounds$1;

                        public final Option<Tuple2<Object, Object>> apply(MinMax<Object> mm) {
                            return this.bounds$1.put((Object)mm.property(), (Object)mm.bounds());
                        }
                        {
                            this.bounds$1 = bounds$1;
                        }
                    });
                } else if (BoxesRunTime.equalsNumObject(response, (Object)BoxesRunTime.boxToInteger((int)2))) {
                    noBounds.foreach((Function1)new Serializable($this, sft, bounds){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;
                        private final Map bounds$1;

                        public final Option<Tuple2<Object, Object>> apply(String attribute) {
                            ClassTag ct = ClassTag$.MODULE$.apply(this.sft$1.getDescriptor(attribute).getType().getBinding());
                            return this.bounds$1.put((Object)attribute, (Object)GeoMesaStats$.MODULE$.defaultBounds(ct.runtimeClass()));
                        }
                        {
                            void var3_3;
                            this.sft$1 = sft$1;
                            this.bounds$1 = var3_3;
                        }
                    });
                } else if (BoxesRunTime.equalsNumObject(response, (Object)BoxesRunTime.boxToInteger((int)3))) {
                    noBounds.foreach((Function1)new Serializable($this, sft, bounds){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;
                        private final Map bounds$1;

                        public final Option<Tuple2<Object, Object>> apply(String attribute) {
                            Class ct = this.sft$1.getDescriptor(attribute).getType().getBinding();
                            Object lower = null;
                            Object upper = null;
                            while (lower == null) {
                                Object x$17;
                                String x$16 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Enter initial lower bound for '", "': "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute}));
                                lower = Converters.convert((Object)Prompt$.MODULE$.read(x$16, x$17 = Prompt$.MODULE$.read$default$2(x$16)), (Class)ct);
                                if (lower != null) continue;
                                Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't convert input to appropriate type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ct.getSimpleName()})));
                            }
                            while (upper == null) {
                                Object x$19;
                                String x$18 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Enter initial upper bound for '", "': "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute}));
                                upper = Converters.convert((Object)Prompt$.MODULE$.read(x$18, x$19 = Prompt$.MODULE$.read$default$2(x$18)), (Class)ct);
                                if (upper != null) continue;
                                Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't convert input to appropriate type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ct.getSimpleName()})));
                            }
                            return BoxesRunTime.equals(lower, upper) ? this.bounds$1.put((Object)attribute, (Object)Histogram$.MODULE$.buffer(lower)) : this.bounds$1.put((Object)attribute, (Object)new Tuple2(lower, upper));
                        }
                        {
                            void var3_3;
                            this.sft$1 = sft$1;
                            this.bounds$1 = var3_3;
                        }
                    });
                } else {
                    Command$.MODULE$.user().info("Operation cancelled.");
                    return;
                }
            }
            Command$.MODULE$.user().info("Running stat query...");
            int length = BoxesRunTime.unboxToInt((Object)bins.getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return GeoMesaStats$.MODULE$.DefaultHistogramSize();
                }
            }));
            Seq queries = (Seq)attributes.map((Function1)new Serializable($this, sft, bounds, length){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;
                private final Map bounds$1;
                private final int length$1;

                public final String apply(String attribute) {
                    ClassTag ct = ClassTag$.MODULE$.apply(this.sft$1.getDescriptor(attribute).getType().getBinding());
                    Tuple2 tuple2 = (Tuple2)this.bounds$1.apply((Object)attribute);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Object lower = tuple2._1();
                        Object upper = tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2(lower, upper);
                        Object lower2 = tuple23._1();
                        Object upper2 = tuple23._2();
                        return Stat$.MODULE$.Histogram(attribute, this.length$1, lower2, upper2, ct);
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    void var3_3;
                    this.sft$1 = sft$1;
                    this.bounds$1 = var3_3;
                    this.length$1 = length$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            seq = ((HasGeoMesaStats)ds).stats().runStats(sft, Stat$.MODULE$.SeqStat(queries), filter);
        } else {
            Filter filter2 = filter;
            IncludeFilter includeFilter = Filter.INCLUDE;
            if (filter2 == null ? includeFilter != null : !filter2.equals(includeFilter)) {
                Command$.MODULE$.user().warn("Ignoring CQL filter for non-exact stat query");
            }
            GeoMesaStats qual$2 = ((HasGeoMesaStats)ds).stats();
            SimpleFeatureType x$20 = sft;
            Seq<String> x$21 = attributes;
            Seq x$22 = qual$2.getStats$default$3();
            seq = (Seq)qual$2.getStats(x$20, x$21, x$22, ClassTag$.MODULE$.apply(Histogram.class)).map((Function1)new Serializable($this, sft, bins){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;
                private final Option bins$1;

                public final Histogram<Object> apply(Histogram<Object> x0$1) {
                    Histogram histogram2;
                    block4: {
                        Histogram histogram3;
                        block3: {
                            block2: {
                                Histogram histogram4;
                                histogram2 = x0$1;
                                if (histogram2 == null || !this.bins$1.forall((Function1)new Serializable(this, histogram4 = histogram2){
                                    public static final long serialVersionUID = 0L;
                                    private final Histogram x2$1;

                                    public final boolean apply(int x$3) {
                                        return this.apply$mcZI$sp(x$3);
                                    }

                                    public boolean apply$mcZI$sp(int x$3) {
                                        return x$3 == this.x2$1.length();
                                    }
                                    {
                                        this.x2$1 = x2$1;
                                    }
                                })) break block2;
                                histogram3 = histogram4;
                                break block3;
                            }
                            if (histogram2 == null) break block4;
                            Histogram histogram5 = histogram2;
                            AttributeDescriptor descriptor = this.sft$1.getDescriptor(histogram5.property());
                            ClassTag ct = ClassTag$.MODULE$.apply(descriptor.getType().getBinding());
                            String statString = Stat$.MODULE$.Histogram(histogram5.property(), BoxesRunTime.unboxToInt((Object)this.bins$1.get()), histogram5.min(), histogram5.max(), ct);
                            Histogram binned = (Histogram)Stat$.MODULE$.apply(this.sft$1, statString);
                            binned.addCountsFrom(histogram5);
                            histogram3 = binned;
                        }
                        return histogram3;
                    }
                    throw new MatchError(histogram2);
                }
                {
                    void var3_3;
                    this.sft$1 = sft$1;
                    this.bins$1 = var3_3;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        Seq histograms = seq;
        attributes.foreach((Function1)new Serializable($this, sft, histograms){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final Seq histograms$1;

            public final void apply(String attribute) {
                Option option;
                block7: {
                    block6: {
                        BoxedUnit boxedUnit;
                        block5: {
                            option = this.histograms$1.find((Function1)new Serializable(this, attribute){
                                public static final long serialVersionUID = 0L;
                                private final String attribute$2;

                                public final boolean apply(Histogram<Object> x$4) {
                                    String string = x$4.property();
                                    String string2 = this.attribute$2;
                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                }
                                {
                                    this.attribute$2 = attribute$2;
                                }
                            });
                            if (!None$.MODULE$.equals(option)) break block5;
                            Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No histogram available for attribute '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute})));
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            break block6;
                        }
                        if (!(option instanceof Some)) break block7;
                        Some some = (Some)option;
                        Histogram hist = (Histogram)some.x();
                        if (Geometry.class.isAssignableFrom(this.sft$1.getDescriptor(attribute).getType().getBinding())) {
                            Command$.MODULE$.output().info(StatsHistogramCommand$.MODULE$.geomHistToString(attribute, (Histogram<Geometry>)hist));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            StatsHistogramCommand$.MODULE$.printHist((Histogram<Object>)hist, this.sft$1, attribute);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                void var3_3;
                this.sft$1 = sft$1;
                this.histograms$1 = var3_3;
            }
        });
        ds.dispose();
    }

    public static void $init$(StatsHistogramCommand $this) {
        $this.org$locationtech$geomesa$tools$stats$StatsHistogramCommand$_setter_$name_$eq("stats-histogram");
    }
}

