/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.avro;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.geotools.util.Converters;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils$;
import org.locationtech.geomesa.features.avro.FieldNameEncoder;
import org.locationtech.geomesa.features.avro.FieldNameEncoder$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class AvroSimpleFeatureUtils$ {
    public static final AvroSimpleFeatureUtils$ MODULE$;
    private final String FEATURE_ID_AVRO_FIELD_NAME;
    private final String AVRO_SIMPLE_FEATURE_VERSION;
    private final String AVRO_SIMPLE_FEATURE_USERDATA;
    private final int VERSION;
    private final String AVRO_NAMESPACE;
    private final List<Class<? super Object>> primitiveTypes;

    static {
        new AvroSimpleFeatureUtils$();
    }

    public String FEATURE_ID_AVRO_FIELD_NAME() {
        return this.FEATURE_ID_AVRO_FIELD_NAME;
    }

    public String AVRO_SIMPLE_FEATURE_VERSION() {
        return this.AVRO_SIMPLE_FEATURE_VERSION;
    }

    public String AVRO_SIMPLE_FEATURE_USERDATA() {
        return this.AVRO_SIMPLE_FEATURE_USERDATA;
    }

    public int VERSION() {
        return this.VERSION;
    }

    public String AVRO_NAMESPACE() {
        return this.AVRO_NAMESPACE;
    }

    public Schema generateSchema(SimpleFeatureType sft, boolean withUserData, boolean withFeatureId, String namespace) {
        FieldNameEncoder nameEncoder = new FieldNameEncoder(this.VERSION(), FieldNameEncoder$.MODULE$.$lessinit$greater$default$2());
        SchemaBuilder.FieldAssembler initialAssembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)nameEncoder.encode(sft.getTypeName())).namespace(namespace)).fields().name(this.AVRO_SIMPLE_FEATURE_VERSION()).type().intType().noDefault();
        SchemaBuilder.FieldAssembler withFid = withFeatureId ? initialAssembler.name(this.FEATURE_ID_AVRO_FIELD_NAME()).type().stringType().noDefault() : initialAssembler;
        SchemaBuilder.FieldAssembler withFields = (SchemaBuilder.FieldAssembler)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).foldLeft((Object)withFid, (Function2)new Serializable(nameEncoder){
            public static final long serialVersionUID = 0L;
            private final FieldNameEncoder nameEncoder$1;

            public final SchemaBuilder.FieldAssembler<Schema> apply(SchemaBuilder.FieldAssembler<Schema> x0$1, AttributeDescriptor x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    SchemaBuilder.FieldAssembler assembler = (SchemaBuilder.FieldAssembler)tuple2._1();
                    AttributeDescriptor ad = (AttributeDescriptor)tuple2._2();
                    SchemaBuilder.FieldAssembler<Schema> fieldAssembler = AvroSimpleFeatureUtils$.MODULE$.addField((SchemaBuilder.FieldAssembler<Schema>)assembler, this.nameEncoder$1.encode(ad.getLocalName()), ad.getType().getBinding(), ad.isNillable());
                    return fieldAssembler;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.nameEncoder$1 = nameEncoder$1;
            }
        });
        SchemaBuilder.FieldAssembler fullSchema = withUserData ? ((SchemaBuilder.ArrayDefault)withFields.name(this.AVRO_SIMPLE_FEATURE_USERDATA()).type().array().items().record("userDataItem").fields().name("keyClass").type().stringType().noDefault().name("key").type().stringType().noDefault().name("valueClass").type().stringType().noDefault().name("value").type().stringType().noDefault().endRecord()).noDefault() : withFields;
        return (Schema)fullSchema.endRecord();
    }

    public String generateSchema$default$4() {
        return this.AVRO_NAMESPACE();
    }

    public SchemaBuilder.FieldAssembler<Schema> addField(SchemaBuilder.FieldAssembler<Schema> assembler, String name, Class<?> ct, boolean nillable) {
        Class<?> clazz;
        block14: {
            SchemaBuilder.FieldAssembler fieldAssembler;
            block3: {
                SchemaBuilder.FieldTypeBuilder baseType;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            baseType = nillable ? assembler.name(name).type().nullable() : assembler.name(name).type();
                                                            clazz = ct;
                                                            if (!String.class.isAssignableFrom(clazz)) break block2;
                                                            fieldAssembler = baseType.stringType().noDefault();
                                                            break block3;
                                                        }
                                                        if (!Integer.class.isAssignableFrom(clazz)) break block4;
                                                        fieldAssembler = baseType.intType().noDefault();
                                                        break block3;
                                                    }
                                                    if (!Long.class.isAssignableFrom(clazz)) break block5;
                                                    fieldAssembler = baseType.longType().noDefault();
                                                    break block3;
                                                }
                                                if (!Double.class.isAssignableFrom(clazz)) break block6;
                                                fieldAssembler = baseType.doubleType().noDefault();
                                                break block3;
                                            }
                                            if (!Float.class.isAssignableFrom(clazz)) break block7;
                                            fieldAssembler = baseType.floatType().noDefault();
                                            break block3;
                                        }
                                        if (!Boolean.class.isAssignableFrom(clazz)) break block8;
                                        fieldAssembler = baseType.booleanType().noDefault();
                                        break block3;
                                    }
                                    if (!UUID.class.isAssignableFrom(clazz)) break block9;
                                    fieldAssembler = baseType.bytesType().noDefault();
                                    break block3;
                                }
                                if (!Date.class.isAssignableFrom(clazz)) break block10;
                                fieldAssembler = baseType.longType().noDefault();
                                break block3;
                            }
                            if (!Geometry.class.isAssignableFrom(clazz)) break block11;
                            fieldAssembler = baseType.bytesType().noDefault();
                            break block3;
                        }
                        if (!java.util.List.class.isAssignableFrom(clazz)) break block12;
                        fieldAssembler = baseType.bytesType().noDefault();
                        break block3;
                    }
                    if (!Map.class.isAssignableFrom(clazz)) break block13;
                    fieldAssembler = baseType.bytesType().noDefault();
                    break block3;
                }
                if (!byte[].class.isAssignableFrom(clazz)) break block14;
                fieldAssembler = baseType.bytesType().noDefault();
            }
            return fieldAssembler;
        }
        throw new MatchError(clazz);
    }

    public List<Class<? super Object>> primitiveTypes() {
        return this.primitiveTypes;
    }

    public scala.collection.immutable.Map<String, AvroSimpleFeatureUtils.Binding> createTypeMap(SimpleFeatureType sft, WKBWriter wkbWriter, FieldNameEncoder nameEncoder) {
        return ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new Serializable(wkbWriter, nameEncoder){
            public static final long serialVersionUID = 0L;
            public final WKBWriter wkbWriter$1;
            private final FieldNameEncoder nameEncoder$2;

            public final Tuple2<String, AvroSimpleFeatureUtils.Binding> apply(AttributeDescriptor ad) {
                Class binding = ad.getType().getBinding();
                Serializable converter = AvroSimpleFeatureUtils$.MODULE$.primitiveTypes().contains((Object)binding) ? new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Object value) {
                        return value;
                    }
                } : (UUID.class.isAssignableFrom(binding) ? new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ByteBuffer apply(Object value) {
                        return AvroSimpleFeatureUtils$.MODULE$.encodeUUID((UUID)value);
                    }
                } : (Date.class.isAssignableFrom(binding) ? new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Object value) {
                        return ((Date)value).getTime();
                    }
                } : (Geometry.class.isAssignableFrom(binding) ? new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createTypeMap.1 $outer;

                    public final ByteBuffer apply(Object value) {
                        return ByteBuffer.wrap(this.$outer.wkbWriter$1.write((Geometry)value));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                } : (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad)) ? new Serializable(this, ad){
                    public static final long serialVersionUID = 0L;
                    private final AttributeDescriptor ad$1;

                    public final ByteBuffer apply(Object value) {
                        return AvroSimpleFeatureUtils$.MODULE$.encodeList((java.util.List)value, RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(this.ad$1)));
                    }
                    {
                        this.ad$1 = ad$1;
                    }
                } : (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad)) ? new Serializable(this, ad){
                    public static final long serialVersionUID = 0L;
                    private final AttributeDescriptor ad$1;

                    public final ByteBuffer apply(Object value) {
                        Tuple2 tuple2 = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(this.ad$1));
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            Class keyclass = (Class)tuple2._1();
                            Class valueclass = (Class)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)keyclass, (Object)valueclass);
                            Class keyclass2 = (Class)tuple23._1();
                            Class valueclass2 = (Class)tuple23._2();
                            return AvroSimpleFeatureUtils$.MODULE$.encodeMap((Map)value, keyclass2, valueclass2);
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.ad$1 = ad$1;
                    }
                } : (byte[].class.isAssignableFrom(binding) ? new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ByteBuffer apply(Object value) {
                        return ByteBuffer.wrap((byte[])value);
                    }
                } : new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object value) {
                        return (String)Option$.MODULE$.apply(Converters.convert((Object)value, String.class)).getOrElse((Function0)new Serializable(this, value){
                            public static final long serialVersionUID = 0L;
                            private final Object value$1;

                            public final String apply() {
                                return this.value$1.toString();
                            }
                            {
                                this.value$1 = value$1;
                            }
                        });
                    }
                }))))));
                return new Tuple2((Object)this.nameEncoder$2.encode(ad.getLocalName()), (Object)new AvroSimpleFeatureUtils.Binding(ad.getType().getBinding(), (Function1<Object, Object>)converter));
            }
            {
                this.wkbWriter$1 = wkbWriter$1;
                this.nameEncoder$2 = nameEncoder$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public ByteBuffer encodeUUID(UUID uuid) {
        return (ByteBuffer)ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).flip();
    }

    public UUID decodeUUID(ByteBuffer bb) {
        return new UUID(bb.getLong(), bb.getLong());
    }

    public ByteBuffer encodeList(java.util.List<?> list, Class<?> binding) {
        Option option;
        block5: {
            ByteBuffer byteBuffer;
            block3: {
                block4: {
                    Some some;
                    boolean bl;
                    block2: {
                        Option size = Option$.MODULE$.apply(list).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply(java.util.List<Object> x$2) {
                                return x$2.size();
                            }
                        });
                        bl = false;
                        some = null;
                        option = size;
                        if (!(option instanceof Some)) break block2;
                        bl = true;
                        some = (Some)option;
                        int s = BoxesRunTime.unboxToInt((Object)some.x());
                        if (s != 0) break block2;
                        byteBuffer = this.encodeEmptyCollection();
                        break block3;
                    }
                    if (!bl) break block4;
                    int s = BoxesRunTime.unboxToInt((Object)some.x());
                    byteBuffer = this.encodeNonEmptyList(list, s, binding);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block5;
                byteBuffer = this.encodeNullCollection();
            }
            return byteBuffer;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    public java.util.List<?> decodeList(ByteBuffer bb) {
        java.util.List list;
        int size = bb.getInt();
        if (size < 0) {
            list = null;
        } else if (size == 0) {
            list = Collections.emptyList();
        } else {
            void var3_3;
            ArrayList list2 = new ArrayList(size);
            String label = this.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$getString(bb);
            Function0<Object> readMethod = this.getReadMethod(label, bb);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), size - 1).foreach((Function1)new Serializable(list2, readMethod){
                public static final long serialVersionUID = 0L;
                private final ArrayList list$1;
                private final Function0 readMethod$1;

                public final boolean apply(int x$3) {
                    return this.apply$mcZI$sp(x$3);
                }

                public boolean apply$mcZI$sp(int x$3) {
                    return this.list$1.add(this.readMethod$1.apply());
                }
                {
                    this.list$1 = list$1;
                    this.readMethod$1 = readMethod$1;
                }
            });
            list = var3_3;
        }
        return list;
    }

    public ByteBuffer encodeMap(Map<?, ?> map, Class<?> keyBinding, Class<?> valueBinding) {
        Option option;
        block5: {
            ByteBuffer byteBuffer;
            block3: {
                block4: {
                    Some some;
                    boolean bl;
                    block2: {
                        Option size = Option$.MODULE$.apply(map).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Map<Object, Object> x$4) {
                                return x$4.size();
                            }
                        });
                        bl = false;
                        some = null;
                        option = size;
                        if (!(option instanceof Some)) break block2;
                        bl = true;
                        some = (Some)option;
                        int s = BoxesRunTime.unboxToInt((Object)some.x());
                        if (s != 0) break block2;
                        byteBuffer = this.encodeEmptyCollection();
                        break block3;
                    }
                    if (!bl) break block4;
                    int s = BoxesRunTime.unboxToInt((Object)some.x());
                    byteBuffer = this.encodeNonEmptyMap(map, s, keyBinding, valueBinding);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block5;
                byteBuffer = this.encodeNullCollection();
            }
            return byteBuffer;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    public Map<?, ?> decodeMap(ByteBuffer bb) {
        Map map;
        int size = bb.getInt();
        if (size < 0) {
            map = null;
        } else if (size == 0) {
            map = Collections.emptyMap();
        } else {
            void var3_3;
            HashMap map2 = new HashMap(size);
            String keyType = this.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$getString(bb);
            String valueType = this.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$getString(bb);
            Function0<Object> keyReadMethod = this.getReadMethod(keyType, bb);
            Function0<Object> valueReadMethod = this.getReadMethod(valueType, bb);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), size - 1).foreach((Function1)new Serializable(map2, keyReadMethod, valueReadMethod){
                public static final long serialVersionUID = 0L;
                private final HashMap map$1;
                private final Function0 keyReadMethod$1;
                private final Function0 valueReadMethod$1;

                public final Object apply(int x$5) {
                    Object key = this.keyReadMethod$1.apply();
                    Object value = this.valueReadMethod$1.apply();
                    return this.map$1.put(key, value);
                }
                {
                    this.map$1 = map$1;
                    this.keyReadMethod$1 = keyReadMethod$1;
                    this.valueReadMethod$1 = valueReadMethod$1;
                }
            });
            map = var3_3;
        }
        return map;
    }

    private ByteBuffer encodeNullCollection() {
        return (ByteBuffer)ByteBuffer.allocate(4).putInt(-1).flip();
    }

    private ByteBuffer encodeEmptyCollection() {
        return (ByteBuffer)ByteBuffer.allocate(4).putInt(0).flip();
    }

    private ByteBuffer encodeNonEmptyList(java.util.List<?> list, int size, Class<?> binding) {
        String label = binding.getSimpleName();
        Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> tuple2 = this.getWriteMethod(label);
        if (tuple2 != null) {
            Tuple2 tuple22;
            int bytesPerItem = tuple2._1$mcI$sp();
            Function2 putMethod = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesPerItem), (Object)putMethod);
            int bytesPerItem2 = tuple23._1$mcI$sp();
            Function2 putMethod2 = (Function2)tuple23._2();
            int totalBytes = this.getTotalBytes(bytesPerItem2, size, JavaConversions$.MODULE$.asScalaIterator(list.iterator()), binding.getSimpleName());
            byte[] labelBytes = label.getBytes(StandardCharsets.UTF_8);
            ByteBuffer bb = ByteBuffer.allocate(8 + Predef$.MODULE$.byteArrayOps(labelBytes).size() + totalBytes);
            bb.putInt(size);
            this.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putString(bb, label);
            JavaConversions$.MODULE$.asScalaBuffer(list).foreach((Function1)new Serializable(putMethod2, bb){
                public static final long serialVersionUID = 0L;
                private final Function2 putMethod$1;
                private final ByteBuffer bb$2;

                public final void apply(Object v) {
                    this.putMethod$1.apply((Object)this.bb$2, v);
                }
                {
                    this.putMethod$1 = putMethod$1;
                    this.bb$2 = bb$2;
                }
            });
            bb.flip();
            return bb;
        }
        throw new MatchError(tuple2);
    }

    private ByteBuffer encodeNonEmptyMap(Map<?, ?> map, int size, Class<?> keyBinding, Class<?> valueBinding) {
        String keyLabel = keyBinding.getSimpleName();
        String valueLabel = valueBinding.getSimpleName();
        Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> tuple2 = this.getWriteMethod(keyLabel);
        if (tuple2 != null) {
            Tuple2 tuple22;
            int bytesPerKeyItem = tuple2._1$mcI$sp();
            Function2 keyPutMethod = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesPerKeyItem), (Object)keyPutMethod);
            int bytesPerKeyItem2 = tuple23._1$mcI$sp();
            Function2 keyPutMethod2 = (Function2)tuple23._2();
            Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> tuple24 = this.getWriteMethod(valueLabel);
            if (tuple24 != null) {
                Tuple2 tuple25;
                int bytesPerValueItem = tuple24._1$mcI$sp();
                Function2 valuePutMethod = (Function2)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesPerValueItem), (Object)valuePutMethod);
                int bytesPerValueItem2 = tuple26._1$mcI$sp();
                Function2 valuePutMethod2 = (Function2)tuple26._2();
                int totalKeyBytes = this.getTotalBytes(bytesPerKeyItem2, size, JavaConversions$.MODULE$.mapAsScalaMap(map).keysIterator(), keyLabel);
                int totalValueBytes = this.getTotalBytes(bytesPerValueItem2, size, JavaConversions$.MODULE$.mapAsScalaMap(map).valuesIterator(), valueLabel);
                byte[] keyLabelBytes = keyLabel.getBytes(StandardCharsets.UTF_8);
                byte[] valueLabelBytes = valueLabel.getBytes(StandardCharsets.UTF_8);
                int totalBytes = 12 + Predef$.MODULE$.byteArrayOps(keyLabelBytes).size() + Predef$.MODULE$.byteArrayOps(valueLabelBytes).size() + totalKeyBytes + totalValueBytes;
                ByteBuffer bb = ByteBuffer.allocate(totalBytes);
                bb.putInt(size);
                this.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putString(bb, keyLabel);
                this.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putString(bb, valueLabel);
                JavaConversions$.MODULE$.mapAsScalaMap(map).foreach((Function1)new Serializable(keyPutMethod2, valuePutMethod2, bb){
                    public static final long serialVersionUID = 0L;
                    private final Function2 keyPutMethod$1;
                    private final Function2 valuePutMethod$1;
                    private final ByteBuffer bb$3;

                    public final void apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            this.keyPutMethod$1.apply((Object)this.bb$3, k);
                            BoxedUnit boxedUnit = (BoxedUnit)this.valuePutMethod$1.apply((Object)this.bb$3, v);
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.keyPutMethod$1 = keyPutMethod$1;
                        this.valuePutMethod$1 = valuePutMethod$1;
                        this.bb$3 = bb$3;
                    }
                });
                bb.flip();
                return bb;
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> getWriteMethod(String label) {
        block11: {
            Tuple2 tuple2;
            block3: {
                String string;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                string = label.toLowerCase(Locale.US);
                                                if (!"string".equals(string)) break block2;
                                                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final void apply(ByteBuffer bb, Object v) {
                                                        AvroSimpleFeatureUtils$.MODULE$.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putString(bb, (String)v);
                                                    }
                                                });
                                                break block3;
                                            }
                                            boolean bl = "int".equals(string) ? true : "integer".equals(string);
                                            if (!bl) break block4;
                                            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(ByteBuffer bb, Object v) {
                                                    bb.putInt(BoxesRunTime.unboxToInt((Object)v));
                                                }
                                            });
                                            break block3;
                                        }
                                        if (!"double".equals(string)) break block5;
                                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Object)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final void apply(ByteBuffer bb, Object v) {
                                                bb.putDouble(BoxesRunTime.unboxToDouble((Object)v));
                                            }
                                        });
                                        break block3;
                                    }
                                    if (!"long".equals(string)) break block6;
                                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Object)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(ByteBuffer bb, Object v) {
                                            bb.putLong(BoxesRunTime.unboxToLong((Object)v));
                                        }
                                    });
                                    break block3;
                                }
                                if (!"float".equals(string)) break block7;
                                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(ByteBuffer bb, Object v) {
                                        bb.putFloat(BoxesRunTime.unboxToFloat((Object)v));
                                    }
                                });
                                break block3;
                            }
                            if (!"date".equals(string)) break block8;
                            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Object)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply(ByteBuffer bb, Object v) {
                                    bb.putLong(((Date)v).getTime());
                                }
                            });
                            break block3;
                        }
                        if (!"boolean".equals(string)) break block9;
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply(ByteBuffer bb, Object v) {
                                if (BoxesRunTime.unboxToBoolean((Object)v)) {
                                    bb.put((byte)1);
                                } else {
                                    bb.put((byte)0);
                                }
                            }
                        });
                        break block3;
                    }
                    if (!"uuid".equals(string)) break block10;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)16), (Object)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ByteBuffer bb, Object v) {
                            AvroSimpleFeatureUtils$.MODULE$.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putUUID(bb, (UUID)v);
                        }
                    });
                    break block3;
                }
                if (!"byte[]".equals(string)) break block11;
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ByteBuffer bb, Object v) {
                        AvroSimpleFeatureUtils$.MODULE$.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putBytes(bb, (byte[])v);
                    }
                });
            }
            return tuple2;
        }
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid collection type: '", "'. Only primitives and Dates are supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label}));
        throw new IllegalArgumentException(msg);
    }

    private Function0<Object> getReadMethod(String label, ByteBuffer bb) {
        block11: {
            Object object;
            block3: {
                String string;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                string = label.toLowerCase(Locale.US);
                                                if (!"string".equals(string)) break block2;
                                                object = new Serializable(bb){
                                                    public static final long serialVersionUID = 0L;
                                                    private final ByteBuffer bb$1;

                                                    public final String apply() {
                                                        return AvroSimpleFeatureUtils$.MODULE$.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$getString(this.bb$1);
                                                    }
                                                    {
                                                        this.bb$1 = bb$1;
                                                    }
                                                };
                                                break block3;
                                            }
                                            boolean bl = "int".equals(string) ? true : "integer".equals(string);
                                            if (!bl) break block4;
                                            object = new Serializable(bb){
                                                public static final long serialVersionUID = 0L;
                                                private final ByteBuffer bb$1;

                                                public final Object apply() {
                                                    return BoxesRunTime.boxToInteger((int)this.bb$1.getInt());
                                                }
                                                {
                                                    this.bb$1 = bb$1;
                                                }
                                            };
                                            break block3;
                                        }
                                        if (!"double".equals(string)) break block5;
                                        object = new Serializable(bb){
                                            public static final long serialVersionUID = 0L;
                                            private final ByteBuffer bb$1;

                                            public final Object apply() {
                                                return BoxesRunTime.boxToDouble((double)this.bb$1.getDouble());
                                            }
                                            {
                                                this.bb$1 = bb$1;
                                            }
                                        };
                                        break block3;
                                    }
                                    if (!"long".equals(string)) break block6;
                                    object = new Serializable(bb){
                                        public static final long serialVersionUID = 0L;
                                        private final ByteBuffer bb$1;

                                        public final Object apply() {
                                            return BoxesRunTime.boxToLong((long)this.bb$1.getLong());
                                        }
                                        {
                                            this.bb$1 = bb$1;
                                        }
                                    };
                                    break block3;
                                }
                                if (!"float".equals(string)) break block7;
                                object = new Serializable(bb){
                                    public static final long serialVersionUID = 0L;
                                    private final ByteBuffer bb$1;

                                    public final Object apply() {
                                        return BoxesRunTime.boxToFloat((float)this.bb$1.getFloat());
                                    }
                                    {
                                        this.bb$1 = bb$1;
                                    }
                                };
                                break block3;
                            }
                            if (!"boolean".equals(string)) break block8;
                            object = new Serializable(bb){
                                public static final long serialVersionUID = 0L;
                                private final ByteBuffer bb$1;

                                public final Boolean apply() {
                                    return this.bb$1.get() > 0;
                                }
                                {
                                    this.bb$1 = bb$1;
                                }
                            };
                            break block3;
                        }
                        if (!"date".equals(string)) break block9;
                        object = new Serializable(bb){
                            public static final long serialVersionUID = 0L;
                            private final ByteBuffer bb$1;

                            public final Date apply() {
                                return new Date(this.bb$1.getLong());
                            }
                            {
                                this.bb$1 = bb$1;
                            }
                        };
                        break block3;
                    }
                    if (!"uuid".equals(string)) break block10;
                    object = new Serializable(bb){
                        public static final long serialVersionUID = 0L;
                        private final ByteBuffer bb$1;

                        public final UUID apply() {
                            return AvroSimpleFeatureUtils$.MODULE$.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$getUUID(this.bb$1);
                        }
                        {
                            this.bb$1 = bb$1;
                        }
                    };
                    break block3;
                }
                if (!"byte[]".equals(string)) break block11;
                object = new Serializable(bb){
                    public static final long serialVersionUID = 0L;
                    private final ByteBuffer bb$1;

                    public final byte[] apply() {
                        return AvroSimpleFeatureUtils$.MODULE$.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$getBytes(this.bb$1);
                    }
                    {
                        this.bb$1 = bb$1;
                    }
                };
            }
            return object;
        }
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid collection type: '", "'. Only primitives and Dates are supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label}));
        throw new IllegalArgumentException(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getTotalBytes(int bytesPerItem, int size, Iterator<?> values, String label) {
        int n;
        if (bytesPerItem == -1) {
            int n2;
            String string = label.toLowerCase();
            if ("string".equals(string)) {
                n2 = BoxesRunTime.unboxToInt((Object)values.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Object x$9) {
                        return ((String)x$9).getBytes(StandardCharsets.UTF_8).length + 4;
                    }
                }).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            } else {
                if (!"byte[]".equals(string)) throw new IllegalArgumentException("invalid type");
                n2 = BoxesRunTime.unboxToInt((Object)values.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Object x$10) {
                        return ((byte[])x$10).length + 4;
                    }
                }).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            n = n2;
            return n;
        } else {
            n = bytesPerItem * size;
        }
        return n;
    }

    public String org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$getString(ByteBuffer bb) {
        int size = bb.getInt();
        byte[] buf = new byte[size];
        bb.get(buf);
        return new String(buf, StandardCharsets.UTF_8);
    }

    public ByteBuffer org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putString(ByteBuffer bb, String s) {
        return this.org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putBytes(bb, s.getBytes(StandardCharsets.UTF_8));
    }

    public ByteBuffer org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putBytes(ByteBuffer bb, byte[] arr) {
        return bb.putInt(arr.length).put(arr);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$getBytes(ByteBuffer bb) {
        void var3_3;
        int sz = bb.getInt();
        byte[] bytes = new byte[sz];
        bb.get(bytes, 0, sz);
        return var3_3;
    }

    public ByteBuffer org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$putUUID(ByteBuffer bb, UUID uuid) {
        return bb.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
    }

    public UUID org$locationtech$geomesa$features$avro$AvroSimpleFeatureUtils$$getUUID(ByteBuffer bb) {
        return new UUID(bb.getLong(), bb.getLong());
    }

    private AvroSimpleFeatureUtils$() {
        MODULE$ = this;
        this.FEATURE_ID_AVRO_FIELD_NAME = "__fid__";
        this.AVRO_SIMPLE_FEATURE_VERSION = "__version__";
        this.AVRO_SIMPLE_FEATURE_USERDATA = "__userdata__";
        this.VERSION = 4;
        this.AVRO_NAMESPACE = "org.geomesa";
        this.primitiveTypes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{String.class, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Boolean.class, Boolean.TYPE}));
    }
}

