/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.ortholine;

import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.LineElement;
import org.geotools.grid.ortholine.LineOrientation;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OrthoLine
implements LineElement {
    private static final double TOL = 1.0E-8;
    private static final GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
    private final LineOrientation orientation;
    private final int level;
    private final CoordinateReferenceSystem crs;
    private final Coordinate v0;
    private final Coordinate v1;

    public OrthoLine(ReferencedEnvelope gridBounds, LineOrientation orientation, double ordinate, int level) {
        this.crs = gridBounds.getCoordinateReferenceSystem();
        this.orientation = orientation;
        this.level = level;
        if (orientation == LineOrientation.HORIZONTAL) {
            this.v0 = new Coordinate(gridBounds.getMinX(), ordinate);
            this.v1 = new Coordinate(gridBounds.getMaxX(), ordinate);
        } else {
            this.v0 = new Coordinate(ordinate, gridBounds.getMinY());
            this.v1 = new Coordinate(ordinate, gridBounds.getMaxY());
        }
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return new ReferencedEnvelope(this.v0.x, this.v1.x, this.v0.y, this.v1.y, this.crs);
    }

    @Override
    public Coordinate[] getVertices() {
        Coordinate[] vertices = new Coordinate[]{this.v0, this.v1};
        return vertices;
    }

    public LineOrientation getOrientation() {
        return this.orientation;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public Geometry toGeometry() {
        return geomFactory.createLineString(new Coordinate[]{this.v0, this.v1});
    }

    @Override
    public Geometry toDenseGeometry(double maxSpacing) {
        if (maxSpacing <= 0.0) {
            throw new IllegalArgumentException("maxSpacing must be a positive value");
        }
        return Densifier.densify((Geometry)this.toGeometry(), (double)maxSpacing);
    }
}

