/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.grid.io.footprint.FootprintLoader;
import org.geotools.coverage.grid.io.footprint.FootprintLoaderSpi;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class WKTLoaderSPI
implements FootprintLoaderSpi {
    @Override
    public FootprintLoader createLoader() {
        return new WKTLoader();
    }

    public static class WKTLoader
    implements FootprintLoader {
        WKTReader reader = new WKTReader();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Geometry loadFootprint(String pathNoExtension) throws Exception {
            File file = new File(pathNoExtension + ".wkt");
            if (file.exists()) {
                Geometry geometry;
                FileReader fr = null;
                try {
                    fr = new FileReader(file);
                    geometry = this.reader.read((Reader)fr);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fr);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)fr);
                return geometry;
            }
            return null;
        }
    }
}

