/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedLongArray;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$class;
import org.locationtech.geomesa.utils.stats.WholeNumberBinnedArray;
import org.locationtech.geomesa.utils.stats.Z3Histogram$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005g\u0001B\u0001\u0003\u00015\u00111BW\u001aISN$xn\u001a:b[*\u00111\u0001B\u0001\u0006gR\fGo\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0005'R\fG\u000f\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u0005a1oY1mC2|wmZ5oO*\u0011QDH\u0001\tif\u0004Xm]1gK*\tq$A\u0002d_6L!!\t\u000e\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005\u00191O\u001a;\u0016\u0003\u0015\u0002\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\rMLW\u000e\u001d7f\u0015\tQ3&A\u0004gK\u0006$XO]3\u000b\u00051R\u0011aB8qK:<\u0017n]\u0005\u0003]\u001d\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011!\u0001\u0004A!A!\u0002\u0013)\u0013\u0001B:gi\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\u0005O\u0016|W.F\u00015!\t)\u0004H\u0004\u0002\u0010m%\u0011q\u0007E\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028!!AA\b\u0001B\u0001B\u0003%A'A\u0003hK>l\u0007\u0005\u0003\u0005?\u0001\t\u0015\r\u0011\"\u00014\u0003\r!Go\u001a\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005i\u0005!A\r^4!\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0015A\u00029fe&|G-F\u0001E!\t)UK\u0004\u0002G%:\u0011q\t\u0015\b\u0003\u0011>s!!\u0013(\u000f\u0005)kU\"A&\u000b\u00051c\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011\u0011KB\u0001\u0006GV\u0014h/Z\u0005\u0003'R\u000b!\u0002V5nKB+'/[8e\u0015\t\tf!\u0003\u0002W/\nQA+[7f!\u0016\u0014\u0018n\u001c3\u000b\u0005M#\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\u000fA,'/[8eA!A1\f\u0001BC\u0002\u0013\u0005A,\u0001\u0004mK:<G\u000f[\u000b\u0002;B\u0011qBX\u0005\u0003?B\u00111!\u00138u\u0011!\t\u0007A!A!\u0002\u0013i\u0016a\u00027f]\u001e$\b\u000e\t\u0005\u0006G\u0002!\t\u0001Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u00154w\r[5k!\t)\u0002\u0001C\u0003$E\u0002\u0007Q\u0005C\u00033E\u0002\u0007A\u0007C\u0003?E\u0002\u0007A\u0007C\u0003CE\u0002\u0007A\tC\u0003\\E\u0002\u0007Q,\u0002\u0003m\u0001\u0001*'!A*\t\u00119\u0004\u0001R1A\u0005\u0002q\u000b\u0011bZ3p[&sG-\u001a=)\t5\u00048\u000f\u001e\t\u0003\u001fEL!A\u001d\t\u0003\u0015\u0011,\u0007O]3dCR,G-I\u00013c\u0015\u0019C'^=w\u0013\t1x/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r\u0006\u0003qB\t!\u0002Z3qe\u0016\u001c\u0017\r^3ec\u0015\u0019#p\u001f?y\u001d\ty10\u0003\u0002y!E\"!e\u0004\t~\u0005\u0015\u00198-\u00197b\u0011!y\b\u0001#A!B\u0013i\u0016AC4f_6Le\u000eZ3yA!I\u00111\u0001\u0001\t\u0006\u0004%\t\u0001X\u0001\tIR<\u0017J\u001c3fq\":\u0011\u0011\u00019\u0002\b\u0005%\u0011%\u0001 2\r\r\"T/a\u0003wc\u0019\u0019#p_A\u0007qF\"!e\u0004\t~\u0011%\t\t\u0002\u0001E\u0001B\u0003&Q,A\u0005ei\u001eLe\u000eZ3yA!A\u0011Q\u0003\u0001C\u0002\u0013%A,A\u0001h\u0011\u001d\tI\u0002\u0001Q\u0001\nu\u000b!a\u001a\u0011\t\u0011\u0005u\u0001A1A\u0005\nq\u000b\u0011\u0001\u001a\u0005\b\u0003C\u0001\u0001\u0015!\u0003^\u0003\t!\u0007\u0005C\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(\u0005\u00191OZ2\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003[i\u0011\u0001V\u0005\u0004\u0003_!&!\u0002.4'\u001a\u001b\u0005\u0002CA\u001a\u0001\u0001\u0006I!!\u000b\u0002\tM47\r\t\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003s\t\u0011\u0002^5nKR{')\u001b8\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0007rA!a\u000b\u0002@%\u0019\u0011\u0011\t+\u0002\u0015\tKgN\\3e)&lW-\u0003\u0003\u0002F\u0005\u001d#\u0001\u0005+j[\u0016$vNQ5o]\u0016$G+[7f\u0015\r\t\t\u0005\u0016\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002<\u0005QA/[7f)>\u0014\u0015N\u001c\u0011\t\u0013\u0005=\u0003A1A\u0005\n\u0005E\u0013!\u00032j]R{G)\u0019;f+\t\t\u0019\u0006\u0005\u0003\u0002>\u0005U\u0013\u0002BA,\u0003\u000f\u0012\u0001CQ5o]\u0016$G+[7f)>$\u0015\r^3\t\u0011\u0005m\u0003\u0001)A\u0005\u0003'\n!BY5o)>$\u0015\r^3!\u0011%\ty\u0006\u0001b\u0001\n\u0013\t\t'\u0001\u0003nS:TVCAA2!\ry\u0011QM\u0005\u0004\u0003O\u0002\"\u0001\u0002'p]\u001eD\u0001\"a\u001b\u0001A\u0003%\u00111M\u0001\u0006[&t'\f\t\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003C\nA!\\1y5\"A\u00111\u000f\u0001!\u0002\u0013\t\u0019'A\u0003nCbT\u0006\u0005C\u0005\u0002x\u0001A)\u0019!C\u0005g\u0005Q!n]8o\r>\u0014X.\u0019;\t\u0013\u0005m\u0004\u0001#A!B\u0013!\u0014a\u00036t_:4uN]7bi\u0002B!\"a \u0001\u0005\u0004%\tAAAA\u0003\u0019\u0011\u0017N\\'baV\u0011\u00111\u0011\t\t\u0003\u000b\u000by)a%\u0002\u001a6\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)A\u0004nkR\f'\r\\3\u000b\u0007\u00055\u0005#\u0001\u0006d_2dWm\u0019;j_:LA!!%\u0002\b\n\u0019Q*\u00199\u0011\u0007=\t)*C\u0002\u0002\u0018B\u0011Qa\u00155peR\u00042!FAN\u0013\r\tiJ\u0001\u0002\u0010\u0005&tg.\u001a3M_:<\u0017I\u001d:bs\"A\u0011\u0011\u0015\u0001!\u0002\u0013\t\u0019)A\u0004cS:l\u0015\r\u001d\u0011\t\u0011\u0005\u0015\u0006\u0001\"\u0001\u0003\u0003O\u000bqA\\3x\u0005&t7/\u0006\u0002\u0002\u001a\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0016\u0001\u0003;j[\u0016\u0014\u0015N\\:\u0016\u0005\u0005=\u0006CBAY\u0003w\u000b\u0019J\u0004\u0003\u00024\u0006]fb\u0001&\u00026&\t\u0011#C\u0002\u0002:B\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002>\u0006}&aA*fc*\u0019\u0011\u0011\u0018\t\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\u0006)1m\\;oiR1\u00111MAd\u0003\u0017D\u0001\"!3\u0002B\u0002\u0007\u00111S\u0001\bi&lWMQ5o\u0011\u001d\ti-!1A\u0002u\u000b\u0011!\u001b\u0005\b\u0003#\u0004A\u0011AAj\u0003-!\u0017N]3di&sG-\u001a=\u0015\u000bu\u000b).a6\t\u0011\u0005%\u0017q\u001aa\u0001\u0003'C\u0001\"!7\u0002P\u0002\u0007\u00111M\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003;\u0004A\u0011AAp\u0003\u001dIg\u000eZ3y\u001f\u001a$B!!9\u0002hB1q\"a9\u0002\u0014vK1!!:\u0011\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\\An\u0001\u0004\tI\u000fE\u0004\u0010\u0003G\fY/!?\u0011\t\u00055\u0018Q_\u0007\u0003\u0003_T1AMAy\u0015\r\t\u0019\u0010C\u0001\u0004UR\u001c\u0018\u0002BA|\u0003_\u0014\u0001bR3p[\u0016$(/\u001f\t\u0005\u0003w\u0014)!\u0004\u0002\u0002~*!\u0011q B\u0001\u0003\u0011)H/\u001b7\u000b\u0005\t\r\u0011\u0001\u00026bm\u0006LAAa\u0002\u0002~\n!A)\u0019;f\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0005\u001b\t1\"\\3eS\u0006tg+\u00197vKR1\u0011\u0011\u001eB\b\u0005#A\u0001\"!3\u0003\n\u0001\u0007\u00111\u0013\u0005\b\u0003\u001b\u0014I\u00011\u0001^\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/\tQ\u0001^8LKf$bA!\u0007\u0003\u001c\tu\u0001cB\b\u0002d\u0006M\u00151\r\u0005\be\tM\u0001\u0019AAv\u0011\u001dq$1\u0003a\u0001\u0003sDqA!\t\u0001\t\u0013\u0011\u0019#A\u0004ge>l7*Z=\u0015\r\u0005%(Q\u0005B\u0014\u0011!\tIMa\bA\u0002\u0005M\u0005\u0002\u0003B\u0015\u0005?\u0001\r!a\u0019\u0002\u0003iDqA!\f\u0001\t\u0003\u0011y#A\u0006ta2LGOQ=US6,WC\u0001B\u0019!\u0019\t\t,a/\u00034A1q\"a9\u0002\u0014\u0016DqAa\u000e\u0001\t\u0003\u0012I$A\u0004pEN,'O^3\u0015\t\tm\"\u0011\t\t\u0004\u001f\tu\u0012b\u0001B !\t!QK\\5u\u0011!\u0011\u0019E!\u000eA\u0002\t\u0015\u0013AA:g!\r1#qI\u0005\u0004\u0005\u0013:#!D*j[BdWMR3biV\u0014X\rC\u0004\u0003N\u0001!\tEa\u0014\u0002\u0013UtwNY:feZ,G\u0003\u0002B\u001e\u0005#B\u0001Ba\u0011\u0003L\u0001\u0007!Q\t\u0005\b\u0005+\u0002A\u0011\tB,\u0003\u0015!\u0003\u000f\\;t)\r)'\u0011\f\u0005\b\u00057\u0012\u0019\u00061\u0001f\u0003\u0015yG\u000f[3s\u0011\u001d\u0011y\u0006\u0001C!\u0005C\n\u0001\u0002\n9mkN$S-\u001d\u000b\u0005\u0005w\u0011\u0019\u0007C\u0004\u0003\\\tu\u0003\u0019A3\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j\u0005aAo\u001c&t_:|%M[3diV\u0011!1\u000e\t\u0004\u001f\t5\u0014b\u0001B8!\t\u0019\u0011I\\=\t\u000f\tM\u0004\u0001\"\u0011\u0003v\u00059\u0011n]#naRLXC\u0001B<!\ry!\u0011P\u0005\u0004\u0005w\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u007f\u0002A\u0011\tBA\u0003\u0015\u0019G.Z1s)\t\u0011Y\u0004C\u0004\u0003\u0006\u0002!\tEa\"\u0002\u0019%\u001cX)];jm\u0006dWM\u001c;\u0015\t\t]$\u0011\u0012\u0005\b\u00057\u0012\u0019\t1\u0001\u0015\u000f\u001d\u0011iI\u0001E\u0001\u0005\u001f\u000b1BW\u001aISN$xn\u001a:b[B\u0019QC!%\u0007\r\u0005\u0011\u0001\u0012\u0001BJ'\r\u0011\tJ\u0004\u0005\bG\nEE\u0011\u0001BL)\t\u0011y\t\u0003\u0006\u0003\u001c\nE%\u0019!C\u0005\u0005;\u000b!a\u001a4\u0016\u0005\t}\u0005\u0003BAw\u0005CKAAa)\u0002p\nyq)Z8nKR\u0014\u0018PR1di>\u0014\u0018\u0010C\u0005\u0003(\nE\u0005\u0015!\u0003\u0003 \u0006\u0019qM\u001a\u0011\t\u0015\t-&\u0011\u0013b\u0001\n\u0003\u0011i+A\u0004nS:<Um\\7\u0016\u0005\t=\u0006\u0003BAw\u0005cKAAa-\u0002p\n)\u0001k\\5oi\"I!q\u0017BIA\u0003%!qV\u0001\t[&tw)Z8nA!Q!1\u0018BI\u0005\u0004%\tA!,\u0002\u000f5\f\u0007pR3p[\"I!q\u0018BIA\u0003%!qV\u0001\t[\u0006Dx)Z8nA\u0001")
public class Z3Histogram
implements Stat,
LazyLogging {
    private final SimpleFeatureType sft;
    private final String geom;
    private final String dtg;
    private final Enumeration.Value period;
    private final int length;
    private int geomIndex;
    private int dtgIndex;
    private final int g;
    private final int d;
    private final Z3SFC sfc;
    private final Function1<Object, BinnedTime> timeToBin;
    private final Function1<BinnedTime, ZonedDateTime> binToDate;
    private final long minZ;
    private final long maxZ;
    private String org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat;
    private final Map<Object, BinnedLongArray> binMap;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static Point maxGeom() {
        return Z3Histogram$.MODULE$.maxGeom();
    }

    public static Point minGeom() {
        return Z3Histogram$.MODULE$.minGeom();
    }

    private int geomIndex$lzycompute() {
        Z3Histogram z3Histogram2 = this;
        synchronized (z3Histogram2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.geomIndex = this.g();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.geomIndex;
        }
    }

    private int dtgIndex$lzycompute() {
        Z3Histogram z3Histogram2 = this;
        synchronized (z3Histogram2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dtgIndex = this.d();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.dtgIndex;
        }
    }

    private String org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat$lzycompute() {
        Z3Histogram z3Histogram2 = this;
        synchronized (z3Histogram2) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String string2;
                Enumeration.Value value2 = this.period();
                Enumeration.Value value3 = TimePeriod$.MODULE$.Day();
                Enumeration.Value value4 = value2;
                if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                    string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%05d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                } else {
                    Enumeration.Value value5 = TimePeriod$.MODULE$.Week();
                    Enumeration.Value value6 = value2;
                    if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%04d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                    } else {
                        Enumeration.Value value7 = TimePeriod$.MODULE$.Month();
                        Enumeration.Value value8 = value2;
                        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%03d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                        } else {
                            Enumeration.Value value9 = TimePeriod$.MODULE$.Year();
                            Enumeration.Value value10 = value2;
                            if (value9 != null ? !value9.equals(value10) : value10 != null) {
                                throw new MatchError((Object)value2);
                            }
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%02d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                        }
                    }
                }
                this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat = string2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat;
        }
    }

    private Logger logger$lzycompute() {
        Z3Histogram z3Histogram2 = this;
        synchronized (z3Histogram2) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat$class.$plus$eq(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat$class.$plus(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat$class.toJson(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String geom() {
        return this.geom;
    }

    public String dtg() {
        return this.dtg;
    }

    public Enumeration.Value period() {
        return this.period;
    }

    public int length() {
        return this.length;
    }

    public int geomIndex() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.geomIndex$lzycompute() : this.geomIndex;
    }

    public int dtgIndex() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dtgIndex$lzycompute() : this.dtgIndex;
    }

    private int g() {
        return this.g;
    }

    private int d() {
        return this.d;
    }

    private Z3SFC sfc() {
        return this.sfc;
    }

    private Function1<Object, BinnedTime> timeToBin() {
        return this.timeToBin;
    }

    private Function1<BinnedTime, ZonedDateTime> binToDate() {
        return this.binToDate;
    }

    private long minZ() {
        return this.minZ;
    }

    private long maxZ() {
        return this.maxZ;
    }

    public String org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat$lzycompute() : this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat;
    }

    public Map<Object, BinnedLongArray> binMap() {
        return this.binMap;
    }

    public BinnedLongArray newBins() {
        return new BinnedLongArray(this.length(), (Tuple2<Long, Long>)new Tuple2((Object)Predef$.MODULE$.long2Long(this.minZ()), (Object)Predef$.MODULE$.long2Long(this.maxZ())));
    }

    public Seq<Object> timeBins() {
        return (Seq)this.binMap().keys().toSeq().sorted((Ordering)Ordering.Short$.MODULE$);
    }

    public long count(short timeBin, int i) {
        return BoxesRunTime.unboxToLong((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1)new Serializable(this, i){
            public static final long serialVersionUID = 0L;
            private final int i$1;

            public final long apply(BinnedLongArray x$1) {
                return x$1.counts()[this.i$1];
            }
            {
                this.i$1 = i$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public int directIndex(short timeBin, long value2) {
        return BoxesRunTime.unboxToInt((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1)new Serializable(this, value2){
            public static final long serialVersionUID = 0L;
            private final long value$1;

            public final int apply(BinnedLongArray x$2) {
                return x$2.indexOf(Predef$.MODULE$.long2Long(this.value$1));
            }
            {
                this.value$1 = value$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }));
    }

    public Tuple2<Object, Object> indexOf(Tuple2<Geometry, Date> value2) {
        Tuple2<Object, Object> tuple2 = this.toKey((Geometry)value2._1(), (Date)value2._2());
        if (tuple2 != null) {
            Tuple2 tuple22;
            short timeBin = BoxesRunTime.unboxToShort((Object)tuple2._1());
            long z = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z));
            short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long z2 = tuple23._2$mcJ$sp();
            return new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin2), (Object)BoxesRunTime.boxToInteger((int)this.directIndex(timeBin2, z2)));
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Geometry, Date> medianValue(short timeBin, int i) {
        return this.fromKey(timeBin, Predef$.MODULE$.Long2long((Long)((WholeNumberBinnedArray)this.binMap().apply((Object)BoxesRunTime.boxToShort((short)timeBin))).medianValue(i)));
    }

    private Tuple2<Object, Object> toKey(Geometry geom, Date dtg) {
        BinnedTime binnedTime = (BinnedTime)this.timeToBin().apply((Object)BoxesRunTime.boxToLong((long)dtg.getTime()));
        if (binnedTime != null) {
            Tuple2 tuple2;
            short bin = binnedTime.bin();
            long offset = binnedTime.offset();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)offset));
            short bin2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
            long offset2 = tuple22._2$mcJ$sp();
            Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
            long z = this.sfc().index(centroid.getX(), centroid.getY(), offset2, this.sfc().index$default$4());
            return new Tuple2((Object)BoxesRunTime.boxToShort((short)bin2), (Object)BoxesRunTime.boxToLong((long)z));
        }
        throw new MatchError((Object)binnedTime);
    }

    private Tuple2<Geometry, Date> fromKey(short timeBin, long z) {
        Tuple3 tuple3 = this.sfc().invert(z);
        if (tuple3 != null) {
            Tuple3 tuple32;
            double x = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double y = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            long t = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToLong((long)t));
            double x2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
            double y2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
            long t2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
            Date dtg = Date.from(((ChronoZonedDateTime)this.binToDate().apply((Object)new BinnedTime(timeBin, t2))).toInstant());
            Point geom = Z3Histogram$.MODULE$.org$locationtech$geomesa$utils$stats$Z3Histogram$$gf().createPoint(new Coordinate(x2, y2));
            return new Tuple2((Object)geom, (Object)dtg);
        }
        throw new MatchError((Object)tuple3);
    }

    public Seq<Tuple2<Object, Z3Histogram>> splitByTime() {
        return (Seq)this.binMap().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Histogram $outer;

            public final Tuple2<Object, Z3Histogram> apply(Tuple2<Object, BinnedLongArray> x0$1) {
                Tuple2<Object, BinnedLongArray> tuple2 = x0$1;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedLongArray bins = (BinnedLongArray)tuple2._2();
                    Z3Histogram hist = new Z3Histogram(this.$outer.sft(), this.$outer.geom(), this.$outer.dtg(), this.$outer.period(), this.$outer.length());
                    hist.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)w), (Object)hist);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.g());
        Date dtg = (Date)sf.getAttribute(this.d());
        if (geom != null && dtg != null) {
            try {
                Tuple2 tuple2;
                Tuple2<Object, Object> tuple22 = this.toKey(geom, dtg);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z3 = tuple22._2$mcJ$sp();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                ((BinnedArray)this.binMap().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)timeBin2), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Z3Histogram $outer;

                    public final BinnedLongArray apply() {
                        return this.$outer.newBins();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).add(Predef$.MODULE$.long2Long(z32), 1L);
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, exception.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.g());
        Date dtg = (Date)sf.getAttribute(this.d());
        if (geom != null && dtg != null) {
            try {
                Tuple2 tuple2;
                Tuple2<Object, Object> tuple22 = this.toKey(geom, dtg);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z3 = tuple22._2$mcJ$sp();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin2)).foreach((Function1)new Serializable(this, z32){
                    public static final long serialVersionUID = 0L;
                    private final long z3$1;

                    public final void apply(BinnedLongArray x$8) {
                        x$8.add(Predef$.MODULE$.long2Long(this.z3$1), -1L);
                    }
                    {
                        this.z3$1 = z3$1;
                    }
                });
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error un-observing geom '{}' and date '{}': {}", new Object[]{geom, dtg, exception.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Z3Histogram $plus(Z3Histogram other) {
        void var2_2;
        Z3Histogram plus2 = new Z3Histogram(this.sft(), this.geom(), this.dtg(), this.period(), this.length());
        plus2.$plus$eq(this);
        plus2.$plus$eq(other);
        return var2_2;
    }

    public void $plus$eq(Z3Histogram other) {
        if (this.length() != other.length()) {
            throw new NotImplementedError("Can only add z3 histograms with the same length");
        }
        other.binMap().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Histogram $outer;

            public final Object apply(Tuple2<Object, BinnedLongArray> x0$2) {
                Tuple2<Object, BinnedLongArray> tuple2;
                block3: {
                    Option option2;
                    block6: {
                        Option option3;
                        block5: {
                            BinnedLongArray bins;
                            block4: {
                                tuple2 = x0$2;
                                if (tuple2 == null) break block3;
                                short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                bins = (BinnedLongArray)tuple2._2();
                                option2 = this.$outer.binMap().get((Object)BoxesRunTime.boxToShort((short)w));
                                if (!None$.MODULE$.equals(option2)) break block4;
                                option3 = this.$outer.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
                                break block5;
                            }
                            if (!(option2 instanceof Some)) break block6;
                            Some some = (Some)option2;
                            BinnedLongArray b = (BinnedLongArray)some.x();
                            for (int i = 0; i < b.length(); ++i) {
                                int n = i;
                                b.counts()[n] = b.counts()[n] + bins.counts()[i];
                            }
                            option3 = BoxedUnit.UNIT;
                        }
                        Option option4 = option3;
                        return option4;
                    }
                    throw new MatchError((Object)option2);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Object toJsonObject() {
        return ((TraversableLike)((TraversableLike)this.binMap().toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(Tuple2<Object, BinnedLongArray> x$9) {
                return BoxesRunTime.unboxToShort((Object)x$9._1());
            }
        }, (Ordering)Ordering.Short$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Histogram $outer;

            public final Tuple2<String, BinnedLongArray> apply(Tuple2<Object, BinnedLongArray> x0$3) {
                Tuple2<Object, BinnedLongArray> tuple2 = x0$3;
                if (tuple2 != null) {
                    short p = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedLongArray bins = (BinnedLongArray)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)String.format(this.$outer.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat(), BoxesRunTime.boxToShort((short)p)), (Object)bins);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, long[]>> apply(Tuple2<String, BinnedLongArray> x0$4) {
                Tuple2<String, BinnedLongArray> tuple2 = x0$4;
                if (tuple2 != null) {
                    String label = (String)tuple2._1();
                    BinnedLongArray bins = (BinnedLongArray)tuple2._2();
                    scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), (Object)bins.counts())})))}));
                    return map2;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isEmpty() {
        return this.binMap().values().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BinnedLongArray x$10) {
                return Predef$.MODULE$.longArrayOps(x$10.counts()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$11) {
                        return this.apply$mcZJ$sp(x$11);
                    }

                    public boolean apply$mcZJ$sp(long x$11) {
                        return x$11 == 0L;
                    }
                });
            }
        });
    }

    @Override
    public void clear() {
        this.binMap().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BinnedLongArray x$12) {
                x$12.clear();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat2 = other;
        if (!(stat2 instanceof Z3Histogram)) return false;
        Z3Histogram z3Histogram2 = (Z3Histogram)stat2;
        if (this.g() != z3Histogram2.g()) return false;
        if (this.d() != z3Histogram2.d()) return false;
        Enumeration.Value value2 = this.period();
        Enumeration.Value value3 = z3Histogram2.period();
        if (value2 == null) {
            if (value3 != null) {
                return false;
            }
        } else if (!value2.equals(value3)) return false;
        if (this.length() != z3Histogram2.length()) return false;
        Set set = this.binMap().keySet();
        Set set2 = z3Histogram2.binMap().keySet();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        if (!this.binMap().forall((Function1)new Serializable(this, z3Histogram2){
            public static final long serialVersionUID = 0L;
            private final Z3Histogram x2$1;

            public final boolean apply(Tuple2<Object, BinnedLongArray> x0$5) {
                Tuple2<Object, BinnedLongArray> tuple2 = x0$5;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedLongArray bins = (BinnedLongArray)tuple2._2();
                    boolean bl = Arrays.equals(bins.counts(), ((BinnedArray)this.x2$1.binMap().apply((Object)BoxesRunTime.boxToShort((short)w))).counts());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.x2$1 = x2$1;
            }
        })) return false;
        return true;
    }

    public Z3Histogram(SimpleFeatureType sft, String geom, String dtg, Enumeration.Value period, int length2) {
        this.sft = sft;
        this.geom = geom;
        this.dtg = dtg;
        this.period = period;
        this.length = length2;
        Stat$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.g = sft.indexOf(geom);
        this.d = sft.indexOf(dtg);
        this.sfc = Z3SFC$.MODULE$.apply(period);
        this.timeToBin = BinnedTime$.MODULE$.timeToBinnedTime(period);
        this.binToDate = BinnedTime$.MODULE$.binnedTimeToDate(period);
        this.minZ = this.sfc().index(Z3Histogram$.MODULE$.minGeom().getX(), Z3Histogram$.MODULE$.minGeom().getY(), (long)this.sfc().time().min(), this.sfc().index$default$4());
        this.maxZ = this.sfc().index(Z3Histogram$.MODULE$.maxGeom().getX(), Z3Histogram$.MODULE$.maxGeom().getY(), (long)this.sfc().time().max(), this.sfc().index$default$4());
        this.binMap = Map$.MODULE$.empty();
    }
}

