/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.io.Serializable;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.SingularMatrixException;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.operation.Matrix;

public class Matrix2
implements XMatrix,
Serializable {
    private static final long serialVersionUID = 7116561372481474290L;
    public static final int SIZE = 2;
    public double m00;
    public double m01;
    public double m10;
    public double m11;

    public Matrix2() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public Matrix2(double m00, double m01, double m10, double m11) {
        this.m00 = m00;
        this.m01 = m01;
        this.m10 = m10;
        this.m11 = m11;
    }

    public Matrix2(Matrix matrix) {
        if (matrix.getNumRow() != 2 || matrix.getNumCol() != 2) {
            throw new IllegalArgumentException(Errors.format((int)70));
        }
        this.m00 = matrix.getElement(0, 0);
        this.m01 = matrix.getElement(0, 1);
        this.m10 = matrix.getElement(1, 0);
        this.m11 = matrix.getElement(1, 1);
    }

    Matrix2 internal(Matrix matrix) {
        if (matrix instanceof Matrix2) {
            return (Matrix2)matrix;
        }
        if (matrix.getNumRow() != 2 || matrix.getNumCol() != 2) {
            throw new IllegalArgumentException(Errors.format((int)70));
        }
        return new Matrix2(matrix);
    }

    @Override
    public final int getNumRow() {
        return 2;
    }

    @Override
    public final int getNumCol() {
        return 2;
    }

    @Override
    public final double getElement(int row, int col) {
        switch (row) {
            case 0: {
                switch (col) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                }
                break;
            }
            case 1: {
                switch (col) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                }
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public final void setElement(int row, int col, double value) {
        switch (row) {
            case 0: {
                switch (col) {
                    case 0: {
                        this.m00 = value;
                        return;
                    }
                    case 1: {
                        this.m01 = value;
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (col) {
                    case 0: {
                        this.m10 = value;
                        return;
                    }
                    case 1: {
                        this.m11 = value;
                        return;
                    }
                }
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final void setZero() {
        this.m11 = 0.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m00 = 0.0;
    }

    @Override
    public final void setIdentity() {
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        assert (this.isIdentity());
    }

    public final boolean isIdentity() {
        return this.m01 == 0.0 && this.m10 == 0.0 && this.m00 == 1.0 && this.m11 == 1.0;
    }

    @Override
    public final boolean isIdentity(double tolerance) {
        return GeneralMatrix.isIdentity(this, tolerance);
    }

    @Override
    public final boolean isAffine() {
        return this.m10 == 0.0 && this.m11 == 1.0;
    }

    @Override
    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
    }

    @Override
    public void negate(Matrix matrix) {
        Matrix2 k = this.internal(matrix);
        this.m00 = -k.m00;
        this.m01 = -k.m01;
        this.m10 = -k.m10;
        this.m11 = -k.m11;
    }

    @Override
    public final void transpose() {
        double swap = this.m10;
        this.m10 = this.m01;
        this.m01 = swap;
    }

    @Override
    public void transpose(Matrix matrix) {
        Matrix2 k = this.internal(matrix);
        this.m00 = k.m00;
        this.m01 = k.m10;
        this.m10 = k.m01;
        this.m11 = k.m11;
    }

    @Override
    public final void invert() {
        double det = this.m00 * this.m11 - this.m01 * this.m10;
        if (det == 0.0) {
            throw new SingularMatrixException("Determinate is zero, cannot invert matrix");
        }
        double swap = this.m00;
        this.m00 = this.m11 / det;
        this.m11 = swap / det;
        this.m10 = -this.m10 / det;
        this.m01 = -this.m01 / det;
    }

    @Override
    public void invert(Matrix matrix) throws SingularMatrixException {
        Matrix2 k = this.internal(matrix);
        double det = k.m00 * k.m11 - k.m01 * k.m10;
        if (det == 0.0) {
            throw new SingularMatrixException("Determinate is zero, cannot invert matrix");
        }
        this.m00 = k.m11 / det;
        this.m11 = k.m00 / det;
        this.m10 = -k.m10 / det;
        this.m01 = -k.m01 / det;
    }

    @Override
    public final void multiply(Matrix matrix) {
        this.mul(matrix);
    }

    @Override
    public boolean equals(Matrix matrix, double tolerance) {
        return GeneralMatrix.epsilonEquals(this, matrix, tolerance);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Matrix2 that = (Matrix2)object;
            return Double.doubleToLongBits(this.m00) == Double.doubleToLongBits(that.m00) && Double.doubleToLongBits(this.m01) == Double.doubleToLongBits(that.m01) && Double.doubleToLongBits(this.m10) == Double.doubleToLongBits(that.m10) && Double.doubleToLongBits(this.m11) == Double.doubleToLongBits(that.m11);
        }
        return false;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.m00) + 37L * Double.doubleToLongBits(this.m01) + 37L * Double.doubleToLongBits(this.m10) + 37L * Double.doubleToLongBits(this.m11) ^ 0x62C31ADCF5064EF2L);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    public Matrix2 clone() {
        try {
            return (Matrix2)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void getRow(int row, double[] array) {
        if (array.length != 2) {
            throw new IllegalArgumentException("Call getRow received an array of length " + array.length + ".  The dimensions of the matrix is 2 by 2.");
        }
        if (row == 0) {
            array[0] = this.m00;
            array[1] = this.m01;
        } else if (row == 1) {
            array[0] = this.m10;
            array[1] = this.m11;
        } else {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + row + ", 0)");
        }
    }

    @Override
    public void setRow(int row, double ... values) {
        if (values.length != 2) {
            throw new IllegalArgumentException("Call setRow received an array of length " + values.length + ".  The dimensions of the matrix is 2 by 2.");
        }
        if (row == 0) {
            this.m00 = values[0];
            this.m01 = values[1];
        } else if (row == 1) {
            this.m10 = values[0];
            this.m11 = values[1];
        } else {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + row + " , 0)");
        }
    }

    @Override
    public void getColumn(int column, double[] array) {
        if (array.length != 2) {
            throw new IllegalArgumentException("Call getColumn received an array of length " + array.length + ".  The dimensions of the matrix is 2 by 2.");
        }
        if (column == 0) {
            array[0] = this.m00;
            array[1] = this.m10;
        } else if (column == 1) {
            array[0] = this.m01;
            array[1] = this.m11;
        } else {
            throw new IllegalArgumentException("Specified element is out of bounds: (0 , " + column + ")");
        }
    }

    @Override
    public void setColumn(int column, double ... values) {
        if (values.length != 2) {
            throw new IllegalArgumentException("Call setColumn received an array of length " + values.length + ".  The dimensions of the matrix is 2 by 2.");
        }
        if (column == 0) {
            this.m00 = values[0];
            this.m10 = values[1];
        } else if (column == 1) {
            this.m01 = values[0];
            this.m11 = values[1];
        } else {
            throw new IllegalArgumentException("Specified element is out of bounds: (0 , " + column + ")");
        }
    }

    @Override
    public void add(double scalar) {
        this.m00 += scalar;
        this.m01 += scalar;
        this.m10 += scalar;
        this.m11 += scalar;
    }

    @Override
    public void add(double scalar, XMatrix matrix) {
        Matrix2 k = this.internal(matrix);
        this.m00 = scalar + k.m00;
        this.m01 = scalar + k.m01;
        this.m10 = scalar + k.m10;
        this.m11 = scalar + k.m11;
    }

    @Override
    public void add(XMatrix matrix) {
        Matrix2 k = this.internal(matrix);
        this.m00 += k.m00;
        this.m01 += k.m01;
        this.m10 += k.m10;
        this.m11 += k.m11;
    }

    @Override
    public void add(XMatrix matrix1, XMatrix matrix2) {
        Matrix2 a = this.internal(matrix1);
        Matrix2 b = this.internal(matrix2);
        this.m00 = a.m00 + b.m00;
        this.m01 = a.m01 + b.m01;
        this.m10 = a.m10 + b.m10;
        this.m11 = a.m11 + b.m11;
    }

    @Override
    public double determinate() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    @Override
    public void mul(double scalar) {
        this.m00 *= scalar;
        this.m01 *= scalar;
        this.m10 *= scalar;
        this.m11 *= scalar;
    }

    @Override
    public void mul(double scalar, Matrix matrix) {
        Matrix2 k = this.internal(matrix);
        this.m00 = scalar * k.m00;
        this.m01 = scalar * k.m01;
        this.m10 = scalar * k.m10;
        this.m11 = scalar * k.m11;
    }

    @Override
    public void mul(Matrix matrix) {
        Matrix2 k = this.internal(matrix);
        double m0 = this.m00;
        double m1 = this.m01;
        this.m00 = m0 * k.m00 + m1 * k.m10;
        this.m01 = m0 * k.m01 + m1 * k.m11;
        m0 = this.m10;
        m1 = this.m11;
        this.m10 = m0 * k.m00 + m1 * k.m10;
        this.m11 = m0 * k.m01 + m1 * k.m11;
    }

    @Override
    public void mul(Matrix matrix1, Matrix matrix2) {
        Matrix2 a = this.internal(matrix1);
        Matrix2 b = this.internal(matrix2);
        this.m00 = a.m00 * b.m00 + a.m10 * b.m01;
        this.m01 = a.m00 * b.m10 + a.m10 * b.m11;
        this.m10 = a.m01 * b.m00 + a.m11 * b.m01;
        this.m11 = a.m01 * b.m10 + a.m11 * b.m11;
    }

    @Override
    public void sub(double scalar) {
        this.m00 -= scalar;
        this.m01 -= scalar;
        this.m10 -= scalar;
        this.m11 -= scalar;
    }

    @Override
    public void sub(double scalar, Matrix matrix) {
        Matrix2 k = this.internal(matrix);
        this.m00 = scalar - k.m00;
        this.m01 = scalar - k.m01;
        this.m10 = scalar - k.m10;
        this.m11 = scalar - k.m11;
    }

    @Override
    public void sub(Matrix matrix) {
        Matrix2 k = this.internal(matrix);
        this.m00 -= k.m00;
        this.m01 -= k.m01;
        this.m10 -= k.m10;
        this.m11 -= k.m11;
    }

    @Override
    public void sub(Matrix matrix1, Matrix matrix2) {
        Matrix2 a = this.internal(matrix1);
        Matrix2 b = this.internal(matrix2);
        this.m00 = a.m00 - b.m00;
        this.m01 = a.m01 - b.m01;
        this.m10 = a.m10 - b.m10;
        this.m11 = a.m11 - b.m11;
    }
}

