/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.operation.Matrix;

public class Matrix4
extends GeneralMatrix
implements XMatrix {
    private static final long serialVersionUID = 5685762518066856311L;
    public static final int SIZE = 4;

    public Matrix4() {
        super(4);
        this.setIdentity();
    }

    public Matrix4(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        super(4, 4, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }

    public Matrix4(Matrix matrix) {
        super(4);
        if (matrix.getNumRow() != 4 || matrix.getNumCol() != 4) {
            throw new IllegalArgumentException(Errors.format((int)70));
        }
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                this.setElement(j, i, matrix.getElement(j, i));
            }
        }
    }

    @Override
    public final int getNumRow() {
        return 4;
    }

    @Override
    public final int getNumCol() {
        return 4;
    }

    @Override
    public Matrix4 clone() {
        return new Matrix4((Matrix)this);
    }
}

