/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.Encoder;
import org.locationtech.jts.geom.Point;
import org.xml.sax.helpers.AttributesImpl;

class PointEncoder
extends GeometryEncoder<Point> {
    static final QualifiedName POINT = new QualifiedName("http://www.opengis.net/gml", "Point", "gml");
    static final QualifiedName COORD = new QualifiedName("http://www.opengis.net/gml", "coord", "gml");
    QualifiedName point;
    QualifiedName coord;
    QualifiedName multiPolygon;

    protected PointEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.point = POINT.derive(gmlPrefix);
        this.coord = COORD.derive(gmlPrefix);
    }

    @Override
    public void encode(Point geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.point, atts);
        handler.coordinates(geometry.getCoordinateSequence());
        handler.endElement(this.point);
    }
}

