/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert2.transforms;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction;
import org.locationtech.geomesa.convert2.transforms.TransformerFunction$;
import org.locationtech.geomesa.convert2.transforms.TransformerFunctionFactory;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.utils.uuid.Z3UuidGenerator$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u001b\t\t\u0012\n\u001a$v]\u000e$\u0018n\u001c8GC\u000e$xN]=\u000b\u0005\r!\u0011A\u0003;sC:\u001chm\u001c:ng*\u0011QAB\u0001\tG>tg/\u001a:ue)\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002\u0006\r\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u000eUe\u0006t7OZ8s[\u0016\u0014h)\u001e8di&|gNR1di>\u0014\u0018\u0010\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u0005a1oY1mC2|wmZ5oO*\u0011QDH\u0001\tif\u0004Xm]1gK*\tq$A\u0002d_6L!!\t\u000e\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"!\u0006\u0001\t\u000b\u001d\u0002A\u0011\t\u0015\u0002\u0013\u0019,hn\u0019;j_:\u001cX#A\u0015\u0011\u0007)js&D\u0001,\u0015\ta\u0003#\u0001\u0006d_2dWm\u0019;j_:L!AL\u0016\u0003\u0007M+\u0017\u000f\u0005\u0002\u0016a%\u0011\u0011G\u0001\u0002\u0014)J\fgn\u001d4pe6,'OR;oGRLwN\u001c\u0005\bg\u0001\u0011\r\u0011\"\u00035\u00031\u0019HO]5oOJ\u0012\u0015\u0010^3t+\u0005y\u0003B\u0002\u001c\u0001A\u0003%q&A\u0007tiJLgn\u001a\u001aCsR,7\u000f\t\u0005\bq\u0001\u0011\r\u0011\"\u00035\u0003\u0011)X/\u001b3\t\ri\u0002\u0001\u0015!\u00030\u0003\u0015)X/\u001b3!\u0011\u001da\u0004A1A\u0005\nQ\na!^;jIj\u001b\u0004B\u0002 \u0001A\u0003%q&A\u0004vk&$'l\r\u0011\t\u000f\u0001\u0003!\u0019!C\u0005i\u0005qQ/^5e5N\u001aUM\u001c;s_&$\u0007B\u0002\"\u0001A\u0003%q&A\bvk&$'lM\"f]R\u0014x.\u001b3!\u0011\u001d!\u0005A1A\u0005\nQ\naAY1tKZ\"\u0004B\u0002$\u0001A\u0003%q&A\u0004cCN,g\u0007\u000e\u0011\t\u000f!\u0003!\u0019!C\u0005\u0013\u0006\u0019Q\u000eZ\u001b\u0016\u0003)\u0003\"aS.\u000f\u00051KfBA'Y\u001d\tquK\u0004\u0002P-:\u0011\u0001+\u0016\b\u0003#Rk\u0011A\u0015\u0006\u0003'2\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t%\u0011!LA\u0001\u0014)J\fgn\u001d4pe6,'OR;oGRLwN\\\u0005\u00039v\u0013\u0001DT1nK\u0012$&/\u00198tM>\u0014X.\u001a:Gk:\u001cG/[8o\u0015\tQ&\u0001\u0003\u0004`\u0001\u0001\u0006IAS\u0001\u0005[\u0012,\u0004\u0005C\u0004b\u0001\t\u0007I\u0011B%\u0002\u00155,(/\\;sg}\u001b$\u0007\u0003\u0004d\u0001\u0001\u0006IAS\u0001\f[V\u0014X.\u001e:4?N\u0012\u0004\u0005C\u0004f\u0001\t\u0007I\u0011B%\u0002\u00175,(/\\;sg}\u000b$\u0007\u000f\u0005\u0007O\u0002\u0001\u000b\u0011\u0002&\u0002\u00195,(/\\;sg}\u000b$\u0007\u000f\u0011")
public class IdFunctionFactory
implements TransformerFunctionFactory,
LazyLogging {
    private final TransformerFunction string2Bytes;
    private final TransformerFunction uuid;
    private final TransformerFunction uuidZ3;
    private final TransformerFunction uuidZ3Centroid;
    private final TransformerFunction base64;
    private final TransformerFunction.NamedTransformerFunction md5;
    private final TransformerFunction.NamedTransformerFunction murmur3_32;
    private final TransformerFunction.NamedTransformerFunction murmur3_128;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        IdFunctionFactory idFunctionFactory = this;
        synchronized (idFunctionFactory) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Seq<TransformerFunction> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFunction[]{this.string2Bytes(), this.md5(), this.uuid(), this.uuidZ3(), this.uuidZ3Centroid(), this.base64(), this.murmur3_32(), this.murmur3_128()}));
    }

    private TransformerFunction string2Bytes() {
        return this.string2Bytes;
    }

    private TransformerFunction uuid() {
        return this.uuid;
    }

    private TransformerFunction uuidZ3() {
        return this.uuidZ3;
    }

    private TransformerFunction uuidZ3Centroid() {
        return this.uuidZ3Centroid;
    }

    private TransformerFunction base64() {
        return this.base64;
    }

    private TransformerFunction.NamedTransformerFunction md5() {
        return this.md5;
    }

    private TransformerFunction.NamedTransformerFunction murmur3_32() {
        return this.murmur3_32;
    }

    private TransformerFunction.NamedTransformerFunction murmur3_128() {
        return this.murmur3_128;
    }

    public IdFunctionFactory() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.string2Bytes = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string2bytes", "stringToBytes"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Object[] args) {
                return ((String)args[0]).getBytes(StandardCharsets.UTF_8);
            }
        });
        this.uuid = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] args) {
                return UUID.randomUUID().toString();
            }
        });
        this.uuidZ3 = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuidZ3"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdFunctionFactory $outer;

            public final Object apply(Object[] args) {
                String string;
                Point geom = (Point)args[0];
                Date date = (Date)args[1];
                Enumeration.Value interval = TimePeriod$.MODULE$.withName((String)args[2]);
                try {
                    string = Z3UuidGenerator$.MODULE$.createUuid(geom, date.getTime(), interval).toString();
                }
                catch (Throwable throwable) {
                    String string2;
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Invalid z3 values for UUID: {} {} {}: {}", new Object[]{geom, date, interval, e});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    string = string2 = UUID.randomUUID().toString();
                }
                return string;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.uuidZ3Centroid = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuidZ3Centroid"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdFunctionFactory $outer;

            public final Object apply(Object[] args) {
                String string;
                Geometry geom = (Geometry)args[0];
                Date date = (Date)args[1];
                Enumeration.Value interval = TimePeriod$.MODULE$.withName((String)args[2]);
                try {
                    string = Z3UuidGenerator$.MODULE$.createUuid(geom, date.getTime(), interval).toString();
                }
                catch (Throwable throwable) {
                    String string2;
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Invalid z3 values for UUID: {} {} {}: {}", new Object[]{geom, date, interval, e});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    string = string2 = UUID.randomUUID().toString();
                }
                return string;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.base64 = TransformerFunction$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"base64"}), (Function1<Object[], Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] args) {
                return Base64.encodeBase64URLSafeString((byte[])((byte[])args[0]));
            }
        });
        this.md5 = new TransformerFunction.NamedTransformerFunction(this){
            private final HashFunction hasher;

            private HashFunction hasher() {
                return this.hasher;
            }

            public Object eval(Object[] args, EvaluationContext ctx) {
                return this.hasher().hashBytes((byte[])args[0]).toString();
            }
            {
                this.hasher = Hashing.md5();
            }
        };
        this.murmur3_32 = new TransformerFunction.NamedTransformerFunction(this){
            private final HashFunction hasher;

            private HashFunction hasher() {
                return this.hasher;
            }

            public Object eval(Object[] args, EvaluationContext ctx) {
                return this.hasher().hashString((CharSequence)args[0].toString(), StandardCharsets.UTF_8);
            }
            {
                this.hasher = Hashing.murmur3_32();
            }
        };
        this.murmur3_128 = new TransformerFunction.NamedTransformerFunction(this){
            private final HashFunction hasher;

            private HashFunction hasher() {
                return this.hasher;
            }

            public Object eval(Object[] args, EvaluationContext ctx) {
                return BoxesRunTime.boxToLong((long)this.hasher().hashString((CharSequence)args[0].toString(), StandardCharsets.UTF_8).asLong());
            }
            {
                this.hasher = Hashing.murmur3_128();
            }
        };
    }
}

