/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.FeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFeatureCollectionWrapper;
import org.geotools.data.transform.TransformFeatureReaderWrapper;
import org.geotools.data.transform.TransformFeatureSource;
import org.geotools.data.transform.Transformer;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public class TransformFeatureStore
extends TransformFeatureSource
implements SimpleFeatureStore {
    protected SimpleFeatureStore store;
    protected Transformer invertedTransformer;

    public TransformFeatureStore(SimpleFeatureStore store, Name name, List<Definition> definitions) throws IOException {
        super(store, name, definitions);
        this.store = store;
        ArrayList<Definition> inverted = new ArrayList<Definition>();
        for (Definition definition : definitions) {
            List<Definition> inverses = definition.inverse();
            if (inverses == null) continue;
            inverted.addAll(inverses);
        }
        if (inverted.size() == 0) {
            throw new IllegalArgumentException("None of the expressions could be inverted, cannot create a writable transformer");
        }
        List<String> requiredAttributes = this.getRequiredAttributes((SimpleFeatureType)store.getSchema());
        for (Definition id : inverted) {
            requiredAttributes.remove(id.getName());
        }
        if (requiredAttributes.size() > 0) {
            throw new IllegalArgumentException("The inverted expressions do not cover some of the required attributes, cannot create a writable transformer. The missing mandatory attributes are: " + requiredAttributes);
        }
        this.invertedTransformer = new Transformer(this, store.getName(), inverted, (SimpleFeatureType)store.getSchema());
    }

    private List<String> getRequiredAttributes(SimpleFeatureType schema) {
        ArrayList<String> result = new ArrayList<String>();
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            if (ad.getMinOccurs() <= 0) continue;
            result.add(ad.getLocalName());
        }
        return result;
    }

    @Override
    public void setTransaction(Transaction transaction) {
        this.store.setTransaction(transaction);
    }

    @Override
    public Transaction getTransaction() {
        return this.store.getTransaction();
    }

    @Override
    public void removeFeatures(Filter filter) throws IOException {
        Filter transformed = this.transformer.transformFilter(filter);
        this.store.removeFeatures(transformed);
    }

    @Override
    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        TransformFeatureCollectionWrapper transformed = new TransformFeatureCollectionWrapper(collection, this.invertedTransformer);
        return this.store.addFeatures(transformed);
    }

    @Override
    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        TransformFeatureReaderWrapper rr = new TransformFeatureReaderWrapper(reader, this.invertedTransformer);
        this.store.setFeatures(rr);
    }

    @Override
    public void modifyFeatures(Name[] attributeNames, Object[] attributeValues, Filter filter) throws IOException {
        String[] simpleNames = new String[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            simpleNames[i] = attributeNames[i].getLocalPart();
        }
        this.modifyFeatures(simpleNames, attributeValues, filter);
    }

    @Override
    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        String[] simpleNames = new String[type.length];
        for (int i = 0; i < type.length; ++i) {
            simpleNames[i] = type[i].getLocalName();
        }
        this.modifyFeatures(simpleNames, value, filter);
    }

    @Override
    public void modifyFeatures(Name attributeName, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{attributeName}, new Object[]{attributeValue}, filter);
    }

    @Override
    public void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new AttributeDescriptor[]{type}, new Object[]{value}, filter);
    }

    @Override
    public void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new String[]{name}, new Object[]{attributeValue}, filter);
    }

    @Override
    public void modifyFeatures(String[] nameArray, Object[] attributeValues, Filter filter) throws IOException {
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(this.getSchema());
        for (int i = 0; i < nameArray.length; ++i) {
            fb.set(nameArray[i], attributeValues[i]);
        }
        SimpleFeature sample = fb.buildFeature(null);
        List<String> names = Arrays.asList(nameArray);
        HashMap<String, Object> invertedValueMap = new HashMap<String, Object>();
        for (Definition definition : this.transformer.getDefinitions()) {
            List<Definition> ids;
            if (!names.contains(definition.getName()) || (ids = definition.inverse()) == null) continue;
            for (Definition id : ids) {
                Object value = id.getExpression().evaluate((Object)sample);
                invertedValueMap.put(id.getName(), value);
            }
        }
        if (!invertedValueMap.isEmpty()) {
            String[] invertedNames = new String[invertedValueMap.size()];
            Object[] invertedValues = new Object[invertedValueMap.size()];
            int i = 0;
            Iterator<Definition> iterator = invertedValueMap.keySet().iterator();
            while (iterator.hasNext()) {
                String name;
                invertedNames[i] = name = (String)((Object)iterator.next());
                invertedValues[i] = invertedValueMap.get(name);
                ++i;
            }
            Filter txFilter = this.transformer.transformFilter(filter);
            this.store.modifyFeatures(invertedNames, invertedValues, txFilter);
        }
    }
}

