/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class ReverseRangeIterator
implements SequenceIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator {
    long start;
    long currentValue;
    long limit;

    public ReverseRangeIterator(long start, long end) throws XPathException {
        if (start - end > Integer.MAX_VALUE) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^31)", "XPDY0130");
        }
        this.start = start;
        this.currentValue = start + 1L;
        this.limit = end;
    }

    public boolean hasNext() {
        return this.currentValue > this.limit;
    }

    public IntegerValue next() {
        if (--this.currentValue < this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    public void close() {
    }

    public int getLength() {
        return (int)(this.start - this.limit + 1L);
    }

    public SequenceIterator getAnother() throws XPathException {
        return new ReverseRangeIterator(this.start, this.limit);
    }

    public int getProperties() {
        return 6;
    }

    public SequenceIterator getReverseIterator() {
        return new RangeIterator(this.limit, this.start);
    }
}

