/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;

public class EqualArea
extends MapProjection {
    static final double A1 = 1.340264;
    static final double A2 = -0.081106;
    static final double A3 = 8.93E-4;
    static final double A4 = 0.003796;
    static final double M = Math.sqrt(3.0) / 2.0;
    static final double EPSILON = 1.0E-11;
    static final int MAX_ITER = 12;
    static final double MAX_Y = 1.3173627591574;

    public EqualArea(ParameterValueGroup parameters) {
        super(parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double y6;
        double y2;
        double yc;
        block5: {
            if (y > 1.3173627591574) {
                y = 1.3173627591574;
            } else if (y < -1.3173627591574) {
                y = -1.3173627591574;
            }
            yc = y;
            int i = 12;
            do {
                y2 = yc * yc;
                y6 = y2 * y2 * y2;
                double f = yc * (1.340264 + -0.081106 * y2 + y6 * (8.93E-4 + 0.003796 * y2)) - y;
                double fder = 1.340264 + -0.24331799999999998 * y2 + y6 * (0.0062510000000000005 + 0.034164 * y2);
                double tol = f / fder;
                yc -= tol;
                if (Math.abs(tol) < 1.0E-11) break block5;
            } while (--i >= 0);
            throw new ProjectionException(129);
        }
        y2 = yc * yc;
        y6 = y2 * y2 * y2;
        double lam = M * x * (1.340264 + -0.24331799999999998 * y2 + y6 * (0.0062510000000000005 + 0.034164 * y2)) / Math.cos(yc);
        double phi = Math.asin(Math.sin(yc) / M);
        if (ptDst != null) {
            ptDst.setLocation(lam, phi);
            return ptDst;
        }
        return new Point2D.Double(lam, phi);
    }

    @Override
    protected Point2D transformNormalized(double lpLambda, double lpPhi, Point2D ptDst) throws ProjectionException {
        double phi = Math.asin(M * Math.sin(lpPhi));
        double phi2 = phi * phi;
        double phi6 = phi2 * phi2 * phi2;
        double x = lpLambda * Math.cos(phi) / (M * (1.340264 + -0.24331799999999998 * phi2 + phi6 * (0.0062510000000000005 + 0.034164 * phi2)));
        double y = phi * (1.340264 + -0.081106 * phi2 + phi6 * (8.93E-4 + 0.003796 * phi2));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -339526664946772642L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Equal Earth")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            return new EqualArea(parameters);
        }
    }
}

