/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.bin;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.locationtech.geomesa.utils.bin.AxisOrder$;
import org.locationtech.geomesa.utils.bin.BinaryOutputCallback;
import org.locationtech.geomesa.utils.bin.BinaryOutputCallback$class;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$RichTraversableOnce$;
import org.locationtech.geomesa.utils.geotools.AttributeSpec;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureSpecParser$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class BinaryOutputEncoder$
implements LazyLogging {
    public static final BinaryOutputEncoder$ MODULE$;
    private final SimpleFeatureType BinEncodedSft;
    private final int BIN_ATTRIBUTE_INDEX;
    private final Object org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$DateOrdering;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BinaryOutputEncoder$();
    }

    private Logger logger$lzycompute() {
        BinaryOutputEncoder$ binaryOutputEncoder$ = this;
        synchronized (binaryOutputEncoder$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeatureType BinEncodedSft() {
        return this.BinEncodedSft;
    }

    public int BIN_ATTRIBUTE_INDEX() {
        return this.BIN_ATTRIBUTE_INDEX;
    }

    public Object org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$DateOrdering() {
        return this.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$DateOrdering;
    }

    public BinaryOutputEncoder apply(SimpleFeatureType sft, BinaryOutputEncoder.EncodingOptions options) {
        return new BinaryOutputEncoder(this.toValues(sft, options));
    }

    public int convertToTrack(SimpleFeature f, int i) {
        return this.convertToTrack(f.getAttribute(i));
    }

    public int convertToTrack(Object track) {
        return track == null ? 0 : track.hashCode();
    }

    public long convertToDate(SimpleFeature f, int i) {
        return this.convertToDate((Date)f.getAttribute(i));
    }

    public long convertToDate(Date date) {
        return date == null ? 0L : date.getTime();
    }

    public long convertToLabel(SimpleFeature f, int i) {
        return this.convertToLabel(f.getAttribute(i));
    }

    public long convertToLabel(Object label) {
        long l;
        Object object = label;
        if (object == null) {
            l = 0L;
        } else if (object instanceof Number) {
            Number number = (Number)object;
            l = number.longValue();
        } else {
            LongRef sum = LongRef.create((long)0L);
            ScalaImplicits$RichTraversableOnce$.MODULE$.foreachIndex$extension(ScalaImplicits$.MODULE$.RichTraversableOnce(Predef$.MODULE$.byteArrayOps(label.toString().getBytes(StandardCharsets.UTF_8)).iterator().take(8)), new Serializable(sum){
                public static final long serialVersionUID = 0L;
                private final LongRef sum$1;

                public final void apply(byte x0$1, int x1$1) {
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)x0$1), (Object)BoxesRunTime.boxToInteger((int)x1$1));
                    if (tuple2 != null) {
                        byte b = BoxesRunTime.unboxToByte((Object)tuple2._1());
                        int i = tuple2._2$mcI$sp();
                        this.sum$1.elem += ((long)b & 0xFFL) << 8 * i;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.sum$1 = sum$1;
                }
            });
            l = sum.elem;
        }
        return l;
    }

    public void decode(byte[] encoded, BinaryOutputCallback callback) {
        ByteBuffer buf = ByteBuffer.wrap(encoded).order(ByteOrder.LITTLE_ENDIAN);
        int trackId = buf.getInt();
        long time2 = (long)buf.getInt() * 1000L;
        float lat = buf.getFloat();
        float lon = buf.getFloat();
        if (encoded.length > 16) {
            long label = buf.getLong();
            callback.apply(trackId, lat, lon, time2, label);
        } else {
            callback.apply(trackId, lat, lon, time2);
        }
    }

    public BinaryOutputEncoder.EncodedValues decode(byte[] encoded) {
        ObjectRef values = ObjectRef.create(null);
        this.decode(encoded, new BinaryOutputCallback(values){
            private final ObjectRef values$1;

            public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg) {
                BinaryOutputCallback$class.put(this, buffer, trackId, lat, lon, dtg);
            }

            public void put(ByteBuffer buffer, int trackId, float lat, float lon, long dtg, long label) {
                BinaryOutputCallback$class.put(this, buffer, trackId, lat, lon, dtg, label);
            }

            public void apply(int trackId, float lat, float lon, long dtg) {
                this.values$1.elem = new BinaryOutputEncoder.EncodedValues(trackId, lat, lon, dtg, -1L);
            }

            public void apply(int trackId, float lat, float lon, long dtg, long label) {
                this.values$1.elem = new BinaryOutputEncoder.EncodedValues(trackId, lat, lon, dtg, label);
            }
            {
                this.values$1 = values$1;
                BinaryOutputCallback$class.$init$(this);
            }
        });
        return (BinaryOutputEncoder.EncodedValues)values.elem;
    }

    private BinaryOutputEncoder.ToValues toValues(SimpleFeatureType sft, BinaryOutputEncoder.EncodingOptions options) {
        Tuple2.mcZZ.sp sp2;
        block7: {
            block9: {
                Option<Object> option2;
                block12: {
                    Tuple2 tuple2;
                    block29: {
                        Option option3;
                        block32: {
                            BinaryOutputEncoder.ToValues toValues2;
                            block21: {
                                BinaryOutputEncoder.ToValues toValues3;
                                block31: {
                                    Serializable getLatLon;
                                    Serializable getTrackId;
                                    int dtgIndex;
                                    block30: {
                                        Object object;
                                        Option getLabelOption;
                                        block26: {
                                            int geomIndex;
                                            block28: {
                                                block27: {
                                                    block25: {
                                                        boolean isPoint;
                                                        Enumeration.Value axisOrder;
                                                        block13: {
                                                            Enumeration.Value value2;
                                                            block16: {
                                                                Option option4;
                                                                block24: {
                                                                    BinaryOutputEncoder.ToValues toValues4;
                                                                    block23: {
                                                                        Serializable getLineDtg;
                                                                        Serializable getLineLatLon;
                                                                        block22: {
                                                                            block17: {
                                                                                Option option5;
                                                                                block20: {
                                                                                    BinaryOutputEncoder.ToValues toValues5;
                                                                                    block19: {
                                                                                        block18: {
                                                                                            Object object2;
                                                                                            boolean isSingleDate;
                                                                                            block15: {
                                                                                                block14: {
                                                                                                    Object object3;
                                                                                                    boolean isLineString;
                                                                                                    block11: {
                                                                                                        block10: {
                                                                                                            block8: {
                                                                                                                Tuple2.mcZZ.sp sp3;
                                                                                                                Class binding;
                                                                                                                geomIndex = BoxesRunTime.unboxToInt((Object)options.geomField().getOrElse((Function0)new Serializable(sft){
                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                    private final SimpleFeatureType sft$1;

                                                                                                                    public final int apply() {
                                                                                                                        return this.apply$mcI$sp();
                                                                                                                    }

                                                                                                                    public int apply$mcI$sp() {
                                                                                                                        return RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
                                                                                                                    }
                                                                                                                    {
                                                                                                                        this.sft$1 = sft$1;
                                                                                                                    }
                                                                                                                }));
                                                                                                                if (geomIndex == -1) {
                                                                                                                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid geometry field requested for feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                                                                                                                }
                                                                                                                dtgIndex = BoxesRunTime.unboxToInt((Object)options.dtgField().orElse((Function0)new Serializable(sft){
                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                    private final SimpleFeatureType sft$1;

                                                                                                                    public final Option<Object> apply() {
                                                                                                                        return RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
                                                                                                                    }
                                                                                                                    {
                                                                                                                        this.sft$1 = sft$1;
                                                                                                                    }
                                                                                                                }).getOrElse((Function0)new Serializable(){
                                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                                    public final int apply() {
                                                                                                                        return this.apply$mcI$sp();
                                                                                                                    }

                                                                                                                    public int apply$mcI$sp() {
                                                                                                                        return -1;
                                                                                                                    }
                                                                                                                }));
                                                                                                                if (dtgIndex == -1) {
                                                                                                                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid date field requested for feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                                                                                                                }
                                                                                                                isSingleDate = Date.class.isAssignableFrom(sft.getDescriptor(dtgIndex).getType().getBinding());
                                                                                                                axisOrder = (Enumeration.Value)options.axisOrder().getOrElse((Function0)new Serializable(){
                                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                                    public final Enumeration.Value apply() {
                                                                                                                        return AxisOrder$.MODULE$.LonLat();
                                                                                                                    }
                                                                                                                });
                                                                                                                Class clazz = binding = sft.getDescriptor(geomIndex).getType().getBinding();
                                                                                                                Class<Point> clazz2 = Point.class;
                                                                                                                Class clazz3 = binding;
                                                                                                                Class<LineString> clazz4 = LineString.class;
                                                                                                                sp2 = new Tuple2.mcZZ.sp(!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null), !(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null));
                                                                                                                if (sp2 == null) break block7;
                                                                                                                boolean isPoint2 = sp2._1$mcZ$sp();
                                                                                                                boolean isLineString2 = sp2._2$mcZ$sp();
                                                                                                                Tuple2.mcZZ.sp sp4 = sp3 = new Tuple2.mcZZ.sp(isPoint2, isLineString2);
                                                                                                                isPoint = sp4._1$mcZ$sp();
                                                                                                                isLineString = sp4._2$mcZ$sp();
                                                                                                                if (options.trackIdField().exists((Function1)new Serializable(){
                                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                                    public final boolean apply(int x$4) {
                                                                                                                        return this.apply$mcZI$sp(x$4);
                                                                                                                    }

                                                                                                                    public boolean apply$mcZI$sp(int x$4) {
                                                                                                                        return x$4 == -1;
                                                                                                                    }
                                                                                                                })) {
                                                                                                                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid track field requested for feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                                                                                                                }
                                                                                                                if (options.labelField().exists((Function1)new Serializable(){
                                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                                    public final boolean apply(int x$5) {
                                                                                                                        return this.apply$mcZI$sp(x$5);
                                                                                                                    }

                                                                                                                    public boolean apply$mcZI$sp(int x$5) {
                                                                                                                        return x$5 == -1;
                                                                                                                    }
                                                                                                                })) {
                                                                                                                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid label field requested for feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                                                                                                                }
                                                                                                                if (isSingleDate) break block8;
                                                                                                                if (!isLineString) break block9;
                                                                                                                String dtgField = sft.getDescriptor(dtgIndex).getLocalName();
                                                                                                                Seq<AttributeSpec> sftAttributes = SimpleFeatureSpecParser$.MODULE$.parse(SimpleFeatureTypes$.MODULE$.encodeType(sft), SimpleFeatureSpecParser$.MODULE$.parse$default$2()).attributes();
                                                                                                                sftAttributes.find((Function1)new Serializable(dtgField){
                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                    private final String dtgField$1;

                                                                                                                    public final boolean apply(AttributeSpec x$6) {
                                                                                                                        String string2 = x$6.name();
                                                                                                                        String string3 = this.dtgField$1;
                                                                                                                        return !(string2 != null ? !string2.equals(string3) : string3 != null);
                                                                                                                    }
                                                                                                                    {
                                                                                                                        this.dtgField$1 = dtgField$1;
                                                                                                                    }
                                                                                                                }).foreach((Function1)new Serializable(sft){
                                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                                    private final SimpleFeatureType sft$1;

                                                                                                                    public final void apply(AttributeSpec spec2) {
                                                                                                                        if (spec2 instanceof AttributeSpec.ListAttributeSpec && Date.class.isAssignableFrom(((AttributeSpec.ListAttributeSpec)spec2).subClass())) {
                                                                                                                            return;
                                                                                                                        }
                                                                                                                        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid date field requested for feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sft$1.getTypeName()})));
                                                                                                                    }
                                                                                                                    {
                                                                                                                        this.sft$1 = sft$1;
                                                                                                                    }
                                                                                                                });
                                                                                                            }
                                                                                                            if (!None$.MODULE$.equals(option2 = options.trackIdField())) break block10;
                                                                                                            object3 = new Serializable(){
                                                                                                                public static final long serialVersionUID = 0L;

                                                                                                                public final int apply(SimpleFeature f) {
                                                                                                                    return f.getID().hashCode();
                                                                                                                }
                                                                                                            };
                                                                                                            break block11;
                                                                                                        }
                                                                                                        if (!(option2 instanceof Some)) break block12;
                                                                                                        Some some = (Some)option2;
                                                                                                        int trackId = BoxesRunTime.unboxToInt((Object)some.x());
                                                                                                        object3 = new Serializable(trackId){
                                                                                                            public static final long serialVersionUID = 0L;
                                                                                                            private final int trackId$1;

                                                                                                            public final int apply(SimpleFeature x$7) {
                                                                                                                return BinaryOutputEncoder$.MODULE$.convertToTrack(x$7, this.trackId$1);
                                                                                                            }
                                                                                                            {
                                                                                                                this.trackId$1 = trackId$1;
                                                                                                            }
                                                                                                        };
                                                                                                    }
                                                                                                    getTrackId = object3;
                                                                                                    getLabelOption = options.labelField().map((Function1)new Serializable(){
                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                        public final Function1<SimpleFeature, Object> apply(int labelIndex) {
                                                                                                            return new Serializable(this, labelIndex){
                                                                                                                public static final long serialVersionUID = 0L;
                                                                                                                private final int labelIndex$1;

                                                                                                                public final long apply(SimpleFeature x$8) {
                                                                                                                    return BinaryOutputEncoder$.MODULE$.convertToLabel(x$8, this.labelIndex$1);
                                                                                                                }
                                                                                                                {
                                                                                                                    this.labelIndex$1 = labelIndex$1;
                                                                                                                }
                                                                                                            };
                                                                                                        }
                                                                                                    });
                                                                                                    if (!isLineString) break block13;
                                                                                                    value2 = axisOrder;
                                                                                                    Enumeration.Value value3 = AxisOrder$.MODULE$.LatLon();
                                                                                                    Enumeration.Value value4 = value2;
                                                                                                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block14;
                                                                                                    object2 = new Serializable(geomIndex){
                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                        private final int geomIndex$1;

                                                                                                        public final Tuple2<Object, Object>[] apply(SimpleFeature x$9) {
                                                                                                            return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$lineToXY(x$9, this.geomIndex$1);
                                                                                                        }
                                                                                                        {
                                                                                                            this.geomIndex$1 = geomIndex$1;
                                                                                                        }
                                                                                                    };
                                                                                                    break block15;
                                                                                                }
                                                                                                Enumeration.Value value5 = AxisOrder$.MODULE$.LonLat();
                                                                                                Enumeration.Value value6 = value2;
                                                                                                if (value5 != null ? !value5.equals(value6) : value6 != null) break block16;
                                                                                                object2 = new Serializable(geomIndex){
                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                    private final int geomIndex$1;

                                                                                                    public final Tuple2<Object, Object>[] apply(SimpleFeature x$10) {
                                                                                                        return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$lineToYX(x$10, this.geomIndex$1);
                                                                                                    }
                                                                                                    {
                                                                                                        this.geomIndex$1 = geomIndex$1;
                                                                                                    }
                                                                                                };
                                                                                            }
                                                                                            getLineLatLon = object2;
                                                                                            if (!isSingleDate) break block17;
                                                                                            option5 = getLabelOption;
                                                                                            if (!None$.MODULE$.equals(option5)) break block18;
                                                                                            toValues5 = new BinaryOutputEncoder.ToValuesLines((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>[]>)getLineLatLon, dtgIndex);
                                                                                            break block19;
                                                                                        }
                                                                                        if (!(option5 instanceof Some)) break block20;
                                                                                        Some some = (Some)option5;
                                                                                        Function1 getLabel = (Function1)some.x();
                                                                                        toValues5 = new BinaryOutputEncoder.ToValuesLinesLabels((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>[]>)getLineLatLon, (Function1<SimpleFeature, Object>)getLabel, dtgIndex);
                                                                                    }
                                                                                    toValues2 = toValues5;
                                                                                    break block21;
                                                                                }
                                                                                throw new MatchError((Object)option5);
                                                                            }
                                                                            getLineDtg = new Serializable(dtgIndex){
                                                                                public static final long serialVersionUID = 0L;
                                                                                private final int dtgIndex$1;

                                                                                public final long[] apply(SimpleFeature x$11) {
                                                                                    return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$dateArray(x$11, this.dtgIndex$1);
                                                                                }
                                                                                {
                                                                                    this.dtgIndex$1 = dtgIndex$1;
                                                                                }
                                                                            };
                                                                            option4 = getLabelOption;
                                                                            if (!None$.MODULE$.equals(option4)) break block22;
                                                                            toValues4 = new BinaryOutputEncoder.ToValuesLinesDates((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>[]>)getLineLatLon, (Function1<SimpleFeature, long[]>)getLineDtg);
                                                                            break block23;
                                                                        }
                                                                        if (!(option4 instanceof Some)) break block24;
                                                                        Some some = (Some)option4;
                                                                        Function1 getLabel = (Function1)some.x();
                                                                        toValues4 = new BinaryOutputEncoder.ToValuesLinesDatesLabels((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>[]>)getLineLatLon, (Function1<SimpleFeature, long[]>)getLineDtg, (Function1<SimpleFeature, Object>)getLabel);
                                                                    }
                                                                    toValues2 = toValues4;
                                                                    break block21;
                                                                }
                                                                throw new MatchError((Object)option4);
                                                            }
                                                            throw new MatchError((Object)value2);
                                                        }
                                                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isPoint), (Object)axisOrder);
                                                        if (tuple2 == null) break block25;
                                                        boolean bl = tuple2._1$mcZ$sp();
                                                        Enumeration.Value value7 = (Enumeration.Value)tuple2._2();
                                                        if (!bl) break block25;
                                                        Enumeration.Value value8 = AxisOrder$.MODULE$.LatLon();
                                                        Enumeration.Value value9 = value7;
                                                        if (value8 != null ? !value8.equals(value9) : value9 != null) break block25;
                                                        object = new Serializable(geomIndex){
                                                            public static final long serialVersionUID = 0L;
                                                            private final int geomIndex$1;

                                                            public final Tuple2<Object, Object> apply(SimpleFeature x$12) {
                                                                return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToXY(x$12, this.geomIndex$1);
                                                            }
                                                            {
                                                                this.geomIndex$1 = geomIndex$1;
                                                            }
                                                        };
                                                        break block26;
                                                    }
                                                    if (tuple2 == null) break block27;
                                                    boolean bl = tuple2._1$mcZ$sp();
                                                    Enumeration.Value value10 = (Enumeration.Value)tuple2._2();
                                                    if (!bl) break block27;
                                                    Enumeration.Value value11 = AxisOrder$.MODULE$.LonLat();
                                                    Enumeration.Value value12 = value10;
                                                    if (value11 != null ? !value11.equals(value12) : value12 != null) break block27;
                                                    object = new Serializable(geomIndex){
                                                        public static final long serialVersionUID = 0L;
                                                        private final int geomIndex$1;

                                                        public final Tuple2<Object, Object> apply(SimpleFeature x$13) {
                                                            return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToYX(x$13, this.geomIndex$1);
                                                        }
                                                        {
                                                            this.geomIndex$1 = geomIndex$1;
                                                        }
                                                    };
                                                    break block26;
                                                }
                                                if (tuple2 == null) break block28;
                                                boolean bl = tuple2._1$mcZ$sp();
                                                Enumeration.Value value13 = (Enumeration.Value)tuple2._2();
                                                if (bl) break block28;
                                                Enumeration.Value value14 = AxisOrder$.MODULE$.LatLon();
                                                Enumeration.Value value15 = value13;
                                                if (value14 != null ? !value14.equals(value15) : value15 != null) break block28;
                                                object = new Serializable(geomIndex){
                                                    public static final long serialVersionUID = 0L;
                                                    private final int geomIndex$1;

                                                    public final Tuple2<Object, Object> apply(SimpleFeature x$14) {
                                                        return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$geomToXY(x$14, this.geomIndex$1);
                                                    }
                                                    {
                                                        this.geomIndex$1 = geomIndex$1;
                                                    }
                                                };
                                                break block26;
                                            }
                                            if (tuple2 == null) break block29;
                                            boolean bl = tuple2._1$mcZ$sp();
                                            Enumeration.Value value16 = (Enumeration.Value)tuple2._2();
                                            if (bl) break block29;
                                            Enumeration.Value value17 = AxisOrder$.MODULE$.LonLat();
                                            Enumeration.Value value18 = value16;
                                            if (value17 != null ? !value17.equals(value18) : value18 != null) break block29;
                                            object = new Serializable(geomIndex){
                                                public static final long serialVersionUID = 0L;
                                                private final int geomIndex$1;

                                                public final Tuple2<Object, Object> apply(SimpleFeature x$15) {
                                                    return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$geomToYX(x$15, this.geomIndex$1);
                                                }
                                                {
                                                    this.geomIndex$1 = geomIndex$1;
                                                }
                                            };
                                        }
                                        getLatLon = object;
                                        option3 = getLabelOption;
                                        if (!None$.MODULE$.equals(option3)) break block30;
                                        toValues3 = new BinaryOutputEncoder.ToValuesPoints((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>>)getLatLon, dtgIndex);
                                        break block31;
                                    }
                                    if (!(option3 instanceof Some)) break block32;
                                    Some some = (Some)option3;
                                    Function1 getLabel = (Function1)some.x();
                                    toValues3 = new BinaryOutputEncoder.ToValuesPointsLabels((Function1<SimpleFeature, Object>)getTrackId, (Function1<SimpleFeature, Tuple2<Object, Object>>)getLatLon, (Function1<SimpleFeature, Object>)getLabel, dtgIndex);
                                }
                                toValues2 = toValues3;
                            }
                            return toValues2;
                        }
                        throw new MatchError((Object)option3);
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError(option2);
            }
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid date field requested for feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
        }
        throw new MatchError((Object)sp2);
    }

    public Tuple2<Object, Object> org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToXY(Point p) {
        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)((float)p.getX())), (Object)BoxesRunTime.boxToFloat((float)((float)p.getY())));
    }

    public Tuple2<Object, Object> org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToYX(Point p) {
        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)((float)p.getY())), (Object)BoxesRunTime.boxToFloat((float)((float)p.getX())));
    }

    public Tuple2<Object, Object> org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToXY(SimpleFeature f, int i) {
        return this.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToXY((Point)f.getAttribute(i));
    }

    public Tuple2<Object, Object> org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToYX(SimpleFeature f, int i) {
        return this.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToYX((Point)f.getAttribute(i));
    }

    public Tuple2<Object, Object> org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$geomToXY(SimpleFeature f, int i) {
        return this.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToXY(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)f.getAttribute(i))));
    }

    public Tuple2<Object, Object> org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$geomToYX(SimpleFeature f, int i) {
        return this.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToYX(Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)f.getAttribute(i))));
    }

    public Tuple2<Object, Object>[] org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$lineToXY(SimpleFeature f, int i) {
        LineString line = (LineString)f.getAttribute(i);
        return (Tuple2[])Array$.MODULE$.tabulate(line.getNumPoints(), (Function1)new Serializable(line){
            public static final long serialVersionUID = 0L;
            private final LineString line$1;

            public final Tuple2<Object, Object> apply(int i) {
                return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToXY(this.line$1.getPointN(i));
            }
            {
                this.line$1 = line$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Tuple2<Object, Object>[] org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$lineToYX(SimpleFeature f, int i) {
        LineString line = (LineString)f.getAttribute(i);
        return (Tuple2[])Array$.MODULE$.tabulate(line.getNumPoints(), (Function1)new Serializable(line){
            public static final long serialVersionUID = 0L;
            private final LineString line$2;

            public final Tuple2<Object, Object> apply(int i) {
                return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$pointToYX(this.line$2.getPointN(i));
            }
            {
                this.line$2 = line$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public long[] org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$dateArray(SimpleFeature f, int i) {
        List dates = (List)f.getAttribute(i);
        return dates == null ? (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.Long()) : (long[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(dates).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Date x$16) {
                return x$16.getTime();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
    }

    private BinaryOutputEncoder$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.BinEncodedSft = SimpleFeatureTypes$.MODULE$.createType("bin", "bin:Bytes,*geom:Point:srid=4326");
        this.BIN_ATTRIBUTE_INDEX = 0;
        this.org$locationtech$geomesa$utils$bin$BinaryOutputEncoder$$DateOrdering = new Ordering<byte[]>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<byte[]> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, byte[]> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(byte[] x, byte[] y) {
                int compare1 = Ordering.Byte$.MODULE$.compare(x[4], y[4]);
                if (compare1 != 0) {
                    return compare1;
                }
                int compare2 = Ordering.Byte$.MODULE$.compare(x[5], y[5]);
                if (compare2 != 0) {
                    return compare2;
                }
                int compare3 = Ordering.Byte$.MODULE$.compare(x[6], y[6]);
                if (compare3 != 0) {
                    return compare3;
                }
                return Ordering.Byte$.MODULE$.compare(x[7], y[7]);
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
    }
}

