/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import java.util.NoSuchElementException;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeoHash$;
import org.locationtech.geomesa.utils.geohash.TwoGeoHashBoundingBox;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\t\u0011\"i\\;oI&twMQ8y'\u0006l\u0007\u000f\\3s\u0015\t\u0019A!A\u0004hK>D\u0017m\u001d5\u000b\u0005\u00151\u0011!B;uS2\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0019Q#\b\u0011\u000f\u0005YYbBA\f\u001b\u001b\u0005A\"BA\r\r\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u001d!\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0010 \u0005!IE/\u001a:bi>\u0014(B\u0001\u000f\u0011!\t\t#%D\u0001\u0003\u0013\t\u0019#AA\u0004HK>D\u0015m\u001d5\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\nQ\u0001^<p\u000f\"\u0004\"!I\u0014\n\u0005!\u0012!!\u0006+x_\u001e+w\u000eS1tQ\n{WO\u001c3j]\u001e\u0014u\u000e\u001f\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051j\u0003CA\u0011\u0001\u0011\u0015)\u0013\u00061\u0001'\u0011\u001dy\u0003A1A\u0005\u0002A\nAA]1oIV\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025!\u0005!Q\u000f^5m\u0013\t14G\u0001\u0004SC:$w.\u001c\u0005\u0007q\u0001\u0001\u000b\u0011B\u0019\u0002\u000bI\fg\u000e\u001a\u0011\t\u0015i\u0002\u0001\u0013!A\u0002B\u0003%1(A\u0002yIE\u0002Ba\u0004\u001f?}%\u0011Q\b\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005=y\u0014B\u0001!\u0011\u0005\rIe\u000e\u001e\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0003!a\u0017\r^*uKB\u001cX#\u0001 \t\r\u0015\u0003\u0001\u0015!\u0003?\u0003%a\u0017\r^*uKB\u001c\b\u0005C\u0004H\u0001\t\u0007I\u0011A\"\u0002\u00111|gn\u0015;faNDa!\u0013\u0001!\u0002\u0013q\u0014!\u00037p]N#X\r]:!\u0011\u001dY\u0005A1A\u0005\u0002\r\u000b\u0011B\\;n!>Lg\u000e^:\t\r5\u0003\u0001\u0015!\u0003?\u0003)qW/\u001c)pS:$8\u000f\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0003\u0011)8/\u001a3\u0016\u0003E\u00032AU,Z\u001b\u0005\u0019&B\u0001+V\u0003\u001diW\u000f^1cY\u0016T!A\u0016\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Y'\n9\u0001*Y:i'\u0016$\bC\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011a\u0017M\\4\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\b\u0013:$XmZ3s\u0011\u0019\u0011\u0007\u0001)A\u0005#\u0006)Qo]3eA!)A\r\u0001C!K\u00069\u0001.Y:OKb$X#\u00014\u0011\u0005=9\u0017B\u00015\u0011\u0005\u001d\u0011un\u001c7fC:DQA\u001b\u0001\u0005F-\fAA\\3yiR\t\u0001\u0005\u000b\u0002j[B\u0011a.]\u0007\u0002_*\u0011\u0001\u000fE\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:p\u0005\u001d!\u0018-\u001b7sK\u000e\u0004")
public class BoundingBoxSampler
implements Iterator<GeoHash> {
    private final TwoGeoHashBoundingBox twoGh;
    private final Random rand;
    private final /* synthetic */ Tuple2 x$1;
    private final int latSteps;
    private final int lonSteps;
    private final int numPoints;
    private final HashSet<Integer> used;

    public Iterator<GeoHash> seq() {
        return Iterator.class.seq((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.class.isEmpty((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.class.isTraversableAgain((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.class.hasDefiniteSize((Iterator)this);
    }

    public Iterator<GeoHash> take(int n) {
        return Iterator.class.take((Iterator)this, (int)n);
    }

    public Iterator<GeoHash> drop(int n) {
        return Iterator.class.drop((Iterator)this, (int)n);
    }

    public Iterator<GeoHash> slice(int from, int until) {
        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<GeoHash, B> f) {
        return Iterator.class.map((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.class.$plus$plus((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<GeoHash, GenTraversableOnce<B>> f) {
        return Iterator.class.flatMap((Iterator)this, f);
    }

    public Iterator<GeoHash> filter(Function1<GeoHash, Object> p) {
        return Iterator.class.filter((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<GeoHash, B, Object> p) {
        return Iterator.class.corresponds((Iterator)this, that, p);
    }

    public Iterator<GeoHash> withFilter(Function1<GeoHash, Object> p) {
        return Iterator.class.withFilter((Iterator)this, p);
    }

    public Iterator<GeoHash> filterNot(Function1<GeoHash, Object> p) {
        return Iterator.class.filterNot((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<GeoHash, B> pf) {
        return Iterator.class.collect((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, GeoHash, B> op) {
        return Iterator.class.scanLeft((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<GeoHash, B, B> op) {
        return Iterator.class.scanRight((Iterator)this, z, op);
    }

    public Iterator<GeoHash> takeWhile(Function1<GeoHash, Object> p) {
        return Iterator.class.takeWhile((Iterator)this, p);
    }

    public Tuple2<Iterator<GeoHash>, Iterator<GeoHash>> partition(Function1<GeoHash, Object> p) {
        return Iterator.class.partition((Iterator)this, p);
    }

    public Tuple2<Iterator<GeoHash>, Iterator<GeoHash>> span(Function1<GeoHash, Object> p) {
        return Iterator.class.span((Iterator)this, p);
    }

    public Iterator<GeoHash> dropWhile(Function1<GeoHash, Object> p) {
        return Iterator.class.dropWhile((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<GeoHash, B>> zip(Iterator<B> that) {
        return Iterator.class.zip((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.class.padTo((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<GeoHash, Object>> zipWithIndex() {
        return Iterator.class.zipWithIndex((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<GeoHash, U> f) {
        Iterator.class.foreach((Iterator)this, f);
    }

    public boolean forall(Function1<GeoHash, Object> p) {
        return Iterator.class.forall((Iterator)this, p);
    }

    public boolean exists(Function1<GeoHash, Object> p) {
        return Iterator.class.exists((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.class.contains((Iterator)this, (Object)elem);
    }

    public Option<GeoHash> find(Function1<GeoHash, Object> p) {
        return Iterator.class.find((Iterator)this, p);
    }

    public int indexWhere(Function1<GeoHash, Object> p) {
        return Iterator.class.indexWhere((Iterator)this, p);
    }

    public <B> int indexOf(B elem) {
        return Iterator.class.indexOf((Iterator)this, elem);
    }

    public BufferedIterator<GeoHash> buffered() {
        return Iterator.class.buffered((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size2) {
        return Iterator.class.grouped((Iterator)this, (int)size2);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
        return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
    }

    public int length() {
        return Iterator.class.length((Iterator)this);
    }

    public Tuple2<Iterator<GeoHash>, Iterator<GeoHash>> duplicate() {
        return Iterator.class.duplicate((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.class.sameElements((Iterator)this, that);
    }

    public Traversable<GeoHash> toTraversable() {
        return Iterator.class.toTraversable((Iterator)this);
    }

    public Iterator<GeoHash> toIterator() {
        return Iterator.class.toIterator((Iterator)this);
    }

    public Stream<GeoHash> toStream() {
        return Iterator.class.toStream((Iterator)this);
    }

    public String toString() {
        return Iterator.class.toString((Iterator)this);
    }

    public <B> int sliding$default$2() {
        return Iterator.class.sliding$default$2((Iterator)this);
    }

    public List<GeoHash> reversed() {
        return TraversableOnce.class.reversed((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.class.size((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
    }

    public int count(Function1<GeoHash, Object> p) {
        return TraversableOnce.class.count((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<GeoHash, B> pf) {
        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, GeoHash, B> op) {
        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<GeoHash, B, B> op) {
        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, GeoHash, B> op) {
        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<GeoHash, B, B> op) {
        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, GeoHash, B> op) {
        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<GeoHash, B, B> op) {
        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, GeoHash, B> op) {
        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<GeoHash, B, B> op) {
        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, GeoHash, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
    }

    public List<GeoHash> toList() {
        return TraversableOnce.class.toList((TraversableOnce)this);
    }

    public Iterable<GeoHash> toIterable() {
        return TraversableOnce.class.toIterable((TraversableOnce)this);
    }

    public Seq<GeoHash> toSeq() {
        return TraversableOnce.class.toSeq((TraversableOnce)this);
    }

    public IndexedSeq<GeoHash> toIndexedSeq() {
        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.class.toBuffer((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.class.toSet((TraversableOnce)this);
    }

    public Vector<GeoHash> toVector() {
        return TraversableOnce.class.toVector((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, GeoHash, Col> cbf) {
        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<GeoHash, Tuple2<T, U>> ev) {
        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.class.mkString((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
    }

    public Random rand() {
        return this.rand;
    }

    public int latSteps() {
        return this.latSteps;
    }

    public int lonSteps() {
        return this.lonSteps;
    }

    public int numPoints() {
        return this.numPoints;
    }

    private HashSet<Integer> used() {
        return this.used;
    }

    public boolean hasNext() {
        return this.used().size() < this.numPoints();
    }

    public final GeoHash next() {
        while (this.hasNext()) {
            int idx = this.rand().nextInt(this.numPoints());
            while (this.used().contains((Object)Predef$.MODULE$.int2Integer(idx))) {
                idx = this.rand().nextInt(this.numPoints());
            }
            this.used().add((Object)Predef$.MODULE$.int2Integer(idx));
            GeoHash gh = GeoHash$.MODULE$.composeGeoHashFromBitIndicesAndPrec(GeoHash$.MODULE$.gridIndexForLatitude(this.twoGh.ll()) + (long)(idx / this.lonSteps()), GeoHash$.MODULE$.gridIndexForLongitude(this.twoGh.ll()) + (long)(idx % this.lonSteps()), this.twoGh.ll().prec());
            if (!this.twoGh.bbox().covers(gh.bbox())) continue;
            return gh;
        }
        throw new NoSuchElementException("No more points available.");
    }

    public BoundingBoxSampler(TwoGeoHashBoundingBox twoGh) {
        this.twoGh = twoGh;
        TraversableOnce.class.$init$((TraversableOnce)this);
        Iterator.class.$init$((Iterator)this);
        this.rand = new Random();
        Tuple2<Object, Object> tuple2 = GeoHash$.MODULE$.getLatitudeLongitudeSpanCount(twoGh.ll(), twoGh.ur(), twoGh.prec());
        if (tuple2 != null) {
            int latSteps = tuple2._1$mcI$sp();
            int lonSteps = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(latSteps, lonSteps);
            this.x$1 = sp2;
            this.latSteps = this.x$1._1$mcI$sp();
            this.lonSteps = this.x$1._2$mcI$sp();
            this.numPoints = this.latSteps() * this.lonSteps();
            Predef$.MODULE$.require(this.numPoints() <= Integer.MAX_VALUE, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Bounding box too big, cannot sample.";
                }
            });
            Predef$.MODULE$.require(this.numPoints() > 1, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Only one point in bounding box, cannot sample.";
                }
            });
            this.used = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
            return;
        }
        throw new MatchError(tuple2);
    }
}

