/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZUtils;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.locationtech.geomesa.utils.io.PathUtils;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.HadoopDelegate;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

public final class PathUtils$
implements FileSystemDelegate,
LazyLogging {
    public static final PathUtils$ MODULE$;
    private final Pattern uriRegex;
    private final boolean hadoopAvailable;
    private final LocalDelegate localDelegate;
    private final HadoopDelegate hadoopDelegate;
    private final AtomicBoolean factorySet;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PathUtils$();
    }

    private Logger logger$lzycompute() {
        PathUtils$ pathUtils$ = this;
        synchronized (pathUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Pattern uriRegex() {
        return this.uriRegex;
    }

    private boolean hadoopAvailable() {
        return this.hadoopAvailable;
    }

    private LocalDelegate localDelegate() {
        return this.localDelegate;
    }

    private HadoopDelegate hadoopDelegate() {
        return this.hadoopDelegate;
    }

    private AtomicBoolean factorySet() {
        return this.factorySet;
    }

    public void configureURLFactory() {
        if (this.factorySet().compareAndSet(false, true)) {
            try {
                BoxedUnit boxedUnit;
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory());
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Configured Hadoop URL Factory.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Could not register Hadoop URL Factory.  Some filesystems may not be available.");
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public boolean isRemote(String path) {
        return this.uriRegex().matcher(path).matches() && !path.toLowerCase().startsWith("file://");
    }

    public URL getUrl(String path) {
        try {
            URL uRL;
            if (this.isRemote(path)) {
                this.configureURLFactory();
                uRL = new URL(path);
            } else {
                uRL = new File(path).toURI().toURL();
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid URL ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), malformedURLException);
        }
    }

    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        return this.chooseDelegate(path).interpretPath(path);
    }

    public InputStream handleCompression(InputStream is, String filename) {
        return GzipUtils.isCompressedFilename((String)filename) ? new GZIPInputStream(new BufferedInputStream(is)) : (BZip2Utils.isCompressedFilename((String)filename) ? new BZip2CompressorInputStream((InputStream)new BufferedInputStream(is)) : (XZUtils.isCompressedFilename((String)filename) ? new XZCompressorInputStream((InputStream)new BufferedInputStream(is)) : new BufferedInputStream(is)));
    }

    public void deleteRecursively(Path f) {
        Files.walkFileTree(f, new PathUtils.DeleteFileVisitor());
    }

    private FileSystemDelegate chooseDelegate(String path) {
        return this.hadoopAvailable() && this.uriRegex().matcher(path).matches() ? this.hadoopDelegate() : this.localDelegate();
    }

    private PathUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.uriRegex = Pattern.compile("\\w+://.*");
        this.hadoopAvailable = Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<Object> apply() {
                return Class.forName("org.apache.hadoop.conf.Configuration");
            }
        }).isSuccess();
        this.localDelegate = new LocalDelegate();
        this.hadoopDelegate = this.hadoopAvailable() ? new HadoopDelegate() : null;
        this.factorySet = new AtomicBoolean(false);
    }
}

