/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.RasterFactory;
import javax.media.jai.TiledImage;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.process.vector.VectorToRasterException;
import org.geotools.referencing.CRS;
import org.geotools.util.NullProgressListener;
import org.geotools.util.SimpleInternationalString;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Transform", description="Converts some or all of a feature collection to a raster grid, using an attribute to specify cell values.")
public class VectorToRasterProcess
implements VectorProcess {
    private static final int COORD_GRID_CHUNK_SIZE = 1000;
    private TransferType transferType;
    private ValueSource valueSource;
    GridCoverage2D result;
    private Number minAttValue;
    private Number maxAttValue;
    private float nodataValue;
    private ReferencedEnvelope extent;
    private Geometry extentGeometry;
    private GridGeometry2D gridGeom;
    private boolean transformFeatures;
    private MathTransform featureToRasterTransform;
    private int[] coordGridX = new int[1000];
    private int[] coordGridY = new int[1000];
    TiledImage image;
    Graphics2D graphics;

    public static GridCoverage2D process(SimpleFeatureCollection features, Object attribute, Dimension gridDim, org.opengis.geometry.Envelope bounds, String covName, ProgressListener monitor) throws VectorToRasterException {
        VectorToRasterProcess process = new VectorToRasterProcess();
        return process.convert(features, attribute, gridDim, bounds, covName, monitor);
    }

    @DescribeResult(name="result", description="Rasterized grid")
    public GridCoverage2D execute(@DescribeParameter(name="features", description="Features to process", min=1, max=1) SimpleFeatureCollection features, @DescribeParameter(name="rasterWidth", description="Width of the output grid in pixels", min=1, max=1, minValue=1.0) Integer rasterWidth, @DescribeParameter(name="rasterHeight", description="Height of the output grid in pixels", min=1, max=1, minValue=1.0) Integer rasterHeight, @DescribeParameter(name="title", description="Title to use for the output grid", min=0, max=1, defaultValue="raster") String title, @DescribeParameter(name="attribute", description="Attribute name to use for the raster cell values", min=1, max=1) String attribute, @DescribeParameter(name="bounds", description="Bounding box of the area to rasterize", min=0, max=1) org.opengis.geometry.Envelope bounds, ProgressListener progressListener) {
        Expression attributeExpr = null;
        try {
            attributeExpr = ECQL.toExpression((String)attribute);
        }
        catch (CQLException e) {
            throw new VectorToRasterException((Exception)((Object)e));
        }
        return this.convert(features, attributeExpr, new Dimension(rasterWidth, rasterHeight), bounds, title, progressListener);
    }

    protected void processFeature(SimpleFeature feature, Object attribute) throws Exception {
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (geometry.intersects(this.extentGeometry)) {
            Number value = this.getFeatureValue(feature, attribute);
            switch (this.transferType) {
                case FLOAT: {
                    if (this.minAttValue == null) {
                        this.minAttValue = this.maxAttValue = Float.valueOf(value.floatValue());
                        break;
                    }
                    if (Float.compare(value.floatValue(), this.minAttValue.floatValue()) < 0) {
                        this.minAttValue = Float.valueOf(value.floatValue());
                        break;
                    }
                    if (Float.compare(value.floatValue(), this.maxAttValue.floatValue()) <= 0) break;
                    this.maxAttValue = Float.valueOf(value.floatValue());
                    break;
                }
                case INTEGRAL: {
                    if (this.minAttValue == null) {
                        this.minAttValue = this.maxAttValue = Integer.valueOf(value.intValue());
                        break;
                    }
                    if (value.intValue() < this.minAttValue.intValue()) {
                        this.minAttValue = value.intValue();
                        break;
                    }
                    if (value.intValue() <= this.maxAttValue.intValue()) break;
                    this.maxAttValue = value.intValue();
                }
            }
            this.graphics.setColor(this.valueToColor(value));
            Geometries geomType = Geometries.get(geometry);
            switch (geomType) {
                case MULTIPOLYGON: 
                case MULTILINESTRING: 
                case MULTIPOINT: {
                    int numGeom = geometry.getNumGeometries();
                    for (int i = 0; i < numGeom; ++i) {
                        Geometry geomN = geometry.getGeometryN(i);
                        this.drawGeometry(Geometries.get(geomN), geomN);
                    }
                    break;
                }
                case POLYGON: 
                case LINESTRING: 
                case POINT: {
                    this.drawGeometry(geomType, geometry);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported geometry type: " + geomType.getName());
                }
            }
        }
    }

    private Number getFeatureValue(SimpleFeature feature, Object attribute) {
        Class rtnType;
        Class clazz = rtnType = this.transferType == TransferType.FLOAT ? Float.class : Integer.class;
        if (this.valueSource == ValueSource.PROPERTY_NAME) {
            return (Number)rtnType.cast(feature.getAttribute((String)attribute));
        }
        return (Number)((Expression)attribute).evaluate((Object)feature, rtnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCoverage2D convert(SimpleFeatureCollection features, Object attribute, Dimension gridDim, org.opengis.geometry.Envelope bounds, String covName, ProgressListener monitor) throws VectorToRasterException {
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        this.initialize(features, bounds, attribute, gridDim);
        monitor.setTask((InternationalString)new SimpleInternationalString("Rasterizing features..."));
        float scale = 100.0f / (float)features.size();
        monitor.started();
        try (SimpleFeatureIterator fi = features.features();){
            int counter = 0;
            while (fi.hasNext()) {
                try {
                    this.processFeature((SimpleFeature)fi.next(), attribute);
                }
                catch (Exception e) {
                    monitor.exceptionOccurred((Throwable)e);
                }
                monitor.progress(scale * (float)counter++);
            }
        }
        monitor.complete();
        this.flattenImage();
        GridCoverageFactory gcf = new GridCoverageFactory();
        return gcf.create((CharSequence)covName, (RenderedImage)this.image, (org.opengis.geometry.Envelope)this.extent);
    }

    private void initialize(SimpleFeatureCollection features, org.opengis.geometry.Envelope bounds, Object attribute, Dimension gridDim) throws VectorToRasterException {
        if (attribute instanceof String) {
            String propName = (String)attribute;
            AttributeDescriptor attDesc = ((SimpleFeatureType)features.getSchema()).getDescriptor(propName);
            if (attDesc == null) {
                throw new VectorToRasterException(propName + " not found");
            }
            Class attClass = attDesc.getType().getBinding();
            if (!Number.class.isAssignableFrom(attClass)) {
                throw new VectorToRasterException(propName + " is not numeric");
            }
            if (Float.class.isAssignableFrom(attClass)) {
                this.transferType = TransferType.FLOAT;
            } else if (Double.class.isAssignableFrom(attClass)) {
                this.transferType = TransferType.FLOAT;
                Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing double feature values to float raster values");
            } else if (Long.class.isAssignableFrom(attClass)) {
                this.transferType = TransferType.INTEGRAL;
                Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing long feature values to int raster values");
            } else {
                this.transferType = TransferType.INTEGRAL;
            }
            this.valueSource = ValueSource.PROPERTY_NAME;
        } else if (attribute instanceof Expression) {
            this.valueSource = ValueSource.EXPRESSION;
            SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)features);
            Object value = ((Expression)attribute).evaluate((Object)feature);
            if (value.getClass().equals(String.class)) {
                Boolean hasException = false;
                try {
                    Integer.valueOf((String)value);
                    this.transferType = TransferType.INTEGRAL;
                }
                catch (NumberFormatException e) {
                    hasException = true;
                }
                if (hasException.booleanValue()) {
                    hasException = false;
                    try {
                        Float.valueOf((String)value);
                        this.transferType = TransferType.FLOAT;
                    }
                    catch (NumberFormatException e) {
                        hasException = true;
                    }
                }
                if (hasException.booleanValue()) {
                    throw new VectorToRasterException(((Expression)attribute).toString() + " does not evaluate to a number");
                }
            } else {
                if (!Number.class.isAssignableFrom(value.getClass())) {
                    throw new VectorToRasterException(((Expression)attribute).toString() + " does not evaluate to a number");
                }
                if (Float.class.isAssignableFrom(value.getClass())) {
                    this.transferType = TransferType.FLOAT;
                } else if (Double.class.isAssignableFrom(value.getClass())) {
                    this.transferType = TransferType.FLOAT;
                    Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing double feature values to float raster values");
                } else if (Long.class.isAssignableFrom(value.getClass())) {
                    this.transferType = TransferType.INTEGRAL;
                    Logger.getLogger(VectorToRasterProcess.class.getName()).log(Level.WARNING, "coercing long feature values to int raster values");
                } else {
                    this.transferType = TransferType.INTEGRAL;
                }
            }
        } else {
            throw new VectorToRasterException("value attribute must be a feature property nameor an org.opengis.filter.expression.Expression object");
        }
        this.maxAttValue = null;
        this.minAttValue = null;
        try {
            this.setBounds(features, bounds);
        }
        catch (TransformException ex) {
            throw new VectorToRasterException((Exception)((Object)ex));
        }
        this.createImage(gridDim);
        this.gridGeom = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, gridDim.width, gridDim.height), (org.opengis.geometry.Envelope)this.extent);
    }

    private void setBounds(SimpleFeatureCollection features, org.opengis.geometry.Envelope bounds) throws TransformException {
        ReferencedEnvelope featureBounds = features.getBounds();
        this.extent = bounds == null ? featureBounds : new ReferencedEnvelope(bounds);
        this.extentGeometry = new GeometryFactory().toGeometry((Envelope)this.extent);
        CoordinateReferenceSystem featuresCRS = featureBounds.getCoordinateReferenceSystem();
        CoordinateReferenceSystem boundsCRS = this.extent.getCoordinateReferenceSystem();
        this.transformFeatures = false;
        if (featuresCRS != null && boundsCRS != null && !CRS.equalsIgnoreMetadata((Object)boundsCRS, (Object)featuresCRS)) {
            try {
                this.featureToRasterTransform = CRS.findMathTransform((CoordinateReferenceSystem)featuresCRS, (CoordinateReferenceSystem)boundsCRS, (boolean)true);
            }
            catch (Exception ex) {
                throw new TransformException("Unable to transform features into output coordinate reference system", (Throwable)ex);
            }
            this.transformFeatures = true;
        }
    }

    private void createImage(Dimension gridDim) {
        ColorModel cm = ColorModel.getRGBdefault();
        SampleModel sm = cm.createCompatibleSampleModel(gridDim.width, gridDim.height);
        this.image = new TiledImage(0, 0, gridDim.width, gridDim.height, 0, 0, sm, cm);
        this.graphics = this.image.createGraphics();
        this.graphics.setPaintMode();
        this.graphics.setComposite(AlphaComposite.Src);
    }

    private void flattenImage() {
        if (this.transferType == TransferType.FLOAT) {
            this.flattenImageToFloat();
        } else {
            this.flattenImageToInt();
        }
    }

    private void flattenImageToInt() {
        int numXTiles = this.image.getNumXTiles();
        int numYTiles = this.image.getNumYTiles();
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)3, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)1);
        TiledImage destImage = new TiledImage(0, 0, this.image.getWidth(), this.image.getHeight(), 0, 0, sm, (ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 3));
        for (int yt = 0; yt < numYTiles; ++yt) {
            for (int xt = 0; xt < numXTiles; ++xt) {
                Raster srcTile = this.image.getTile(xt, yt);
                WritableRaster destTile = destImage.getWritableTile(xt, yt);
                int[] data = new int[srcTile.getDataBuffer().getSize()];
                srcTile.getDataElements(srcTile.getMinX(), srcTile.getMinY(), srcTile.getWidth(), srcTile.getHeight(), data);
                Rectangle bounds = destTile.getBounds();
                destTile.setPixels(bounds.x, bounds.y, bounds.width, bounds.height, data);
                destImage.releaseWritableTile(xt, yt);
            }
        }
        this.image = destImage;
    }

    private void flattenImageToFloat() {
        int numXTiles = this.image.getNumXTiles();
        int numYTiles = this.image.getNumYTiles();
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)4, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)1);
        TiledImage destImage = new TiledImage(0, 0, this.image.getWidth(), this.image.getHeight(), 0, 0, sm, (ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 4));
        for (int yt = 0; yt < numYTiles; ++yt) {
            for (int xt = 0; xt < numXTiles; ++xt) {
                Raster srcTile = this.image.getTile(xt, yt);
                WritableRaster destTile = destImage.getWritableTile(xt, yt);
                int[] data = new int[srcTile.getDataBuffer().getSize()];
                srcTile.getDataElements(srcTile.getMinX(), srcTile.getMinY(), srcTile.getWidth(), srcTile.getHeight(), data);
                Rectangle bounds = destTile.getBounds();
                int k = 0;
                int dy = bounds.y;
                for (int drow = 0; drow < bounds.height; ++drow) {
                    int dx = bounds.x;
                    int dcol = 0;
                    while (dcol < bounds.width) {
                        destTile.setSample(dx, dy, 0, Float.intBitsToFloat(data[k]));
                        ++dx;
                        ++dcol;
                        ++k;
                    }
                    ++dy;
                }
                destImage.releaseWritableTile(xt, yt);
            }
        }
        this.image = destImage;
    }

    private void drawGeometry(Geometries geomType, Geometry geometry) throws TransformException {
        Geometry workingGeometry;
        if (this.transformFeatures) {
            try {
                workingGeometry = JTS.transform(geometry, this.featureToRasterTransform);
            }
            catch (TransformException ex) {
                throw ex;
            }
            catch (MismatchedDimensionException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            workingGeometry = geometry;
        }
        Coordinate[] coords = geometry.getCoordinates();
        if (coords.length > this.coordGridX.length) {
            int n = coords.length / 1000 + 1;
            this.coordGridX = new int[n * 1000];
            this.coordGridY = new int[n * 1000];
        }
        DirectPosition2D worldPos = new DirectPosition2D();
        for (int n = 0; n < coords.length; ++n) {
            worldPos.setLocation(coords[n].x, coords[n].y);
            GridCoordinates2D gridPos = this.gridGeom.worldToGrid((DirectPosition)worldPos);
            this.coordGridX[n] = gridPos.x;
            this.coordGridY[n] = gridPos.y;
        }
        switch (geomType) {
            case POLYGON: {
                this.graphics.fillPolygon(this.coordGridX, this.coordGridY, coords.length);
                break;
            }
            case LINESTRING: {
                this.graphics.drawPolyline(this.coordGridX, this.coordGridY, coords.length);
                break;
            }
            case POINT: {
                this.graphics.fillRect(this.coordGridX[0], this.coordGridY[0], 1, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid geometry type: " + geomType.getName());
            }
        }
    }

    private Color valueToColor(Number value) {
        int intBits = this.transferType == TransferType.FLOAT ? Float.floatToIntBits(value.floatValue()) : value.intValue();
        return new Color(intBits, true);
    }

    private static enum ValueSource {
        PROPERTY_NAME,
        EXPRESSION;

    }

    private static enum TransferType {
        INTEGRAL,
        FLOAT;

    }
}

