/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.factory.FactoryRegistry;
import org.geotools.feature.NameImpl;
import org.geotools.process.factory.AnnotationDrivenProcessFactory;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.factory.DescribeResults;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

public class AnnotatedBeanProcessFactory
extends AnnotationDrivenProcessFactory {
    Map<String, Class<?>> classMap;

    public AnnotatedBeanProcessFactory(InternationalString title, String namespace, Class<?> ... beanClasses) {
        super(title, namespace);
        this.classMap = AnnotatedBeanProcessFactory.classMap(beanClasses);
    }

    static Map<String, Class<?>> classMap(Class<?> ... beanClasses) {
        HashMap map = new HashMap();
        for (Class<?> c : beanClasses) {
            String name = c.getSimpleName();
            if (name.endsWith("Process")) {
                name = name.substring(0, name.indexOf("Process"));
            }
            map.put(name, c);
        }
        return map;
    }

    @Override
    protected DescribeProcess getProcessDescription(Name name) {
        Class<?> c = this.classMap.get(name.getLocalPart());
        if (c == null) {
            return null;
        }
        return c.getAnnotation(DescribeProcess.class);
    }

    @Override
    protected Method method(String className) {
        Class<?> c = this.classMap.get(className);
        if (c != null) {
            ArrayList<Method> candidates = new ArrayList<Method>();
            for (Method m : c.getMethods()) {
                if (!"execute".equals(m.getName())) continue;
                candidates.add(m);
            }
            if (candidates.size() == 1) {
                return (Method)candidates.get(0);
            }
            if (candidates.size() > 1) {
                Method selection = null;
                for (Method m : candidates) {
                    if (!this.hasProcessAnnotations(m)) continue;
                    if (selection != null) {
                        throw new IllegalArgumentException("Invalid process bean " + className + ", has two annotated execute methods");
                    }
                    selection = m;
                }
                return selection;
            }
        }
        return null;
    }

    private boolean hasProcessAnnotations(Method m) {
        Annotation[][] paramAnnotations;
        Annotation[] annotations = m.getAnnotations();
        if (this.hasProcessAnnotations(annotations)) {
            return true;
        }
        for (Annotation[] pa : paramAnnotations = m.getParameterAnnotations()) {
            if (!this.hasProcessAnnotations(pa)) continue;
            return true;
        }
        return false;
    }

    private boolean hasProcessAnnotations(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof DescribeResult) && !(annotation instanceof DescribeResults) && !(annotation instanceof DescribeParameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Name> getNames() {
        LinkedHashSet<Name> result = new LinkedHashSet<Name>();
        ArrayList<String> names = new ArrayList<String>(this.classMap.keySet());
        Collections.sort(names);
        for (String name : names) {
            result.add(new NameImpl(this.namespace, name));
        }
        return result;
    }

    @Override
    protected Object createProcessBean(Name name) {
        try {
            Class<?> processClass = this.classMap.get(name.getLocalPart());
            if (processClass == null) {
                throw new IllegalArgumentException("Process " + name + " is unknown");
            }
            return processClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static class BeanFactoryRegistry<T>
    extends FactoryRegistry {
        public BeanFactoryRegistry(Class<T> clazz) {
            super(clazz);
        }

        public Class<T> getBeanClass() {
            return (Class)this.streamCategories().findFirst().orElseThrow(NoSuchElementException::new);
        }

        public Class<? extends T>[] lookupBeanClasses() {
            return (Class[])this.getFactories(this.getBeanClass(), null, null).map(Object::getClass).toArray(Class[]::new);
        }
    }
}

