/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.impl;

import java.util.HashMap;
import java.util.Map;
import org.geotools.process.ProcessFactory;
import org.geotools.process.impl.AbstractProcess;
import org.geotools.util.NullProgressListener;
import org.opengis.util.ProgressListener;

public abstract class SimpleProcess
extends AbstractProcess {
    private boolean started = false;
    protected Map<String, Object> input;
    protected Map<String, Object> result;

    protected SimpleProcess(ProcessFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) {
        if (this.started) {
            throw new IllegalStateException("Process can only be run once");
        }
        this.started = true;
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        try {
            if (monitor.isCanceled()) {
                Map<String, Object> map = null;
                return map;
            }
            this.input = input;
            this.result = new HashMap<String, Object>();
            this.process();
            Map<String, Object> map = this.result;
            return map;
        }
        catch (Throwable eek) {
            monitor.exceptionOccurred(eek);
            Map<String, Object> map = null;
            return map;
        }
        finally {
            monitor.complete();
        }
    }

    public abstract void process() throws Exception;

    protected Object get(String key) {
        return this.input.get(key);
    }
}

