/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.strategies;

import java.time.ZonedDateTime;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.filter.visitor.FilterExtractingVisitor$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.strategies.SpatialFilterStrategy$;
import org.locationtech.geomesa.index.strategies.SpatioTemporalFilterStrategy;
import org.locationtech.geomesa.index.strategies.SpatioTemporalFilterStrategy$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class SpatioTemporalFilterStrategy$class {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Seq getFilterStrategy(SpatioTemporalFilterStrategy $this, SimpleFeatureType sft, Filter filter2, Option transform2) {
        Seq seq;
        String dtg = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new RuntimeException("Trying to plan a z3 query but the schema does not have a date");
            }
        });
        Filter filter3 = filter2;
        IncludeFilter includeFilter = Filter.INCLUDE;
        if (!(filter3 != null ? !filter3.equals(includeFilter) : includeFilter != null)) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FilterStrategy[]{new FilterStrategy($this, (Option<Filter>)None$.MODULE$, (Option<Filter>)None$.MODULE$)}));
            return seq;
        } else {
            Filter filter4 = filter2;
            ExcludeFilter excludeFilter = Filter.EXCLUDE;
            if (!(filter4 != null ? !filter4.equals(excludeFilter) : excludeFilter != null)) {
                seq = (Seq)Seq$.MODULE$.empty();
                return seq;
            } else {
                Tuple2 tuple2;
                Tuple2 tuple22 = FilterExtractingVisitor$.MODULE$.apply(filter2, dtg, sft, FilterExtractingVisitor$.MODULE$.apply$default$4());
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                Option temporal = (Option)tuple22._1();
                Option nonTemporal = (Option)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)temporal, (Object)nonTemporal);
                Option temporal2 = (Option)tuple23._1();
                Option nonTemporal2 = (Option)tuple23._2();
                FilterValues intervals = (FilterValues)temporal2.map((Function1)new Serializable($this, dtg){
                    public static final long serialVersionUID = 0L;
                    private final String dtg$1;

                    public final FilterValues<Bounds<ZonedDateTime>> apply(Filter x$2) {
                        return FilterHelper$.MODULE$.extractIntervals(x$2, this.dtg$1, FilterHelper$.MODULE$.extractIntervals$default$3(), FilterHelper$.MODULE$.extractIntervals$default$4());
                    }
                    {
                        this.dtg$1 = dtg$1;
                    }
                }).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final FilterValues<Nothing$> apply() {
                        return FilterValues$.MODULE$.empty();
                    }
                });
                if (intervals.disjoint() || intervals.exists((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Bounds<ZonedDateTime> x$3) {
                        return x$3.isBounded();
                    }
                })) {
                    Tuple2 tuple24;
                    Tuple2 tuple25;
                    Option option = nonTemporal2;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Filter nt = (Filter)some.x();
                        tuple25 = FilterExtractingVisitor$.MODULE$.apply(nt, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), sft, (Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Filter filter2) {
                                return SpatialFilterStrategy$.MODULE$.spatialCheck(filter2);
                            }
                        });
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                        tuple25 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                    }
                    Tuple2 tuple26 = tuple25;
                    if (tuple26 == null) throw new MatchError((Object)tuple26);
                    Option spatial = (Option)tuple26._1();
                    Option others = (Option)tuple26._2();
                    Tuple2 tuple27 = tuple24 = new Tuple2((Object)spatial, (Object)others);
                    Option spatial2 = (Option)tuple27._1();
                    Option others2 = (Option)tuple27._2();
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FilterStrategy[]{new FilterStrategy($this, (Option<Filter>)package$.MODULE$.andOption(((TraversableOnce)Option$.MODULE$.option2Iterable(spatial2).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(temporal2), Iterable$.MODULE$.canBuildFrom())).toSeq(), (FilterFactory)package$.MODULE$.ff()), (Option<Filter>)others2)}));
                    return seq;
                } else {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FilterStrategy[]{new FilterStrategy($this, (Option<Filter>)None$.MODULE$, (Option<Filter>)new Some((Object)filter2))}));
                }
            }
        }
        return seq;
    }

    public static long getCost(SpatioTemporalFilterStrategy $this, SimpleFeatureType sft, Option stats, FilterStrategy filter2, Option transform2) {
        Option<Filter> option;
        block5: {
            long l;
            block4: {
                block3: {
                    option = filter2.primary();
                    if (!None$.MODULE$.equals(option)) break block3;
                    l = Long.MAX_VALUE;
                    break block4;
                }
                if (!(option instanceof Some)) break block5;
                Some some = (Some)option;
                Filter f = (Filter)some.x();
                String dtg = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new RuntimeException("Trying to plan a z3 query but the schema does not have a date");
                    }
                });
                long base = BoxesRunTime.unboxToLong((Object)stats.flatMap((Function1)new Serializable($this, f, sft){
                    public static final long serialVersionUID = 0L;
                    private final Filter f$1;
                    private final SimpleFeatureType sft$1;

                    public final Option<Object> apply(GeoMesaStats x$5) {
                        return x$5.getCount(this.sft$1, this.f$1, false);
                    }
                    {
                        void var3_3;
                        this.f$1 = f$1;
                        this.sft$1 = var3_3;
                    }
                }).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return SpatioTemporalFilterStrategy$.MODULE$.StaticCost();
                    }
                }));
                l = FilterHelper$.MODULE$.extractGeometries(f, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), FilterHelper$.MODULE$.extractGeometries$default$3()).isEmpty() ? (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isIndexed$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(sft.getDescriptor(dtg))) ? Long.MAX_VALUE : base * 2L + 1L) : (FilterHelper$.MODULE$.extractIntervals(f, (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).get(), FilterHelper$.MODULE$.extractIntervals$default$3(), FilterHelper$.MODULE$.extractIntervals$default$4()).forall((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Bounds<ZonedDateTime> x$6) {
                        return x$6.isBoundedBothSides();
                    }
                }) ? base : base * 2L + 1L);
            }
            return l;
        }
        throw new MatchError(option);
    }

    public static void $init$(SpatioTemporalFilterStrategy $this) {
    }
}

