/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.PointEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.Encoder;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.xml.sax.helpers.AttributesImpl;

class MultiPointEncoder
extends GeometryEncoder<MultiPoint> {
    static final QualifiedName MULTI_POINT = new QualifiedName("http://www.opengis.net/gml", "MultiPoint", "gml");
    static final QualifiedName POINT_MEMBER = new QualifiedName("http://www.opengis.net/gml", "pointMember", "gml");
    PointEncoder pe;
    QualifiedName multiPoint;
    QualifiedName pointMember;

    protected MultiPointEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.pe = new PointEncoder(encoder, gmlPrefix);
        this.multiPoint = MULTI_POINT.derive(gmlPrefix);
        this.pointMember = POINT_MEMBER.derive(gmlPrefix);
    }

    @Override
    public void encode(MultiPoint geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.multiPoint, atts);
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            handler.startElement(this.pointMember, null);
            this.pe.encode((Point)geometry.getGeometryN(i), (AttributesImpl)null, handler);
            handler.endElement(this.pointMember);
        }
        handler.endElement(this.multiPoint);
    }
}

