/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector.impl;

import io.netty.buffer.ArrowBuf;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryVector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;

public abstract class AbstractMultiPointVector<T extends FieldVector>
extends AbstractGeometryVector<MultiPoint, ListVector, T> {
    private final FixedSizeListVector tuples;

    public static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null, metadata);
    }

    protected AbstractMultiPointVector(String name, BufferAllocator allocator, Map<String, String> metadata) {
        this(new ListVector(name, allocator, AbstractMultiPointVector.createFieldType(metadata), null));
    }

    protected AbstractMultiPointVector(String name, AbstractContainerVector container, Map<String, String> metadata) {
        this((ListVector)container.addOrGet(name, AbstractMultiPointVector.createFieldType(metadata), ListVector.class));
    }

    protected AbstractMultiPointVector(ListVector vector) {
        super(vector);
        if (vector.getDataVector().equals(BaseRepeatedValueVector.DEFAULT_DATA_VECTOR)) {
            vector.initializeChildrenFromFields(this.getFields());
            vector.allocateNew();
        }
        this.tuples = (FixedSizeListVector)vector.getChildrenFromFields().get(0);
        this.setOrdinalVector((FieldVector)this.tuples.getChildrenFromFields().get(0));
    }

    @Override
    public void set(int index, MultiPoint geom) {
        if (index == 0) {
            ((ListVector)this.vector).setLastSet(0);
        }
        int position = ((ListVector)this.vector).startNewValue(index);
        if (geom == null) {
            ((ListVector)this.vector).endValue(index, 0);
            BitVectorHelper.setValidityBit((ArrowBuf)((ListVector)this.vector).getValidityBuffer(), (int)index, (int)0);
        } else {
            for (int i = 0; i < geom.getNumPoints(); ++i) {
                Point p = (Point)geom.getGeometryN(i);
                this.tuples.setNotNull(position + i);
                this.writeOrdinal((position + i) * 2, p.getY());
                this.writeOrdinal((position + i) * 2 + 1, p.getX());
            }
            ((ListVector)this.vector).endValue(index, geom.getNumPoints());
        }
    }

    @Override
    public MultiPoint get(int index) {
        if (((ListVector)this.vector).isNull(index)) {
            return null;
        }
        int offsetStart = ((ListVector)this.vector).getOffsetBuffer().getInt(index * 4);
        int offsetEnd = ((ListVector)this.vector).getOffsetBuffer().getInt((index + 1) * 4);
        Coordinate[] coordinates = new Coordinate[offsetEnd - offsetStart];
        for (int i = 0; i < coordinates.length; ++i) {
            double y = this.readOrdinal((offsetStart + i) * 2);
            double x = this.readOrdinal((offsetStart + i) * 2 + 1);
            coordinates[i] = new Coordinate(x, y);
        }
        return factory.createMultiPoint(coordinates);
    }
}

