/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.beust.jcommander.ParameterException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportCommand$;
import org.locationtech.geomesa.tools.export.ExportParams;
import org.locationtech.geomesa.tools.export.FileExportParams;
import org.locationtech.geomesa.tools.export.formats.ShapefileExporter$;
import org.locationtech.geomesa.tools.utils.DataFormats$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class ExportCommand$
implements LazyLogging {
    public static final ExportCommand$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ExportCommand$();
    }

    private Logger logger$lzycompute() {
        ExportCommand$ exportCommand$ = this;
        synchronized (exportCommand$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Tuple2<Query, Option<ExportCommand.ExportAttributes>> createQuery(Function0<SimpleFeatureType> toSft, Enumeration.Value fmt2, ExportParams params) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Option option;
        Object object;
        ObjectRef sft$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String typeName = (String)Option$.MODULE$.apply((Object)params).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ExportParams, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TypeNameParam) {
                    A1 A12 = A1;
                    object = ((TypeNameParam)((Object)A12)).featureName();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ExportParams x1) {
                ExportParams exportParams = x1;
                boolean bl = exportParams instanceof TypeNameParam;
                return bl;
            }
        }).orNull(Predef$.MODULE$.$conforms());
        Filter filter = (Filter)Option$.MODULE$.apply((Object)params.cqlFilter()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IncludeFilter apply() {
                return Filter.INCLUDE;
            }
        });
        Query query = new Query(typeName, filter);
        Option$.MODULE$.apply((Object)params.maxFeatures()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Object x) {
                return BoxesRunTime.unboxToInt((Object)x);
            }
        }).foreach((Function1)new Serializable(query){
            public static final long serialVersionUID = 0L;
            private final Query query$2;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.query$2.setMaxFeatures(x$1);
            }
            {
                this.query$2 = query$2;
            }
        });
        Option$.MODULE$.apply((Object)params).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ExportParams, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x2;
                Object object = A12 instanceof OptionalIndexParam ? (A1 = A12) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(ExportParams x2) {
                ExportParams exportParams = x2;
                boolean bl = exportParams instanceof OptionalIndexParam;
                return bl;
            }
        }).foreach((Function1)new Serializable(query){
            public static final long serialVersionUID = 0L;
            public final Query query$2;

            public final void apply(ExportParams p) {
                Option$.MODULE$.apply((Object)((OptionalIndexParam)((Object)p)).index()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createQuery.4 $outer;

                    public final Object apply(String index) {
                        BoxedUnit boxedUnit;
                        if (ExportCommand$.MODULE$.logger().underlying().isDebugEnabled()) {
                            ExportCommand$.MODULE$.logger().underlying().debug("Using index {}", new Object[]{index});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return this.$outer.query$2.getHints().put((Object)QueryHints$.MODULE$.QUERY_INDEX(), (Object)index);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.query$2 = query$2;
            }
        });
        Option$.MODULE$.apply(params.hints()).foreach((Function1)new Serializable(query){
            public static final long serialVersionUID = 0L;
            private final Query query$2;

            public final void apply(Map<String, String> hints2) {
                this.query$2.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, hints2);
                ViewParams$.MODULE$.setHints(this.query$2);
            }
            {
                this.query$2 = query$2;
            }
        });
        Enumeration.Value value = fmt2;
        Enumeration.Value value2 = DataFormats$.MODULE$.Arrow();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            object = query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)Boolean.TRUE);
        } else {
            Enumeration.Value value3 = fmt2;
            Enumeration.Value value4 = DataFormats$.MODULE$.Bin();
            object = !(value3 != null ? !value3.equals(value4) : value4 != null) ? (query.getHints().containsKey((Object)QueryHints$.MODULE$.BIN_TRACK()) ? BoxedUnit.UNIT : query.getHints().put((Object)QueryHints$.MODULE$.BIN_TRACK(), (Object)"id")) : BoxedUnit.UNIT;
        }
        Option provided = Option$.MODULE$.apply(params.attributes()).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends List<String>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                Object object = A1.isEmpty() ? function1.apply(x3) : JavaConversions$.MODULE$.asScalaBuffer(A1).toSeq();
                return (B1)object;
            }

            public final boolean isDefinedAt(List<String> x3) {
                List<String> list = x3;
                boolean bl = !list.isEmpty();
                return bl;
            }
        }).orElse((Function0)new Serializable(toSft, fmt2, sft$lzy, query, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final Function0 toSft$1;
            private final Enumeration.Value fmt$1;
            private final ObjectRef sft$lzy$1;
            private final Query query$2;
            private final VolatileByteRef bitmap$0$1;

            public final Option<Seq<String>> apply() {
                Enumeration.Value value = this.fmt$1;
                Enumeration.Value value2 = DataFormats$.MODULE$.Bin();
                return !(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)BinAggregatingScan$.MODULE$.propertyNames(this.query$2.getHints(), ExportCommand$.MODULE$.org$locationtech$geomesa$tools$export$ExportCommand$$sft$1(this.toSft$1, this.sft$lzy$1, this.bitmap$0$1))) : None$.MODULE$;
            }
            {
                this.toSft$1 = toSft$1;
                this.fmt$1 = fmt$1;
                this.sft$lzy$1 = sft$lzy$1;
                this.query$2 = query$2;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
        Enumeration.Value value5 = fmt2;
        Enumeration.Value value6 = DataFormats$.MODULE$.Shp();
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            Seq attributes = (Seq)provided.map((Function1)new Serializable(toSft, sft$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final Function0 toSft$1;
                private final ObjectRef sft$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final Seq<String> apply(Seq<String> x$5) {
                    return ShapefileExporter$.MODULE$.replaceGeom(ExportCommand$.MODULE$.org$locationtech$geomesa$tools$export$ExportCommand$$sft$1(this.toSft$1, this.sft$lzy$1, this.bitmap$0$1), x$5);
                }
                {
                    this.toSft$1 = toSft$1;
                    this.sft$lzy$1 = sft$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).getOrElse((Function0)new Serializable(toSft, sft$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final Function0 toSft$1;
                private final ObjectRef sft$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final Seq<String> apply() {
                    return ShapefileExporter$.MODULE$.modifySchema(ExportCommand$.MODULE$.org$locationtech$geomesa$tools$export$ExportCommand$$sft$1(this.toSft$1, this.sft$lzy$1, this.bitmap$0$1));
                }
                {
                    this.toSft$1 = toSft$1;
                    this.sft$lzy$1 = sft$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            option = new Some((Object)new ExportCommand.ExportAttributes((Seq<String>)attributes, true));
        } else {
            option = provided.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ExportCommand.ExportAttributes apply(Seq<String> p) {
                    Tuple2 tuple2 = p.partition((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$6) {
                            return x$6.equalsIgnoreCase("id");
                        }
                    });
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Seq id = (Seq)tuple2._1();
                        Seq attributes = (Seq)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)id, (Object)attributes);
                        Seq id2 = (Seq)tuple23._1();
                        Seq attributes2 = (Seq)tuple23._2();
                        return new ExportCommand.ExportAttributes((Seq<String>)attributes2, id2.nonEmpty());
                    }
                    throw new MatchError((Object)tuple2);
                }
            });
        }
        Option attributes = option;
        query.setPropertyNames((String[])attributes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(ExportCommand.ExportAttributes x$8) {
                return (String[])x$8.names().toArray(ClassTag$.MODULE$.apply(String.class));
            }
        }).orNull(Predef$.MODULE$.$conforms()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Applying CQL filter {}", new Object[]{ECQL.toCQL((Filter)filter)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Applying transform {}", new Object[]{Option$.MODULE$.apply((Object)query.getPropertyNames()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String[] x$9) {
                    return Predef$.MODULE$.refArrayOps((Object[])x$9).mkString(",");
                }
            }).orNull(Predef$.MODULE$.$conforms())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Tuple2((Object)query, (Object)attributes);
    }

    public OutputStream createOutputStream(File file, Integer compress) {
        OutputStream out = (OutputStream)Option$.MODULE$.apply((Object)file).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileOutputStream apply(File x$10) {
                return new FileOutputStream(x$10);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PrintStream apply() {
                return System.out;
            }
        });
        OutputStream compressed = compress == null ? out : new GZIPOutputStream(compress, out){
            {
                this.def.setLevel(Predef$.MODULE$.Integer2int(compress$1));
            }
        };
        return new BufferedOutputStream(compressed);
    }

    public Writer getWriter(FileExportParams params) {
        return new OutputStreamWriter(this.createOutputStream(params.file(), params.gzip()));
    }

    public Writer getWriter(File file, Integer compress) {
        return new OutputStreamWriter(this.createOutputStream(file, compress));
    }

    public File checkShpFile(FileExportParams params) {
        if (params.file() == null) {
            throw new ParameterException("Error: -o or --output for file-based output is required for shapefile export (stdout not supported for shape files)");
        }
        return params.file();
    }

    private final SimpleFeatureType sft$lzycompute$1(Function0 toSft$1, ObjectRef sft$lzy$1, VolatileByteRef bitmap$0$1) {
        ExportCommand$ exportCommand$ = this;
        synchronized (exportCommand$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                sft$lzy$1.elem = (SimpleFeatureType)toSft$1.apply();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (SimpleFeatureType)sft$lzy$1.elem;
        }
    }

    public final SimpleFeatureType org$locationtech$geomesa$tools$export$ExportCommand$$sft$1(Function0 toSft$1, ObjectRef sft$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.sft$lzycompute$1(toSft$1, sft$lzy$1, bitmap$0$1) : (SimpleFeatureType)sft$lzy$1.elem;
    }

    private ExportCommand$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

