/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings.ext;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.SurfaceTypeBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class MultiSurfaceTypeBinding
extends org.geotools.gml3.bindings.MultiSurfaceTypeBinding
implements Comparable {
    public MultiSurfaceTypeBinding(GeometryFactory gf) {
        super(gf);
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List surfaceMemberList = node.getChildValues("surfaceMember");
        MultiPolygon surfaceMembers = (MultiPolygon)node.getChildValue("surfaceMembers");
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        if (surfaceMemberList != null) {
            for (MultiPolygon surface : surfaceMemberList) {
                for (int i = 0; i < surface.getNumGeometries(); ++i) {
                    Polygon polygon = (Polygon)surface.getGeometryN(i);
                    polygons.add(polygon);
                }
            }
        }
        if (surfaceMembers != null) {
            for (int i = 0; i < surfaceMembers.getNumGeometries(); ++i) {
                Polygon polygon = (Polygon)surfaceMembers.getGeometryN(i);
                polygons.add(polygon);
            }
        }
        return this.gf.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if ("surfaceMembers".equals(name.getLocalPart())) {
            return super.getProperty(object, GML.surfaceMember);
        }
        return super.getProperty(object, name);
    }

    public int compareTo(Object o) {
        if (o instanceof SurfaceTypeBinding) {
            return 1;
        }
        return 0;
    }
}

