/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.knn;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Collection;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.knn.KNNQuery$;
import org.locationtech.geomesa.process.knn.KNNResult;
import org.locationtech.geomesa.process.knn.NearestNeighbors;
import org.locationtech.geomesa.process.knn.SimpleFeatureWithDistance;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u00015\u0011!b\u0013(O-&\u001c\u0018\u000e^8s\u0015\t\u0019A!A\u0002l]:T!!\u0002\u0004\u0002\u000fA\u0014xnY3tg*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0006\u000e\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\r\u000e\u0003\u0011I!!\u0007\u0003\u0003+\u001d+w.T3tCB\u0013xnY3tgZK7/\u001b;peB\u00111DI\u0007\u00029)\u0011QDH\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003?\u0001\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002C\u0005\u00191m\\7\n\u0005\rb\"a\u0003'bufdunZ4j]\u001eD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u000eS:\u0004X\u000f\u001e$fCR,(/Z:\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013AB:j[BdWM\u0003\u0002,Y\u0005!A-\u0019;b\u0015\ti#\"\u0001\u0005hK>$xn\u001c7t\u0013\ty\u0003FA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\"A\u0011\u0007\u0001B\u0001B\u0003%a%\u0001\u0007eCR\fg)Z1ukJ,7\u000f\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0003)qW/\u001c#fg&\u0014X\r\u001a\t\u0003\u001fUJ!A\u000e\t\u0003\u000f%sG/Z4fe\"A\u0001\b\u0001B\u0001B\u0003%\u0011(A\tfgRLW.\u0019;fI\u0012K7\u000f^1oG\u0016\u0004\"a\u0004\u001e\n\u0005m\u0002\"A\u0002#pk\ndW\r\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003:\u0003Ei\u0017\r_*fCJ\u001c\u0007\u000eR5ti\u0006t7-\u001a\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0005\u001bE)\u0012$H!\t\u0011\u0005!D\u0001\u0003\u0011\u0015)c\b1\u0001'\u0011\u0015\td\b1\u0001'\u0011\u0015\u0019d\b1\u00015\u0011\u0015Ad\b1\u0001:\u0011\u0015id\b1\u0001:\u0011\u001dI\u0005A1A\u0005\u0002)\u000b!#\\1ok\u0006dg+[:jiJ+7/\u001e7ugV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002OY\u00059a-Z1ukJ,\u0017B\u0001)N\u0005a!UMZ1vYR4U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0007%\u0002\u0001\u000b\u0011B&\u0002'5\fg.^1m-&\u001c\u0018\u000e\u001e*fgVdGo\u001d\u0011\t\u000bQ\u0003A\u0011A+\u0002\u000bYL7/\u001b;\u0015\u0005Yc\u0006CA,[\u001b\u0005A&\"A-\u0002\u000bM\u001c\u0017\r\\1\n\u0005mC&\u0001B+oSRDQAT*A\u0002u\u0003\"A\u00182\u000e\u0003}S!A\u00141\u000b\u0005\u0005T\u0011aB8qK:<\u0017n]\u0005\u0003G~\u0013qAR3biV\u0014X\rC\u0004f\u0001\u0001\u0007I\u0011\u00014\u0002\u0015I,7/\u001e7u\u0007\u0006d7-F\u0001h!\t\u0011\u0005.\u0003\u0002j\u0005\tI1J\u0014(SKN,H\u000e\u001e\u0005\bW\u0002\u0001\r\u0011\"\u0001m\u00039\u0011Xm];mi\u000e\u000bGnY0%KF$\"AV7\t\u000f9T\u0017\u0011!a\u0001O\u0006\u0019\u0001\u0010J\u0019\t\rA\u0004\u0001\u0015)\u0003h\u0003-\u0011Xm];mi\u000e\u000bGn\u0019\u0011\t\u000bI\u0004A\u0011I:\u0002\u0013\u001d,GOU3tk2$H#\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0005]l\u0015a\u0002<jg&$xN]\u0005\u0003sZ\u0014!bQ1mGJ+7/\u001e7u\u0011\u0015Y\b\u0001\"\u0011}\u0003\u001d)\u00070Z2vi\u0016$BAV?\u0002\u0006!)aP\u001fa\u0001\u007f\u000611o\\;sG\u0016\u00042aJA\u0001\u0013\r\t\u0019\u0001\u000b\u0002\u0014'&l\u0007\u000f\\3GK\u0006$XO]3T_V\u00148-\u001a\u0005\b\u0003\u000fQ\b\u0019AA\u0005\u0003\u0015\tX/\u001a:z!\u0011\tY!!\u0004\u000e\u0003)J1!a\u0004+\u0005\u0015\tV/\u001a:z\u0001")
public class KNNVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final SimpleFeatureCollection inputFeatures;
    private final Integer numDesired;
    private final Double estimatedDistance;
    private final Double maxSearchDistance;
    private final DefaultFeatureCollection manualVisitResults;
    private KNNResult resultCalc;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        KNNVisitor kNNVisitor = this;
        synchronized (kNNVisitor) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.class.getExpressions((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
    }

    public DefaultFeatureCollection manualVisitResults() {
        return this.manualVisitResults;
    }

    public void visit(Feature feature) {
    }

    public KNNResult resultCalc() {
        return this.resultCalc;
    }

    public void resultCalc_$eq(KNNResult x$1) {
        this.resultCalc = x$1;
    }

    public CalcResult getResult() {
        return this.resultCalc();
    }

    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Running Geomesa K-Nearest Neighbor Search on source type ").append((Object)source.getClass().getName()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        DefaultFeatureCollection resultCollection = new DefaultFeatureCollection();
        SelfClosingIterator searchFeatureIterator = SelfClosingIterator$.MODULE$.apply(this.inputFeatures.features());
        while (searchFeatureIterator.hasNext()) {
            BoxedUnit boxedUnit2;
            Object object;
            SimpleFeature aFeatureForSearch = (SimpleFeature)searchFeatureIterator.next();
            Object object2 = aFeatureForSearch.getDefaultGeometry();
            if (object2 instanceof Point) {
                NearestNeighbors knnResults = KNNQuery$.MODULE$.runNewKNNQuery(source, query, Predef$.MODULE$.Integer2int(this.numDesired), Predef$.MODULE$.Double2double(this.estimatedDistance), Predef$.MODULE$.Double2double(this.maxSearchDistance), aFeatureForSearch);
                Collection sfList = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)knnResults.getK().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(SimpleFeatureWithDistance x$1) {
                        return x$1.sf();
                    }
                }, List$.MODULE$.canBuildFrom())).asJavaCollection();
                object = BoxesRunTime.boxToBoolean((boolean)resultCollection.addAll(sfList));
                continue;
            }
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("K Nearest Neighbor Search not implemented for non-point geometries, skipping this Feature");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            object = boxedUnit2;
        }
        this.resultCalc_$eq(new KNNResult((SimpleFeatureCollection)resultCollection));
    }

    public KNNVisitor(SimpleFeatureCollection inputFeatures, SimpleFeatureCollection dataFeatures, Integer numDesired, Double estimatedDistance, Double maxSearchDistance) {
        this.inputFeatures = inputFeatures;
        this.numDesired = numDesired;
        this.estimatedDistance = estimatedDistance;
        this.maxSearchDistance = maxSearchDistance;
        GeoMesaProcessVisitor.class.$init$((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.manualVisitResults = new DefaultFeatureCollection(null, (SimpleFeatureType)dataFeatures.getSchema());
        this.resultCalc = new KNNResult((SimpleFeatureCollection)this.manualVisitResults());
    }
}

